/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.uploader;

import com.microsoft.azure.management.datalake.store.uploader.SegmentUploadStatus;
import com.microsoft.azure.management.datalake.store.uploader.UploadMetadata;
import java.io.Serializable;
import java.text.MessageFormat;

public class UploadSegmentMetadata
implements Serializable {
    private static final int BASE_MULTIPLIER = 50;
    private static final int SEGMENT_COUNT_MULTIPLIER = 2;
    public static final int MINIMUM_SEGMENT_SIZE = 0x400000;
    private int segmentNumber;
    private long offset;
    private long length;
    private SegmentUploadStatus status;
    private String path;

    protected UploadSegmentMetadata() {
    }

    public UploadSegmentMetadata(int segmentNumber, UploadMetadata metadata) {
        this.segmentNumber = segmentNumber;
        this.status = SegmentUploadStatus.Pending;
        String targetStreamName = metadata.splitTargetStreamPathByName()[0];
        this.path = MessageFormat.format("{0}/{1}.{2}.segment{3}", metadata.getSegmentStreamDirectory(), targetStreamName, metadata.getUploadId(), this.segmentNumber);
        this.offset = (long)this.segmentNumber * metadata.getSegmentLength();
        this.length = UploadSegmentMetadata.calculateSegmentLength(this.segmentNumber, metadata);
    }

    public static long calculateSegmentLength(long fileLength, int segmentCount) {
        if (segmentCount < 0) {
            throw new IllegalArgumentException("Number of segments must be a positive integer");
        }
        if (segmentCount == 0) {
            return 0L;
        }
        long segmentLength = fileLength / (long)segmentCount;
        if (fileLength % (long)segmentCount != 0L && fileLength - (long)(segmentCount - 1) * (segmentLength + 1L) > 0L) {
            ++segmentLength;
        }
        return segmentLength;
    }

    public static long calculateSegmentLength(int segmentNumber, UploadMetadata metadata) {
        if (segmentNumber < 0 || segmentNumber >= metadata.getSegmentCount()) {
            throw new IndexOutOfBoundsException("Segment Number must be at least zero and less than the total number of segments");
        }
        if (metadata.getFileLength() < 0L) {
            throw new IllegalArgumentException("Cannot have a negative file length");
        }
        long lastSegmentLength = metadata.getFileLength() - (long)(metadata.getSegmentCount() - 1) * metadata.getSegmentLength();
        if (lastSegmentLength < 0L) {
            throw new IllegalArgumentException("The given values for segmentCount and segmentLength cannot possibly be used to split a file with the given fileLength (the last segment would have a negative length)");
        }
        if (lastSegmentLength > metadata.getSegmentLength() && metadata.getFileLength() - (long)(metadata.getSegmentCount() - 1) * (metadata.getSegmentLength() + 1L) > 0L) {
            throw new IllegalArgumentException("The given values for segmentCount and segmentLength would not produce an even split of a file with given fileLength");
        }
        if (metadata.getFileLength() == 0L) {
            return 0L;
        }
        if (segmentNumber < metadata.getSegmentCount() - 1) {
            return metadata.getSegmentLength();
        }
        return lastSegmentLength;
    }

    public static int calculateSegmentCount(long fileLength) {
        if (fileLength < 0L) {
            throw new IllegalArgumentException("File length cannot be negative");
        }
        if (fileLength == 0L) {
            return 0;
        }
        int minNumberOfSegments = (int)Math.max(1L, fileLength / 0x400000L);
        double lengthInGb = (double)fileLength / 1024.0 / 1024.0 / 1024.0;
        double baseMultiplier = UploadSegmentMetadata.calculateBaseMultiplier(lengthInGb);
        int segmentCount = (int)(baseMultiplier * Math.pow(2.0, Math.log10(lengthInGb)));
        if (segmentCount > minNumberOfSegments) {
            segmentCount = minNumberOfSegments;
        }
        if (segmentCount < 1) {
            segmentCount = 1;
        }
        return segmentCount;
    }

    private static double calculateBaseMultiplier(double lengthInGb) {
        double value = 50.0 * Math.pow(2.0, Math.log10(lengthInGb));
        return Math.min(100.0, value);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public void setSegmentNumber(int segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public SegmentUploadStatus getStatus() {
        return this.status;
    }

    public void setStatus(SegmentUploadStatus status) {
        this.status = status;
    }
}

