/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.uploader;

import com.microsoft.azure.management.datalake.store.uploader.AggregateUploadException;
import com.microsoft.azure.management.datalake.store.uploader.FrontEndAdapter;
import com.microsoft.azure.management.datalake.store.uploader.InvalidMetadataException;
import com.microsoft.azure.management.datalake.store.uploader.MultipleSegmentUploader;
import com.microsoft.azure.management.datalake.store.uploader.SegmentUploadStatus;
import com.microsoft.azure.management.datalake.store.uploader.SingleSegmentUploader;
import com.microsoft.azure.management.datalake.store.uploader.UploadFailedException;
import com.microsoft.azure.management.datalake.store.uploader.UploadMetadata;
import com.microsoft.azure.management.datalake.store.uploader.UploadMetadataGenerator;
import com.microsoft.azure.management.datalake.store.uploader.UploadParameters;
import com.microsoft.azure.management.datalake.store.uploader.UploadSegmentMetadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.OperationsException;
import org.apache.commons.lang3.StringUtils;

public class DataLakeStoreUploader {
    public static final int MAX_ALLOWED_THREADS = 1024;
    private FrontEndAdapter frontEnd;
    private String metadataFilePath;
    private UploadParameters parameters;

    public DataLakeStoreUploader(UploadParameters uploadParameters, FrontEndAdapter frontEnd) throws FileNotFoundException {
        this.parameters = uploadParameters;
        this.frontEnd = frontEnd;
        this.validateParameters();
        this.metadataFilePath = this.getCanonicalMetadataFilePath();
    }

    private String getCanonicalMetadataFilePath() {
        return Paths.get(this.getParameters().getLocalMetadataLocation(), MessageFormat.format("{0}.upload.xml", Paths.get(this.getParameters().getInputFilePath(), new String[0]).getFileName())).toString();
    }

    public UploadParameters getParameters() {
        return this.parameters;
    }

    public void execute() throws Exception {
        UploadMetadata metadata = this.getMetadata();
        if (metadata.getSegmentCount() < this.getParameters().getThreadCount()) {
            this.getParameters().setThreadCount(metadata.getSegmentCount());
        }
        this.uploadFile(metadata);
        metadata.deleteFile();
    }

    private void validateParameters() throws FileNotFoundException, IllegalArgumentException {
        if (!new File(this.getParameters().getInputFilePath()).exists()) {
            throw new FileNotFoundException("Could not find input file: " + this.getParameters().getInputFilePath());
        }
        if (this.getParameters().getTargetStreamPath() == null || StringUtils.isEmpty((CharSequence)this.getParameters().getTargetStreamPath())) {
            throw new IllegalArgumentException("Null or empty Target Stream path");
        }
        if (this.getParameters().getTargetStreamPath().endsWith("/")) {
            throw new IllegalArgumentException("Invalid TargetStreamPath, a stream path should not end with /");
        }
        if (this.getParameters().getAccountName() == null || StringUtils.isEmpty((CharSequence)this.getParameters().getAccountName())) {
            throw new IllegalArgumentException("Null or empty Account Name");
        }
        if (this.getParameters().getThreadCount() < 1 || this.getParameters().getThreadCount() > 1024) {
            throw new IllegalArgumentException(MessageFormat.format("ThreadCount must be at least 1 and at most {0}", 1024));
        }
    }

    private UploadMetadata getMetadata() throws IOException, InvalidMetadataException, UploadFailedException {
        UploadMetadataGenerator metadataGenerator = new UploadMetadataGenerator(this.parameters);
        if (this.getParameters().isResume()) {
            return metadataGenerator.getExistingMetadata(this.metadataFilePath);
        }
        return metadataGenerator.createNewMetadata(this.metadataFilePath);
    }

    public void deleteMetadataFile() {
        File toDelete = new File(this.metadataFilePath);
        if (toDelete.exists()) {
            toDelete.delete();
        }
    }

    private void validateMetadataForResume(UploadMetadata metadata) throws Exception {
        this.validateMetadataMatchesLocalFile(metadata);
        if (!this.getParameters().isOverwrite() && this.frontEnd.streamExists(metadata.getTargetStreamPath())) {
            throw new OperationsException("Target Stream already exists");
        }
        if (this.getParameters().isBinary() != metadata.isBinary()) {
            throw new OperationsException(MessageFormat.format("Existing metadata was created for a {0}binary file while the current parameters requested a {1}binary upload.", metadata.isBinary() ? "" : "non-", this.getParameters().isBinary() ? "" : "non-"));
        }
        block2: for (UploadSegmentMetadata segment : metadata.getSegments()) {
            if (segment.getStatus() == SegmentUploadStatus.Complete) {
                for (int retryCount = 0; retryCount < 4; ++retryCount) {
                    try {
                        if (!this.frontEnd.streamExists(segment.getPath())) {
                            segment.setStatus(SegmentUploadStatus.Pending);
                            continue block2;
                        }
                        long remoteLength = this.frontEnd.getStreamLength(segment.getPath());
                        if (remoteLength == segment.getLength()) continue block2;
                        segment.setStatus(SegmentUploadStatus.Pending);
                        continue block2;
                    }
                    catch (Exception e) {
                        if (retryCount >= 4) {
                            throw new UploadFailedException(MessageFormat.format("Cannot validate metadata in order to resume due to the following exception retrieving file information: {0}", e));
                        }
                        SingleSegmentUploader.waitForRetry(retryCount, this.parameters.isUseSegmentBlockBackOffRetryStrategy());
                        continue;
                    }
                }
                continue;
            }
            segment.setStatus(SegmentUploadStatus.Pending);
        }
        metadata.save();
    }

    private void validateMetadataForFreshUpload(UploadMetadata metadata) throws Exception {
        this.validateMetadataMatchesLocalFile(metadata);
        if (!this.getParameters().isOverwrite() && this.frontEnd.streamExists(metadata.getTargetStreamPath())) {
            throw new OperationsException("Target Stream already exists");
        }
    }

    private void validateMetadataMatchesLocalFile(UploadMetadata metadata) throws OperationsException {
        if (!metadata.getTargetStreamPath().trim().equalsIgnoreCase(this.getParameters().getTargetStreamPath().trim())) {
            throw new OperationsException("Metadata points to a different target stream than the input parameters");
        }
        File metadataInputFileInfo = new File(metadata.getInputFilePath());
        File paramInputFileInfo = new File(this.getParameters().getInputFilePath());
        if (!paramInputFileInfo.toString().toLowerCase().equals(metadataInputFileInfo.toString().toLowerCase())) {
            throw new OperationsException("The metadata refers to different file than the one requested");
        }
        if (!metadataInputFileInfo.exists()) {
            throw new OperationsException("The metadata refers to a file that does not exist");
        }
        if (metadata.getFileLength() != metadataInputFileInfo.length()) {
            throw new OperationsException("The metadata's file information differs from the actual file");
        }
    }

    private void uploadFile(UploadMetadata metadata) throws Exception {
        try {
            if (this.getParameters().isResume()) {
                this.validateMetadataForResume(metadata);
            } else {
                this.validateMetadataForFreshUpload(metadata);
            }
            if (metadata.getSegmentCount() == 0) {
                this.frontEnd.createStream(metadata.getTargetStreamPath(), true, null, 0);
            } else if (metadata.getSegmentCount() > 1) {
                MultipleSegmentUploader msu = new MultipleSegmentUploader(metadata, this.getParameters().getThreadCount(), this.frontEnd);
                msu.setUseSegmentBlockBackOffRetryStrategy(this.getParameters().isUseSegmentBlockBackOffRetryStrategy());
                msu.upload();
                this.concatenateSegments(metadata);
            } else {
                UploadSegmentMetadata[] toUse = metadata.getSegments();
                toUse[0].setPath(metadata.getTargetStreamPath());
                metadata.setSegments(toUse);
                SingleSegmentUploader ssu = new SingleSegmentUploader(0, metadata, this.frontEnd);
                ssu.setUseBackOffRetryStrategy(this.getParameters().isUseSegmentBlockBackOffRetryStrategy());
                ssu.upload();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void concatenateSegments(final UploadMetadata metadata) throws Exception {
        final String[] inputPaths = new String[metadata.getSegmentCount()];
        if (this.frontEnd.streamExists(metadata.getTargetStreamPath())) {
            if (this.getParameters().isOverwrite()) {
                this.frontEnd.deleteStream(metadata.getTargetStreamPath(), false);
            } else {
                throw new OperationsException("Target Stream already exists");
            }
        }
        final ArrayList<Exception> exceptions = new ArrayList<Exception>();
        ExecutorService exec = Executors.newFixedThreadPool(this.getParameters().getThreadCount());
        int i = 0;
        while (i < metadata.getSegmentCount()) {
            final int finalI = i++;
            exec.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (metadata.getSegments()[finalI].getStatus() != SegmentUploadStatus.Complete) {
                            throw new UploadFailedException("Cannot perform 'concatenate' operation because not all streams are fully uploaded.");
                        }
                        String remoteStreamPath = metadata.getSegments()[finalI].getPath();
                        long remoteLength = -1L;
                        for (int retryCount = 0; retryCount < 4; ++retryCount) {
                            try {
                                remoteLength = DataLakeStoreUploader.this.frontEnd.getStreamLength(remoteStreamPath);
                                break;
                            }
                            catch (Exception e) {
                                if (retryCount >= 4) {
                                    throw new UploadFailedException(MessageFormat.format("Cannot perform 'concatenate' operation due to the following exception retrieving file information: {0}", e));
                                }
                                SingleSegmentUploader.waitForRetry(retryCount, DataLakeStoreUploader.this.parameters.isUseSegmentBlockBackOffRetryStrategy());
                                continue;
                            }
                        }
                        if (remoteLength != metadata.getSegments()[finalI].getLength()) {
                            throw new UploadFailedException(MessageFormat.format("Cannot perform 'concatenate' operation because segment {0} has an incorrect length (expected {1}, actual {2}).", finalI, metadata.getSegments()[finalI].getLength(), remoteLength));
                        }
                        inputPaths[finalI] = remoteStreamPath;
                    }
                    catch (Exception ex) {
                        List list = exceptions;
                        synchronized (list) {
                            exceptions.add(ex);
                        }
                    }
                }
            });
        }
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            exceptions.add(e);
        }
        if (exceptions.size() > 0) {
            throw new AggregateUploadException("At least one concatenate test failed", (Exception)exceptions.remove(0), exceptions);
        }
        this.frontEnd.concatenate(metadata.getTargetStreamPath(), inputPaths);
    }
}

