/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.uploader;

import com.microsoft.azure.management.datalake.store.uploader.AggregateUploadException;
import com.microsoft.azure.management.datalake.store.uploader.FrontEndAdapter;
import com.microsoft.azure.management.datalake.store.uploader.SegmentUploadStatus;
import com.microsoft.azure.management.datalake.store.uploader.SingleSegmentUploader;
import com.microsoft.azure.management.datalake.store.uploader.UploadMetadata;
import com.microsoft.azure.management.datalake.store.uploader.UploadSegmentMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class MultipleSegmentUploader
implements Runnable {
    public static final int MAX_UPLOAD_ATTEMPT_COUNT = 4;
    private UploadMetadata metadata;
    private FrontEndAdapter frontEnd;
    private int maxThreadCount;
    private Queue<SegmentQueueItem> pendingSegments;
    private List<Exception> exceptions;
    private boolean useSegmentBlockBackOffRetryStrategy;

    public MultipleSegmentUploader(UploadMetadata uploadMetadata, int maxThreadCount, FrontEndAdapter frontEnd) {
        this.metadata = uploadMetadata;
        this.maxThreadCount = maxThreadCount;
        this.frontEnd = frontEnd;
        this.exceptions = new ArrayList<Exception>();
        this.pendingSegments = MultipleSegmentUploader.getPendingSegmentsToUpload(this.metadata);
        this.useSegmentBlockBackOffRetryStrategy = true;
    }

    public boolean useSegmentBlockBackOffRetryStrategy() {
        return this.useSegmentBlockBackOffRetryStrategy;
    }

    public void setUseSegmentBlockBackOffRetryStrategy(boolean isEnabled) {
        this.useSegmentBlockBackOffRetryStrategy = isEnabled;
    }

    public void upload() throws InterruptedException, AggregateUploadException {
        int threadCount = Math.min(this.pendingSegments.size(), this.maxThreadCount);
        ArrayList<Thread> threads = new ArrayList<Thread>(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            Thread t = new Thread(this);
            t.start();
            threads.add(t);
        }
        for (Thread t : threads) {
            t.join();
        }
        if (this.exceptions.size() > 0) {
            throw new AggregateUploadException("One or more segments could not be uploaded. Review the upload Metadata to determine which segments failed", this.exceptions.remove(0), this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingSegments(Queue<SegmentQueueItem> pendingSegments, Collection<Exception> exceptions) {
        while (pendingSegments.size() > 0) {
            SegmentQueueItem toProcess;
            Queue<SegmentQueueItem> queue = pendingSegments;
            synchronized (queue) {
                if (pendingSegments.size() == 0) {
                    break;
                }
                toProcess = pendingSegments.remove();
            }
            try {
                this.uploadSegment(toProcess.segmentNumber, this.metadata);
            }
            catch (Exception ex) {
                Collection<Object> collection;
                if (toProcess.attemptCount + 1 < 4) {
                    collection = pendingSegments;
                    synchronized (collection) {
                        pendingSegments.add(new SegmentQueueItem(toProcess.segmentNumber, toProcess.attemptCount + 1));
                        continue;
                    }
                }
                collection = exceptions;
                synchronized (collection) {
                    exceptions.add(ex);
                }
            }
        }
    }

    private void uploadSegment(int segmentNumber, UploadMetadata metadata) throws Exception {
        MultipleSegmentUploader.updateSegmentMetadataStatus(metadata, segmentNumber, SegmentUploadStatus.InProgress);
        SingleSegmentUploader segmentUploader = new SingleSegmentUploader(segmentNumber, metadata, this.frontEnd);
        segmentUploader.setUseBackOffRetryStrategy(this.useSegmentBlockBackOffRetryStrategy);
        try {
            segmentUploader.upload();
            MultipleSegmentUploader.updateSegmentMetadataStatus(metadata, segmentNumber, SegmentUploadStatus.Complete);
        }
        catch (Exception e) {
            MultipleSegmentUploader.updateSegmentMetadataStatus(metadata, segmentNumber, SegmentUploadStatus.Failed);
            throw e;
        }
    }

    private static Queue<SegmentQueueItem> getPendingSegmentsToUpload(UploadMetadata metadata) {
        LinkedList<SegmentQueueItem> result = new LinkedList<SegmentQueueItem>();
        for (UploadSegmentMetadata segment : metadata.getSegments()) {
            if (segment.getStatus() != SegmentUploadStatus.Pending) continue;
            result.add(new SegmentQueueItem(segment.getSegmentNumber(), 0));
        }
        return result;
    }

    private static void updateSegmentMetadataStatus(UploadMetadata metadata, int segmentNumber, SegmentUploadStatus newStatus) {
        UploadSegmentMetadata[] toSave = metadata.getSegments();
        toSave[segmentNumber].setStatus(newStatus);
        metadata.setSegments(toSave);
        try {
            metadata.save();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.processPendingSegments(this.pendingSegments, this.exceptions);
    }

    private static class SegmentQueueItem {
        private int segmentNumber;
        private int attemptCount;

        SegmentQueueItem(int segmentNumber, int attemptCount) {
            this.segmentNumber = segmentNumber;
            this.attemptCount = attemptCount;
        }

        public int getSegmentNumber() {
            return this.segmentNumber;
        }

        public int getAttemptCount() {
            return this.attemptCount;
        }
    }
}

