/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.uploader;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public final class StringExtensions {
    private StringExtensions() {
    }

    public static int findNewline(byte[] buffer, int startOffset, int length, boolean reverse, Charset encoding, String delimiter) {
        int bytesPerChar;
        if (buffer.length == 0 || length == 0) {
            return -1;
        }
        if (encoding.equals(StandardCharsets.UTF_16) || encoding.equals(StandardCharsets.UTF_16BE) || encoding.equals(StandardCharsets.UTF_16LE)) {
            bytesPerChar = 2;
        } else if (encoding.equals(StandardCharsets.US_ASCII) || encoding.equals(StandardCharsets.UTF_8)) {
            bytesPerChar = 1;
        } else {
            throw new IllegalArgumentException("Only the following encodings are allowed: UTF-8, UTF-16, UTF-16BE, UTF16-LE and ASCII");
        }
        if (delimiter != null && !StringUtils.isEmpty((CharSequence)delimiter) && delimiter.length() > 1) {
            throw new IllegalArgumentException("The delimiter must only be a single character or unspecified to represent the CRLF delimiter");
        }
        if (delimiter != null && !StringUtils.isEmpty((CharSequence)delimiter)) {
            int startOfSegment = reverse ? startOffset - length + 1 : startOffset;
            String bytesToString = new String(buffer, startOfSegment, length, encoding);
            if (!bytesToString.contains(delimiter)) {
                return -1;
            }
            int numCharsToDelim = reverse ? bytesToString.lastIndexOf(delimiter) : bytesToString.indexOf(delimiter);
            int toReturn = 0;
            for (int i = 0; i <= numCharsToDelim; ++i) {
                toReturn += Character.toString(bytesToString.charAt(startOfSegment + i)).getBytes(encoding).length;
            }
            return toReturn - 1;
        }
        int endOffset = reverse ? startOffset - length : startOffset + length;
        int n = startOffset = reverse ? startOffset - (bytesPerChar - 1) : startOffset;
        if (startOffset < 0 || startOffset >= buffer.length) {
            throw new IndexOutOfBoundsException("Given start offset is outside the bounds of the given buffer. In reverse cases, the start offset is modified to ensure we check the full size of the last character");
        }
        if (length < bytesPerChar) {
            throw new IllegalArgumentException("length must be at least as long as the length, in bytes, of a single character");
        }
        if (endOffset < -1 || endOffset > buffer.length) {
            throw new IndexOutOfBoundsException("Given combination of startOffset and length would execute the search outside the bounds of the given buffer.");
        }
        int bufferEndOffset = reverse ? startOffset : startOffset + length;
        int result = -1;
        int charPos = startOffset;
        while (reverse ? charPos != endOffset : charPos + bytesPerChar - 1 < endOffset) {
            block24: {
                char c;
                block23: {
                    block22: {
                        if (bytesPerChar != 1) break block22;
                        c = (char)buffer[charPos];
                        break block23;
                    }
                    String temp = new String(buffer, charPos, bytesPerChar, encoding);
                    if (StringUtils.isEmpty((CharSequence)temp)) break block24;
                    c = temp.toCharArray()[0];
                }
                if (StringExtensions.isNewline(c, delimiter)) {
                    result = charPos + bytesPerChar - 1;
                    break;
                }
            }
            charPos = reverse ? charPos - 1 : charPos + 1;
        }
        if ((delimiter == null || StringUtils.isEmpty((CharSequence)delimiter)) && !reverse && result < bufferEndOffset - bytesPerChar) {
            char c;
            if (bytesPerChar == 1) {
                c = (char)buffer[result + bytesPerChar];
            } else {
                String temp = new String(buffer, result + 1, bytesPerChar, encoding);
                if (StringUtils.isEmpty((CharSequence)temp)) {
                    return result;
                }
                c = temp.toCharArray()[0];
            }
            if (StringExtensions.isNewline(c, delimiter)) {
                result += bytesPerChar;
            }
        }
        return result;
    }

    private static boolean isNewline(char c, String delimiter) {
        if (delimiter == null || StringUtils.isEmpty((CharSequence)delimiter)) {
            return c == '\r' || c == '\n';
        }
        return c == delimiter.toCharArray()[0];
    }
}

