/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.uploader;

import com.microsoft.azure.management.datalake.store.uploader.InvalidMetadataException;
import com.microsoft.azure.management.datalake.store.uploader.UploadParameters;
import com.microsoft.azure.management.datalake.store.uploader.UploadSegmentMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class UploadMetadata
implements Serializable {
    private static Object saveSync = new Object();
    private transient String metadataFilePath;
    private String uploadId;
    private String inputFilePath;
    private long fileLength;
    private String targetStreamPath;
    private String segmentStreamDirectory;
    private int segmentCount;
    private long segmentLength;
    private UploadSegmentMetadata[] segments;
    private boolean isBinary;
    private String encodingName;
    private String delimiter;

    public UploadMetadata(String metadataFilePath, UploadParameters uploadParameters) {
        this.metadataFilePath = metadataFilePath;
        this.uploadId = UUID.randomUUID().toString();
        this.inputFilePath = uploadParameters.getInputFilePath();
        this.targetStreamPath = uploadParameters.getTargetStreamPath();
        String[] streamData = this.splitTargetStreamPathByName();
        String streamName = streamData[0];
        String streamDirectory = streamData[1];
        this.segmentStreamDirectory = streamDirectory == null || StringUtils.isEmpty((CharSequence)streamDirectory) ? MessageFormat.format("/{0}.segments.{1}", streamName, UUID.randomUUID()) : MessageFormat.format("{0}/{1}.segments.{2}", streamDirectory, streamName, UUID.randomUUID());
        this.isBinary = uploadParameters.isBinary();
        File fileInfo = new File(uploadParameters.getInputFilePath());
        this.fileLength = fileInfo.length();
        this.encodingName = uploadParameters.getFileEncoding().name();
        int preliminarySegmentCount = (int)Math.ceil((double)fileInfo.length() / (double)uploadParameters.getMaxSegementLength());
        this.segmentCount = Math.min(preliminarySegmentCount, UploadSegmentMetadata.calculateSegmentCount(fileInfo.length()));
        this.segmentLength = UploadSegmentMetadata.calculateSegmentLength(fileInfo.length(), this.segmentCount);
        this.segments = new UploadSegmentMetadata[this.segmentCount];
        for (int i = 0; i < this.segmentCount; ++i) {
            this.segments[i] = new UploadSegmentMetadata(i, this);
        }
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public String getTargetStreamPath() {
        return this.targetStreamPath;
    }

    public String getSegmentStreamDirectory() {
        return this.segmentStreamDirectory;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public void setSegmentCount(int segCount) {
        this.segmentCount = segCount;
    }

    public long getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(long segLength) {
        this.segmentLength = segLength;
    }

    public UploadSegmentMetadata[] getSegments() {
        return this.segments;
    }

    public void setSegments(UploadSegmentMetadata[] segs) {
        this.segments = segs;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getMetadataFilePath() {
        return this.metadataFilePath;
    }

    public void setMetadataFilePath(String metadataFilePath) {
        this.metadataFilePath = metadataFilePath;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public void setInputFilePath(String inputFilePath) {
        this.inputFilePath = inputFilePath;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public void setTargetStreamPath(String targetStreamPath) {
        this.targetStreamPath = targetStreamPath;
    }

    public void setSegmentStreamDirectory(String segmentStreamDirectory) {
        this.segmentStreamDirectory = segmentStreamDirectory;
    }

    public void setBinary(boolean binary) {
        this.isBinary = binary;
    }

    public void setEncodingName(String encodingName) {
        this.encodingName = encodingName;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    protected UploadMetadata() {
        this.encodingName = StandardCharsets.UTF_8.name();
    }

    public static UploadMetadata loadFrom(String filePath) throws FileNotFoundException, InvalidMetadataException {
        if (!new File(filePath).exists()) {
            throw new FileNotFoundException("Could not find metadata file: " + filePath);
        }
        UploadMetadata result = null;
        try {
            FileInputStream fileIn = new FileInputStream(filePath);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            result = (UploadMetadata)in.readObject();
            in.close();
            fileIn.close();
            result.metadataFilePath = filePath;
            return result;
        }
        catch (Exception ex) {
            throw new InvalidMetadataException("Unable to parse metadata file", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException, InvalidMetadataException {
        if (this.metadataFilePath == null || StringUtils.isEmpty((CharSequence)this.metadataFilePath)) {
            throw new InvalidObjectException("Null or empty metadataFilePath. Cannot save metadata until this property is set.");
        }
        this.validateConsistency();
        Object object = saveSync;
        synchronized (object) {
            File curMetadata = new File(this.metadataFilePath);
            if (curMetadata.exists()) {
                curMetadata.delete();
            }
            curMetadata.getParentFile().mkdirs();
            curMetadata.createNewFile();
            try {
                FileOutputStream fileOut = new FileOutputStream(this.metadataFilePath);
                ObjectOutputStream out = new ObjectOutputStream(fileOut);
                out.writeObject(this);
                out.close();
                fileOut.close();
            }
            catch (Exception ex) {
                throw new InvalidMetadataException("Unable to parse metadata object and write it to a file", ex);
            }
        }
    }

    public void deleteFile() throws InvalidObjectException {
        if (this.metadataFilePath == null || StringUtils.isEmpty((CharSequence)this.metadataFilePath)) {
            throw new InvalidObjectException("Null or empty metadataFilePath. Cannot delete metadata until this property is set.");
        }
        File curMetadata = new File(this.metadataFilePath);
        if (curMetadata.exists()) {
            curMetadata.delete();
        }
    }

    public void validateConsistency() throws InvalidMetadataException {
        if (this.segments == null || this.segments.length != this.segmentCount) {
            throw new InvalidMetadataException("Inconsistent number of segments");
        }
        long sum = 0L;
        int lastSegmentNumber = -1;
        BitSet segments = new BitSet(this.segmentCount);
        for (UploadSegmentMetadata segment : this.segments) {
            if (segment.getSegmentNumber() < 0 || segment.getSegmentNumber() >= this.segmentCount) {
                throw new InvalidMetadataException(MessageFormat.format("Segment numbers must be at least 0 and less than {0}. Found segment number {1}.", this.segmentCount, segment.getSegmentNumber()));
            }
            if (segment.getSegmentNumber() <= lastSegmentNumber) {
                throw new InvalidMetadataException(MessageFormat.format("Segment number {0} appears out of order.", segment.getSegmentNumber()));
            }
            if (segments.get(segment.getSegmentNumber())) {
                throw new InvalidMetadataException(MessageFormat.format("Segment number {0} appears twice", segment.getSegmentNumber()));
            }
            if (segment.getOffset() != sum) {
                throw new InvalidMetadataException(MessageFormat.format("Segment number {0} has an invalid starting offset ({1}). Expected {2}.", segment.getSegmentNumber(), segment.getOffset(), sum));
            }
            segments.set(segment.getSegmentNumber());
            sum += segment.getLength();
            lastSegmentNumber = segment.getSegmentNumber();
        }
        if (sum != this.fileLength) {
            throw new InvalidMetadataException("The individual segment lengths do not add up to the input File length");
        }
    }

    public String[] splitTargetStreamPathByName() {
        String[] toReturn = new String[2];
        int numFoldersInPath = this.targetStreamPath.split("/").length;
        if (numFoldersInPath - 1 == 0 || numFoldersInPath - 1 == 1 && this.targetStreamPath.startsWith("/")) {
            toReturn[0] = this.targetStreamPath.replaceAll("^[/]", "");
            toReturn[1] = null;
        } else {
            toReturn[0] = this.targetStreamPath.substring(this.targetStreamPath.lastIndexOf(47) + 1);
            toReturn[1] = this.targetStreamPath.substring(0, this.targetStreamPath.lastIndexOf(47));
        }
        return toReturn;
    }
}

