/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.uploader;

import com.microsoft.azure.management.datalake.store.uploader.InvalidMetadataException;
import com.microsoft.azure.management.datalake.store.uploader.StringExtensions;
import com.microsoft.azure.management.datalake.store.uploader.UploadFailedException;
import com.microsoft.azure.management.datalake.store.uploader.UploadMetadata;
import com.microsoft.azure.management.datalake.store.uploader.UploadParameters;
import com.microsoft.azure.management.datalake.store.uploader.UploadSegmentMetadata;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class UploadMetadataGenerator {
    private UploadParameters parameters;
    private int maxAppendLength;

    public UploadMetadataGenerator(UploadParameters parameters) {
        this(parameters, 0x400000);
    }

    public UploadMetadataGenerator(UploadParameters parameters, int maxAppendLength) {
        this.parameters = parameters;
        this.maxAppendLength = maxAppendLength;
    }

    public UploadMetadata getExistingMetadata(String metadataFilePath) throws FileNotFoundException, InvalidMetadataException {
        UploadMetadata metadata = UploadMetadata.loadFrom(metadataFilePath);
        metadata.validateConsistency();
        return metadata;
    }

    public UploadMetadata createNewMetadata(String metadataFilePath) throws IOException, UploadFailedException, InvalidMetadataException {
        UploadMetadata metadata = new UploadMetadata(metadataFilePath, this.parameters);
        if (!this.parameters.isBinary() && metadata.getSegmentCount() > 1) {
            this.alignSegmentsToRecordBoundaries(metadata);
        }
        metadata.save();
        return metadata;
    }

    private void alignSegmentsToRecordBoundaries(UploadMetadata metadata) throws IOException, UploadFailedException {
        int remainingSegments = 0;
        try (RandomAccessFile stream = new RandomAccessFile(metadata.getInputFilePath(), "r");){
            long offset = 0L;
            for (int i = 0; i < metadata.getSegments().length; ++i) {
                UploadSegmentMetadata segment = metadata.getSegments()[i];
                long diff = segment.getOffset() - offset;
                segment.setOffset(offset);
                segment.setLength(segment.getLength() + diff);
                if (segment.getOffset() >= metadata.getFileLength()) continue;
                if (segment.getSegmentNumber() == metadata.getSegments().length - 1) {
                    segment.setLength(metadata.getFileLength() - segment.getOffset());
                } else {
                    int lengthAdjustment = this.determineLengthAdjustment(segment, stream, Charset.forName(metadata.getEncodingName()), metadata.getDelimiter()) + 1;
                    segment.setLength(segment.getLength() + (long)lengthAdjustment);
                }
                offset += segment.getLength();
                ++remainingSegments;
            }
        }
        Object[] segments = metadata.getSegments();
        if (remainingSegments < segments.length) {
            ArrayUtils.subarray((Object[])segments, (int)0, (int)remainingSegments);
            metadata.setSegments((UploadSegmentMetadata[])segments);
            metadata.setSegmentCount(segments.length);
        }
    }

    private int determineLengthAdjustment(UploadSegmentMetadata segment, RandomAccessFile stream, Charset encoding, String delimiter) throws UploadFailedException, IOException {
        byte[] buffer = new byte[this.maxAppendLength];
        long referenceFileOffset = segment.getOffset() + segment.getLength();
        int bytesRead = UploadMetadataGenerator.readIntoBufferAroundReference(stream, buffer, referenceFileOffset);
        if (bytesRead > 0) {
            int closestNewLinePos;
            int newNewLinePosBefore;
            int middlePoint = bytesRead / 2;
            int newLinePosBefore = StringExtensions.findNewline(buffer, middlePoint + 1, middlePoint + 1, true, encoding, delimiter);
            if ((delimiter == null || StringUtils.isEmpty((CharSequence)delimiter)) && newLinePosBefore == middlePoint + 1 && buffer[newLinePosBefore] == 13 && (newNewLinePosBefore = StringExtensions.findNewline(buffer, middlePoint, middlePoint, true, encoding, delimiter)) >= 0) {
                newLinePosBefore = newNewLinePosBefore;
            }
            int newLinePosAfter = StringExtensions.findNewline(buffer, middlePoint, middlePoint, false, encoding, delimiter);
            if ((delimiter == null || StringUtils.isEmpty((CharSequence)delimiter)) && newLinePosAfter == buffer.length - 1 && buffer[newLinePosAfter] == 13 && newLinePosBefore >= 0) {
                newLinePosAfter = -1;
            }
            if ((closestNewLinePos = UploadMetadataGenerator.findClosestToCenter(newLinePosBefore, newLinePosAfter, middlePoint)) >= 0) {
                return closestNewLinePos - middlePoint;
            }
        }
        throw new UploadFailedException(MessageFormat.format("Unable to locate a record boundary within {0}MB on either side of segment {1} (offset {2}). This means the record at that offset is larger than {0}MB.", this.maxAppendLength / 1024 / 1024 / 2, segment.getSegmentNumber(), segment.getOffset(), this.maxAppendLength / 1024 / 1024));
    }

    private static int findClosestToCenter(int value1, int value2, int centerValue) {
        if (value1 >= 0) {
            if (value2 >= 0) {
                return Math.abs(value2 - centerValue) > Math.abs(value1 - centerValue) ? value1 : value2;
            }
            return value1;
        }
        return value2;
    }

    private static int readIntoBufferAroundReference(RandomAccessFile stream, byte[] buffer, long fileReferenceOffset) throws IOException {
        int bytesRead;
        int length = buffer.length;
        long fileStartOffset = fileReferenceOffset - (long)(length / 2);
        if (fileStartOffset < 0L) {
            length += (int)fileStartOffset;
            fileStartOffset = 0L;
            if (length <= 0) {
                return 0;
            }
        }
        if (fileStartOffset + (long)length > stream.length() && (length = (int)(stream.length() - fileStartOffset)) <= 0) {
            return 0;
        }
        stream.seek(0L);
        stream.seek(fileStartOffset);
        for (int bufferOffset = 0; bufferOffset < length; bufferOffset += bytesRead) {
            bytesRead = stream.read(buffer, bufferOffset, length - bufferOffset);
        }
        return length;
    }
}

