/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.uploader;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class UploadParameters {
    private static final long SEGMENT_LENGTH = 0x10000000L;
    private boolean useSegmentBlockBackOffRetryStrategy;
    private String inputFilePath;
    private String targetStreamPath;
    private String accountName;
    private int threadCount;
    private boolean overwrite;
    private boolean resume;
    private boolean binary;
    private long maxSegementLength;
    private String localMetadataLocation;
    private Charset fileEncoding;
    private String delimiter;

    public UploadParameters(String inputFilePath, String targetStreamPath, String accountName) {
        this(inputFilePath, targetStreamPath, accountName, 1, false, false, true, 0x10000000L, null);
    }

    public UploadParameters(String inputFilePath, String targetStreamPath, String accountName, int threadCount, boolean isOverwrite, boolean isResume) {
        this(inputFilePath, targetStreamPath, accountName, threadCount, isOverwrite, isResume, true, 0x10000000L, null);
    }

    public UploadParameters(String inputFilePath, String targetStreamPath, String accountName, int threadCount, boolean isOverwrite, boolean isResume, String localMetadataLocation) {
        this(inputFilePath, targetStreamPath, accountName, threadCount, isOverwrite, isResume, true, 0x10000000L, localMetadataLocation);
    }

    public UploadParameters(String inputFilePath, String targetStreamPath, String accountName, int threadCount, boolean isOverwrite, boolean isResume, boolean isBinary, long maxSegmentLength, String localMetadataLocation) {
        this.setInputFilePath(inputFilePath);
        this.setTargetStreamPath(targetStreamPath);
        this.setThreadCount(threadCount);
        this.setAccountName(accountName);
        this.setOverwrite(isOverwrite);
        this.setResume(isResume);
        this.setBinary(isBinary);
        this.setMaxSegementLength(maxSegmentLength);
        if (localMetadataLocation == null || StringUtils.isEmpty((CharSequence)localMetadataLocation)) {
            localMetadataLocation = System.getProperty("java.io.tmpdir");
        }
        this.setLocalMetadataLocation(localMetadataLocation);
        this.setUseSegmentBlockBackOffRetryStrategy(true);
        this.setFileEncoding(StandardCharsets.UTF_8);
        this.setDelimiter(null);
    }

    protected UploadParameters(String inputFilePath, String targetStreamPath, String accountName, boolean useSegmentBlockBackOffRetryStrategy, int threadCount, boolean isOverwrite, boolean isResume, boolean isBinary, long maxSegmentLength, String localMetadataLocation) {
        this(inputFilePath, targetStreamPath, accountName, threadCount, isOverwrite, isResume, isBinary, maxSegmentLength, localMetadataLocation);
        this.setUseSegmentBlockBackOffRetryStrategy(useSegmentBlockBackOffRetryStrategy);
    }

    public boolean isUseSegmentBlockBackOffRetryStrategy() {
        return this.useSegmentBlockBackOffRetryStrategy;
    }

    private void setUseSegmentBlockBackOffRetryStrategy(boolean useSegmentBlockBackOffRetryStrategy) {
        this.useSegmentBlockBackOffRetryStrategy = useSegmentBlockBackOffRetryStrategy;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    private void setInputFilePath(String inputFilePath) {
        this.inputFilePath = inputFilePath;
    }

    public String getTargetStreamPath() {
        return this.targetStreamPath;
    }

    private void setTargetStreamPath(String targetStreamPath) {
        this.targetStreamPath = targetStreamPath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    private void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    protected void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    private void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isResume() {
        return this.resume;
    }

    private void setResume(boolean resume) {
        this.resume = resume;
    }

    public boolean isBinary() {
        return this.binary;
    }

    private void setBinary(boolean binary) {
        this.binary = binary;
    }

    public long getMaxSegementLength() {
        return this.maxSegementLength;
    }

    private void setMaxSegementLength(long maxSegementLength) {
        this.maxSegementLength = maxSegementLength;
    }

    public String getLocalMetadataLocation() {
        return this.localMetadataLocation;
    }

    private void setLocalMetadataLocation(String localMetadataLocation) {
        this.localMetadataLocation = localMetadataLocation;
    }

    public Charset getFileEncoding() {
        return this.fileEncoding;
    }

    private void setFileEncoding(Charset fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    private void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

