/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns;

import com.microsoft.azure.management.dns.DnsManagementClientImpl;
import com.microsoft.azure.management.dns.RecordSetOperations;
import com.microsoft.azure.management.dns.models.ARecord;
import com.microsoft.azure.management.dns.models.AaaaRecord;
import com.microsoft.azure.management.dns.models.CnameRecord;
import com.microsoft.azure.management.dns.models.MxRecord;
import com.microsoft.azure.management.dns.models.NsRecord;
import com.microsoft.azure.management.dns.models.PtrRecord;
import com.microsoft.azure.management.dns.models.RecordSet;
import com.microsoft.azure.management.dns.models.RecordSetCreateOrUpdateParameters;
import com.microsoft.azure.management.dns.models.RecordSetCreateOrUpdateResponse;
import com.microsoft.azure.management.dns.models.RecordSetDeleteParameters;
import com.microsoft.azure.management.dns.models.RecordSetGetResponse;
import com.microsoft.azure.management.dns.models.RecordSetListParameters;
import com.microsoft.azure.management.dns.models.RecordSetListResponse;
import com.microsoft.azure.management.dns.models.RecordSetProperties;
import com.microsoft.azure.management.dns.models.RecordType;
import com.microsoft.azure.management.dns.models.SoaRecord;
import com.microsoft.azure.management.dns.models.SrvRecord;
import com.microsoft.azure.management.dns.models.TxtRecord;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class RecordSetOperationsImpl
implements ServiceOperations<DnsManagementClientImpl>,
RecordSetOperations {
    private DnsManagementClientImpl client;

    RecordSetOperationsImpl(DnsManagementClientImpl client) {
        this.client = client;
    }

    public DnsManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<RecordSetCreateOrUpdateResponse> createOrUpdateAsync(final String resourceGroupName, final String zoneName, final String relativeRecordSetName, final RecordType recordType, final RecordSetCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<RecordSetCreateOrUpdateResponse>(){

            @Override
            public RecordSetCreateOrUpdateResponse call() throws Exception {
                return RecordSetOperationsImpl.this.createOrUpdate(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordSetCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        ObjectNode recordSetCreateOrUpdateParametersValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        if (relativeRecordSetName == null) {
            throw new NullPointerException("relativeRecordSetName");
        }
        if (recordType == null) {
            throw new NullPointerException("recordType");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getRecordSet() == null) {
            throw new NullPointerException("parameters.RecordSet");
        }
        if (parameters.getRecordSet().getLocation() == null) {
            throw new NullPointerException("parameters.RecordSet.Location");
        }
        if (parameters.getRecordSet().getProperties() != null) {
            if (parameters.getRecordSet().getProperties().getAaaaRecords() != null) {
                for (AaaaRecord aaaaRecordsParameterItem : parameters.getRecordSet().getProperties().getAaaaRecords()) {
                    if (aaaaRecordsParameterItem.getIpv6Address() != null) continue;
                    throw new NullPointerException("parameters.RecordSet.Properties.AaaaRecords.Ipv6Address");
                }
            }
            if (parameters.getRecordSet().getProperties().getARecords() != null) {
                for (ARecord aRecordsParameterItem : parameters.getRecordSet().getProperties().getARecords()) {
                    if (aRecordsParameterItem.getIpv4Address() != null) continue;
                    throw new NullPointerException("parameters.RecordSet.Properties.ARecords.Ipv4Address");
                }
            }
            if (parameters.getRecordSet().getProperties().getCnameRecord() != null && parameters.getRecordSet().getProperties().getCnameRecord().getCname() == null) {
                throw new NullPointerException("parameters.RecordSet.Properties.CnameRecord.Cname");
            }
            if (parameters.getRecordSet().getProperties().getMxRecords() != null) {
                for (MxRecord mxRecordsParameterItem : parameters.getRecordSet().getProperties().getMxRecords()) {
                    if (mxRecordsParameterItem.getExchange() != null) continue;
                    throw new NullPointerException("parameters.RecordSet.Properties.MxRecords.Exchange");
                }
            }
            if (parameters.getRecordSet().getProperties().getNsRecords() != null) {
                for (NsRecord nsRecordsParameterItem : parameters.getRecordSet().getProperties().getNsRecords()) {
                    if (nsRecordsParameterItem.getNsdname() != null) continue;
                    throw new NullPointerException("parameters.RecordSet.Properties.NsRecords.Nsdname");
                }
            }
            if (parameters.getRecordSet().getProperties().getPtrRecords() != null) {
                for (PtrRecord ptrRecordsParameterItem : parameters.getRecordSet().getProperties().getPtrRecords()) {
                    if (ptrRecordsParameterItem.getPtrdname() != null) continue;
                    throw new NullPointerException("parameters.RecordSet.Properties.PtrRecords.Ptrdname");
                }
            }
            if (parameters.getRecordSet().getProperties().getSoaRecord() != null) {
                if (parameters.getRecordSet().getProperties().getSoaRecord().getEmail() == null) {
                    throw new NullPointerException("parameters.RecordSet.Properties.SoaRecord.Email");
                }
                if (parameters.getRecordSet().getProperties().getSoaRecord().getHost() == null) {
                    throw new NullPointerException("parameters.RecordSet.Properties.SoaRecord.Host");
                }
            }
            if (parameters.getRecordSet().getProperties().getSrvRecords() != null) {
                for (SrvRecord srvRecordsParameterItem : parameters.getRecordSet().getProperties().getSrvRecords()) {
                    if (srvRecordsParameterItem.getTarget() != null) continue;
                    throw new NullPointerException("parameters.RecordSet.Properties.SrvRecords.Target");
                }
            }
            if (parameters.getRecordSet().getProperties().getTxtRecords() != null) {
                for (TxtRecord txtRecordsParameterItem : parameters.getRecordSet().getProperties().getTxtRecords()) {
                    if (txtRecordsParameterItem.getValue() != null) continue;
                    throw new NullPointerException("parameters.RecordSet.Properties.TxtRecords.Value");
                }
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            tracingParameters.put("relativeRecordSetName", relativeRecordSetName);
            tracingParameters.put("recordType", (Object)recordType);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(recordType.toString(), "UTF-8");
        url = url + "/";
        url = url + relativeRecordSetName;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("If-Match", parameters.getRecordSet().getETag());
        httpRequest.setHeader("If-None-Match", parameters.getIfNoneMatch());
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = recordSetCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        if (parameters.getRecordSet().getETag() != null) {
            recordSetCreateOrUpdateParametersValue.put("etag", parameters.getRecordSet().getETag());
        }
        if (parameters.getRecordSet().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            recordSetCreateOrUpdateParametersValue.put("properties", (JsonNode)propertiesValue);
            propertiesValue.put("TTL", parameters.getRecordSet().getProperties().getTtl());
            if (parameters.getRecordSet().getProperties().getARecords() != null) {
                ArrayNode aRecordsArray = objectMapper.createArrayNode();
                for (ARecord aRecordsItem : parameters.getRecordSet().getProperties().getARecords()) {
                    ObjectNode aRecordValue = objectMapper.createObjectNode();
                    aRecordsArray.add((JsonNode)aRecordValue);
                    aRecordValue.put("ipv4Address", aRecordsItem.getIpv4Address());
                }
                propertiesValue.put("ARecords", (JsonNode)aRecordsArray);
            }
            if (parameters.getRecordSet().getProperties().getAaaaRecords() != null) {
                ArrayNode aAAARecordsArray = objectMapper.createArrayNode();
                for (AaaaRecord aAAARecordsItem : parameters.getRecordSet().getProperties().getAaaaRecords()) {
                    ObjectNode aaaaRecordValue = objectMapper.createObjectNode();
                    aAAARecordsArray.add((JsonNode)aaaaRecordValue);
                    aaaaRecordValue.put("ipv6Address", aAAARecordsItem.getIpv6Address());
                }
                propertiesValue.put("AAAARecords", (JsonNode)aAAARecordsArray);
            }
            if (parameters.getRecordSet().getProperties().getMxRecords() != null) {
                ArrayNode mXRecordsArray = objectMapper.createArrayNode();
                for (MxRecord mXRecordsItem : parameters.getRecordSet().getProperties().getMxRecords()) {
                    ObjectNode mxRecordValue = objectMapper.createObjectNode();
                    mXRecordsArray.add((JsonNode)mxRecordValue);
                    mxRecordValue.put("preference", mXRecordsItem.getPreference());
                    mxRecordValue.put("exchange", mXRecordsItem.getExchange());
                }
                propertiesValue.put("MXRecords", (JsonNode)mXRecordsArray);
            }
            if (parameters.getRecordSet().getProperties().getNsRecords() != null) {
                ArrayNode nSRecordsArray = objectMapper.createArrayNode();
                for (NsRecord nSRecordsItem : parameters.getRecordSet().getProperties().getNsRecords()) {
                    ObjectNode nsRecordValue = objectMapper.createObjectNode();
                    nSRecordsArray.add((JsonNode)nsRecordValue);
                    nsRecordValue.put("nsdname", nSRecordsItem.getNsdname());
                }
                propertiesValue.put("NSRecords", (JsonNode)nSRecordsArray);
            }
            if (parameters.getRecordSet().getProperties().getPtrRecords() != null) {
                ArrayNode pTRRecordsArray = objectMapper.createArrayNode();
                for (PtrRecord pTRRecordsItem : parameters.getRecordSet().getProperties().getPtrRecords()) {
                    ObjectNode ptrRecordValue = objectMapper.createObjectNode();
                    pTRRecordsArray.add((JsonNode)ptrRecordValue);
                    ptrRecordValue.put("ptrdname", pTRRecordsItem.getPtrdname());
                }
                propertiesValue.put("PTRRecords", (JsonNode)pTRRecordsArray);
            }
            if (parameters.getRecordSet().getProperties().getSrvRecords() != null) {
                ArrayNode sRVRecordsArray = objectMapper.createArrayNode();
                for (SrvRecord sRVRecordsItem : parameters.getRecordSet().getProperties().getSrvRecords()) {
                    ObjectNode srvRecordValue = objectMapper.createObjectNode();
                    sRVRecordsArray.add((JsonNode)srvRecordValue);
                    srvRecordValue.put("priority", sRVRecordsItem.getPriority());
                    srvRecordValue.put("weight", sRVRecordsItem.getWeight());
                    srvRecordValue.put("port", sRVRecordsItem.getPort());
                    srvRecordValue.put("target", sRVRecordsItem.getTarget());
                }
                propertiesValue.put("SRVRecords", (JsonNode)sRVRecordsArray);
            }
            if (parameters.getRecordSet().getProperties().getTxtRecords() != null) {
                ArrayNode tXTRecordsArray = objectMapper.createArrayNode();
                for (TxtRecord tXTRecordsItem : parameters.getRecordSet().getProperties().getTxtRecords()) {
                    ObjectNode txtRecordValue = objectMapper.createObjectNode();
                    tXTRecordsArray.add((JsonNode)txtRecordValue);
                    txtRecordValue.put("value", tXTRecordsItem.getValue());
                }
                propertiesValue.put("TXTRecords", (JsonNode)tXTRecordsArray);
            }
            if (parameters.getRecordSet().getProperties().getCnameRecord() != null) {
                ObjectNode cNAMERecordValue = objectMapper.createObjectNode();
                propertiesValue.put("CNAMERecord", (JsonNode)cNAMERecordValue);
                cNAMERecordValue.put("cname", parameters.getRecordSet().getProperties().getCnameRecord().getCname());
            }
            if (parameters.getRecordSet().getProperties().getSoaRecord() != null) {
                ObjectNode sOARecordValue = objectMapper.createObjectNode();
                propertiesValue.put("SOARecord", (JsonNode)sOARecordValue);
                sOARecordValue.put("host", parameters.getRecordSet().getProperties().getSoaRecord().getHost());
                sOARecordValue.put("email", parameters.getRecordSet().getProperties().getSoaRecord().getEmail());
                sOARecordValue.put("serialNumber", parameters.getRecordSet().getProperties().getSoaRecord().getSerialNumber());
                sOARecordValue.put("refreshTime", parameters.getRecordSet().getProperties().getSoaRecord().getRefreshTime());
                sOARecordValue.put("retryTime", parameters.getRecordSet().getProperties().getSoaRecord().getRetryTime());
                sOARecordValue.put("expireTime", parameters.getRecordSet().getProperties().getSoaRecord().getExpireTime());
                sOARecordValue.put("minimumTTL", parameters.getRecordSet().getProperties().getSoaRecord().getMinimumTtl());
            }
        }
        if (parameters.getRecordSet().getId() != null) {
            recordSetCreateOrUpdateParametersValue.put("id", parameters.getRecordSet().getId());
        }
        if (parameters.getRecordSet().getName() != null) {
            recordSetCreateOrUpdateParametersValue.put("name", parameters.getRecordSet().getName());
        }
        if (parameters.getRecordSet().getType() != null) {
            recordSetCreateOrUpdateParametersValue.put("type", parameters.getRecordSet().getType());
        }
        recordSetCreateOrUpdateParametersValue.put("location", parameters.getRecordSet().getLocation());
        if (parameters.getRecordSet().getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getRecordSet().getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            recordSetCreateOrUpdateParametersValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RecordSetCreateOrUpdateResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new RecordSetCreateOrUpdateResponse();
            JsonNode responseDoc = null;
            if (!(responseContent == null)) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                JsonNode tagsSequenceElement;
                JsonNode locationValue;
                JsonNode typeValue;
                JsonNode nameValue;
                JsonNode idValue;
                JsonNode propertiesValue2;
                RecordSet recordSetInstance = new RecordSet();
                result.setRecordSet(recordSetInstance);
                JsonNode etagValue = responseDoc.get("etag");
                if (etagValue != null && !(etagValue instanceof NullNode)) {
                    String etagInstance = etagValue.getTextValue();
                    recordSetInstance.setETag(etagInstance);
                }
                if ((propertiesValue2 = responseDoc.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                    JsonNode sOARecordValue2;
                    JsonNode cNAMERecordValue2;
                    JsonNode tXTRecordsArray2;
                    JsonNode sRVRecordsArray2;
                    JsonNode pTRRecordsArray2;
                    JsonNode nSRecordsArray2;
                    JsonNode mXRecordsArray2;
                    JsonNode aAAARecordsArray2;
                    JsonNode aRecordsArray2;
                    RecordSetProperties propertiesInstance = new RecordSetProperties();
                    recordSetInstance.setProperties(propertiesInstance);
                    JsonNode tTLValue = propertiesValue2.get("TTL");
                    if (tTLValue != null && !(tTLValue instanceof NullNode)) {
                        long tTLInstance = tTLValue.getLongValue();
                        propertiesInstance.setTtl(tTLInstance);
                    }
                    if ((aRecordsArray2 = propertiesValue2.get("ARecords")) != null && !(aRecordsArray2 instanceof NullNode)) {
                        propertiesInstance.setARecords(new ArrayList<ARecord>());
                        for (Iterator aRecordsValue : (ArrayNode)aRecordsArray2) {
                            ARecord aRecordInstance = new ARecord();
                            propertiesInstance.getARecords().add(aRecordInstance);
                            JsonNode ipv4AddressValue = aRecordsValue.get("ipv4Address");
                            if (ipv4AddressValue == null || ipv4AddressValue instanceof NullNode) continue;
                            String ipv4AddressInstance = ipv4AddressValue.getTextValue();
                            aRecordInstance.setIpv4Address(ipv4AddressInstance);
                        }
                    }
                    if ((aAAARecordsArray2 = propertiesValue2.get("AAAARecords")) != null && !(aAAARecordsArray2 instanceof NullNode)) {
                        propertiesInstance.setAaaaRecords(new ArrayList<AaaaRecord>());
                        for (Iterator aAAARecordsValue : (ArrayNode)aAAARecordsArray2) {
                            AaaaRecord aaaaRecordInstance = new AaaaRecord();
                            propertiesInstance.getAaaaRecords().add(aaaaRecordInstance);
                            JsonNode ipv6AddressValue = aAAARecordsValue.get("ipv6Address");
                            if (ipv6AddressValue == null || ipv6AddressValue instanceof NullNode) continue;
                            String ipv6AddressInstance = ipv6AddressValue.getTextValue();
                            aaaaRecordInstance.setIpv6Address(ipv6AddressInstance);
                        }
                    }
                    if ((mXRecordsArray2 = propertiesValue2.get("MXRecords")) != null && !(mXRecordsArray2 instanceof NullNode)) {
                        propertiesInstance.setMxRecords(new ArrayList<MxRecord>());
                        for (Iterator mXRecordsValue : (ArrayNode)mXRecordsArray2) {
                            JsonNode exchangeValue;
                            MxRecord mxRecordInstance = new MxRecord();
                            propertiesInstance.getMxRecords().add(mxRecordInstance);
                            JsonNode preferenceValue = mXRecordsValue.get("preference");
                            if (preferenceValue != null && !(preferenceValue instanceof NullNode)) {
                                int preferenceInstance = preferenceValue.getIntValue();
                                mxRecordInstance.setPreference(preferenceInstance);
                            }
                            if ((exchangeValue = mXRecordsValue.get("exchange")) == null || exchangeValue instanceof NullNode) continue;
                            String exchangeInstance = exchangeValue.getTextValue();
                            mxRecordInstance.setExchange(exchangeInstance);
                        }
                    }
                    if ((nSRecordsArray2 = propertiesValue2.get("NSRecords")) != null && !(nSRecordsArray2 instanceof NullNode)) {
                        propertiesInstance.setNsRecords(new ArrayList<NsRecord>());
                        for (Iterator nSRecordsValue : (ArrayNode)nSRecordsArray2) {
                            NsRecord nsRecordInstance = new NsRecord();
                            propertiesInstance.getNsRecords().add(nsRecordInstance);
                            JsonNode nsdnameValue = nSRecordsValue.get("nsdname");
                            if (nsdnameValue == null || nsdnameValue instanceof NullNode) continue;
                            String nsdnameInstance = nsdnameValue.getTextValue();
                            nsRecordInstance.setNsdname(nsdnameInstance);
                        }
                    }
                    if ((pTRRecordsArray2 = propertiesValue2.get("PTRRecords")) != null && !(pTRRecordsArray2 instanceof NullNode)) {
                        propertiesInstance.setPtrRecords(new ArrayList<PtrRecord>());
                        for (Iterator pTRRecordsValue : (ArrayNode)pTRRecordsArray2) {
                            PtrRecord ptrRecordInstance = new PtrRecord();
                            propertiesInstance.getPtrRecords().add(ptrRecordInstance);
                            JsonNode ptrdnameValue = pTRRecordsValue.get("ptrdname");
                            if (ptrdnameValue == null || ptrdnameValue instanceof NullNode) continue;
                            String ptrdnameInstance = ptrdnameValue.getTextValue();
                            ptrRecordInstance.setPtrdname(ptrdnameInstance);
                        }
                    }
                    if ((sRVRecordsArray2 = propertiesValue2.get("SRVRecords")) != null && !(sRVRecordsArray2 instanceof NullNode)) {
                        propertiesInstance.setSrvRecords(new ArrayList<SrvRecord>());
                        for (Iterator sRVRecordsValue : (ArrayNode)sRVRecordsArray2) {
                            JsonNode targetValue;
                            JsonNode portValue;
                            JsonNode weightValue;
                            SrvRecord srvRecordInstance = new SrvRecord();
                            propertiesInstance.getSrvRecords().add(srvRecordInstance);
                            JsonNode priorityValue = sRVRecordsValue.get("priority");
                            if (priorityValue != null && !(priorityValue instanceof NullNode)) {
                                int priorityInstance = priorityValue.getIntValue();
                                srvRecordInstance.setPriority(priorityInstance);
                            }
                            if ((weightValue = sRVRecordsValue.get("weight")) != null && !(weightValue instanceof NullNode)) {
                                int weightInstance = weightValue.getIntValue();
                                srvRecordInstance.setWeight(weightInstance);
                            }
                            if ((portValue = sRVRecordsValue.get("port")) != null && !(portValue instanceof NullNode)) {
                                int portInstance = portValue.getIntValue();
                                srvRecordInstance.setPort(portInstance);
                            }
                            if ((targetValue = sRVRecordsValue.get("target")) == null || targetValue instanceof NullNode) continue;
                            String targetInstance = targetValue.getTextValue();
                            srvRecordInstance.setTarget(targetInstance);
                        }
                    }
                    if ((tXTRecordsArray2 = propertiesValue2.get("TXTRecords")) != null && !(tXTRecordsArray2 instanceof NullNode)) {
                        propertiesInstance.setTxtRecords(new ArrayList<TxtRecord>());
                        for (JsonNode tXTRecordsValue : (ArrayNode)tXTRecordsArray2) {
                            TxtRecord txtRecordInstance = new TxtRecord();
                            propertiesInstance.getTxtRecords().add(txtRecordInstance);
                            JsonNode valueValue = tXTRecordsValue.get("value");
                            if (valueValue == null || valueValue instanceof NullNode) continue;
                            String valueInstance = valueValue.getTextValue();
                            txtRecordInstance.setValue(valueInstance);
                        }
                    }
                    if ((cNAMERecordValue2 = propertiesValue2.get("CNAMERecord")) != null && !(cNAMERecordValue2 instanceof NullNode)) {
                        CnameRecord cNAMERecordInstance = new CnameRecord();
                        propertiesInstance.setCnameRecord(cNAMERecordInstance);
                        JsonNode cnameValue = cNAMERecordValue2.get("cname");
                        if (cnameValue != null && !(cnameValue instanceof NullNode)) {
                            String cnameInstance = cnameValue.getTextValue();
                            cNAMERecordInstance.setCname(cnameInstance);
                        }
                    }
                    if ((sOARecordValue2 = propertiesValue2.get("SOARecord")) != null && !(sOARecordValue2 instanceof NullNode)) {
                        JsonNode minimumTTLValue;
                        JsonNode expireTimeValue;
                        JsonNode retryTimeValue;
                        JsonNode refreshTimeValue;
                        JsonNode serialNumberValue;
                        JsonNode emailValue;
                        SoaRecord sOARecordInstance = new SoaRecord();
                        propertiesInstance.setSoaRecord(sOARecordInstance);
                        JsonNode hostValue = sOARecordValue2.get("host");
                        if (hostValue != null && !(hostValue instanceof NullNode)) {
                            String hostInstance = hostValue.getTextValue();
                            sOARecordInstance.setHost(hostInstance);
                        }
                        if ((emailValue = sOARecordValue2.get("email")) != null && !(emailValue instanceof NullNode)) {
                            String emailInstance = emailValue.getTextValue();
                            sOARecordInstance.setEmail(emailInstance);
                        }
                        if ((serialNumberValue = sOARecordValue2.get("serialNumber")) != null && !(serialNumberValue instanceof NullNode)) {
                            long serialNumberInstance = serialNumberValue.getLongValue();
                            sOARecordInstance.setSerialNumber(serialNumberInstance);
                        }
                        if ((refreshTimeValue = sOARecordValue2.get("refreshTime")) != null && !(refreshTimeValue instanceof NullNode)) {
                            long refreshTimeInstance = refreshTimeValue.getLongValue();
                            sOARecordInstance.setRefreshTime(refreshTimeInstance);
                        }
                        if ((retryTimeValue = sOARecordValue2.get("retryTime")) != null && !(retryTimeValue instanceof NullNode)) {
                            long retryTimeInstance = retryTimeValue.getLongValue();
                            sOARecordInstance.setRetryTime(retryTimeInstance);
                        }
                        if ((expireTimeValue = sOARecordValue2.get("expireTime")) != null && !(expireTimeValue instanceof NullNode)) {
                            long expireTimeInstance = expireTimeValue.getLongValue();
                            sOARecordInstance.setExpireTime(expireTimeInstance);
                        }
                        if ((minimumTTLValue = sOARecordValue2.get("minimumTTL")) != null && !(minimumTTLValue instanceof NullNode)) {
                            long minimumTTLInstance = minimumTTLValue.getLongValue();
                            sOARecordInstance.setMinimumTtl(minimumTTLInstance);
                        }
                    }
                }
                if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                    String idInstance = idValue.getTextValue();
                    recordSetInstance.setId(idInstance);
                }
                if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                    String nameInstance = nameValue.getTextValue();
                    recordSetInstance.setName(nameInstance);
                }
                if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                    String typeInstance = typeValue.getTextValue();
                    recordSetInstance.setType(typeInstance);
                }
                if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                    String locationInstance = locationValue.getTextValue();
                    recordSetInstance.setLocation(locationInstance);
                }
                if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                    Iterator itr = tagsSequenceElement.getFields();
                    while (itr.hasNext()) {
                        Map.Entry property = (Map.Entry)itr.next();
                        String tagsKey2 = (String)property.getKey();
                        String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                        recordSetInstance.getTags().put(tagsKey2, tagsValue2);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RecordSetCreateOrUpdateResponse recordSetCreateOrUpdateResponse = result;
            return recordSetCreateOrUpdateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String zoneName, final String relativeRecordSetName, final RecordType recordType, final RecordSetDeleteParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return RecordSetOperationsImpl.this.delete(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetDeleteParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        if (relativeRecordSetName == null) {
            throw new NullPointerException("relativeRecordSetName");
        }
        if (recordType == null) {
            throw new NullPointerException("recordType");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            tracingParameters.put("relativeRecordSetName", relativeRecordSetName);
            tracingParameters.put("recordType", (Object)recordType);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(recordType.toString(), "UTF-8");
        url = url + "/";
        url = url + relativeRecordSetName;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("If-Match", parameters.getIfMatch());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<RecordSetGetResponse> getAsync(final String resourceGroupName, final String zoneName, final String relativeRecordSetName, final RecordType recordType) {
        return this.getClient().getExecutorService().submit(new Callable<RecordSetGetResponse>(){

            @Override
            public RecordSetGetResponse call() throws Exception {
                return RecordSetOperationsImpl.this.get(resourceGroupName, zoneName, relativeRecordSetName, recordType);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordSetGetResponse get(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        if (relativeRecordSetName == null) {
            throw new NullPointerException("relativeRecordSetName");
        }
        if (recordType == null) {
            throw new NullPointerException("recordType");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            tracingParameters.put("relativeRecordSetName", relativeRecordSetName);
            tracingParameters.put("recordType", (Object)recordType);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(recordType.toString(), "UTF-8");
        url = url + "/";
        url = url + relativeRecordSetName;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RecordSetGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new RecordSetGetResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (!(responseContent == null)) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                JsonNode tagsSequenceElement;
                JsonNode locationValue;
                JsonNode typeValue;
                JsonNode nameValue;
                JsonNode idValue;
                JsonNode propertiesValue;
                RecordSet recordSetInstance = new RecordSet();
                result.setRecordSet(recordSetInstance);
                JsonNode etagValue = responseDoc.get("etag");
                if (etagValue != null && !(etagValue instanceof NullNode)) {
                    String etagInstance = etagValue.getTextValue();
                    recordSetInstance.setETag(etagInstance);
                }
                if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                    JsonNode sOARecordValue;
                    JsonNode cNAMERecordValue;
                    JsonNode tXTRecordsArray;
                    JsonNode sRVRecordsArray;
                    JsonNode pTRRecordsArray;
                    JsonNode nSRecordsArray;
                    JsonNode mXRecordsArray;
                    JsonNode aAAARecordsArray;
                    JsonNode aRecordsArray;
                    RecordSetProperties propertiesInstance = new RecordSetProperties();
                    recordSetInstance.setProperties(propertiesInstance);
                    JsonNode tTLValue = propertiesValue.get("TTL");
                    if (tTLValue != null && !(tTLValue instanceof NullNode)) {
                        long tTLInstance = tTLValue.getLongValue();
                        propertiesInstance.setTtl(tTLInstance);
                    }
                    if ((aRecordsArray = propertiesValue.get("ARecords")) != null && !(aRecordsArray instanceof NullNode)) {
                        propertiesInstance.setARecords(new ArrayList<ARecord>());
                        for (Iterator aRecordsValue : (ArrayNode)aRecordsArray) {
                            ARecord aRecordInstance = new ARecord();
                            propertiesInstance.getARecords().add(aRecordInstance);
                            JsonNode ipv4AddressValue = aRecordsValue.get("ipv4Address");
                            if (ipv4AddressValue == null || ipv4AddressValue instanceof NullNode) continue;
                            String ipv4AddressInstance = ipv4AddressValue.getTextValue();
                            aRecordInstance.setIpv4Address(ipv4AddressInstance);
                        }
                    }
                    if ((aAAARecordsArray = propertiesValue.get("AAAARecords")) != null && !(aAAARecordsArray instanceof NullNode)) {
                        propertiesInstance.setAaaaRecords(new ArrayList<AaaaRecord>());
                        for (Iterator aAAARecordsValue : (ArrayNode)aAAARecordsArray) {
                            AaaaRecord aaaaRecordInstance = new AaaaRecord();
                            propertiesInstance.getAaaaRecords().add(aaaaRecordInstance);
                            JsonNode ipv6AddressValue = aAAARecordsValue.get("ipv6Address");
                            if (ipv6AddressValue == null || ipv6AddressValue instanceof NullNode) continue;
                            String ipv6AddressInstance = ipv6AddressValue.getTextValue();
                            aaaaRecordInstance.setIpv6Address(ipv6AddressInstance);
                        }
                    }
                    if ((mXRecordsArray = propertiesValue.get("MXRecords")) != null && !(mXRecordsArray instanceof NullNode)) {
                        propertiesInstance.setMxRecords(new ArrayList<MxRecord>());
                        for (Iterator mXRecordsValue : (ArrayNode)mXRecordsArray) {
                            JsonNode exchangeValue;
                            MxRecord mxRecordInstance = new MxRecord();
                            propertiesInstance.getMxRecords().add(mxRecordInstance);
                            JsonNode preferenceValue = mXRecordsValue.get("preference");
                            if (preferenceValue != null && !(preferenceValue instanceof NullNode)) {
                                int preferenceInstance = preferenceValue.getIntValue();
                                mxRecordInstance.setPreference(preferenceInstance);
                            }
                            if ((exchangeValue = mXRecordsValue.get("exchange")) == null || exchangeValue instanceof NullNode) continue;
                            String exchangeInstance = exchangeValue.getTextValue();
                            mxRecordInstance.setExchange(exchangeInstance);
                        }
                    }
                    if ((nSRecordsArray = propertiesValue.get("NSRecords")) != null && !(nSRecordsArray instanceof NullNode)) {
                        propertiesInstance.setNsRecords(new ArrayList<NsRecord>());
                        for (Iterator nSRecordsValue : (ArrayNode)nSRecordsArray) {
                            NsRecord nsRecordInstance = new NsRecord();
                            propertiesInstance.getNsRecords().add(nsRecordInstance);
                            JsonNode nsdnameValue = nSRecordsValue.get("nsdname");
                            if (nsdnameValue == null || nsdnameValue instanceof NullNode) continue;
                            String nsdnameInstance = nsdnameValue.getTextValue();
                            nsRecordInstance.setNsdname(nsdnameInstance);
                        }
                    }
                    if ((pTRRecordsArray = propertiesValue.get("PTRRecords")) != null && !(pTRRecordsArray instanceof NullNode)) {
                        propertiesInstance.setPtrRecords(new ArrayList<PtrRecord>());
                        for (Iterator pTRRecordsValue : (ArrayNode)pTRRecordsArray) {
                            PtrRecord ptrRecordInstance = new PtrRecord();
                            propertiesInstance.getPtrRecords().add(ptrRecordInstance);
                            JsonNode ptrdnameValue = pTRRecordsValue.get("ptrdname");
                            if (ptrdnameValue == null || ptrdnameValue instanceof NullNode) continue;
                            String ptrdnameInstance = ptrdnameValue.getTextValue();
                            ptrRecordInstance.setPtrdname(ptrdnameInstance);
                        }
                    }
                    if ((sRVRecordsArray = propertiesValue.get("SRVRecords")) != null && !(sRVRecordsArray instanceof NullNode)) {
                        propertiesInstance.setSrvRecords(new ArrayList<SrvRecord>());
                        for (Iterator sRVRecordsValue : (ArrayNode)sRVRecordsArray) {
                            JsonNode targetValue;
                            JsonNode portValue;
                            JsonNode weightValue;
                            SrvRecord srvRecordInstance = new SrvRecord();
                            propertiesInstance.getSrvRecords().add(srvRecordInstance);
                            JsonNode priorityValue = sRVRecordsValue.get("priority");
                            if (priorityValue != null && !(priorityValue instanceof NullNode)) {
                                int priorityInstance = priorityValue.getIntValue();
                                srvRecordInstance.setPriority(priorityInstance);
                            }
                            if ((weightValue = sRVRecordsValue.get("weight")) != null && !(weightValue instanceof NullNode)) {
                                int weightInstance = weightValue.getIntValue();
                                srvRecordInstance.setWeight(weightInstance);
                            }
                            if ((portValue = sRVRecordsValue.get("port")) != null && !(portValue instanceof NullNode)) {
                                int portInstance = portValue.getIntValue();
                                srvRecordInstance.setPort(portInstance);
                            }
                            if ((targetValue = sRVRecordsValue.get("target")) == null || targetValue instanceof NullNode) continue;
                            String targetInstance = targetValue.getTextValue();
                            srvRecordInstance.setTarget(targetInstance);
                        }
                    }
                    if ((tXTRecordsArray = propertiesValue.get("TXTRecords")) != null && !(tXTRecordsArray instanceof NullNode)) {
                        propertiesInstance.setTxtRecords(new ArrayList<TxtRecord>());
                        for (JsonNode tXTRecordsValue : (ArrayNode)tXTRecordsArray) {
                            TxtRecord txtRecordInstance = new TxtRecord();
                            propertiesInstance.getTxtRecords().add(txtRecordInstance);
                            JsonNode valueValue = tXTRecordsValue.get("value");
                            if (valueValue == null || valueValue instanceof NullNode) continue;
                            String valueInstance = valueValue.getTextValue();
                            txtRecordInstance.setValue(valueInstance);
                        }
                    }
                    if ((cNAMERecordValue = propertiesValue.get("CNAMERecord")) != null && !(cNAMERecordValue instanceof NullNode)) {
                        CnameRecord cNAMERecordInstance = new CnameRecord();
                        propertiesInstance.setCnameRecord(cNAMERecordInstance);
                        JsonNode cnameValue = cNAMERecordValue.get("cname");
                        if (cnameValue != null && !(cnameValue instanceof NullNode)) {
                            String cnameInstance = cnameValue.getTextValue();
                            cNAMERecordInstance.setCname(cnameInstance);
                        }
                    }
                    if ((sOARecordValue = propertiesValue.get("SOARecord")) != null && !(sOARecordValue instanceof NullNode)) {
                        JsonNode minimumTTLValue;
                        JsonNode expireTimeValue;
                        JsonNode retryTimeValue;
                        JsonNode refreshTimeValue;
                        JsonNode serialNumberValue;
                        JsonNode emailValue;
                        SoaRecord sOARecordInstance = new SoaRecord();
                        propertiesInstance.setSoaRecord(sOARecordInstance);
                        JsonNode hostValue = sOARecordValue.get("host");
                        if (hostValue != null && !(hostValue instanceof NullNode)) {
                            String hostInstance = hostValue.getTextValue();
                            sOARecordInstance.setHost(hostInstance);
                        }
                        if ((emailValue = sOARecordValue.get("email")) != null && !(emailValue instanceof NullNode)) {
                            String emailInstance = emailValue.getTextValue();
                            sOARecordInstance.setEmail(emailInstance);
                        }
                        if ((serialNumberValue = sOARecordValue.get("serialNumber")) != null && !(serialNumberValue instanceof NullNode)) {
                            long serialNumberInstance = serialNumberValue.getLongValue();
                            sOARecordInstance.setSerialNumber(serialNumberInstance);
                        }
                        if ((refreshTimeValue = sOARecordValue.get("refreshTime")) != null && !(refreshTimeValue instanceof NullNode)) {
                            long refreshTimeInstance = refreshTimeValue.getLongValue();
                            sOARecordInstance.setRefreshTime(refreshTimeInstance);
                        }
                        if ((retryTimeValue = sOARecordValue.get("retryTime")) != null && !(retryTimeValue instanceof NullNode)) {
                            long retryTimeInstance = retryTimeValue.getLongValue();
                            sOARecordInstance.setRetryTime(retryTimeInstance);
                        }
                        if ((expireTimeValue = sOARecordValue.get("expireTime")) != null && !(expireTimeValue instanceof NullNode)) {
                            long expireTimeInstance = expireTimeValue.getLongValue();
                            sOARecordInstance.setExpireTime(expireTimeInstance);
                        }
                        if ((minimumTTLValue = sOARecordValue.get("minimumTTL")) != null && !(minimumTTLValue instanceof NullNode)) {
                            long minimumTTLInstance = minimumTTLValue.getLongValue();
                            sOARecordInstance.setMinimumTtl(minimumTTLInstance);
                        }
                    }
                }
                if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                    String idInstance = idValue.getTextValue();
                    recordSetInstance.setId(idInstance);
                }
                if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                    String nameInstance = nameValue.getTextValue();
                    recordSetInstance.setName(nameInstance);
                }
                if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                    String typeInstance = typeValue.getTextValue();
                    recordSetInstance.setType(typeInstance);
                }
                if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                    String locationInstance = locationValue.getTextValue();
                    recordSetInstance.setLocation(locationInstance);
                }
                if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                    Iterator itr = tagsSequenceElement.getFields();
                    while (itr.hasNext()) {
                        Map.Entry property = (Map.Entry)itr.next();
                        String tagsKey = (String)property.getKey();
                        String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                        recordSetInstance.getTags().put(tagsKey, tagsValue);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RecordSetGetResponse recordSetGetResponse = result;
            return recordSetGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<RecordSetListResponse> listAsync(final String resourceGroupName, final String zoneName, final RecordType recordType, final RecordSetListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<RecordSetListResponse>(){

            @Override
            public RecordSetListResponse call() throws Exception {
                return RecordSetOperationsImpl.this.list(resourceGroupName, zoneName, recordType, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordSetListResponse list(String resourceGroupName, String zoneName, RecordType recordType, RecordSetListParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            tracingParameters.put("recordType", (Object)recordType);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        url = url + "/";
        if (recordType != null) {
            url = url + URLEncoder.encode(recordType.toString(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(parameters.getTop(), "UTF-8"));
        }
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getFilter() != null) {
            odataFilter.add(URLEncoder.encode(parameters.getFilter(), "UTF-8"));
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        queryParameters.add("api-version=2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RecordSetListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new RecordSetListResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (!(responseContent == null)) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                JsonNode nextLinkValue;
                JsonNode valueArray = responseDoc.get("value");
                if (valueArray != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode tagsSequenceElement;
                        JsonNode locationValue;
                        JsonNode typeValue;
                        JsonNode nameValue;
                        JsonNode idValue;
                        JsonNode propertiesValue;
                        RecordSet recordSetInstance = new RecordSet();
                        result.getRecordSets().add(recordSetInstance);
                        JsonNode etagValue = valueValue.get("etag");
                        if (etagValue != null && !(etagValue instanceof NullNode)) {
                            String etagInstance = etagValue.getTextValue();
                            recordSetInstance.setETag(etagInstance);
                        }
                        if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                            JsonNode sOARecordValue;
                            JsonNode cNAMERecordValue;
                            JsonNode tXTRecordsArray;
                            JsonNode sRVRecordsArray;
                            JsonNode pTRRecordsArray;
                            JsonNode nSRecordsArray;
                            JsonNode mXRecordsArray;
                            JsonNode aAAARecordsArray;
                            JsonNode aRecordsArray;
                            RecordSetProperties propertiesInstance = new RecordSetProperties();
                            recordSetInstance.setProperties(propertiesInstance);
                            JsonNode tTLValue = propertiesValue.get("TTL");
                            if (tTLValue != null && !(tTLValue instanceof NullNode)) {
                                long tTLInstance = tTLValue.getLongValue();
                                propertiesInstance.setTtl(tTLInstance);
                            }
                            if ((aRecordsArray = propertiesValue.get("ARecords")) != null && !(aRecordsArray instanceof NullNode)) {
                                propertiesInstance.setARecords(new ArrayList<ARecord>());
                                for (Iterator aRecordsValue : (ArrayNode)aRecordsArray) {
                                    ARecord aRecordInstance = new ARecord();
                                    propertiesInstance.getARecords().add(aRecordInstance);
                                    JsonNode ipv4AddressValue = aRecordsValue.get("ipv4Address");
                                    if (ipv4AddressValue == null || ipv4AddressValue instanceof NullNode) continue;
                                    String ipv4AddressInstance = ipv4AddressValue.getTextValue();
                                    aRecordInstance.setIpv4Address(ipv4AddressInstance);
                                }
                            }
                            if ((aAAARecordsArray = propertiesValue.get("AAAARecords")) != null && !(aAAARecordsArray instanceof NullNode)) {
                                Iterator aRecordsValue;
                                propertiesInstance.setAaaaRecords(new ArrayList<AaaaRecord>());
                                aRecordsValue = ((ArrayNode)aAAARecordsArray).iterator();
                                while (aRecordsValue.hasNext()) {
                                    Iterator aAAARecordsValue = (JsonNode)aRecordsValue.next();
                                    AaaaRecord aaaaRecordInstance = new AaaaRecord();
                                    propertiesInstance.getAaaaRecords().add(aaaaRecordInstance);
                                    JsonNode ipv6AddressValue = aAAARecordsValue.get("ipv6Address");
                                    if (ipv6AddressValue == null || ipv6AddressValue instanceof NullNode) continue;
                                    String ipv6AddressInstance = ipv6AddressValue.getTextValue();
                                    aaaaRecordInstance.setIpv6Address(ipv6AddressInstance);
                                }
                            }
                            if ((mXRecordsArray = propertiesValue.get("MXRecords")) != null && !(mXRecordsArray instanceof NullNode)) {
                                propertiesInstance.setMxRecords(new ArrayList<MxRecord>());
                                for (Iterator mXRecordsValue : (ArrayNode)mXRecordsArray) {
                                    JsonNode exchangeValue;
                                    MxRecord mxRecordInstance = new MxRecord();
                                    propertiesInstance.getMxRecords().add(mxRecordInstance);
                                    JsonNode preferenceValue = mXRecordsValue.get("preference");
                                    if (preferenceValue != null && !(preferenceValue instanceof NullNode)) {
                                        int preferenceInstance = preferenceValue.getIntValue();
                                        mxRecordInstance.setPreference(preferenceInstance);
                                    }
                                    if ((exchangeValue = mXRecordsValue.get("exchange")) == null || exchangeValue instanceof NullNode) continue;
                                    String exchangeInstance = exchangeValue.getTextValue();
                                    mxRecordInstance.setExchange(exchangeInstance);
                                }
                            }
                            if ((nSRecordsArray = propertiesValue.get("NSRecords")) != null && !(nSRecordsArray instanceof NullNode)) {
                                Iterator mXRecordsValue;
                                propertiesInstance.setNsRecords(new ArrayList<NsRecord>());
                                mXRecordsValue = ((ArrayNode)nSRecordsArray).iterator();
                                while (mXRecordsValue.hasNext()) {
                                    Iterator nSRecordsValue = (JsonNode)mXRecordsValue.next();
                                    NsRecord nsRecordInstance = new NsRecord();
                                    propertiesInstance.getNsRecords().add(nsRecordInstance);
                                    JsonNode nsdnameValue = nSRecordsValue.get("nsdname");
                                    if (nsdnameValue == null || nsdnameValue instanceof NullNode) continue;
                                    String nsdnameInstance = nsdnameValue.getTextValue();
                                    nsRecordInstance.setNsdname(nsdnameInstance);
                                }
                            }
                            if ((pTRRecordsArray = propertiesValue.get("PTRRecords")) != null && !(pTRRecordsArray instanceof NullNode)) {
                                propertiesInstance.setPtrRecords(new ArrayList<PtrRecord>());
                                for (Iterator pTRRecordsValue : (ArrayNode)pTRRecordsArray) {
                                    PtrRecord ptrRecordInstance = new PtrRecord();
                                    propertiesInstance.getPtrRecords().add(ptrRecordInstance);
                                    JsonNode ptrdnameValue = pTRRecordsValue.get("ptrdname");
                                    if (ptrdnameValue == null || ptrdnameValue instanceof NullNode) continue;
                                    String ptrdnameInstance = ptrdnameValue.getTextValue();
                                    ptrRecordInstance.setPtrdname(ptrdnameInstance);
                                }
                            }
                            if ((sRVRecordsArray = propertiesValue.get("SRVRecords")) != null && !(sRVRecordsArray instanceof NullNode)) {
                                Iterator pTRRecordsValue;
                                propertiesInstance.setSrvRecords(new ArrayList<SrvRecord>());
                                pTRRecordsValue = ((ArrayNode)sRVRecordsArray).iterator();
                                while (pTRRecordsValue.hasNext()) {
                                    JsonNode targetValue;
                                    JsonNode portValue;
                                    JsonNode weightValue;
                                    Iterator sRVRecordsValue = (JsonNode)pTRRecordsValue.next();
                                    SrvRecord srvRecordInstance = new SrvRecord();
                                    propertiesInstance.getSrvRecords().add(srvRecordInstance);
                                    JsonNode priorityValue = sRVRecordsValue.get("priority");
                                    if (priorityValue != null && !(priorityValue instanceof NullNode)) {
                                        int priorityInstance = priorityValue.getIntValue();
                                        srvRecordInstance.setPriority(priorityInstance);
                                    }
                                    if ((weightValue = sRVRecordsValue.get("weight")) != null && !(weightValue instanceof NullNode)) {
                                        int weightInstance = weightValue.getIntValue();
                                        srvRecordInstance.setWeight(weightInstance);
                                    }
                                    if ((portValue = sRVRecordsValue.get("port")) != null && !(portValue instanceof NullNode)) {
                                        int portInstance = portValue.getIntValue();
                                        srvRecordInstance.setPort(portInstance);
                                    }
                                    if ((targetValue = sRVRecordsValue.get("target")) == null || targetValue instanceof NullNode) continue;
                                    String targetInstance = targetValue.getTextValue();
                                    srvRecordInstance.setTarget(targetInstance);
                                }
                            }
                            if ((tXTRecordsArray = propertiesValue.get("TXTRecords")) != null && !(tXTRecordsArray instanceof NullNode)) {
                                propertiesInstance.setTxtRecords(new ArrayList<TxtRecord>());
                                for (JsonNode tXTRecordsValue : (ArrayNode)tXTRecordsArray) {
                                    TxtRecord txtRecordInstance = new TxtRecord();
                                    propertiesInstance.getTxtRecords().add(txtRecordInstance);
                                    JsonNode valueValue2 = tXTRecordsValue.get("value");
                                    if (valueValue2 == null || valueValue2 instanceof NullNode) continue;
                                    String valueInstance = valueValue2.getTextValue();
                                    txtRecordInstance.setValue(valueInstance);
                                }
                            }
                            if ((cNAMERecordValue = propertiesValue.get("CNAMERecord")) != null && !(cNAMERecordValue instanceof NullNode)) {
                                CnameRecord cNAMERecordInstance = new CnameRecord();
                                propertiesInstance.setCnameRecord(cNAMERecordInstance);
                                JsonNode cnameValue = cNAMERecordValue.get("cname");
                                if (cnameValue != null && !(cnameValue instanceof NullNode)) {
                                    String cnameInstance = cnameValue.getTextValue();
                                    cNAMERecordInstance.setCname(cnameInstance);
                                }
                            }
                            if ((sOARecordValue = propertiesValue.get("SOARecord")) != null && !(sOARecordValue instanceof NullNode)) {
                                JsonNode minimumTTLValue;
                                JsonNode expireTimeValue;
                                JsonNode retryTimeValue;
                                JsonNode refreshTimeValue;
                                JsonNode serialNumberValue;
                                JsonNode emailValue;
                                SoaRecord sOARecordInstance = new SoaRecord();
                                propertiesInstance.setSoaRecord(sOARecordInstance);
                                JsonNode hostValue = sOARecordValue.get("host");
                                if (hostValue != null && !(hostValue instanceof NullNode)) {
                                    String hostInstance = hostValue.getTextValue();
                                    sOARecordInstance.setHost(hostInstance);
                                }
                                if ((emailValue = sOARecordValue.get("email")) != null && !(emailValue instanceof NullNode)) {
                                    String emailInstance = emailValue.getTextValue();
                                    sOARecordInstance.setEmail(emailInstance);
                                }
                                if ((serialNumberValue = sOARecordValue.get("serialNumber")) != null && !(serialNumberValue instanceof NullNode)) {
                                    long serialNumberInstance = serialNumberValue.getLongValue();
                                    sOARecordInstance.setSerialNumber(serialNumberInstance);
                                }
                                if ((refreshTimeValue = sOARecordValue.get("refreshTime")) != null && !(refreshTimeValue instanceof NullNode)) {
                                    long refreshTimeInstance = refreshTimeValue.getLongValue();
                                    sOARecordInstance.setRefreshTime(refreshTimeInstance);
                                }
                                if ((retryTimeValue = sOARecordValue.get("retryTime")) != null && !(retryTimeValue instanceof NullNode)) {
                                    long retryTimeInstance = retryTimeValue.getLongValue();
                                    sOARecordInstance.setRetryTime(retryTimeInstance);
                                }
                                if ((expireTimeValue = sOARecordValue.get("expireTime")) != null && !(expireTimeValue instanceof NullNode)) {
                                    long expireTimeInstance = expireTimeValue.getLongValue();
                                    sOARecordInstance.setExpireTime(expireTimeInstance);
                                }
                                if ((minimumTTLValue = sOARecordValue.get("minimumTTL")) != null && !(minimumTTLValue instanceof NullNode)) {
                                    long minimumTTLInstance = minimumTTLValue.getLongValue();
                                    sOARecordInstance.setMinimumTtl(minimumTTLInstance);
                                }
                            }
                        }
                        if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            recordSetInstance.setId(idInstance);
                        }
                        if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            recordSetInstance.setName(nameInstance);
                        }
                        if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            recordSetInstance.setType(typeInstance);
                        }
                        if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                            String locationInstance = locationValue.getTextValue();
                            recordSetInstance.setLocation(locationInstance);
                        }
                        if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            recordSetInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                    String nextLinkInstance = nextLinkValue.getTextValue();
                    result.setNextLink(nextLinkInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RecordSetListResponse recordSetListResponse = result;
            return recordSetListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<RecordSetListResponse> listAllAsync(final String resourceGroupName, final String zoneName, final RecordSetListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<RecordSetListResponse>(){

            @Override
            public RecordSetListResponse call() throws Exception {
                return RecordSetOperationsImpl.this.listAll(resourceGroupName, zoneName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordSetListResponse listAll(String resourceGroupName, String zoneName, RecordSetListParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        url = url + "/recordsets";
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(parameters.getTop(), "UTF-8"));
        }
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getFilter() != null) {
            odataFilter.add(URLEncoder.encode(parameters.getFilter(), "UTF-8"));
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        queryParameters.add("api-version=2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RecordSetListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new RecordSetListResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (!(responseContent == null)) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                JsonNode nextLinkValue;
                JsonNode valueArray = responseDoc.get("value");
                if (valueArray != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode tagsSequenceElement;
                        JsonNode locationValue;
                        JsonNode typeValue;
                        JsonNode nameValue;
                        JsonNode idValue;
                        JsonNode propertiesValue;
                        RecordSet recordSetInstance = new RecordSet();
                        result.getRecordSets().add(recordSetInstance);
                        JsonNode etagValue = valueValue.get("etag");
                        if (etagValue != null && !(etagValue instanceof NullNode)) {
                            String etagInstance = etagValue.getTextValue();
                            recordSetInstance.setETag(etagInstance);
                        }
                        if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                            JsonNode sOARecordValue;
                            JsonNode cNAMERecordValue;
                            JsonNode tXTRecordsArray;
                            JsonNode sRVRecordsArray;
                            JsonNode pTRRecordsArray;
                            JsonNode nSRecordsArray;
                            JsonNode mXRecordsArray;
                            JsonNode aAAARecordsArray;
                            JsonNode aRecordsArray;
                            RecordSetProperties propertiesInstance = new RecordSetProperties();
                            recordSetInstance.setProperties(propertiesInstance);
                            JsonNode tTLValue = propertiesValue.get("TTL");
                            if (tTLValue != null && !(tTLValue instanceof NullNode)) {
                                long tTLInstance = tTLValue.getLongValue();
                                propertiesInstance.setTtl(tTLInstance);
                            }
                            if ((aRecordsArray = propertiesValue.get("ARecords")) != null && !(aRecordsArray instanceof NullNode)) {
                                propertiesInstance.setARecords(new ArrayList<ARecord>());
                                for (Iterator aRecordsValue : (ArrayNode)aRecordsArray) {
                                    ARecord aRecordInstance = new ARecord();
                                    propertiesInstance.getARecords().add(aRecordInstance);
                                    JsonNode ipv4AddressValue = aRecordsValue.get("ipv4Address");
                                    if (ipv4AddressValue == null || ipv4AddressValue instanceof NullNode) continue;
                                    String ipv4AddressInstance = ipv4AddressValue.getTextValue();
                                    aRecordInstance.setIpv4Address(ipv4AddressInstance);
                                }
                            }
                            if ((aAAARecordsArray = propertiesValue.get("AAAARecords")) != null && !(aAAARecordsArray instanceof NullNode)) {
                                Iterator aRecordsValue;
                                propertiesInstance.setAaaaRecords(new ArrayList<AaaaRecord>());
                                aRecordsValue = ((ArrayNode)aAAARecordsArray).iterator();
                                while (aRecordsValue.hasNext()) {
                                    Iterator aAAARecordsValue = (JsonNode)aRecordsValue.next();
                                    AaaaRecord aaaaRecordInstance = new AaaaRecord();
                                    propertiesInstance.getAaaaRecords().add(aaaaRecordInstance);
                                    JsonNode ipv6AddressValue = aAAARecordsValue.get("ipv6Address");
                                    if (ipv6AddressValue == null || ipv6AddressValue instanceof NullNode) continue;
                                    String ipv6AddressInstance = ipv6AddressValue.getTextValue();
                                    aaaaRecordInstance.setIpv6Address(ipv6AddressInstance);
                                }
                            }
                            if ((mXRecordsArray = propertiesValue.get("MXRecords")) != null && !(mXRecordsArray instanceof NullNode)) {
                                propertiesInstance.setMxRecords(new ArrayList<MxRecord>());
                                for (Iterator mXRecordsValue : (ArrayNode)mXRecordsArray) {
                                    JsonNode exchangeValue;
                                    MxRecord mxRecordInstance = new MxRecord();
                                    propertiesInstance.getMxRecords().add(mxRecordInstance);
                                    JsonNode preferenceValue = mXRecordsValue.get("preference");
                                    if (preferenceValue != null && !(preferenceValue instanceof NullNode)) {
                                        int preferenceInstance = preferenceValue.getIntValue();
                                        mxRecordInstance.setPreference(preferenceInstance);
                                    }
                                    if ((exchangeValue = mXRecordsValue.get("exchange")) == null || exchangeValue instanceof NullNode) continue;
                                    String exchangeInstance = exchangeValue.getTextValue();
                                    mxRecordInstance.setExchange(exchangeInstance);
                                }
                            }
                            if ((nSRecordsArray = propertiesValue.get("NSRecords")) != null && !(nSRecordsArray instanceof NullNode)) {
                                Iterator mXRecordsValue;
                                propertiesInstance.setNsRecords(new ArrayList<NsRecord>());
                                mXRecordsValue = ((ArrayNode)nSRecordsArray).iterator();
                                while (mXRecordsValue.hasNext()) {
                                    Iterator nSRecordsValue = (JsonNode)mXRecordsValue.next();
                                    NsRecord nsRecordInstance = new NsRecord();
                                    propertiesInstance.getNsRecords().add(nsRecordInstance);
                                    JsonNode nsdnameValue = nSRecordsValue.get("nsdname");
                                    if (nsdnameValue == null || nsdnameValue instanceof NullNode) continue;
                                    String nsdnameInstance = nsdnameValue.getTextValue();
                                    nsRecordInstance.setNsdname(nsdnameInstance);
                                }
                            }
                            if ((pTRRecordsArray = propertiesValue.get("PTRRecords")) != null && !(pTRRecordsArray instanceof NullNode)) {
                                propertiesInstance.setPtrRecords(new ArrayList<PtrRecord>());
                                for (Iterator pTRRecordsValue : (ArrayNode)pTRRecordsArray) {
                                    PtrRecord ptrRecordInstance = new PtrRecord();
                                    propertiesInstance.getPtrRecords().add(ptrRecordInstance);
                                    JsonNode ptrdnameValue = pTRRecordsValue.get("ptrdname");
                                    if (ptrdnameValue == null || ptrdnameValue instanceof NullNode) continue;
                                    String ptrdnameInstance = ptrdnameValue.getTextValue();
                                    ptrRecordInstance.setPtrdname(ptrdnameInstance);
                                }
                            }
                            if ((sRVRecordsArray = propertiesValue.get("SRVRecords")) != null && !(sRVRecordsArray instanceof NullNode)) {
                                Iterator pTRRecordsValue;
                                propertiesInstance.setSrvRecords(new ArrayList<SrvRecord>());
                                pTRRecordsValue = ((ArrayNode)sRVRecordsArray).iterator();
                                while (pTRRecordsValue.hasNext()) {
                                    JsonNode targetValue;
                                    JsonNode portValue;
                                    JsonNode weightValue;
                                    Iterator sRVRecordsValue = (JsonNode)pTRRecordsValue.next();
                                    SrvRecord srvRecordInstance = new SrvRecord();
                                    propertiesInstance.getSrvRecords().add(srvRecordInstance);
                                    JsonNode priorityValue = sRVRecordsValue.get("priority");
                                    if (priorityValue != null && !(priorityValue instanceof NullNode)) {
                                        int priorityInstance = priorityValue.getIntValue();
                                        srvRecordInstance.setPriority(priorityInstance);
                                    }
                                    if ((weightValue = sRVRecordsValue.get("weight")) != null && !(weightValue instanceof NullNode)) {
                                        int weightInstance = weightValue.getIntValue();
                                        srvRecordInstance.setWeight(weightInstance);
                                    }
                                    if ((portValue = sRVRecordsValue.get("port")) != null && !(portValue instanceof NullNode)) {
                                        int portInstance = portValue.getIntValue();
                                        srvRecordInstance.setPort(portInstance);
                                    }
                                    if ((targetValue = sRVRecordsValue.get("target")) == null || targetValue instanceof NullNode) continue;
                                    String targetInstance = targetValue.getTextValue();
                                    srvRecordInstance.setTarget(targetInstance);
                                }
                            }
                            if ((tXTRecordsArray = propertiesValue.get("TXTRecords")) != null && !(tXTRecordsArray instanceof NullNode)) {
                                propertiesInstance.setTxtRecords(new ArrayList<TxtRecord>());
                                for (JsonNode tXTRecordsValue : (ArrayNode)tXTRecordsArray) {
                                    TxtRecord txtRecordInstance = new TxtRecord();
                                    propertiesInstance.getTxtRecords().add(txtRecordInstance);
                                    JsonNode valueValue2 = tXTRecordsValue.get("value");
                                    if (valueValue2 == null || valueValue2 instanceof NullNode) continue;
                                    String valueInstance = valueValue2.getTextValue();
                                    txtRecordInstance.setValue(valueInstance);
                                }
                            }
                            if ((cNAMERecordValue = propertiesValue.get("CNAMERecord")) != null && !(cNAMERecordValue instanceof NullNode)) {
                                CnameRecord cNAMERecordInstance = new CnameRecord();
                                propertiesInstance.setCnameRecord(cNAMERecordInstance);
                                JsonNode cnameValue = cNAMERecordValue.get("cname");
                                if (cnameValue != null && !(cnameValue instanceof NullNode)) {
                                    String cnameInstance = cnameValue.getTextValue();
                                    cNAMERecordInstance.setCname(cnameInstance);
                                }
                            }
                            if ((sOARecordValue = propertiesValue.get("SOARecord")) != null && !(sOARecordValue instanceof NullNode)) {
                                JsonNode minimumTTLValue;
                                JsonNode expireTimeValue;
                                JsonNode retryTimeValue;
                                JsonNode refreshTimeValue;
                                JsonNode serialNumberValue;
                                JsonNode emailValue;
                                SoaRecord sOARecordInstance = new SoaRecord();
                                propertiesInstance.setSoaRecord(sOARecordInstance);
                                JsonNode hostValue = sOARecordValue.get("host");
                                if (hostValue != null && !(hostValue instanceof NullNode)) {
                                    String hostInstance = hostValue.getTextValue();
                                    sOARecordInstance.setHost(hostInstance);
                                }
                                if ((emailValue = sOARecordValue.get("email")) != null && !(emailValue instanceof NullNode)) {
                                    String emailInstance = emailValue.getTextValue();
                                    sOARecordInstance.setEmail(emailInstance);
                                }
                                if ((serialNumberValue = sOARecordValue.get("serialNumber")) != null && !(serialNumberValue instanceof NullNode)) {
                                    long serialNumberInstance = serialNumberValue.getLongValue();
                                    sOARecordInstance.setSerialNumber(serialNumberInstance);
                                }
                                if ((refreshTimeValue = sOARecordValue.get("refreshTime")) != null && !(refreshTimeValue instanceof NullNode)) {
                                    long refreshTimeInstance = refreshTimeValue.getLongValue();
                                    sOARecordInstance.setRefreshTime(refreshTimeInstance);
                                }
                                if ((retryTimeValue = sOARecordValue.get("retryTime")) != null && !(retryTimeValue instanceof NullNode)) {
                                    long retryTimeInstance = retryTimeValue.getLongValue();
                                    sOARecordInstance.setRetryTime(retryTimeInstance);
                                }
                                if ((expireTimeValue = sOARecordValue.get("expireTime")) != null && !(expireTimeValue instanceof NullNode)) {
                                    long expireTimeInstance = expireTimeValue.getLongValue();
                                    sOARecordInstance.setExpireTime(expireTimeInstance);
                                }
                                if ((minimumTTLValue = sOARecordValue.get("minimumTTL")) != null && !(minimumTTLValue instanceof NullNode)) {
                                    long minimumTTLInstance = minimumTTLValue.getLongValue();
                                    sOARecordInstance.setMinimumTtl(minimumTTLInstance);
                                }
                            }
                        }
                        if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            recordSetInstance.setId(idInstance);
                        }
                        if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            recordSetInstance.setName(nameInstance);
                        }
                        if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            recordSetInstance.setType(typeInstance);
                        }
                        if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                            String locationInstance = locationValue.getTextValue();
                            recordSetInstance.setLocation(locationInstance);
                        }
                        if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            recordSetInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                    String nextLinkInstance = nextLinkValue.getTextValue();
                    result.setNextLink(nextLinkInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RecordSetListResponse recordSetListResponse = result;
            return recordSetListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<RecordSetListResponse> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<RecordSetListResponse>(){

            @Override
            public RecordSetListResponse call() throws Exception {
                return RecordSetOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordSetListResponse listNext(String nextLink) throws IOException, ServiceException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RecordSetListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new RecordSetListResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (!(responseContent == null)) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                JsonNode nextLinkValue;
                JsonNode valueArray = responseDoc.get("value");
                if (valueArray != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode tagsSequenceElement;
                        JsonNode locationValue;
                        JsonNode typeValue;
                        JsonNode nameValue;
                        JsonNode idValue;
                        JsonNode propertiesValue;
                        RecordSet recordSetInstance = new RecordSet();
                        result.getRecordSets().add(recordSetInstance);
                        JsonNode etagValue = valueValue.get("etag");
                        if (etagValue != null && !(etagValue instanceof NullNode)) {
                            String etagInstance = etagValue.getTextValue();
                            recordSetInstance.setETag(etagInstance);
                        }
                        if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                            JsonNode sOARecordValue;
                            JsonNode cNAMERecordValue;
                            JsonNode tXTRecordsArray;
                            JsonNode sRVRecordsArray;
                            JsonNode pTRRecordsArray;
                            JsonNode nSRecordsArray;
                            JsonNode mXRecordsArray;
                            JsonNode aAAARecordsArray;
                            JsonNode aRecordsArray;
                            RecordSetProperties propertiesInstance = new RecordSetProperties();
                            recordSetInstance.setProperties(propertiesInstance);
                            JsonNode tTLValue = propertiesValue.get("TTL");
                            if (tTLValue != null && !(tTLValue instanceof NullNode)) {
                                long tTLInstance = tTLValue.getLongValue();
                                propertiesInstance.setTtl(tTLInstance);
                            }
                            if ((aRecordsArray = propertiesValue.get("ARecords")) != null && !(aRecordsArray instanceof NullNode)) {
                                propertiesInstance.setARecords(new ArrayList<ARecord>());
                                for (Iterator aRecordsValue : (ArrayNode)aRecordsArray) {
                                    ARecord aRecordInstance = new ARecord();
                                    propertiesInstance.getARecords().add(aRecordInstance);
                                    JsonNode ipv4AddressValue = aRecordsValue.get("ipv4Address");
                                    if (ipv4AddressValue == null || ipv4AddressValue instanceof NullNode) continue;
                                    String ipv4AddressInstance = ipv4AddressValue.getTextValue();
                                    aRecordInstance.setIpv4Address(ipv4AddressInstance);
                                }
                            }
                            if ((aAAARecordsArray = propertiesValue.get("AAAARecords")) != null && !(aAAARecordsArray instanceof NullNode)) {
                                Iterator aRecordsValue;
                                propertiesInstance.setAaaaRecords(new ArrayList<AaaaRecord>());
                                aRecordsValue = ((ArrayNode)aAAARecordsArray).iterator();
                                while (aRecordsValue.hasNext()) {
                                    Iterator aAAARecordsValue = (JsonNode)aRecordsValue.next();
                                    AaaaRecord aaaaRecordInstance = new AaaaRecord();
                                    propertiesInstance.getAaaaRecords().add(aaaaRecordInstance);
                                    JsonNode ipv6AddressValue = aAAARecordsValue.get("ipv6Address");
                                    if (ipv6AddressValue == null || ipv6AddressValue instanceof NullNode) continue;
                                    String ipv6AddressInstance = ipv6AddressValue.getTextValue();
                                    aaaaRecordInstance.setIpv6Address(ipv6AddressInstance);
                                }
                            }
                            if ((mXRecordsArray = propertiesValue.get("MXRecords")) != null && !(mXRecordsArray instanceof NullNode)) {
                                propertiesInstance.setMxRecords(new ArrayList<MxRecord>());
                                for (Iterator mXRecordsValue : (ArrayNode)mXRecordsArray) {
                                    JsonNode exchangeValue;
                                    MxRecord mxRecordInstance = new MxRecord();
                                    propertiesInstance.getMxRecords().add(mxRecordInstance);
                                    JsonNode preferenceValue = mXRecordsValue.get("preference");
                                    if (preferenceValue != null && !(preferenceValue instanceof NullNode)) {
                                        int preferenceInstance = preferenceValue.getIntValue();
                                        mxRecordInstance.setPreference(preferenceInstance);
                                    }
                                    if ((exchangeValue = mXRecordsValue.get("exchange")) == null || exchangeValue instanceof NullNode) continue;
                                    String exchangeInstance = exchangeValue.getTextValue();
                                    mxRecordInstance.setExchange(exchangeInstance);
                                }
                            }
                            if ((nSRecordsArray = propertiesValue.get("NSRecords")) != null && !(nSRecordsArray instanceof NullNode)) {
                                Iterator mXRecordsValue;
                                propertiesInstance.setNsRecords(new ArrayList<NsRecord>());
                                mXRecordsValue = ((ArrayNode)nSRecordsArray).iterator();
                                while (mXRecordsValue.hasNext()) {
                                    Iterator nSRecordsValue = (JsonNode)mXRecordsValue.next();
                                    NsRecord nsRecordInstance = new NsRecord();
                                    propertiesInstance.getNsRecords().add(nsRecordInstance);
                                    JsonNode nsdnameValue = nSRecordsValue.get("nsdname");
                                    if (nsdnameValue == null || nsdnameValue instanceof NullNode) continue;
                                    String nsdnameInstance = nsdnameValue.getTextValue();
                                    nsRecordInstance.setNsdname(nsdnameInstance);
                                }
                            }
                            if ((pTRRecordsArray = propertiesValue.get("PTRRecords")) != null && !(pTRRecordsArray instanceof NullNode)) {
                                propertiesInstance.setPtrRecords(new ArrayList<PtrRecord>());
                                for (Iterator pTRRecordsValue : (ArrayNode)pTRRecordsArray) {
                                    PtrRecord ptrRecordInstance = new PtrRecord();
                                    propertiesInstance.getPtrRecords().add(ptrRecordInstance);
                                    JsonNode ptrdnameValue = pTRRecordsValue.get("ptrdname");
                                    if (ptrdnameValue == null || ptrdnameValue instanceof NullNode) continue;
                                    String ptrdnameInstance = ptrdnameValue.getTextValue();
                                    ptrRecordInstance.setPtrdname(ptrdnameInstance);
                                }
                            }
                            if ((sRVRecordsArray = propertiesValue.get("SRVRecords")) != null && !(sRVRecordsArray instanceof NullNode)) {
                                Iterator pTRRecordsValue;
                                propertiesInstance.setSrvRecords(new ArrayList<SrvRecord>());
                                pTRRecordsValue = ((ArrayNode)sRVRecordsArray).iterator();
                                while (pTRRecordsValue.hasNext()) {
                                    JsonNode targetValue;
                                    JsonNode portValue;
                                    JsonNode weightValue;
                                    Iterator sRVRecordsValue = (JsonNode)pTRRecordsValue.next();
                                    SrvRecord srvRecordInstance = new SrvRecord();
                                    propertiesInstance.getSrvRecords().add(srvRecordInstance);
                                    JsonNode priorityValue = sRVRecordsValue.get("priority");
                                    if (priorityValue != null && !(priorityValue instanceof NullNode)) {
                                        int priorityInstance = priorityValue.getIntValue();
                                        srvRecordInstance.setPriority(priorityInstance);
                                    }
                                    if ((weightValue = sRVRecordsValue.get("weight")) != null && !(weightValue instanceof NullNode)) {
                                        int weightInstance = weightValue.getIntValue();
                                        srvRecordInstance.setWeight(weightInstance);
                                    }
                                    if ((portValue = sRVRecordsValue.get("port")) != null && !(portValue instanceof NullNode)) {
                                        int portInstance = portValue.getIntValue();
                                        srvRecordInstance.setPort(portInstance);
                                    }
                                    if ((targetValue = sRVRecordsValue.get("target")) == null || targetValue instanceof NullNode) continue;
                                    String targetInstance = targetValue.getTextValue();
                                    srvRecordInstance.setTarget(targetInstance);
                                }
                            }
                            if ((tXTRecordsArray = propertiesValue.get("TXTRecords")) != null && !(tXTRecordsArray instanceof NullNode)) {
                                propertiesInstance.setTxtRecords(new ArrayList<TxtRecord>());
                                for (JsonNode tXTRecordsValue : (ArrayNode)tXTRecordsArray) {
                                    TxtRecord txtRecordInstance = new TxtRecord();
                                    propertiesInstance.getTxtRecords().add(txtRecordInstance);
                                    JsonNode valueValue2 = tXTRecordsValue.get("value");
                                    if (valueValue2 == null || valueValue2 instanceof NullNode) continue;
                                    String valueInstance = valueValue2.getTextValue();
                                    txtRecordInstance.setValue(valueInstance);
                                }
                            }
                            if ((cNAMERecordValue = propertiesValue.get("CNAMERecord")) != null && !(cNAMERecordValue instanceof NullNode)) {
                                CnameRecord cNAMERecordInstance = new CnameRecord();
                                propertiesInstance.setCnameRecord(cNAMERecordInstance);
                                JsonNode cnameValue = cNAMERecordValue.get("cname");
                                if (cnameValue != null && !(cnameValue instanceof NullNode)) {
                                    String cnameInstance = cnameValue.getTextValue();
                                    cNAMERecordInstance.setCname(cnameInstance);
                                }
                            }
                            if ((sOARecordValue = propertiesValue.get("SOARecord")) != null && !(sOARecordValue instanceof NullNode)) {
                                JsonNode minimumTTLValue;
                                JsonNode expireTimeValue;
                                JsonNode retryTimeValue;
                                JsonNode refreshTimeValue;
                                JsonNode serialNumberValue;
                                JsonNode emailValue;
                                SoaRecord sOARecordInstance = new SoaRecord();
                                propertiesInstance.setSoaRecord(sOARecordInstance);
                                JsonNode hostValue = sOARecordValue.get("host");
                                if (hostValue != null && !(hostValue instanceof NullNode)) {
                                    String hostInstance = hostValue.getTextValue();
                                    sOARecordInstance.setHost(hostInstance);
                                }
                                if ((emailValue = sOARecordValue.get("email")) != null && !(emailValue instanceof NullNode)) {
                                    String emailInstance = emailValue.getTextValue();
                                    sOARecordInstance.setEmail(emailInstance);
                                }
                                if ((serialNumberValue = sOARecordValue.get("serialNumber")) != null && !(serialNumberValue instanceof NullNode)) {
                                    long serialNumberInstance = serialNumberValue.getLongValue();
                                    sOARecordInstance.setSerialNumber(serialNumberInstance);
                                }
                                if ((refreshTimeValue = sOARecordValue.get("refreshTime")) != null && !(refreshTimeValue instanceof NullNode)) {
                                    long refreshTimeInstance = refreshTimeValue.getLongValue();
                                    sOARecordInstance.setRefreshTime(refreshTimeInstance);
                                }
                                if ((retryTimeValue = sOARecordValue.get("retryTime")) != null && !(retryTimeValue instanceof NullNode)) {
                                    long retryTimeInstance = retryTimeValue.getLongValue();
                                    sOARecordInstance.setRetryTime(retryTimeInstance);
                                }
                                if ((expireTimeValue = sOARecordValue.get("expireTime")) != null && !(expireTimeValue instanceof NullNode)) {
                                    long expireTimeInstance = expireTimeValue.getLongValue();
                                    sOARecordInstance.setExpireTime(expireTimeInstance);
                                }
                                if ((minimumTTLValue = sOARecordValue.get("minimumTTL")) != null && !(minimumTTLValue instanceof NullNode)) {
                                    long minimumTTLInstance = minimumTTLValue.getLongValue();
                                    sOARecordInstance.setMinimumTtl(minimumTTLInstance);
                                }
                            }
                        }
                        if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            recordSetInstance.setId(idInstance);
                        }
                        if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            recordSetInstance.setName(nameInstance);
                        }
                        if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            recordSetInstance.setType(typeInstance);
                        }
                        if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                            String locationInstance = locationValue.getTextValue();
                            recordSetInstance.setLocation(locationInstance);
                        }
                        if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            recordSetInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                    String nextLinkInstance = nextLinkValue.getTextValue();
                    result.setNextLink(nextLinkInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RecordSetListResponse recordSetListResponse = result;
            return recordSetListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

