/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns;

import com.microsoft.azure.management.dns.DnsManagementClientImpl;
import com.microsoft.azure.management.dns.ZoneOperations;
import com.microsoft.azure.management.dns.models.Zone;
import com.microsoft.azure.management.dns.models.ZoneCreateOrUpdateParameters;
import com.microsoft.azure.management.dns.models.ZoneCreateOrUpdateResponse;
import com.microsoft.azure.management.dns.models.ZoneDeleteParameters;
import com.microsoft.azure.management.dns.models.ZoneGetResponse;
import com.microsoft.azure.management.dns.models.ZoneListParameters;
import com.microsoft.azure.management.dns.models.ZoneListResponse;
import com.microsoft.azure.management.dns.models.ZoneProperties;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class ZoneOperationsImpl
implements ServiceOperations<DnsManagementClientImpl>,
ZoneOperations {
    private DnsManagementClientImpl client;

    ZoneOperationsImpl(DnsManagementClientImpl client) {
        this.client = client;
    }

    public DnsManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<ZoneCreateOrUpdateResponse> createOrUpdateAsync(final String resourceGroupName, final String zoneName, final ZoneCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ZoneCreateOrUpdateResponse>(){

            @Override
            public ZoneCreateOrUpdateResponse call() throws Exception {
                return ZoneOperationsImpl.this.createOrUpdate(resourceGroupName, zoneName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZoneCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String zoneName, ZoneCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        ObjectNode zoneCreateOrUpdateParametersValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getZone() == null) {
            throw new NullPointerException("parameters.Zone");
        }
        if (parameters.getZone().getLocation() == null) {
            throw new NullPointerException("parameters.Zone.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("If-Match", parameters.getZone().getETag());
        httpRequest.setHeader("If-None-Match", parameters.getIfNoneMatch());
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = zoneCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        if (parameters.getZone().getETag() != null) {
            zoneCreateOrUpdateParametersValue.put("etag", parameters.getZone().getETag());
        }
        if (parameters.getZone().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            zoneCreateOrUpdateParametersValue.put("properties", (JsonNode)propertiesValue);
            if (parameters.getZone().getProperties().getMaxNumberOfRecordSets() != null) {
                propertiesValue.put("maxNumberOfRecordSets", parameters.getZone().getProperties().getMaxNumberOfRecordSets());
            }
            if (parameters.getZone().getProperties().getNumberOfRecordSets() != null) {
                propertiesValue.put("numberOfRecordSets", parameters.getZone().getProperties().getNumberOfRecordSets());
            }
        }
        if (parameters.getZone().getId() != null) {
            zoneCreateOrUpdateParametersValue.put("id", parameters.getZone().getId());
        }
        if (parameters.getZone().getName() != null) {
            zoneCreateOrUpdateParametersValue.put("name", parameters.getZone().getName());
        }
        if (parameters.getZone().getType() != null) {
            zoneCreateOrUpdateParametersValue.put("type", parameters.getZone().getType());
        }
        zoneCreateOrUpdateParametersValue.put("location", parameters.getZone().getLocation());
        if (parameters.getZone().getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getZone().getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            zoneCreateOrUpdateParametersValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ZoneCreateOrUpdateResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ZoneCreateOrUpdateResponse();
            JsonNode responseDoc = null;
            if (!(responseContent == null)) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                JsonNode tagsSequenceElement;
                JsonNode locationValue;
                JsonNode typeValue;
                JsonNode nameValue;
                JsonNode idValue;
                JsonNode propertiesValue2;
                Zone zoneInstance = new Zone();
                result.setZone(zoneInstance);
                JsonNode etagValue = responseDoc.get("etag");
                if (etagValue != null && !(etagValue instanceof NullNode)) {
                    String etagInstance = etagValue.getTextValue();
                    zoneInstance.setETag(etagInstance);
                }
                if ((propertiesValue2 = responseDoc.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                    JsonNode numberOfRecordSetsValue;
                    ZoneProperties propertiesInstance = new ZoneProperties();
                    zoneInstance.setProperties(propertiesInstance);
                    JsonNode maxNumberOfRecordSetsValue = propertiesValue2.get("maxNumberOfRecordSets");
                    if (maxNumberOfRecordSetsValue != null && !(maxNumberOfRecordSetsValue instanceof NullNode)) {
                        long maxNumberOfRecordSetsInstance = maxNumberOfRecordSetsValue.getLongValue();
                        propertiesInstance.setMaxNumberOfRecordSets(maxNumberOfRecordSetsInstance);
                    }
                    if ((numberOfRecordSetsValue = propertiesValue2.get("numberOfRecordSets")) != null && !(numberOfRecordSetsValue instanceof NullNode)) {
                        long numberOfRecordSetsInstance = numberOfRecordSetsValue.getLongValue();
                        propertiesInstance.setNumberOfRecordSets(numberOfRecordSetsInstance);
                    }
                }
                if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                    String idInstance = idValue.getTextValue();
                    zoneInstance.setId(idInstance);
                }
                if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                    String nameInstance = nameValue.getTextValue();
                    zoneInstance.setName(nameInstance);
                }
                if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                    String typeInstance = typeValue.getTextValue();
                    zoneInstance.setType(typeInstance);
                }
                if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                    String locationInstance = locationValue.getTextValue();
                    zoneInstance.setLocation(locationInstance);
                }
                if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                    Iterator itr = tagsSequenceElement.getFields();
                    while (itr.hasNext()) {
                        Map.Entry property = (Map.Entry)itr.next();
                        String tagsKey2 = (String)property.getKey();
                        String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                        zoneInstance.getTags().put(tagsKey2, tagsValue2);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ZoneCreateOrUpdateResponse zoneCreateOrUpdateResponse = result;
            return zoneCreateOrUpdateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String zoneName, final ZoneDeleteParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ZoneOperationsImpl.this.delete(resourceGroupName, zoneName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String zoneName, ZoneDeleteParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("If-Match", parameters.getIfMatch());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ZoneGetResponse> getAsync(final String resourceGroupName, final String zoneName) {
        return this.getClient().getExecutorService().submit(new Callable<ZoneGetResponse>(){

            @Override
            public ZoneGetResponse call() throws Exception {
                return ZoneOperationsImpl.this.get(resourceGroupName, zoneName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZoneGetResponse get(String resourceGroupName, String zoneName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ZoneGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ZoneGetResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (!(responseContent == null)) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                JsonNode tagsSequenceElement;
                JsonNode locationValue;
                JsonNode typeValue;
                JsonNode nameValue;
                JsonNode idValue;
                JsonNode propertiesValue;
                Zone zoneInstance = new Zone();
                result.setZone(zoneInstance);
                JsonNode etagValue = responseDoc.get("etag");
                if (etagValue != null && !(etagValue instanceof NullNode)) {
                    String etagInstance = etagValue.getTextValue();
                    zoneInstance.setETag(etagInstance);
                }
                if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                    JsonNode numberOfRecordSetsValue;
                    ZoneProperties propertiesInstance = new ZoneProperties();
                    zoneInstance.setProperties(propertiesInstance);
                    JsonNode maxNumberOfRecordSetsValue = propertiesValue.get("maxNumberOfRecordSets");
                    if (maxNumberOfRecordSetsValue != null && !(maxNumberOfRecordSetsValue instanceof NullNode)) {
                        long maxNumberOfRecordSetsInstance = maxNumberOfRecordSetsValue.getLongValue();
                        propertiesInstance.setMaxNumberOfRecordSets(maxNumberOfRecordSetsInstance);
                    }
                    if ((numberOfRecordSetsValue = propertiesValue.get("numberOfRecordSets")) != null && !(numberOfRecordSetsValue instanceof NullNode)) {
                        long numberOfRecordSetsInstance = numberOfRecordSetsValue.getLongValue();
                        propertiesInstance.setNumberOfRecordSets(numberOfRecordSetsInstance);
                    }
                }
                if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                    String idInstance = idValue.getTextValue();
                    zoneInstance.setId(idInstance);
                }
                if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                    String nameInstance = nameValue.getTextValue();
                    zoneInstance.setName(nameInstance);
                }
                if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                    String typeInstance = typeValue.getTextValue();
                    zoneInstance.setType(typeInstance);
                }
                if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                    String locationInstance = locationValue.getTextValue();
                    zoneInstance.setLocation(locationInstance);
                }
                if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                    Iterator itr = tagsSequenceElement.getFields();
                    while (itr.hasNext()) {
                        Map.Entry property = (Map.Entry)itr.next();
                        String tagsKey = (String)property.getKey();
                        String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                        zoneInstance.getTags().put(tagsKey, tagsValue);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ZoneGetResponse zoneGetResponse = result;
            return zoneGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ZoneListResponse> listAsync(final String resourceGroupName, final ZoneListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ZoneListResponse>(){

            @Override
            public ZoneListResponse call() throws Exception {
                return ZoneOperationsImpl.this.list(resourceGroupName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZoneListResponse list(String resourceGroupName, ZoneListParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones";
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(parameters.getTop(), "UTF-8"));
        }
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getFilter() != null) {
            odataFilter.add(URLEncoder.encode(parameters.getFilter(), "UTF-8"));
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        queryParameters.add("api-version=2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ZoneListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ZoneListResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (!(responseContent == null)) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                JsonNode nextLinkValue;
                JsonNode valueArray = responseDoc.get("value");
                if (valueArray != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode tagsSequenceElement;
                        JsonNode locationValue;
                        JsonNode typeValue;
                        JsonNode nameValue;
                        JsonNode idValue;
                        JsonNode propertiesValue;
                        Zone zoneInstance = new Zone();
                        result.getZones().add(zoneInstance);
                        JsonNode etagValue = valueValue.get("etag");
                        if (etagValue != null && !(etagValue instanceof NullNode)) {
                            String etagInstance = etagValue.getTextValue();
                            zoneInstance.setETag(etagInstance);
                        }
                        if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                            JsonNode numberOfRecordSetsValue;
                            ZoneProperties propertiesInstance = new ZoneProperties();
                            zoneInstance.setProperties(propertiesInstance);
                            JsonNode maxNumberOfRecordSetsValue = propertiesValue.get("maxNumberOfRecordSets");
                            if (maxNumberOfRecordSetsValue != null && !(maxNumberOfRecordSetsValue instanceof NullNode)) {
                                long maxNumberOfRecordSetsInstance = maxNumberOfRecordSetsValue.getLongValue();
                                propertiesInstance.setMaxNumberOfRecordSets(maxNumberOfRecordSetsInstance);
                            }
                            if ((numberOfRecordSetsValue = propertiesValue.get("numberOfRecordSets")) != null && !(numberOfRecordSetsValue instanceof NullNode)) {
                                long numberOfRecordSetsInstance = numberOfRecordSetsValue.getLongValue();
                                propertiesInstance.setNumberOfRecordSets(numberOfRecordSetsInstance);
                            }
                        }
                        if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            zoneInstance.setId(idInstance);
                        }
                        if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            zoneInstance.setName(nameInstance);
                        }
                        if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            zoneInstance.setType(typeInstance);
                        }
                        if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                            String locationInstance = locationValue.getTextValue();
                            zoneInstance.setLocation(locationInstance);
                        }
                        if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            zoneInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                    String nextLinkInstance = nextLinkValue.getTextValue();
                    result.setNextLink(nextLinkInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ZoneListResponse zoneListResponse = result;
            return zoneListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ZoneListResponse> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<ZoneListResponse>(){

            @Override
            public ZoneListResponse call() throws Exception {
                return ZoneOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZoneListResponse listNext(String nextLink) throws IOException, ServiceException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ZoneListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ZoneListResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (!(responseContent == null)) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                JsonNode nextLinkValue;
                JsonNode valueArray = responseDoc.get("value");
                if (valueArray != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode tagsSequenceElement;
                        JsonNode locationValue;
                        JsonNode typeValue;
                        JsonNode nameValue;
                        JsonNode idValue;
                        JsonNode propertiesValue;
                        Zone zoneInstance = new Zone();
                        result.getZones().add(zoneInstance);
                        JsonNode etagValue = valueValue.get("etag");
                        if (etagValue != null && !(etagValue instanceof NullNode)) {
                            String etagInstance = etagValue.getTextValue();
                            zoneInstance.setETag(etagInstance);
                        }
                        if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                            JsonNode numberOfRecordSetsValue;
                            ZoneProperties propertiesInstance = new ZoneProperties();
                            zoneInstance.setProperties(propertiesInstance);
                            JsonNode maxNumberOfRecordSetsValue = propertiesValue.get("maxNumberOfRecordSets");
                            if (maxNumberOfRecordSetsValue != null && !(maxNumberOfRecordSetsValue instanceof NullNode)) {
                                long maxNumberOfRecordSetsInstance = maxNumberOfRecordSetsValue.getLongValue();
                                propertiesInstance.setMaxNumberOfRecordSets(maxNumberOfRecordSetsInstance);
                            }
                            if ((numberOfRecordSetsValue = propertiesValue.get("numberOfRecordSets")) != null && !(numberOfRecordSetsValue instanceof NullNode)) {
                                long numberOfRecordSetsInstance = numberOfRecordSetsValue.getLongValue();
                                propertiesInstance.setNumberOfRecordSets(numberOfRecordSetsInstance);
                            }
                        }
                        if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            zoneInstance.setId(idInstance);
                        }
                        if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            zoneInstance.setName(nameInstance);
                        }
                        if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            zoneInstance.setType(typeInstance);
                        }
                        if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                            String locationInstance = locationValue.getTextValue();
                            zoneInstance.setLocation(locationInstance);
                        }
                        if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            zoneInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                    String nextLinkInstance = nextLinkValue.getTextValue();
                    result.setNextLink(nextLinkInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ZoneListResponse zoneListResponse = result;
            return zoneListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

