/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.implementation.DnsManagementClientImpl;
import com.microsoft.azure.management.dns.implementation.PageImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RecordSetsInner {
    private RecordSetsService service;
    private DnsManagementClientImpl client;

    public RecordSetsInner(Retrofit retrofit, DnsManagementClientImpl client) {
        this.service = (RecordSetsService)retrofit.create(RecordSetsService.class);
        this.client = client;
    }

    public RecordSetInner update(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        return (RecordSetInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters), serviceCallback);
    }

    public Observable<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters).map((Func1)new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>(){

            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return (RecordSetInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RecordSetInner>> updateWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String ifMatch = null;
        return this.service.update(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>(){

            public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecordSetsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RecordSetInner update(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch) {
        return (RecordSetInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch).toBlocking().single()).body();
    }

    public ServiceFuture<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch), serviceCallback);
    }

    public Observable<RecordSetInner> updateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch) {
        return this.updateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch).map((Func1)new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>(){

            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return (RecordSetInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RecordSetInner>> updateWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>(){

            public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecordSetsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RecordSetInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RecordSetInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RecordSetInner createOrUpdate(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        return (RecordSetInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters), serviceCallback);
    }

    public Observable<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters).map((Func1)new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>(){

            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return (RecordSetInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RecordSetInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.service.createOrUpdate(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>(){

            public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecordSetsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RecordSetInner createOrUpdate(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        return (RecordSetInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch).toBlocking().single()).body();
    }

    public ServiceFuture<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch, ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch), serviceCallback);
    }

    public Observable<RecordSetInner> createOrUpdateAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, parameters, ifMatch, ifNoneMatch).map((Func1)new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>(){

            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return (RecordSetInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RecordSetInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, RecordSetInner parameters, String ifMatch, String ifNoneMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdate(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>(){

            public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecordSetsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RecordSetInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<RecordSetInner>(){}.getType()).register(200, new TypeToken<RecordSetInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String ifMatch = null;
        return this.service.delete(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecordSetsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void delete(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType, ifMatch).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecordSetsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RecordSetInner get(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return (RecordSetInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).toBlocking().single()).body();
    }

    public ServiceFuture<RecordSetInner> getAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType, ServiceCallback<RecordSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType), serviceCallback);
    }

    public Observable<RecordSetInner> getAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        return this.getWithServiceResponseAsync(resourceGroupName, zoneName, relativeRecordSetName, recordType).map((Func1)new Func1<ServiceResponse<RecordSetInner>, RecordSetInner>(){

            public RecordSetInner call(ServiceResponse<RecordSetInner> response) {
                return (RecordSetInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RecordSetInner>> getWithServiceResponseAsync(String resourceGroupName, String zoneName, String relativeRecordSetName, RecordType recordType) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (relativeRecordSetName == null) {
            throw new IllegalArgumentException("Parameter relativeRecordSetName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, zoneName, relativeRecordSetName, recordType, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecordSetInner>>>(){

            public Observable<ServiceResponse<RecordSetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecordSetsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RecordSetInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RecordSetInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RecordSetInner> listByType(String resourceGroupName, String zoneName, RecordType recordType) {
        ServiceResponse response = (ServiceResponse)this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType).toBlocking().single();
        return new PagedList<RecordSetInner>((Page)response.body()){

            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecordSetsInner.this.listByTypeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecordSetInner>> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType, ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                return RecordSetsInner.this.listByTypeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecordSetInner>> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType) {
        return this.listByTypeWithServiceResponseAsync(resourceGroupName, zoneName, recordType).map((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>(){

            public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeWithServiceResponseAsync(String resourceGroupName, String zoneName, RecordType recordType) {
        return this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType).concatMap((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecordSetsInner.this.listByTypeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeSinglePageAsync(String resourceGroupName, String zoneName, RecordType recordType) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        String recordsetnamesuffix = null;
        return this.service.listByType(resourceGroupName, zoneName, recordType, this.client.subscriptionId(), top, recordsetnamesuffix, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecordSetsInner.this.listByTypeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RecordSetInner> listByType(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        ServiceResponse response = (ServiceResponse)this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix).toBlocking().single();
        return new PagedList<RecordSetInner>((Page)response.body()){

            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecordSetsInner.this.listByTypeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecordSetInner>> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix, ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                return RecordSetsInner.this.listByTypeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecordSetInner>> listByTypeAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        return this.listByTypeWithServiceResponseAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix).map((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>(){

            public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeWithServiceResponseAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        return this.listByTypeSinglePageAsync(resourceGroupName, zoneName, recordType, top, recordsetnamesuffix).concatMap((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecordSetsInner.this.listByTypeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeSinglePageAsync(String resourceGroupName, String zoneName, RecordType recordType, Integer top, String recordsetnamesuffix) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (recordType == null) {
            throw new IllegalArgumentException("Parameter recordType is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByType(resourceGroupName, zoneName, recordType, this.client.subscriptionId(), top, recordsetnamesuffix, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecordSetsInner.this.listByTypeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecordSetInner>> listByTypeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecordSetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RecordSetInner> listByDnsZone(String resourceGroupName, String zoneName) {
        ServiceResponse response = (ServiceResponse)this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName).toBlocking().single();
        return new PagedList<RecordSetInner>((Page)response.body()){

            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecordSetsInner.this.listByDnsZoneNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecordSetInner>> listByDnsZoneAsync(String resourceGroupName, String zoneName, ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                return RecordSetsInner.this.listByDnsZoneNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecordSetInner>> listByDnsZoneAsync(String resourceGroupName, String zoneName) {
        return this.listByDnsZoneWithServiceResponseAsync(resourceGroupName, zoneName).map((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>(){

            public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneWithServiceResponseAsync(String resourceGroupName, String zoneName) {
        return this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName).concatMap((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecordSetsInner.this.listByDnsZoneNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        String recordsetnamesuffix = null;
        return this.service.listByDnsZone(resourceGroupName, zoneName, this.client.subscriptionId(), top, recordsetnamesuffix, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecordSetsInner.this.listByDnsZoneDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RecordSetInner> listByDnsZone(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix) {
        ServiceResponse response = (ServiceResponse)this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix).toBlocking().single();
        return new PagedList<RecordSetInner>((Page)response.body()){

            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecordSetsInner.this.listByDnsZoneNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecordSetInner>> listByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix, ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                return RecordSetsInner.this.listByDnsZoneNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecordSetInner>> listByDnsZoneAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix) {
        return this.listByDnsZoneWithServiceResponseAsync(resourceGroupName, zoneName, top, recordsetnamesuffix).map((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>(){

            public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneWithServiceResponseAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix) {
        return this.listByDnsZoneSinglePageAsync(resourceGroupName, zoneName, top, recordsetnamesuffix).concatMap((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecordSetsInner.this.listByDnsZoneNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneSinglePageAsync(String resourceGroupName, String zoneName, Integer top, String recordsetnamesuffix) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByDnsZone(resourceGroupName, zoneName, this.client.subscriptionId(), top, recordsetnamesuffix, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecordSetsInner.this.listByDnsZoneDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecordSetInner>> listByDnsZoneDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecordSetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RecordSetInner> listByTypeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByTypeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecordSetInner>((Page)response.body()){

            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecordSetsInner.this.listByTypeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecordSetInner>> listByTypeNextAsync(String nextPageLink, ServiceFuture<List<RecordSetInner>> serviceFuture, ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByTypeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                return RecordSetsInner.this.listByTypeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecordSetInner>> listByTypeNextAsync(String nextPageLink) {
        return this.listByTypeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>(){

            public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByTypeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecordSetsInner.this.listByTypeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByTypeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByTypeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecordSetsInner.this.listByTypeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecordSetInner>> listByTypeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecordSetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RecordSetInner> listByDnsZoneNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByDnsZoneNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RecordSetInner>((Page)response.body()){

            public Page<RecordSetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RecordSetsInner.this.listByDnsZoneNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RecordSetInner>> listByDnsZoneNextAsync(String nextPageLink, ServiceFuture<List<RecordSetInner>> serviceFuture, ListOperationCallback<RecordSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDnsZoneNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(String nextPageLink) {
                return RecordSetsInner.this.listByDnsZoneNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RecordSetInner>> listByDnsZoneNextAsync(String nextPageLink) {
        return this.listByDnsZoneNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Page<RecordSetInner>>(){

            public Page<RecordSetInner> call(ServiceResponse<Page<RecordSetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByDnsZoneNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RecordSetInner>>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(ServiceResponse<Page<RecordSetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RecordSetsInner.this.listByDnsZoneNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RecordSetInner>>> listByDnsZoneNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByDnsZoneNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RecordSetInner>>>>(){

            public Observable<ServiceResponse<Page<RecordSetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecordSetsInner.this.listByDnsZoneNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RecordSetInner>> listByDnsZoneNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RecordSetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RecordSetsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="relativeRecordSetName", encoded=true) String var3, @Path(value="recordType") RecordType var4, @Path(value="subscriptionId") String var5, @Body RecordSetInner var6, @Header(value="If-Match") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="relativeRecordSetName", encoded=true) String var3, @Path(value="recordType") RecordType var4, @Path(value="subscriptionId") String var5, @Body RecordSetInner var6, @Header(value="If-Match") String var7, @Header(value="If-None-Match") String var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="relativeRecordSetName", encoded=true) String var3, @Path(value="recordType") RecordType var4, @Path(value="subscriptionId") String var5, @Header(value="If-Match") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}/{relativeRecordSetName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="relativeRecordSetName", encoded=true) String var3, @Path(value="recordType") RecordType var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets listByType"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/{recordType}")
        public Observable<Response<ResponseBody>> listByType(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="recordType") RecordType var3, @Path(value="subscriptionId") String var4, @Query(value="$top") Integer var5, @Query(value="$recordsetnamesuffix") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets listByDnsZone"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}/recordsets")
        public Observable<Response<ResponseBody>> listByDnsZone(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="subscriptionId") String var3, @Query(value="$top") Integer var4, @Query(value="$recordsetnamesuffix") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets listByTypeNext"})
        @GET
        public Observable<Response<ResponseBody>> listByTypeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.RecordSets listByDnsZoneNext"})
        @GET
        public Observable<Response<ResponseBody>> listByDnsZoneNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

