/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.DisasterRecoveryPairingAuthorizationRule;
import com.microsoft.azure.management.eventhub.EventHubDisasterRecoveryPairing;
import com.microsoft.azure.management.eventhub.EventHubNamespace;
import com.microsoft.azure.management.eventhub.ProvisioningStateDR;
import com.microsoft.azure.management.eventhub.RoleDisasterRecovery;
import com.microsoft.azure.management.eventhub.implementation.Ancestors;
import com.microsoft.azure.management.eventhub.implementation.ArmDisasterRecoveryInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.eventhub.implementation.EventHubNamespaceImpl;
import com.microsoft.azure.management.eventhub.implementation.NestedResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.Objects;
import rx.Completable;
import rx.Observable;

@LangDefinition
class EventHubDisasterRecoveryPairingImpl
extends NestedResourceImpl<EventHubDisasterRecoveryPairing, ArmDisasterRecoveryInner, EventHubDisasterRecoveryPairingImpl>
implements EventHubDisasterRecoveryPairing,
EventHubDisasterRecoveryPairing.Definition,
EventHubDisasterRecoveryPairing.Update {
    private Ancestors.OneAncestor ancestor;

    EventHubDisasterRecoveryPairingImpl(String name, ArmDisasterRecoveryInner inner, EventHubManager manager) {
        super(name, inner, manager);
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = new Ancestors.OneAncestor(ancestors, inner.id());
    }

    EventHubDisasterRecoveryPairingImpl(String name, EventHubManager manager) {
        super(name, new ArmDisasterRecoveryInner(), manager);
    }

    @Override
    public String primaryNamespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String primaryNamespaceName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public String secondaryNamespaceId() {
        return ((ArmDisasterRecoveryInner)((Object)this.inner())).partnerNamespace();
    }

    @Override
    public RoleDisasterRecovery namespaceRole() {
        return ((ArmDisasterRecoveryInner)((Object)this.inner())).role();
    }

    @Override
    public ProvisioningStateDR provisioningState() {
        return ((ArmDisasterRecoveryInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withNewPrimaryNamespace(Creatable<EventHubNamespace> namespaceCreatable) {
        this.addDependency(namespaceCreatable);
        EventHubNamespaceImpl namespace = (EventHubNamespaceImpl)namespaceCreatable;
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = new Ancestors.OneAncestor(ancestors, namespace.resourceGroupName(), namespaceCreatable.name());
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingPrimaryNamespace(EventHubNamespace namespace) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = new Ancestors.OneAncestor(ancestors, this.selfId(namespace.id()));
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingPrimaryNamespace(String resourceGroupName, String primaryNamespaceName) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = new Ancestors.OneAncestor(ancestors, resourceGroupName, primaryNamespaceName);
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingPrimaryNamespaceId(String namespaceId) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = new Ancestors.OneAncestor(ancestors, this.selfId(namespaceId));
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withNewSecondaryNamespace(Creatable<EventHubNamespace> namespaceCreatable) {
        this.addDependency(namespaceCreatable);
        EventHubNamespaceImpl namespace = (EventHubNamespaceImpl)namespaceCreatable;
        ((ArmDisasterRecoveryInner)((Object)this.inner())).withPartnerNamespace(namespace.name());
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingSecondaryNamespace(EventHubNamespace namespace) {
        Objects.requireNonNull(namespace.id());
        ((ArmDisasterRecoveryInner)((Object)this.inner())).withPartnerNamespace(namespace.id());
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingSecondaryNamespaceId(String namespaceId) {
        Objects.requireNonNull(namespaceId);
        ((ArmDisasterRecoveryInner)((Object)this.inner())).withPartnerNamespace(namespaceId);
        return this;
    }

    public Observable<EventHubDisasterRecoveryPairing> createResourceAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager().inner())).disasterRecoveryConfigs().createOrUpdateAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name(), (ArmDisasterRecoveryInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public Completable breakPairingAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager().inner())).disasterRecoveryConfigs().breakPairingAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name()).toCompletable().concatWith(this.refreshAsync().toCompletable());
    }

    @Override
    public void breakPairing() {
        this.breakPairingAsync().await();
    }

    @Override
    public Completable failOverAsync() {
        ResourceId secondaryNs = ResourceId.fromString((String)((ArmDisasterRecoveryInner)((Object)this.inner())).partnerNamespace());
        return ((EventHubManagementClientImpl)((Object)this.manager().inner())).disasterRecoveryConfigs().failOverAsync(secondaryNs.resourceGroupName(), secondaryNs.name(), this.name()).toCompletable().concatWith(this.refreshAsync().toCompletable());
    }

    @Override
    public void failOver() {
        this.failOverAsync().await();
    }

    @Override
    public Observable<DisasterRecoveryPairingAuthorizationRule> listAuthorizationRulesAsync() {
        return this.manager().disasterRecoveryPairingAuthorizationRules().listByDisasterRecoveryPairingAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public PagedList<DisasterRecoveryPairingAuthorizationRule> listAuthorizationRules() {
        return this.manager().disasterRecoveryPairingAuthorizationRules().listByDisasterRecoveryPairing(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    protected Observable<ArmDisasterRecoveryInner> getInnerAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager().inner())).disasterRecoveryConfigs().getAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    private Ancestors.OneAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/disasterRecoveryConfig/%s", parentId, this.name());
    }
}

