/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryApplications;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryGroups;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryUsers;
import com.microsoft.azure.management.graphrbac.RoleAssignments;
import com.microsoft.azure.management.graphrbac.RoleDefinitions;
import com.microsoft.azure.management.graphrbac.ServicePrincipals;
import com.microsoft.azure.management.graphrbac.implementation.ActiveDirectoryApplicationsImpl;
import com.microsoft.azure.management.graphrbac.implementation.ActiveDirectoryGroupsImpl;
import com.microsoft.azure.management.graphrbac.implementation.ActiveDirectoryUsersImpl;
import com.microsoft.azure.management.graphrbac.implementation.AuthorizationManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentsImpl;
import com.microsoft.azure.management.graphrbac.implementation.RoleDefinitionsImpl;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalsImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.interceptors.RequestIdHeaderInterceptor;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta
public final class GraphRbacManager
implements HasInner<GraphRbacManagementClientImpl> {
    private String tenantId;
    private final GraphRbacManagementClientImpl graphRbacManagementClient;
    private final AuthorizationManagementClientImpl authorizationManagementClient;
    private ActiveDirectoryUsers activeDirectoryUsers;
    private ActiveDirectoryGroups activeDirectoryGroups;
    private ServicePrincipals servicePrincipals;
    private ActiveDirectoryApplications applications;
    private RoleAssignments roleAssignments;
    private RoleDefinitions roleDefinitions;

    public GraphRbacManagementClientImpl inner() {
        return this.graphRbacManagementClient;
    }

    public static GraphRbacManager authenticate(AzureTokenCredentials credentials) {
        return new GraphRbacManager(new RestClient.Builder().withBaseUrl(credentials.environment().graphEndpoint()).withInterceptor((Interceptor)new RequestIdHeaderInterceptor()).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), credentials.domain());
    }

    public static GraphRbacManager authenticate(RestClient restClient, String tenantId) {
        return new GraphRbacManager(restClient, tenantId);
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    private GraphRbacManager(RestClient restClient, String tenantId) {
        String graphEndpoint = AzureEnvironment.AZURE.graphEndpoint();
        if (restClient.credentials() instanceof AzureTokenCredentials) {
            graphEndpoint = ((AzureTokenCredentials)restClient.credentials()).environment().graphEndpoint();
        }
        this.graphRbacManagementClient = new GraphRbacManagementClientImpl(restClient.newBuilder().withBaseUrl(graphEndpoint).build()).withTenantID(tenantId);
        this.authorizationManagementClient = new AuthorizationManagementClientImpl(restClient);
        this.tenantId = tenantId;
    }

    public AuthorizationManagementClientImpl roleInner() {
        return this.authorizationManagementClient;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ActiveDirectoryUsers users() {
        if (this.activeDirectoryUsers == null) {
            this.activeDirectoryUsers = new ActiveDirectoryUsersImpl(this);
        }
        return this.activeDirectoryUsers;
    }

    @Beta(value=Beta.SinceVersion.V1_1_0)
    public ActiveDirectoryGroups groups() {
        if (this.activeDirectoryGroups == null) {
            this.activeDirectoryGroups = new ActiveDirectoryGroupsImpl(this);
        }
        return this.activeDirectoryGroups;
    }

    public ServicePrincipals servicePrincipals() {
        if (this.servicePrincipals == null) {
            this.servicePrincipals = new ServicePrincipalsImpl(this.graphRbacManagementClient.servicePrincipals(), this);
        }
        return this.servicePrincipals;
    }

    @Beta(value=Beta.SinceVersion.V1_1_0)
    public ActiveDirectoryApplications applications() {
        if (this.applications == null) {
            this.applications = new ActiveDirectoryApplicationsImpl(this.graphRbacManagementClient.applications(), this);
        }
        return this.applications;
    }

    @Beta(value=Beta.SinceVersion.V1_1_0)
    public RoleAssignments roleAssignments() {
        if (this.roleAssignments == null) {
            this.roleAssignments = new RoleAssignmentsImpl(this);
        }
        return this.roleAssignments;
    }

    @Beta(value=Beta.SinceVersion.V1_1_0)
    public RoleDefinitions roleDefinitions() {
        if (this.roleDefinitions == null) {
            this.roleDefinitions = new RoleDefinitionsImpl(this);
        }
        return this.roleDefinitions;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public GraphRbacManager authenticate(AzureTokenCredentials credentials) {
            return GraphRbacManager.authenticate(this.buildRestClient(credentials, AzureEnvironment.Endpoint.RESOURCE_MANAGER), credentials.domain());
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public GraphRbacManager authenticate(AzureTokenCredentials var1);
    }
}

