/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.graphrbac.implementation.AuthorizationManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.PageImpl;
import com.microsoft.azure.management.graphrbac.implementation.ProviderOperationsMetadataInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ProviderOperationsMetadatasInner {
    private ProviderOperationsMetadatasService service;
    private AuthorizationManagementClientImpl client;

    public ProviderOperationsMetadatasInner(Retrofit retrofit, AuthorizationManagementClientImpl client) {
        this.service = (ProviderOperationsMetadatasService)retrofit.create(ProviderOperationsMetadatasService.class);
        this.client = client;
    }

    public ProviderOperationsMetadataInner get(String resourceProviderNamespace, String apiVersion) {
        return (ProviderOperationsMetadataInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceProviderNamespace, apiVersion).toBlocking().single()).body();
    }

    public ServiceFuture<ProviderOperationsMetadataInner> getAsync(String resourceProviderNamespace, String apiVersion, ServiceCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceProviderNamespace, apiVersion), serviceCallback);
    }

    public Observable<ProviderOperationsMetadataInner> getAsync(String resourceProviderNamespace, String apiVersion) {
        return this.getWithServiceResponseAsync(resourceProviderNamespace, apiVersion).map((Func1)new Func1<ServiceResponse<ProviderOperationsMetadataInner>, ProviderOperationsMetadataInner>(){

            public ProviderOperationsMetadataInner call(ServiceResponse<ProviderOperationsMetadataInner> response) {
                return (ProviderOperationsMetadataInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ProviderOperationsMetadataInner>> getWithServiceResponseAsync(String resourceProviderNamespace, String apiVersion) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        String expand = null;
        return this.service.get(resourceProviderNamespace, apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderOperationsMetadataInner>>>(){

            public Observable<ServiceResponse<ProviderOperationsMetadataInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProviderOperationsMetadatasInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ProviderOperationsMetadataInner get(String resourceProviderNamespace, String apiVersion, String expand) {
        return (ProviderOperationsMetadataInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceProviderNamespace, apiVersion, expand).toBlocking().single()).body();
    }

    public ServiceFuture<ProviderOperationsMetadataInner> getAsync(String resourceProviderNamespace, String apiVersion, String expand, ServiceCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceProviderNamespace, apiVersion, expand), serviceCallback);
    }

    public Observable<ProviderOperationsMetadataInner> getAsync(String resourceProviderNamespace, String apiVersion, String expand) {
        return this.getWithServiceResponseAsync(resourceProviderNamespace, apiVersion, expand).map((Func1)new Func1<ServiceResponse<ProviderOperationsMetadataInner>, ProviderOperationsMetadataInner>(){

            public ProviderOperationsMetadataInner call(ServiceResponse<ProviderOperationsMetadataInner> response) {
                return (ProviderOperationsMetadataInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ProviderOperationsMetadataInner>> getWithServiceResponseAsync(String resourceProviderNamespace, String apiVersion, String expand) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.get(resourceProviderNamespace, apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderOperationsMetadataInner>>>(){

            public Observable<ServiceResponse<ProviderOperationsMetadataInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProviderOperationsMetadatasInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProviderOperationsMetadataInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProviderOperationsMetadataInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProviderOperationsMetadataInner> list(String apiVersion) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(apiVersion).toBlocking().single();
        return new PagedList<ProviderOperationsMetadataInner>((Page)response.body()){

            public Page<ProviderOperationsMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProviderOperationsMetadatasInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProviderOperationsMetadataInner>> listAsync(String apiVersion, ListOperationCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(apiVersion), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(String nextPageLink) {
                return ProviderOperationsMetadatasInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProviderOperationsMetadataInner>> listAsync(String apiVersion) {
        return this.listWithServiceResponseAsync(apiVersion).map((Func1)new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Page<ProviderOperationsMetadataInner>>(){

            public Page<ProviderOperationsMetadataInner> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listWithServiceResponseAsync(String apiVersion) {
        return this.listSinglePageAsync(apiVersion).concatMap((Func1)new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProviderOperationsMetadatasInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listSinglePageAsync(String apiVersion) {
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        String expand = null;
        return this.service.list(apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProviderOperationsMetadatasInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ProviderOperationsMetadataInner> list(String apiVersion, String expand) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(apiVersion, expand).toBlocking().single();
        return new PagedList<ProviderOperationsMetadataInner>((Page)response.body()){

            public Page<ProviderOperationsMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProviderOperationsMetadatasInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProviderOperationsMetadataInner>> listAsync(String apiVersion, String expand, ListOperationCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(apiVersion, expand), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(String nextPageLink) {
                return ProviderOperationsMetadatasInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProviderOperationsMetadataInner>> listAsync(String apiVersion, String expand) {
        return this.listWithServiceResponseAsync(apiVersion, expand).map((Func1)new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Page<ProviderOperationsMetadataInner>>(){

            public Page<ProviderOperationsMetadataInner> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listWithServiceResponseAsync(String apiVersion, String expand) {
        return this.listSinglePageAsync(apiVersion, expand).concatMap((Func1)new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProviderOperationsMetadatasInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listSinglePageAsync(String apiVersion, String expand) {
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.list(apiVersion, expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProviderOperationsMetadatasInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProviderOperationsMetadataInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProviderOperationsMetadataInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProviderOperationsMetadataInner>((Page)response.body()){

            public Page<ProviderOperationsMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProviderOperationsMetadatasInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProviderOperationsMetadataInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ProviderOperationsMetadataInner>> serviceFuture, ListOperationCallback<ProviderOperationsMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(String nextPageLink) {
                return ProviderOperationsMetadatasInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProviderOperationsMetadataInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Page<ProviderOperationsMetadataInner>>(){

            public Page<ProviderOperationsMetadataInner> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ProviderOperationsMetadataInner>>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(ServiceResponse<Page<ProviderOperationsMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProviderOperationsMetadatasInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderOperationsMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProviderOperationsMetadatasInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProviderOperationsMetadataInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProviderOperationsMetadataInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ProviderOperationsMetadatasService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ProviderOperationsMetadatas get"})
        @GET(value="providers/Microsoft.Authorization/providerOperations/{resourceProviderNamespace}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceProviderNamespace") String var1, @Query(value="api-version") String var2, @Query(value="$expand") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ProviderOperationsMetadatas list"})
        @GET(value="providers/Microsoft.Authorization/providerOperations")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Query(value="$expand") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.graphrbac.ProviderOperationsMetadatas listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

