/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.IncidentInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class AlertRuleIncidentsInner {
    private AlertRuleIncidentsService service;
    private MonitorManagementClientImpl client;

    public AlertRuleIncidentsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (AlertRuleIncidentsService)retrofit.create(AlertRuleIncidentsService.class);
        this.client = client;
    }

    public IncidentInner get(String resourceGroupName, String ruleName, String incidentName) {
        return (IncidentInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, ruleName, incidentName).toBlocking().single()).body();
    }

    public ServiceFuture<IncidentInner> getAsync(String resourceGroupName, String ruleName, String incidentName, ServiceCallback<IncidentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, ruleName, incidentName), serviceCallback);
    }

    public Observable<IncidentInner> getAsync(String resourceGroupName, String ruleName, String incidentName) {
        return this.getWithServiceResponseAsync(resourceGroupName, ruleName, incidentName).map((Func1)new Func1<ServiceResponse<IncidentInner>, IncidentInner>(){

            public IncidentInner call(ServiceResponse<IncidentInner> response) {
                return (IncidentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<IncidentInner>> getWithServiceResponseAsync(String resourceGroupName, String ruleName, String incidentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (incidentName == null) {
            throw new IllegalArgumentException("Parameter incidentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.get(resourceGroupName, ruleName, incidentName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IncidentInner>>>(){

            public Observable<ServiceResponse<IncidentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AlertRuleIncidentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IncidentInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<IncidentInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public List<IncidentInner> listByAlertRule(String resourceGroupName, String ruleName) {
        return (List)((ServiceResponse)this.listByAlertRuleWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single()).body();
    }

    public ServiceFuture<List<IncidentInner>> listByAlertRuleAsync(String resourceGroupName, String ruleName, ServiceCallback<List<IncidentInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByAlertRuleWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    public Observable<List<IncidentInner>> listByAlertRuleAsync(String resourceGroupName, String ruleName) {
        return this.listByAlertRuleWithServiceResponseAsync(resourceGroupName, ruleName).map((Func1)new Func1<ServiceResponse<List<IncidentInner>>, List<IncidentInner>>(){

            public List<IncidentInner> call(ServiceResponse<List<IncidentInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<IncidentInner>>> listByAlertRuleWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listByAlertRule(resourceGroupName, ruleName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<IncidentInner>>>>(){

            public Observable<ServiceResponse<List<IncidentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AlertRuleIncidentsInner.this.listByAlertRuleDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<IncidentInner>> listByAlertRuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<IncidentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AlertRuleIncidentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AlertRuleIncidents get"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}/incidents/{incidentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="ruleName") String var2, @Path(value="incidentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AlertRuleIncidents listByAlertRule"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}/incidents")
        public Observable<Response<ResponseBody>> listByAlertRule(@Path(value="resourceGroupName") String var1, @Path(value="ruleName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

