/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.AlertRuleResourceInner;
import com.microsoft.azure.management.monitor.implementation.AlertRuleResourcePatchInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class AlertRulesInner
implements InnerSupportsGet<AlertRuleResourceInner>,
InnerSupportsDelete<Void> {
    private AlertRulesService service;
    private MonitorManagementClientImpl client;

    public AlertRulesInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (AlertRulesService)retrofit.create(AlertRulesService.class);
        this.client = client;
    }

    public AlertRuleResourceInner createOrUpdate(String resourceGroupName, String ruleName, AlertRuleResourceInner parameters) {
        return (AlertRuleResourceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<AlertRuleResourceInner> createOrUpdateAsync(String resourceGroupName, String ruleName, AlertRuleResourceInner parameters, ServiceCallback<AlertRuleResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters), serviceCallback);
    }

    public Observable<AlertRuleResourceInner> createOrUpdateAsync(String resourceGroupName, String ruleName, AlertRuleResourceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, ruleName, parameters).map((Func1)new Func1<ServiceResponse<AlertRuleResourceInner>, AlertRuleResourceInner>(){

            public AlertRuleResourceInner call(ServiceResponse<AlertRuleResourceInner> response) {
                return (AlertRuleResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AlertRuleResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String ruleName, AlertRuleResourceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2016-03-01";
        return this.service.createOrUpdate(resourceGroupName, ruleName, this.client.subscriptionId(), "2016-03-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AlertRuleResourceInner>>>(){

            public Observable<ServiceResponse<AlertRuleResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AlertRulesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AlertRuleResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AlertRuleResourceInner>(){}.getType()).register(201, new TypeToken<AlertRuleResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String ruleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String ruleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String ruleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, ruleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.delete(resourceGroupName, ruleName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AlertRulesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AlertRuleResourceInner getByResourceGroup(String resourceGroupName, String ruleName) {
        return (AlertRuleResourceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single()).body());
    }

    public ServiceFuture<AlertRuleResourceInner> getByResourceGroupAsync(String resourceGroupName, String ruleName, ServiceCallback<AlertRuleResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    public Observable<AlertRuleResourceInner> getByResourceGroupAsync(String resourceGroupName, String ruleName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, ruleName).map((Func1)new Func1<ServiceResponse<AlertRuleResourceInner>, AlertRuleResourceInner>(){

            public AlertRuleResourceInner call(ServiceResponse<AlertRuleResourceInner> response) {
                return (AlertRuleResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AlertRuleResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getByResourceGroup(resourceGroupName, ruleName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AlertRuleResourceInner>>>(){

            public Observable<ServiceResponse<AlertRuleResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AlertRulesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AlertRuleResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AlertRuleResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AlertRuleResourceInner update(String resourceGroupName, String ruleName, AlertRuleResourcePatchInner alertRulesResource) {
        return (AlertRuleResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, ruleName, alertRulesResource).toBlocking().single()).body());
    }

    public ServiceFuture<AlertRuleResourceInner> updateAsync(String resourceGroupName, String ruleName, AlertRuleResourcePatchInner alertRulesResource, ServiceCallback<AlertRuleResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, ruleName, alertRulesResource), serviceCallback);
    }

    public Observable<AlertRuleResourceInner> updateAsync(String resourceGroupName, String ruleName, AlertRuleResourcePatchInner alertRulesResource) {
        return this.updateWithServiceResponseAsync(resourceGroupName, ruleName, alertRulesResource).map((Func1)new Func1<ServiceResponse<AlertRuleResourceInner>, AlertRuleResourceInner>(){

            public AlertRuleResourceInner call(ServiceResponse<AlertRuleResourceInner> response) {
                return (AlertRuleResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AlertRuleResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String ruleName, AlertRuleResourcePatchInner alertRulesResource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (alertRulesResource == null) {
            throw new IllegalArgumentException("Parameter alertRulesResource is required and cannot be null.");
        }
        Validator.validate((Object)alertRulesResource);
        String apiVersion = "2016-03-01";
        return this.service.update(this.client.subscriptionId(), resourceGroupName, ruleName, "2016-03-01", alertRulesResource, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AlertRuleResourceInner>>>(){

            public Observable<ServiceResponse<AlertRuleResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AlertRulesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AlertRuleResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AlertRuleResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public List<AlertRuleResourceInner> listByResourceGroup(String resourceGroupName) {
        return (List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<List<AlertRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<AlertRuleResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<List<AlertRuleResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<AlertRuleResourceInner>>, List<AlertRuleResourceInner>>(){

            public List<AlertRuleResourceInner> call(ServiceResponse<List<AlertRuleResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<AlertRuleResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<AlertRuleResourceInner>>>>(){

            public Observable<ServiceResponse<List<AlertRuleResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AlertRulesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<AlertRuleResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<AlertRuleResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AlertRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AlertRules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="ruleName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Body AlertRuleResourceInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AlertRules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="ruleName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AlertRules getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="ruleName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AlertRules update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="ruleName") String var3, @Query(value="api-version") String var4, @Body AlertRuleResourcePatchInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AlertRules listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

