/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.AutoscaleSettingResourceInner;
import com.microsoft.azure.management.monitor.implementation.AutoscaleSettingResourcePatchInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AutoscaleSettingsInner
implements InnerSupportsGet<AutoscaleSettingResourceInner>,
InnerSupportsDelete<Void> {
    private AutoscaleSettingsService service;
    private MonitorManagementClientImpl client;

    public AutoscaleSettingsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (AutoscaleSettingsService)retrofit.create(AutoscaleSettingsService.class);
        this.client = client;
    }

    public PagedList<AutoscaleSettingResourceInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<AutoscaleSettingResourceInner>((Page)response.body()){

            public Page<AutoscaleSettingResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AutoscaleSettingsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AutoscaleSettingResourceInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(String nextPageLink) {
                return AutoscaleSettingsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AutoscaleSettingResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Page<AutoscaleSettingResourceInner>>(){

            public Page<AutoscaleSettingResourceInner> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AutoscaleSettingsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AutoscaleSettingsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AutoscaleSettingResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AutoscaleSettingResourceInner createOrUpdate(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourceInner parameters) {
        return (AutoscaleSettingResourceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<AutoscaleSettingResourceInner> createOrUpdateAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourceInner parameters, ServiceCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, parameters), serviceCallback);
    }

    public Observable<AutoscaleSettingResourceInner> createOrUpdateAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, parameters).map((Func1)new Func1<ServiceResponse<AutoscaleSettingResourceInner>, AutoscaleSettingResourceInner>(){

            public AutoscaleSettingResourceInner call(ServiceResponse<AutoscaleSettingResourceInner> response) {
                return (AutoscaleSettingResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AutoscaleSettingResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (autoscaleSettingName == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-04-01";
        return this.service.createOrUpdate(resourceGroupName, autoscaleSettingName, this.client.subscriptionId(), parameters, "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AutoscaleSettingResourceInner>>>(){

            public Observable<ServiceResponse<AutoscaleSettingResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AutoscaleSettingsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AutoscaleSettingResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AutoscaleSettingResourceInner>(){}.getType()).register(201, new TypeToken<AutoscaleSettingResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String autoscaleSettingName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, autoscaleSettingName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String autoscaleSettingName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, autoscaleSettingName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String autoscaleSettingName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, autoscaleSettingName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String autoscaleSettingName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (autoscaleSettingName == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.delete(resourceGroupName, autoscaleSettingName, this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AutoscaleSettingsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AutoscaleSettingResourceInner getByResourceGroup(String resourceGroupName, String autoscaleSettingName) {
        return (AutoscaleSettingResourceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, autoscaleSettingName).toBlocking().single()).body());
    }

    public ServiceFuture<AutoscaleSettingResourceInner> getByResourceGroupAsync(String resourceGroupName, String autoscaleSettingName, ServiceCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, autoscaleSettingName), serviceCallback);
    }

    public Observable<AutoscaleSettingResourceInner> getByResourceGroupAsync(String resourceGroupName, String autoscaleSettingName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, autoscaleSettingName).map((Func1)new Func1<ServiceResponse<AutoscaleSettingResourceInner>, AutoscaleSettingResourceInner>(){

            public AutoscaleSettingResourceInner call(ServiceResponse<AutoscaleSettingResourceInner> response) {
                return (AutoscaleSettingResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AutoscaleSettingResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String autoscaleSettingName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (autoscaleSettingName == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.getByResourceGroup(resourceGroupName, autoscaleSettingName, this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AutoscaleSettingResourceInner>>>(){

            public Observable<ServiceResponse<AutoscaleSettingResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AutoscaleSettingsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AutoscaleSettingResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AutoscaleSettingResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AutoscaleSettingResourceInner update(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourcePatchInner autoscaleSettingResource) {
        return (AutoscaleSettingResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, autoscaleSettingResource).toBlocking().single()).body());
    }

    public ServiceFuture<AutoscaleSettingResourceInner> updateAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourcePatchInner autoscaleSettingResource, ServiceCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, autoscaleSettingResource), serviceCallback);
    }

    public Observable<AutoscaleSettingResourceInner> updateAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourcePatchInner autoscaleSettingResource) {
        return this.updateWithServiceResponseAsync(resourceGroupName, autoscaleSettingName, autoscaleSettingResource).map((Func1)new Func1<ServiceResponse<AutoscaleSettingResourceInner>, AutoscaleSettingResourceInner>(){

            public AutoscaleSettingResourceInner call(ServiceResponse<AutoscaleSettingResourceInner> response) {
                return (AutoscaleSettingResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AutoscaleSettingResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String autoscaleSettingName, AutoscaleSettingResourcePatchInner autoscaleSettingResource) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (autoscaleSettingName == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingName is required and cannot be null.");
        }
        if (autoscaleSettingResource == null) {
            throw new IllegalArgumentException("Parameter autoscaleSettingResource is required and cannot be null.");
        }
        Validator.validate((Object)autoscaleSettingResource);
        String apiVersion = "2015-04-01";
        return this.service.update(this.client.subscriptionId(), resourceGroupName, autoscaleSettingName, "2015-04-01", autoscaleSettingResource, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AutoscaleSettingResourceInner>>>(){

            public Observable<ServiceResponse<AutoscaleSettingResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AutoscaleSettingsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AutoscaleSettingResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AutoscaleSettingResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<AutoscaleSettingResourceInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AutoscaleSettingResourceInner>((Page)response.body()){

            public Page<AutoscaleSettingResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AutoscaleSettingsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AutoscaleSettingResourceInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<AutoscaleSettingResourceInner>> serviceFuture, ListOperationCallback<AutoscaleSettingResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(String nextPageLink) {
                return AutoscaleSettingsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AutoscaleSettingResourceInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Page<AutoscaleSettingResourceInner>>(){

            public Page<AutoscaleSettingResourceInner> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AutoscaleSettingResourceInner>>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(ServiceResponse<Page<AutoscaleSettingResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AutoscaleSettingsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AutoscaleSettingResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AutoscaleSettingsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AutoscaleSettingResourceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AutoscaleSettingResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface AutoscaleSettingsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="autoscaleSettingName") String var2, @Path(value="subscriptionId") String var3, @Body AutoscaleSettingResourceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="autoscaleSettingName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="autoscaleSettingName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/autoscalesettings/{autoscaleSettingName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="autoscaleSettingName") String var3, @Query(value="api-version") String var4, @Body AutoscaleSettingResourcePatchInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.AutoscaleSettings listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

