/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.monitor.implementation.ActionGroupsInner;
import com.microsoft.azure.management.monitor.implementation.ActivityLogAlertsInner;
import com.microsoft.azure.management.monitor.implementation.AlertRuleIncidentsInner;
import com.microsoft.azure.management.monitor.implementation.AlertRulesInner;
import com.microsoft.azure.management.monitor.implementation.AutoscaleSettingsInner;
import com.microsoft.azure.management.monitor.implementation.LogProfilesInner;
import com.microsoft.azure.management.monitor.implementation.ServiceDiagnosticSettingsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class MonitorManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private AutoscaleSettingsInner autoscaleSettings;
    private AlertRulesInner alertRules;
    private AlertRuleIncidentsInner alertRuleIncidents;
    private ActivityLogAlertsInner activityLogAlerts;
    private LogProfilesInner logProfiles;
    private ServiceDiagnosticSettingsInner serviceDiagnosticSettings;
    private ActionGroupsInner actionGroups;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public MonitorManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public MonitorManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public MonitorManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public MonitorManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public AutoscaleSettingsInner autoscaleSettings() {
        return this.autoscaleSettings;
    }

    public AlertRulesInner alertRules() {
        return this.alertRules;
    }

    public AlertRuleIncidentsInner alertRuleIncidents() {
        return this.alertRuleIncidents;
    }

    public ActivityLogAlertsInner activityLogAlerts() {
        return this.activityLogAlerts;
    }

    public LogProfilesInner logProfiles() {
        return this.logProfiles;
    }

    public ServiceDiagnosticSettingsInner serviceDiagnosticSettings() {
        return this.serviceDiagnosticSettings;
    }

    public ActionGroupsInner actionGroups() {
        return this.actionGroups;
    }

    public MonitorManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public MonitorManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public MonitorManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.autoscaleSettings = new AutoscaleSettingsInner(this.restClient().retrofit(), this);
        this.alertRules = new AlertRulesInner(this.restClient().retrofit(), this);
        this.alertRuleIncidents = new AlertRuleIncidentsInner(this.restClient().retrofit(), this);
        this.activityLogAlerts = new ActivityLogAlertsInner(this.restClient().retrofit(), this);
        this.logProfiles = new LogProfilesInner(this.restClient().retrofit(), this);
        this.serviceDiagnosticSettings = new ServiceDiagnosticSettingsInner(this.restClient().retrofit(), this);
        this.actionGroups = new ActionGroupsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "MonitorManagementClient");
    }
}

