/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.MonitorClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl;
import com.microsoft.azure.management.monitor.implementation.UsageMetricInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class UsageMetricsInner {
    private UsageMetricsService service;
    private MonitorClientImpl client;

    public UsageMetricsInner(Retrofit retrofit, MonitorClientImpl client) {
        this.service = (UsageMetricsService)retrofit.create(UsageMetricsService.class);
        this.client = client;
    }

    public List<UsageMetricInner> list(String resourceUri, String apiVersion) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri, apiVersion).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageMetricInner>> listAsync(String resourceUri, String apiVersion, ServiceCallback<List<UsageMetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri, apiVersion), serviceCallback);
    }

    public Observable<List<UsageMetricInner>> listAsync(String resourceUri, String apiVersion) {
        return this.listWithServiceResponseAsync(resourceUri, apiVersion).map((Func1)new Func1<ServiceResponse<List<UsageMetricInner>>, List<UsageMetricInner>>(){

            public List<UsageMetricInner> call(ServiceResponse<List<UsageMetricInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageMetricInner>>> listWithServiceResponseAsync(String resourceUri, String apiVersion) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        String filter = null;
        return this.service.list(resourceUri, apiVersion, filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageMetricInner>>>>(){

            public Observable<ServiceResponse<List<UsageMetricInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsageMetricsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<UsageMetricInner> list(String resourceUri, String apiVersion, String filter) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri, apiVersion, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageMetricInner>> listAsync(String resourceUri, String apiVersion, String filter, ServiceCallback<List<UsageMetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri, apiVersion, filter), serviceCallback);
    }

    public Observable<List<UsageMetricInner>> listAsync(String resourceUri, String apiVersion, String filter) {
        return this.listWithServiceResponseAsync(resourceUri, apiVersion, filter).map((Func1)new Func1<ServiceResponse<List<UsageMetricInner>>, List<UsageMetricInner>>(){

            public List<UsageMetricInner> call(ServiceResponse<List<UsageMetricInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageMetricInner>>> listWithServiceResponseAsync(String resourceUri, String apiVersion, String filter) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("Parameter apiVersion is required and cannot be null.");
        }
        return this.service.list(resourceUri, apiVersion, filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageMetricInner>>>>(){

            public Observable<ServiceResponse<List<UsageMetricInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsageMetricsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageMetricInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UsageMetricInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface UsageMetricsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.UsageMetrics list"})
        @GET(value="{resourceUri}/usages")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceUri", encoded=true) String var1, @Query(value="api-version") String var2, @Query(value="$filter") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

