/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.LoadBalancerOperations;
import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.BackendAddressPool;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.FrontendIpConfiguration;
import com.microsoft.azure.management.network.models.InboundNatRule;
import com.microsoft.azure.management.network.models.LoadBalancer;
import com.microsoft.azure.management.network.models.LoadBalancerGetResponse;
import com.microsoft.azure.management.network.models.LoadBalancerListResponse;
import com.microsoft.azure.management.network.models.LoadBalancerPutResponse;
import com.microsoft.azure.management.network.models.LoadBalancingRule;
import com.microsoft.azure.management.network.models.Probe;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class LoadBalancerOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
LoadBalancerOperations {
    private NetworkResourceProviderClientImpl client;

    LoadBalancerOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<LoadBalancerPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String loadBalancerName, final LoadBalancer parameters) {
        return this.getClient().getExecutorService().submit(new Callable<LoadBalancerPutResponse>(){

            @Override
            public LoadBalancerPutResponse call() throws Exception {
                return LoadBalancerOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, loadBalancerName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoadBalancerPutResponse beginCreateOrUpdating(String resourceGroupName, String loadBalancerName, LoadBalancer parameters) throws IOException, ServiceException {
        LoadBalancerPutResponse loadBalancerPutResponse;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode loadBalancerJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (loadBalancerName == null) {
            throw new NullPointerException("loadBalancerName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getInboundNatRules() != null) {
            for (InboundNatRule inboundNatRulesParameterItem : parameters.getInboundNatRules()) {
                if (inboundNatRulesParameterItem.getProtocol() != null) continue;
                throw new NullPointerException("parameters.InboundNatRules.Protocol");
            }
        }
        if (parameters.getLoadBalancingRules() != null) {
            for (LoadBalancingRule loadBalancingRulesParameterItem : parameters.getLoadBalancingRules()) {
                if (loadBalancingRulesParameterItem.getBackendAddressPool() == null) {
                    throw new NullPointerException("parameters.LoadBalancingRules.BackendAddressPool");
                }
                if (loadBalancingRulesParameterItem.getProtocol() != null) continue;
                throw new NullPointerException("parameters.LoadBalancingRules.Protocol");
            }
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getProbes() != null) {
            for (Probe probesParameterItem : parameters.getProbes()) {
                if (probesParameterItem.getProtocol() != null) continue;
                throw new NullPointerException("parameters.Probes.Protocol");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers/";
        url = url + URLEncoder.encode(loadBalancerName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = loadBalancerJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        loadBalancerJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getFrontendIpConfigurations() != null && (!(parameters.getFrontendIpConfigurations() instanceof LazyCollection) || ((LazyCollection)parameters.getFrontendIpConfigurations()).isInitialized())) {
            ArrayNode frontendIPConfigurationsArray = objectMapper.createArrayNode();
            for (FrontendIpConfiguration frontendIpConfiguration : parameters.getFrontendIpConfigurations()) {
                ObjectNode frontendIpConfigurationJsonFormatValue = objectMapper.createObjectNode();
                frontendIPConfigurationsArray.add((JsonNode)frontendIpConfigurationJsonFormatValue);
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                frontendIpConfigurationJsonFormatValue.put("properties", (JsonNode)propertiesValue2);
                if (frontendIpConfiguration.getPrivateIpAddress() != null) {
                    propertiesValue2.put("privateIPAddress", frontendIpConfiguration.getPrivateIpAddress());
                }
                if (frontendIpConfiguration.getPrivateIpAllocationMethod() != null) {
                    propertiesValue2.put("privateIPAllocationMethod", frontendIpConfiguration.getPrivateIpAllocationMethod());
                }
                if (frontendIpConfiguration.getSubnet() != null) {
                    ObjectNode subnetValue = objectMapper.createObjectNode();
                    propertiesValue2.put("subnet", (JsonNode)subnetValue);
                    if (frontendIpConfiguration.getSubnet().getId() != null) {
                        subnetValue.put("id", frontendIpConfiguration.getSubnet().getId());
                    }
                }
                if (frontendIpConfiguration.getPublicIpAddress() != null) {
                    ObjectNode publicIPAddressValue = objectMapper.createObjectNode();
                    propertiesValue2.put("publicIPAddress", (JsonNode)publicIPAddressValue);
                    if (frontendIpConfiguration.getPublicIpAddress().getId() != null) {
                        publicIPAddressValue.put("id", frontendIpConfiguration.getPublicIpAddress().getId());
                    }
                }
                if (frontendIpConfiguration.getInboundNatRules() != null && (!(frontendIpConfiguration.getInboundNatRules() instanceof LazyCollection) || ((LazyCollection)frontendIpConfiguration.getInboundNatRules()).isInitialized())) {
                    ArrayNode inboundNatRulesArray = objectMapper.createArrayNode();
                    for (ResourceId inboundNatRulesItem : frontendIpConfiguration.getInboundNatRules()) {
                        ObjectNode resourceIdValue = objectMapper.createObjectNode();
                        inboundNatRulesArray.add((JsonNode)resourceIdValue);
                        if (inboundNatRulesItem.getId() == null) continue;
                        resourceIdValue.put("id", inboundNatRulesItem.getId());
                    }
                    propertiesValue2.put("inboundNatRules", (JsonNode)inboundNatRulesArray);
                }
                if (frontendIpConfiguration.getLoadBalancingRules() != null && (!(frontendIpConfiguration.getLoadBalancingRules() instanceof LazyCollection) || ((LazyCollection)frontendIpConfiguration.getLoadBalancingRules()).isInitialized())) {
                    ArrayNode loadBalancingRulesArray = objectMapper.createArrayNode();
                    for (ResourceId loadBalancingRulesItem : frontendIpConfiguration.getLoadBalancingRules()) {
                        ObjectNode resourceIdValue2 = objectMapper.createObjectNode();
                        loadBalancingRulesArray.add((JsonNode)resourceIdValue2);
                        if (loadBalancingRulesItem.getId() == null) continue;
                        resourceIdValue2.put("id", loadBalancingRulesItem.getId());
                    }
                    propertiesValue2.put("loadBalancingRules", (JsonNode)loadBalancingRulesArray);
                }
                if (frontendIpConfiguration.getProvisioningState() != null) {
                    propertiesValue2.put("provisioningState", frontendIpConfiguration.getProvisioningState());
                }
                if (frontendIpConfiguration.getName() != null) {
                    frontendIpConfigurationJsonFormatValue.put("name", frontendIpConfiguration.getName());
                }
                if (frontendIpConfiguration.getEtag() != null) {
                    frontendIpConfigurationJsonFormatValue.put("etag", frontendIpConfiguration.getEtag());
                }
                if (frontendIpConfiguration.getId() == null) continue;
                frontendIpConfigurationJsonFormatValue.put("id", frontendIpConfiguration.getId());
            }
            propertiesValue.put("frontendIPConfigurations", (JsonNode)frontendIPConfigurationsArray);
        }
        if (parameters.getBackendAddressPools() != null && (!(parameters.getBackendAddressPools() instanceof LazyCollection) || ((LazyCollection)parameters.getBackendAddressPools()).isInitialized())) {
            ArrayNode backendAddressPoolsArray = objectMapper.createArrayNode();
            for (BackendAddressPool backendAddressPool : parameters.getBackendAddressPools()) {
                ObjectNode backendAddressPoolJsonFormatValue = objectMapper.createObjectNode();
                backendAddressPoolsArray.add((JsonNode)backendAddressPoolJsonFormatValue);
                ObjectNode propertiesValue3 = objectMapper.createObjectNode();
                backendAddressPoolJsonFormatValue.put("properties", (JsonNode)propertiesValue3);
                if (backendAddressPool.getBackendIpConfigurations() != null && (!(backendAddressPool.getBackendIpConfigurations() instanceof LazyCollection) || ((LazyCollection)backendAddressPool.getBackendIpConfigurations()).isInitialized())) {
                    ArrayNode backendIPConfigurationsArray = objectMapper.createArrayNode();
                    for (ResourceId backendIPConfigurationsItem : backendAddressPool.getBackendIpConfigurations()) {
                        ObjectNode resourceIdValue3 = objectMapper.createObjectNode();
                        backendIPConfigurationsArray.add((JsonNode)resourceIdValue3);
                        if (backendIPConfigurationsItem.getId() == null) continue;
                        resourceIdValue3.put("id", backendIPConfigurationsItem.getId());
                    }
                    propertiesValue3.put("backendIPConfigurations", (JsonNode)backendIPConfigurationsArray);
                }
                if (backendAddressPool.getLoadBalancingRules() != null && (!(backendAddressPool.getLoadBalancingRules() instanceof LazyCollection) || ((LazyCollection)backendAddressPool.getLoadBalancingRules()).isInitialized())) {
                    ArrayNode loadBalancingRulesArray2 = objectMapper.createArrayNode();
                    for (ResourceId loadBalancingRulesItem2 : backendAddressPool.getLoadBalancingRules()) {
                        ObjectNode resourceIdValue4 = objectMapper.createObjectNode();
                        loadBalancingRulesArray2.add((JsonNode)resourceIdValue4);
                        if (loadBalancingRulesItem2.getId() == null) continue;
                        resourceIdValue4.put("id", loadBalancingRulesItem2.getId());
                    }
                    propertiesValue3.put("loadBalancingRules", (JsonNode)loadBalancingRulesArray2);
                }
                if (backendAddressPool.getProvisioningState() != null) {
                    propertiesValue3.put("provisioningState", backendAddressPool.getProvisioningState());
                }
                if (backendAddressPool.getName() != null) {
                    backendAddressPoolJsonFormatValue.put("name", backendAddressPool.getName());
                }
                if (backendAddressPool.getEtag() != null) {
                    backendAddressPoolJsonFormatValue.put("etag", backendAddressPool.getEtag());
                }
                if (backendAddressPool.getId() == null) continue;
                backendAddressPoolJsonFormatValue.put("id", backendAddressPool.getId());
            }
            propertiesValue.put("backendAddressPools", (JsonNode)backendAddressPoolsArray);
        }
        if (parameters.getLoadBalancingRules() != null && (!(parameters.getLoadBalancingRules() instanceof LazyCollection) || ((LazyCollection)parameters.getLoadBalancingRules()).isInitialized())) {
            ArrayNode loadBalancingRulesArray3 = objectMapper.createArrayNode();
            for (LoadBalancingRule loadBalancingRule : parameters.getLoadBalancingRules()) {
                ObjectNode loadBalancingRuleJsonFormatValue = objectMapper.createObjectNode();
                loadBalancingRulesArray3.add((JsonNode)loadBalancingRuleJsonFormatValue);
                ObjectNode propertiesValue4 = objectMapper.createObjectNode();
                loadBalancingRuleJsonFormatValue.put("properties", (JsonNode)propertiesValue4);
                if (loadBalancingRule.getFrontendIPConfiguration() != null) {
                    ObjectNode frontendIPConfigurationValue = objectMapper.createObjectNode();
                    propertiesValue4.put("frontendIPConfiguration", (JsonNode)frontendIPConfigurationValue);
                    if (loadBalancingRule.getFrontendIPConfiguration().getId() != null) {
                        frontendIPConfigurationValue.put("id", loadBalancingRule.getFrontendIPConfiguration().getId());
                    }
                }
                ObjectNode backendAddressPoolValue = objectMapper.createObjectNode();
                propertiesValue4.put("backendAddressPool", (JsonNode)backendAddressPoolValue);
                if (loadBalancingRule.getBackendAddressPool().getId() != null) {
                    backendAddressPoolValue.put("id", loadBalancingRule.getBackendAddressPool().getId());
                }
                if (loadBalancingRule.getProbe() != null) {
                    ObjectNode probeValue = objectMapper.createObjectNode();
                    propertiesValue4.put("probe", (JsonNode)probeValue);
                    if (loadBalancingRule.getProbe().getId() != null) {
                        probeValue.put("id", loadBalancingRule.getProbe().getId());
                    }
                }
                propertiesValue4.put("protocol", loadBalancingRule.getProtocol());
                if (loadBalancingRule.getLoadDistribution() != null) {
                    propertiesValue4.put("loadDistribution", loadBalancingRule.getLoadDistribution());
                }
                propertiesValue4.put("frontendPort", loadBalancingRule.getFrontendPort());
                propertiesValue4.put("backendPort", loadBalancingRule.getBackendPort());
                if (loadBalancingRule.getIdleTimeoutInMinutes() != null) {
                    propertiesValue4.put("idleTimeoutInMinutes", loadBalancingRule.getIdleTimeoutInMinutes());
                }
                propertiesValue4.put("enableFloatingIP", loadBalancingRule.isEnableFloatingIP());
                if (loadBalancingRule.getProvisioningState() != null) {
                    propertiesValue4.put("provisioningState", loadBalancingRule.getProvisioningState());
                }
                if (loadBalancingRule.getName() != null) {
                    loadBalancingRuleJsonFormatValue.put("name", loadBalancingRule.getName());
                }
                if (loadBalancingRule.getEtag() != null) {
                    loadBalancingRuleJsonFormatValue.put("etag", loadBalancingRule.getEtag());
                }
                if (loadBalancingRule.getId() == null) continue;
                loadBalancingRuleJsonFormatValue.put("id", loadBalancingRule.getId());
            }
            propertiesValue.put("loadBalancingRules", (JsonNode)loadBalancingRulesArray3);
        }
        if (parameters.getProbes() != null && (!(parameters.getProbes() instanceof LazyCollection) || ((LazyCollection)parameters.getProbes()).isInitialized())) {
            ArrayNode probesArray = objectMapper.createArrayNode();
            for (Probe probe : parameters.getProbes()) {
                ObjectNode probeJsonFormatValue = objectMapper.createObjectNode();
                probesArray.add((JsonNode)probeJsonFormatValue);
                ObjectNode propertiesValue5 = objectMapper.createObjectNode();
                probeJsonFormatValue.put("properties", (JsonNode)propertiesValue5);
                if (probe.getLoadBalancingRules() != null && (!(probe.getLoadBalancingRules() instanceof LazyCollection) || ((LazyCollection)probe.getLoadBalancingRules()).isInitialized())) {
                    ArrayNode loadBalancingRulesArray4 = objectMapper.createArrayNode();
                    for (ResourceId loadBalancingRulesItem4 : probe.getLoadBalancingRules()) {
                        ObjectNode resourceIdValue5 = objectMapper.createObjectNode();
                        loadBalancingRulesArray4.add((JsonNode)resourceIdValue5);
                        if (loadBalancingRulesItem4.getId() == null) continue;
                        resourceIdValue5.put("id", loadBalancingRulesItem4.getId());
                    }
                    propertiesValue5.put("loadBalancingRules", (JsonNode)loadBalancingRulesArray4);
                }
                propertiesValue5.put("protocol", probe.getProtocol());
                propertiesValue5.put("port", probe.getPort());
                propertiesValue5.put("intervalInSeconds", probe.getIntervalInSeconds());
                propertiesValue5.put("numberOfProbes", probe.getNumberOfProbes());
                if (probe.getRequestPath() != null) {
                    propertiesValue5.put("requestPath", probe.getRequestPath());
                }
                if (probe.getProvisioningState() != null) {
                    propertiesValue5.put("provisioningState", probe.getProvisioningState());
                }
                if (probe.getName() != null) {
                    probeJsonFormatValue.put("name", probe.getName());
                }
                if (probe.getEtag() != null) {
                    probeJsonFormatValue.put("etag", probe.getEtag());
                }
                if (probe.getId() == null) continue;
                probeJsonFormatValue.put("id", probe.getId());
            }
            propertiesValue.put("probes", (JsonNode)probesArray);
        }
        if (parameters.getInboundNatRules() != null && (!(parameters.getInboundNatRules() instanceof LazyCollection) || ((LazyCollection)parameters.getInboundNatRules()).isInitialized())) {
            ArrayNode inboundNatRulesArray2 = objectMapper.createArrayNode();
            for (InboundNatRule inboundNatRule : parameters.getInboundNatRules()) {
                ObjectNode inboundNatRuleJsonFormatValue = objectMapper.createObjectNode();
                inboundNatRulesArray2.add((JsonNode)inboundNatRuleJsonFormatValue);
                ObjectNode propertiesValue6 = objectMapper.createObjectNode();
                inboundNatRuleJsonFormatValue.put("properties", (JsonNode)propertiesValue6);
                if (inboundNatRule.getFrontendIPConfiguration() != null) {
                    ObjectNode frontendIPConfigurationValue2 = objectMapper.createObjectNode();
                    propertiesValue6.put("frontendIPConfiguration", (JsonNode)frontendIPConfigurationValue2);
                    if (inboundNatRule.getFrontendIPConfiguration().getId() != null) {
                        frontendIPConfigurationValue2.put("id", inboundNatRule.getFrontendIPConfiguration().getId());
                    }
                }
                if (inboundNatRule.getBackendIPConfiguration() != null) {
                    ObjectNode backendIPConfigurationValue = objectMapper.createObjectNode();
                    propertiesValue6.put("backendIPConfiguration", (JsonNode)backendIPConfigurationValue);
                    if (inboundNatRule.getBackendIPConfiguration().getId() != null) {
                        backendIPConfigurationValue.put("id", inboundNatRule.getBackendIPConfiguration().getId());
                    }
                }
                propertiesValue6.put("protocol", inboundNatRule.getProtocol());
                propertiesValue6.put("frontendPort", inboundNatRule.getFrontendPort());
                propertiesValue6.put("backendPort", inboundNatRule.getBackendPort());
                if (inboundNatRule.getIdleTimeoutInMinutes() != null) {
                    propertiesValue6.put("idleTimeoutInMinutes", inboundNatRule.getIdleTimeoutInMinutes());
                }
                propertiesValue6.put("enableFloatingIP", inboundNatRule.isEnableFloatingIP());
                if (inboundNatRule.getProvisioningState() != null) {
                    propertiesValue6.put("provisioningState", inboundNatRule.getProvisioningState());
                }
                if (inboundNatRule.getName() != null) {
                    inboundNatRuleJsonFormatValue.put("name", inboundNatRule.getName());
                }
                if (inboundNatRule.getEtag() != null) {
                    inboundNatRuleJsonFormatValue.put("etag", inboundNatRule.getEtag());
                }
                if (inboundNatRule.getId() == null) continue;
                inboundNatRuleJsonFormatValue.put("id", inboundNatRule.getId());
            }
            propertiesValue.put("inboundNatRules", (JsonNode)inboundNatRulesArray2);
        }
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            loadBalancerJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            loadBalancerJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            loadBalancerJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            loadBalancerJsonFormatValue.put("type", parameters.getType());
        }
        loadBalancerJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            loadBalancerJsonFormatValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var17_29 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            LoadBalancerPutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                result = new LoadBalancerPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue6;
                    JsonNode idValue18;
                    JsonNode etagValue6;
                    LoadBalancer loadBalancerInstance = new LoadBalancer();
                    result.setLoadBalancer(loadBalancerInstance);
                    JsonNode propertiesValue7 = responseDoc.get("properties");
                    if (propertiesValue7 != null && !(propertiesValue7 instanceof NullNode)) {
                        JsonNode provisioningStateValue6;
                        JsonNode inboundNatRulesArray4;
                        JsonNode probesArray2;
                        JsonNode loadBalancingRulesArray7;
                        JsonNode backendAddressPoolsArray2;
                        JsonNode frontendIPConfigurationsArray2 = propertiesValue7.get("frontendIPConfigurations");
                        if (frontendIPConfigurationsArray2 != null && !(frontendIPConfigurationsArray2 instanceof NullNode)) {
                            for (Iterator frontendIPConfigurationsValue : (ArrayNode)frontendIPConfigurationsArray2) {
                                Object idValue5;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                FrontendIpConfiguration frontendIpConfigurationJsonFormatInstance = new FrontendIpConfiguration();
                                loadBalancerInstance.getFrontendIpConfigurations().add(frontendIpConfigurationJsonFormatInstance);
                                JsonNode propertiesValue8 = frontendIPConfigurationsValue.get("properties");
                                if (propertiesValue8 != null && !(propertiesValue8 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode loadBalancingRulesArray5;
                                    JsonNode inboundNatRulesArray3;
                                    JsonNode publicIPAddressValue2;
                                    JsonNode subnetValue2;
                                    JsonNode privateIPAllocationMethodValue;
                                    JsonNode privateIPAddressValue = propertiesValue8.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = propertiesValue8.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue2 = propertiesValue8.get("subnet")) != null && !(subnetValue2 instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        frontendIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        JsonNode idValue = subnetValue2.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    if ((publicIPAddressValue2 = propertiesValue8.get("publicIPAddress")) != null && !(publicIPAddressValue2 instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        frontendIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        Iterator idValue2 = publicIPAddressValue2.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    if ((inboundNatRulesArray3 = propertiesValue8.get("inboundNatRules")) != null && !(inboundNatRulesArray3 instanceof NullNode)) {
                                        for (Iterator inboundNatRulesValue : (ArrayNode)inboundNatRulesArray3) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            frontendIpConfigurationJsonFormatInstance.getInboundNatRules().add(resourceIdInstance);
                                            JsonNode idValue3 = inboundNatRulesValue.get("id");
                                            if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                            String idInstance3 = idValue3.getTextValue();
                                            resourceIdInstance.setId(idInstance3);
                                        }
                                    }
                                    if ((loadBalancingRulesArray5 = propertiesValue8.get("loadBalancingRules")) != null && !(loadBalancingRulesArray5 instanceof NullNode)) {
                                        Iterator inboundNatRulesValue;
                                        inboundNatRulesValue = ((ArrayNode)loadBalancingRulesArray5).iterator();
                                        while (inboundNatRulesValue.hasNext()) {
                                            JsonNode loadBalancingRulesValue = (JsonNode)inboundNatRulesValue.next();
                                            ResourceId resourceIdInstance2 = new ResourceId();
                                            frontendIpConfigurationJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance2);
                                            JsonNode idValue4 = loadBalancingRulesValue.get("id");
                                            if (idValue4 == null || idValue4 instanceof NullNode) continue;
                                            String idInstance4 = idValue4.getTextValue();
                                            resourceIdInstance2.setId(idInstance4);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue8.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = frontendIPConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = frontendIPConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue5 = frontendIPConfigurationsValue.get("id")) == null || idValue5 instanceof NullNode) continue;
                                String idInstance5 = idValue5.getTextValue();
                                frontendIpConfigurationJsonFormatInstance.setId(idInstance5);
                            }
                        }
                        if ((backendAddressPoolsArray2 = propertiesValue7.get("backendAddressPools")) != null && !(backendAddressPoolsArray2 instanceof NullNode)) {
                            for (Iterator backendAddressPoolsValue : (ArrayNode)backendAddressPoolsArray2) {
                                JsonNode idValue8;
                                JsonNode etagValue2;
                                JsonNode nameValue2;
                                BackendAddressPool backendAddressPoolJsonFormatInstance = new BackendAddressPool();
                                loadBalancerInstance.getBackendAddressPools().add(backendAddressPoolJsonFormatInstance);
                                JsonNode propertiesValue9 = backendAddressPoolsValue.get("properties");
                                if (propertiesValue9 != null && !(propertiesValue9 instanceof NullNode)) {
                                    JsonNode provisioningStateValue2;
                                    JsonNode loadBalancingRulesArray6;
                                    JsonNode backendIPConfigurationsArray2 = propertiesValue9.get("backendIPConfigurations");
                                    if (backendIPConfigurationsArray2 != null && !(backendIPConfigurationsArray2 instanceof NullNode)) {
                                        for (Iterator backendIPConfigurationsValue : (ArrayNode)backendIPConfigurationsArray2) {
                                            ResourceId resourceIdInstance3 = new ResourceId();
                                            backendAddressPoolJsonFormatInstance.getBackendIpConfigurations().add(resourceIdInstance3);
                                            JsonNode idValue6 = backendIPConfigurationsValue.get("id");
                                            if (idValue6 == null || idValue6 instanceof NullNode) continue;
                                            String idInstance6 = idValue6.getTextValue();
                                            resourceIdInstance3.setId(idInstance6);
                                        }
                                    }
                                    if ((loadBalancingRulesArray6 = propertiesValue9.get("loadBalancingRules")) != null && !(loadBalancingRulesArray6 instanceof NullNode)) {
                                        Iterator backendIPConfigurationsValue;
                                        backendIPConfigurationsValue = ((ArrayNode)loadBalancingRulesArray6).iterator();
                                        while (backendIPConfigurationsValue.hasNext()) {
                                            JsonNode loadBalancingRulesValue2 = (JsonNode)backendIPConfigurationsValue.next();
                                            ResourceId resourceIdInstance4 = new ResourceId();
                                            backendAddressPoolJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance4);
                                            JsonNode idValue7 = loadBalancingRulesValue2.get("id");
                                            if (idValue7 == null || idValue7 instanceof NullNode) continue;
                                            String idInstance7 = idValue7.getTextValue();
                                            resourceIdInstance4.setId(idInstance7);
                                        }
                                    }
                                    if ((provisioningStateValue2 = propertiesValue9.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                        String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        backendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                if ((nameValue2 = backendAddressPoolsValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setName(nameInstance2);
                                }
                                if ((etagValue2 = backendAddressPoolsValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                    String etagInstance2 = etagValue2.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setEtag(etagInstance2);
                                }
                                if ((idValue8 = backendAddressPoolsValue.get("id")) == null || idValue8 instanceof NullNode) continue;
                                String idInstance8 = idValue8.getTextValue();
                                backendAddressPoolJsonFormatInstance.setId(idInstance8);
                            }
                        }
                        if ((loadBalancingRulesArray7 = propertiesValue7.get("loadBalancingRules")) != null && !(loadBalancingRulesArray7 instanceof NullNode)) {
                            for (Iterator loadBalancingRulesValue3 : (ArrayNode)loadBalancingRulesArray7) {
                                Object idValue12;
                                JsonNode etagValue3;
                                JsonNode nameValue3;
                                LoadBalancingRule loadBalancingRuleJsonFormatInstance = new LoadBalancingRule();
                                loadBalancerInstance.getLoadBalancingRules().add(loadBalancingRuleJsonFormatInstance);
                                JsonNode propertiesValue10 = loadBalancingRulesValue3.get("properties");
                                if (propertiesValue10 != null && !(propertiesValue10 instanceof NullNode)) {
                                    JsonNode provisioningStateValue3;
                                    JsonNode enableFloatingIPValue;
                                    JsonNode idleTimeoutInMinutesValue;
                                    JsonNode backendPortValue;
                                    JsonNode frontendPortValue;
                                    JsonNode loadDistributionValue;
                                    JsonNode protocolValue;
                                    JsonNode probeValue2;
                                    JsonNode backendAddressPoolValue2;
                                    JsonNode frontendIPConfigurationValue3 = propertiesValue10.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue3 != null && !(frontendIPConfigurationValue3 instanceof NullNode)) {
                                        ResourceId frontendIPConfigurationInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                        JsonNode idValue9 = frontendIPConfigurationValue3.get("id");
                                        if (idValue9 != null && !(idValue9 instanceof NullNode)) {
                                            String idInstance9 = idValue9.getTextValue();
                                            frontendIPConfigurationInstance.setId(idInstance9);
                                        }
                                    }
                                    if ((backendAddressPoolValue2 = propertiesValue10.get("backendAddressPool")) != null && !(backendAddressPoolValue2 instanceof NullNode)) {
                                        ResourceId backendAddressPoolInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                        JsonNode idValue10 = backendAddressPoolValue2.get("id");
                                        if (idValue10 != null && !(idValue10 instanceof NullNode)) {
                                            String idInstance10 = idValue10.getTextValue();
                                            backendAddressPoolInstance.setId(idInstance10);
                                        }
                                    }
                                    if ((probeValue2 = propertiesValue10.get("probe")) != null && !(probeValue2 instanceof NullNode)) {
                                        ResourceId probeInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setProbe(probeInstance);
                                        JsonNode idValue11 = probeValue2.get("id");
                                        if (idValue11 != null && !(idValue11 instanceof NullNode)) {
                                            String idInstance11 = idValue11.getTextValue();
                                            probeInstance.setId(idInstance11);
                                        }
                                    }
                                    if ((protocolValue = propertiesValue10.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                        String protocolInstance = protocolValue.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    if ((loadDistributionValue = propertiesValue10.get("loadDistribution")) != null && !(loadDistributionValue instanceof NullNode)) {
                                        String loadDistributionInstance = loadDistributionValue.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setLoadDistribution(loadDistributionInstance);
                                    }
                                    if ((frontendPortValue = propertiesValue10.get("frontendPort")) != null && !(frontendPortValue instanceof NullNode)) {
                                        int frontendPortInstance = frontendPortValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                    }
                                    if ((backendPortValue = propertiesValue10.get("backendPort")) != null && !(backendPortValue instanceof NullNode)) {
                                        int backendPortInstance = backendPortValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setBackendPort(backendPortInstance);
                                    }
                                    if ((idleTimeoutInMinutesValue = propertiesValue10.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue instanceof NullNode)) {
                                        int idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                    }
                                    if ((enableFloatingIPValue = propertiesValue10.get("enableFloatingIP")) != null && !(enableFloatingIPValue instanceof NullNode)) {
                                        boolean enableFloatingIPInstance = enableFloatingIPValue.getBooleanValue();
                                        loadBalancingRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance);
                                    }
                                    if ((provisioningStateValue3 = propertiesValue10.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                        String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                    }
                                }
                                if ((nameValue3 = loadBalancingRulesValue3.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                    String nameInstance3 = nameValue3.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setName(nameInstance3);
                                }
                                if ((etagValue3 = loadBalancingRulesValue3.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                    String etagInstance3 = etagValue3.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setEtag(etagInstance3);
                                }
                                if ((idValue12 = loadBalancingRulesValue3.get("id")) == null || idValue12 instanceof NullNode) continue;
                                String idInstance12 = idValue12.getTextValue();
                                loadBalancingRuleJsonFormatInstance.setId(idInstance12);
                            }
                        }
                        if ((probesArray2 = propertiesValue7.get("probes")) != null && !(probesArray2 instanceof NullNode)) {
                            for (Iterator probesValue : (ArrayNode)probesArray2) {
                                JsonNode idValue14;
                                JsonNode etagValue4;
                                JsonNode nameValue4;
                                Probe probeJsonFormatInstance = new Probe();
                                loadBalancerInstance.getProbes().add(probeJsonFormatInstance);
                                JsonNode propertiesValue11 = probesValue.get("properties");
                                if (propertiesValue11 != null && !(propertiesValue11 instanceof NullNode)) {
                                    JsonNode provisioningStateValue4;
                                    JsonNode requestPathValue;
                                    JsonNode numberOfProbesValue;
                                    JsonNode intervalInSecondsValue;
                                    JsonNode portValue;
                                    JsonNode protocolValue2;
                                    JsonNode loadBalancingRulesArray8 = propertiesValue11.get("loadBalancingRules");
                                    if (loadBalancingRulesArray8 != null && !(loadBalancingRulesArray8 instanceof NullNode)) {
                                        for (JsonNode loadBalancingRulesValue4 : (ArrayNode)loadBalancingRulesArray8) {
                                            ResourceId resourceIdInstance5 = new ResourceId();
                                            probeJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance5);
                                            JsonNode idValue13 = loadBalancingRulesValue4.get("id");
                                            if (idValue13 == null || idValue13 instanceof NullNode) continue;
                                            String idInstance13 = idValue13.getTextValue();
                                            resourceIdInstance5.setId(idInstance13);
                                        }
                                    }
                                    if ((protocolValue2 = propertiesValue11.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                        String protocolInstance2 = protocolValue2.getTextValue();
                                        probeJsonFormatInstance.setProtocol(protocolInstance2);
                                    }
                                    if ((portValue = propertiesValue11.get("port")) != null && !(portValue instanceof NullNode)) {
                                        int portInstance = portValue.getIntValue();
                                        probeJsonFormatInstance.setPort(portInstance);
                                    }
                                    if ((intervalInSecondsValue = propertiesValue11.get("intervalInSeconds")) != null && !(intervalInSecondsValue instanceof NullNode)) {
                                        int intervalInSecondsInstance = intervalInSecondsValue.getIntValue();
                                        probeJsonFormatInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                    }
                                    if ((numberOfProbesValue = propertiesValue11.get("numberOfProbes")) != null && !(numberOfProbesValue instanceof NullNode)) {
                                        int numberOfProbesInstance = numberOfProbesValue.getIntValue();
                                        probeJsonFormatInstance.setNumberOfProbes(numberOfProbesInstance);
                                    }
                                    if ((requestPathValue = propertiesValue11.get("requestPath")) != null && !(requestPathValue instanceof NullNode)) {
                                        String requestPathInstance = requestPathValue.getTextValue();
                                        probeJsonFormatInstance.setRequestPath(requestPathInstance);
                                    }
                                    if ((provisioningStateValue4 = propertiesValue11.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                        String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        probeJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                    }
                                }
                                if ((nameValue4 = probesValue.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                    String nameInstance4 = nameValue4.getTextValue();
                                    probeJsonFormatInstance.setName(nameInstance4);
                                }
                                if ((etagValue4 = probesValue.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                    String etagInstance4 = etagValue4.getTextValue();
                                    probeJsonFormatInstance.setEtag(etagInstance4);
                                }
                                if ((idValue14 = probesValue.get("id")) == null || idValue14 instanceof NullNode) continue;
                                String idInstance14 = idValue14.getTextValue();
                                probeJsonFormatInstance.setId(idInstance14);
                            }
                        }
                        if ((inboundNatRulesArray4 = propertiesValue7.get("inboundNatRules")) != null && !(inboundNatRulesArray4 instanceof NullNode)) {
                            for (JsonNode inboundNatRulesValue2 : (ArrayNode)inboundNatRulesArray4) {
                                JsonNode idValue17;
                                JsonNode etagValue5;
                                JsonNode nameValue5;
                                InboundNatRule inboundNatRuleJsonFormatInstance = new InboundNatRule();
                                loadBalancerInstance.getInboundNatRules().add(inboundNatRuleJsonFormatInstance);
                                JsonNode propertiesValue12 = inboundNatRulesValue2.get("properties");
                                if (propertiesValue12 != null && !(propertiesValue12 instanceof NullNode)) {
                                    JsonNode provisioningStateValue5;
                                    JsonNode enableFloatingIPValue2;
                                    JsonNode idleTimeoutInMinutesValue2;
                                    JsonNode backendPortValue2;
                                    JsonNode frontendPortValue2;
                                    JsonNode protocolValue3;
                                    JsonNode backendIPConfigurationValue2;
                                    JsonNode frontendIPConfigurationValue4 = propertiesValue12.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue4 != null && !(frontendIPConfigurationValue4 instanceof NullNode)) {
                                        ResourceId frontendIPConfigurationInstance2 = new ResourceId();
                                        inboundNatRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance2);
                                        JsonNode idValue15 = frontendIPConfigurationValue4.get("id");
                                        if (idValue15 != null && !(idValue15 instanceof NullNode)) {
                                            String idInstance15 = idValue15.getTextValue();
                                            frontendIPConfigurationInstance2.setId(idInstance15);
                                        }
                                    }
                                    if ((backendIPConfigurationValue2 = propertiesValue12.get("backendIPConfiguration")) != null && !(backendIPConfigurationValue2 instanceof NullNode)) {
                                        ResourceId backendIPConfigurationInstance = new ResourceId();
                                        inboundNatRuleJsonFormatInstance.setBackendIPConfiguration(backendIPConfigurationInstance);
                                        JsonNode idValue16 = backendIPConfigurationValue2.get("id");
                                        if (idValue16 != null && !(idValue16 instanceof NullNode)) {
                                            String idInstance16 = idValue16.getTextValue();
                                            backendIPConfigurationInstance.setId(idInstance16);
                                        }
                                    }
                                    if ((protocolValue3 = propertiesValue12.get("protocol")) != null && !(protocolValue3 instanceof NullNode)) {
                                        String protocolInstance3 = protocolValue3.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setProtocol(protocolInstance3);
                                    }
                                    if ((frontendPortValue2 = propertiesValue12.get("frontendPort")) != null && !(frontendPortValue2 instanceof NullNode)) {
                                        int frontendPortInstance2 = frontendPortValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setFrontendPort(frontendPortInstance2);
                                    }
                                    if ((backendPortValue2 = propertiesValue12.get("backendPort")) != null && !(backendPortValue2 instanceof NullNode)) {
                                        int backendPortInstance2 = backendPortValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setBackendPort(backendPortInstance2);
                                    }
                                    if ((idleTimeoutInMinutesValue2 = propertiesValue12.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue2 instanceof NullNode)) {
                                        int idleTimeoutInMinutesInstance2 = idleTimeoutInMinutesValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                    }
                                    if ((enableFloatingIPValue2 = propertiesValue12.get("enableFloatingIP")) != null && !(enableFloatingIPValue2 instanceof NullNode)) {
                                        boolean enableFloatingIPInstance2 = enableFloatingIPValue2.getBooleanValue();
                                        inboundNatRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance2);
                                    }
                                    if ((provisioningStateValue5 = propertiesValue12.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                        String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                    }
                                }
                                if ((nameValue5 = inboundNatRulesValue2.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                    String nameInstance5 = nameValue5.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setName(nameInstance5);
                                }
                                if ((etagValue5 = inboundNatRulesValue2.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                    String etagInstance5 = etagValue5.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setEtag(etagInstance5);
                                }
                                if ((idValue17 = inboundNatRulesValue2.get("id")) == null || idValue17 instanceof NullNode) continue;
                                String idInstance17 = idValue17.getTextValue();
                                inboundNatRuleJsonFormatInstance.setId(idInstance17);
                            }
                        }
                        if ((provisioningStateValue6 = propertiesValue7.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                            String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                            loadBalancerInstance.setProvisioningState(provisioningStateInstance6);
                        }
                    }
                    if ((etagValue6 = responseDoc.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                        String etagInstance6 = etagValue6.getTextValue();
                        loadBalancerInstance.setEtag(etagInstance6);
                    }
                    if ((idValue18 = responseDoc.get("id")) != null && !(idValue18 instanceof NullNode)) {
                        String idInstance18 = idValue18.getTextValue();
                        loadBalancerInstance.setId(idInstance18);
                    }
                    if ((nameValue6 = responseDoc.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                        String nameInstance6 = nameValue6.getTextValue();
                        loadBalancerInstance.setName(nameInstance6);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        loadBalancerInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        loadBalancerInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            loadBalancerInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(closeableHttpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (closeableHttpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)closeableHttpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            loadBalancerPutResponse = result;
        }
        catch (Throwable throwable) {
            if (var17_29 != null && var17_29.getEntity() != null) {
                var17_29.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return loadBalancerPutResponse;
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String loadBalancerName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return LoadBalancerOperationsImpl.this.beginDeleting(resourceGroupName, loadBalancerName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String loadBalancerName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (loadBalancerName == null) {
            throw new NullPointerException("loadBalancerName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers/";
        url = url + URLEncoder.encode(loadBalancerName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String loadBalancerName, final LoadBalancer parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return LoadBalancerOperationsImpl.this.createOrUpdate(resourceGroupName, loadBalancerName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String loadBalancerName, LoadBalancer parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            LoadBalancerPutResponse response = client2.getLoadBalancersOperations().beginCreateOrUpdatingAsync(resourceGroupName, loadBalancerName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String loadBalancerName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return LoadBalancerOperationsImpl.this.delete(resourceGroupName, loadBalancerName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String loadBalancerName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getLoadBalancersOperations().beginDeletingAsync(resourceGroupName, loadBalancerName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<LoadBalancerGetResponse> getAsync(final String resourceGroupName, final String loadBalancerName) {
        return this.getClient().getExecutorService().submit(new Callable<LoadBalancerGetResponse>(){

            @Override
            public LoadBalancerGetResponse call() throws Exception {
                return LoadBalancerOperationsImpl.this.get(resourceGroupName, loadBalancerName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoadBalancerGetResponse get(String resourceGroupName, String loadBalancerName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (loadBalancerName == null) {
            throw new NullPointerException("loadBalancerName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("loadBalancerName", loadBalancerName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers/";
        url = url + URLEncoder.encode(loadBalancerName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            LoadBalancerGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new LoadBalancerGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue6;
                    JsonNode idValue18;
                    JsonNode etagValue6;
                    LoadBalancer loadBalancerInstance = new LoadBalancer();
                    result.setLoadBalancer(loadBalancerInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue6;
                        JsonNode inboundNatRulesArray2;
                        JsonNode probesArray;
                        JsonNode loadBalancingRulesArray3;
                        JsonNode backendAddressPoolsArray;
                        JsonNode frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations");
                        if (frontendIPConfigurationsArray != null && !(frontendIPConfigurationsArray instanceof NullNode)) {
                            for (Iterator frontendIPConfigurationsValue : (ArrayNode)frontendIPConfigurationsArray) {
                                Object idValue5;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                FrontendIpConfiguration frontendIpConfigurationJsonFormatInstance = new FrontendIpConfiguration();
                                loadBalancerInstance.getFrontendIpConfigurations().add(frontendIpConfigurationJsonFormatInstance);
                                JsonNode propertiesValue2 = frontendIPConfigurationsValue.get("properties");
                                if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode loadBalancingRulesArray;
                                    JsonNode inboundNatRulesArray;
                                    JsonNode publicIPAddressValue;
                                    JsonNode subnetValue;
                                    JsonNode privateIPAllocationMethodValue;
                                    JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                    if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                        String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                    }
                                    if ((privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                        String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                    }
                                    if ((subnetValue = propertiesValue2.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                        ResourceId subnetInstance = new ResourceId();
                                        frontendIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                        JsonNode idValue = subnetValue.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            subnetInstance.setId(idInstance);
                                        }
                                    }
                                    if ((publicIPAddressValue = propertiesValue2.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                        ResourceId publicIPAddressInstance = new ResourceId();
                                        frontendIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                        Iterator idValue2 = publicIPAddressValue.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            publicIPAddressInstance.setId(idInstance2);
                                        }
                                    }
                                    if ((inboundNatRulesArray = propertiesValue2.get("inboundNatRules")) != null && !(inboundNatRulesArray instanceof NullNode)) {
                                        for (Iterator inboundNatRulesValue : (ArrayNode)inboundNatRulesArray) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            frontendIpConfigurationJsonFormatInstance.getInboundNatRules().add(resourceIdInstance);
                                            JsonNode idValue3 = inboundNatRulesValue.get("id");
                                            if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                            String idInstance3 = idValue3.getTextValue();
                                            resourceIdInstance.setId(idInstance3);
                                        }
                                    }
                                    if ((loadBalancingRulesArray = propertiesValue2.get("loadBalancingRules")) != null && !(loadBalancingRulesArray instanceof NullNode)) {
                                        Iterator inboundNatRulesValue;
                                        inboundNatRulesValue = ((ArrayNode)loadBalancingRulesArray).iterator();
                                        while (inboundNatRulesValue.hasNext()) {
                                            JsonNode loadBalancingRulesValue = (JsonNode)inboundNatRulesValue.next();
                                            ResourceId resourceIdInstance2 = new ResourceId();
                                            frontendIpConfigurationJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance2);
                                            JsonNode idValue4 = loadBalancingRulesValue.get("id");
                                            if (idValue4 == null || idValue4 instanceof NullNode) continue;
                                            String idInstance4 = idValue4.getTextValue();
                                            resourceIdInstance2.setId(idInstance4);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = frontendIPConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = frontendIPConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    frontendIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue5 = frontendIPConfigurationsValue.get("id")) == null || idValue5 instanceof NullNode) continue;
                                String idInstance5 = idValue5.getTextValue();
                                frontendIpConfigurationJsonFormatInstance.setId(idInstance5);
                            }
                        }
                        if ((backendAddressPoolsArray = propertiesValue.get("backendAddressPools")) != null && !(backendAddressPoolsArray instanceof NullNode)) {
                            for (Iterator backendAddressPoolsValue : (ArrayNode)backendAddressPoolsArray) {
                                JsonNode idValue8;
                                JsonNode etagValue2;
                                JsonNode nameValue2;
                                BackendAddressPool backendAddressPoolJsonFormatInstance = new BackendAddressPool();
                                loadBalancerInstance.getBackendAddressPools().add(backendAddressPoolJsonFormatInstance);
                                JsonNode propertiesValue3 = backendAddressPoolsValue.get("properties");
                                if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                    JsonNode provisioningStateValue2;
                                    JsonNode loadBalancingRulesArray2;
                                    JsonNode backendIPConfigurationsArray = propertiesValue3.get("backendIPConfigurations");
                                    if (backendIPConfigurationsArray != null && !(backendIPConfigurationsArray instanceof NullNode)) {
                                        for (Iterator backendIPConfigurationsValue : (ArrayNode)backendIPConfigurationsArray) {
                                            ResourceId resourceIdInstance3 = new ResourceId();
                                            backendAddressPoolJsonFormatInstance.getBackendIpConfigurations().add(resourceIdInstance3);
                                            JsonNode idValue6 = backendIPConfigurationsValue.get("id");
                                            if (idValue6 == null || idValue6 instanceof NullNode) continue;
                                            String idInstance6 = idValue6.getTextValue();
                                            resourceIdInstance3.setId(idInstance6);
                                        }
                                    }
                                    if ((loadBalancingRulesArray2 = propertiesValue3.get("loadBalancingRules")) != null && !(loadBalancingRulesArray2 instanceof NullNode)) {
                                        Iterator backendIPConfigurationsValue;
                                        backendIPConfigurationsValue = ((ArrayNode)loadBalancingRulesArray2).iterator();
                                        while (backendIPConfigurationsValue.hasNext()) {
                                            JsonNode loadBalancingRulesValue2 = (JsonNode)backendIPConfigurationsValue.next();
                                            ResourceId resourceIdInstance4 = new ResourceId();
                                            backendAddressPoolJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance4);
                                            JsonNode idValue7 = loadBalancingRulesValue2.get("id");
                                            if (idValue7 == null || idValue7 instanceof NullNode) continue;
                                            String idInstance7 = idValue7.getTextValue();
                                            resourceIdInstance4.setId(idInstance7);
                                        }
                                    }
                                    if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                        String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                        backendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                    }
                                }
                                if ((nameValue2 = backendAddressPoolsValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setName(nameInstance2);
                                }
                                if ((etagValue2 = backendAddressPoolsValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                    String etagInstance2 = etagValue2.getTextValue();
                                    backendAddressPoolJsonFormatInstance.setEtag(etagInstance2);
                                }
                                if ((idValue8 = backendAddressPoolsValue.get("id")) == null || idValue8 instanceof NullNode) continue;
                                String idInstance8 = idValue8.getTextValue();
                                backendAddressPoolJsonFormatInstance.setId(idInstance8);
                            }
                        }
                        if ((loadBalancingRulesArray3 = propertiesValue.get("loadBalancingRules")) != null && !(loadBalancingRulesArray3 instanceof NullNode)) {
                            for (Iterator loadBalancingRulesValue3 : (ArrayNode)loadBalancingRulesArray3) {
                                Object idValue12;
                                JsonNode etagValue3;
                                JsonNode nameValue3;
                                LoadBalancingRule loadBalancingRuleJsonFormatInstance = new LoadBalancingRule();
                                loadBalancerInstance.getLoadBalancingRules().add(loadBalancingRuleJsonFormatInstance);
                                JsonNode propertiesValue4 = loadBalancingRulesValue3.get("properties");
                                if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                    JsonNode provisioningStateValue3;
                                    JsonNode enableFloatingIPValue;
                                    JsonNode idleTimeoutInMinutesValue;
                                    JsonNode backendPortValue;
                                    JsonNode frontendPortValue;
                                    JsonNode loadDistributionValue;
                                    JsonNode protocolValue;
                                    JsonNode probeValue;
                                    JsonNode backendAddressPoolValue;
                                    JsonNode frontendIPConfigurationValue = propertiesValue4.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue != null && !(frontendIPConfigurationValue instanceof NullNode)) {
                                        ResourceId frontendIPConfigurationInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                        JsonNode idValue9 = frontendIPConfigurationValue.get("id");
                                        if (idValue9 != null && !(idValue9 instanceof NullNode)) {
                                            String idInstance9 = idValue9.getTextValue();
                                            frontendIPConfigurationInstance.setId(idInstance9);
                                        }
                                    }
                                    if ((backendAddressPoolValue = propertiesValue4.get("backendAddressPool")) != null && !(backendAddressPoolValue instanceof NullNode)) {
                                        ResourceId backendAddressPoolInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                        JsonNode idValue10 = backendAddressPoolValue.get("id");
                                        if (idValue10 != null && !(idValue10 instanceof NullNode)) {
                                            String idInstance10 = idValue10.getTextValue();
                                            backendAddressPoolInstance.setId(idInstance10);
                                        }
                                    }
                                    if ((probeValue = propertiesValue4.get("probe")) != null && !(probeValue instanceof NullNode)) {
                                        ResourceId probeInstance = new ResourceId();
                                        loadBalancingRuleJsonFormatInstance.setProbe(probeInstance);
                                        JsonNode idValue11 = probeValue.get("id");
                                        if (idValue11 != null && !(idValue11 instanceof NullNode)) {
                                            String idInstance11 = idValue11.getTextValue();
                                            probeInstance.setId(idInstance11);
                                        }
                                    }
                                    if ((protocolValue = propertiesValue4.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                        String protocolInstance = protocolValue.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setProtocol(protocolInstance);
                                    }
                                    if ((loadDistributionValue = propertiesValue4.get("loadDistribution")) != null && !(loadDistributionValue instanceof NullNode)) {
                                        String loadDistributionInstance = loadDistributionValue.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setLoadDistribution(loadDistributionInstance);
                                    }
                                    if ((frontendPortValue = propertiesValue4.get("frontendPort")) != null && !(frontendPortValue instanceof NullNode)) {
                                        int frontendPortInstance = frontendPortValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                    }
                                    if ((backendPortValue = propertiesValue4.get("backendPort")) != null && !(backendPortValue instanceof NullNode)) {
                                        int backendPortInstance = backendPortValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setBackendPort(backendPortInstance);
                                    }
                                    if ((idleTimeoutInMinutesValue = propertiesValue4.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue instanceof NullNode)) {
                                        int idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                        loadBalancingRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                    }
                                    if ((enableFloatingIPValue = propertiesValue4.get("enableFloatingIP")) != null && !(enableFloatingIPValue instanceof NullNode)) {
                                        boolean enableFloatingIPInstance = enableFloatingIPValue.getBooleanValue();
                                        loadBalancingRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance);
                                    }
                                    if ((provisioningStateValue3 = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                        String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                    }
                                }
                                if ((nameValue3 = loadBalancingRulesValue3.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                    String nameInstance3 = nameValue3.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setName(nameInstance3);
                                }
                                if ((etagValue3 = loadBalancingRulesValue3.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                    String etagInstance3 = etagValue3.getTextValue();
                                    loadBalancingRuleJsonFormatInstance.setEtag(etagInstance3);
                                }
                                if ((idValue12 = loadBalancingRulesValue3.get("id")) == null || idValue12 instanceof NullNode) continue;
                                String idInstance12 = idValue12.getTextValue();
                                loadBalancingRuleJsonFormatInstance.setId(idInstance12);
                            }
                        }
                        if ((probesArray = propertiesValue.get("probes")) != null && !(probesArray instanceof NullNode)) {
                            for (Iterator probesValue : (ArrayNode)probesArray) {
                                JsonNode idValue14;
                                JsonNode etagValue4;
                                JsonNode nameValue4;
                                Probe probeJsonFormatInstance = new Probe();
                                loadBalancerInstance.getProbes().add(probeJsonFormatInstance);
                                JsonNode propertiesValue5 = probesValue.get("properties");
                                if (propertiesValue5 != null && !(propertiesValue5 instanceof NullNode)) {
                                    JsonNode provisioningStateValue4;
                                    JsonNode requestPathValue;
                                    JsonNode numberOfProbesValue;
                                    JsonNode intervalInSecondsValue;
                                    JsonNode portValue;
                                    JsonNode protocolValue2;
                                    JsonNode loadBalancingRulesArray4 = propertiesValue5.get("loadBalancingRules");
                                    if (loadBalancingRulesArray4 != null && !(loadBalancingRulesArray4 instanceof NullNode)) {
                                        for (JsonNode loadBalancingRulesValue4 : (ArrayNode)loadBalancingRulesArray4) {
                                            ResourceId resourceIdInstance5 = new ResourceId();
                                            probeJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance5);
                                            JsonNode idValue13 = loadBalancingRulesValue4.get("id");
                                            if (idValue13 == null || idValue13 instanceof NullNode) continue;
                                            String idInstance13 = idValue13.getTextValue();
                                            resourceIdInstance5.setId(idInstance13);
                                        }
                                    }
                                    if ((protocolValue2 = propertiesValue5.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                        String protocolInstance2 = protocolValue2.getTextValue();
                                        probeJsonFormatInstance.setProtocol(protocolInstance2);
                                    }
                                    if ((portValue = propertiesValue5.get("port")) != null && !(portValue instanceof NullNode)) {
                                        int portInstance = portValue.getIntValue();
                                        probeJsonFormatInstance.setPort(portInstance);
                                    }
                                    if ((intervalInSecondsValue = propertiesValue5.get("intervalInSeconds")) != null && !(intervalInSecondsValue instanceof NullNode)) {
                                        int intervalInSecondsInstance = intervalInSecondsValue.getIntValue();
                                        probeJsonFormatInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                    }
                                    if ((numberOfProbesValue = propertiesValue5.get("numberOfProbes")) != null && !(numberOfProbesValue instanceof NullNode)) {
                                        int numberOfProbesInstance = numberOfProbesValue.getIntValue();
                                        probeJsonFormatInstance.setNumberOfProbes(numberOfProbesInstance);
                                    }
                                    if ((requestPathValue = propertiesValue5.get("requestPath")) != null && !(requestPathValue instanceof NullNode)) {
                                        String requestPathInstance = requestPathValue.getTextValue();
                                        probeJsonFormatInstance.setRequestPath(requestPathInstance);
                                    }
                                    if ((provisioningStateValue4 = propertiesValue5.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                        String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                        probeJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                    }
                                }
                                if ((nameValue4 = probesValue.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                    String nameInstance4 = nameValue4.getTextValue();
                                    probeJsonFormatInstance.setName(nameInstance4);
                                }
                                if ((etagValue4 = probesValue.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                    String etagInstance4 = etagValue4.getTextValue();
                                    probeJsonFormatInstance.setEtag(etagInstance4);
                                }
                                if ((idValue14 = probesValue.get("id")) == null || idValue14 instanceof NullNode) continue;
                                String idInstance14 = idValue14.getTextValue();
                                probeJsonFormatInstance.setId(idInstance14);
                            }
                        }
                        if ((inboundNatRulesArray2 = propertiesValue.get("inboundNatRules")) != null && !(inboundNatRulesArray2 instanceof NullNode)) {
                            for (JsonNode inboundNatRulesValue2 : (ArrayNode)inboundNatRulesArray2) {
                                JsonNode idValue17;
                                JsonNode etagValue5;
                                JsonNode nameValue5;
                                InboundNatRule inboundNatRuleJsonFormatInstance = new InboundNatRule();
                                loadBalancerInstance.getInboundNatRules().add(inboundNatRuleJsonFormatInstance);
                                JsonNode propertiesValue6 = inboundNatRulesValue2.get("properties");
                                if (propertiesValue6 != null && !(propertiesValue6 instanceof NullNode)) {
                                    JsonNode provisioningStateValue5;
                                    JsonNode enableFloatingIPValue2;
                                    JsonNode idleTimeoutInMinutesValue2;
                                    JsonNode backendPortValue2;
                                    JsonNode frontendPortValue2;
                                    JsonNode protocolValue3;
                                    JsonNode backendIPConfigurationValue;
                                    JsonNode frontendIPConfigurationValue2 = propertiesValue6.get("frontendIPConfiguration");
                                    if (frontendIPConfigurationValue2 != null && !(frontendIPConfigurationValue2 instanceof NullNode)) {
                                        ResourceId frontendIPConfigurationInstance2 = new ResourceId();
                                        inboundNatRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance2);
                                        JsonNode idValue15 = frontendIPConfigurationValue2.get("id");
                                        if (idValue15 != null && !(idValue15 instanceof NullNode)) {
                                            String idInstance15 = idValue15.getTextValue();
                                            frontendIPConfigurationInstance2.setId(idInstance15);
                                        }
                                    }
                                    if ((backendIPConfigurationValue = propertiesValue6.get("backendIPConfiguration")) != null && !(backendIPConfigurationValue instanceof NullNode)) {
                                        ResourceId backendIPConfigurationInstance = new ResourceId();
                                        inboundNatRuleJsonFormatInstance.setBackendIPConfiguration(backendIPConfigurationInstance);
                                        JsonNode idValue16 = backendIPConfigurationValue.get("id");
                                        if (idValue16 != null && !(idValue16 instanceof NullNode)) {
                                            String idInstance16 = idValue16.getTextValue();
                                            backendIPConfigurationInstance.setId(idInstance16);
                                        }
                                    }
                                    if ((protocolValue3 = propertiesValue6.get("protocol")) != null && !(protocolValue3 instanceof NullNode)) {
                                        String protocolInstance3 = protocolValue3.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setProtocol(protocolInstance3);
                                    }
                                    if ((frontendPortValue2 = propertiesValue6.get("frontendPort")) != null && !(frontendPortValue2 instanceof NullNode)) {
                                        int frontendPortInstance2 = frontendPortValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setFrontendPort(frontendPortInstance2);
                                    }
                                    if ((backendPortValue2 = propertiesValue6.get("backendPort")) != null && !(backendPortValue2 instanceof NullNode)) {
                                        int backendPortInstance2 = backendPortValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setBackendPort(backendPortInstance2);
                                    }
                                    if ((idleTimeoutInMinutesValue2 = propertiesValue6.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue2 instanceof NullNode)) {
                                        int idleTimeoutInMinutesInstance2 = idleTimeoutInMinutesValue2.getIntValue();
                                        inboundNatRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                    }
                                    if ((enableFloatingIPValue2 = propertiesValue6.get("enableFloatingIP")) != null && !(enableFloatingIPValue2 instanceof NullNode)) {
                                        boolean enableFloatingIPInstance2 = enableFloatingIPValue2.getBooleanValue();
                                        inboundNatRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance2);
                                    }
                                    if ((provisioningStateValue5 = propertiesValue6.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                        String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                    }
                                }
                                if ((nameValue5 = inboundNatRulesValue2.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                    String nameInstance5 = nameValue5.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setName(nameInstance5);
                                }
                                if ((etagValue5 = inboundNatRulesValue2.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                    String etagInstance5 = etagValue5.getTextValue();
                                    inboundNatRuleJsonFormatInstance.setEtag(etagInstance5);
                                }
                                if ((idValue17 = inboundNatRulesValue2.get("id")) == null || idValue17 instanceof NullNode) continue;
                                String idInstance17 = idValue17.getTextValue();
                                inboundNatRuleJsonFormatInstance.setId(idInstance17);
                            }
                        }
                        if ((provisioningStateValue6 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                            String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                            loadBalancerInstance.setProvisioningState(provisioningStateInstance6);
                        }
                    }
                    if ((etagValue6 = responseDoc.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                        String etagInstance6 = etagValue6.getTextValue();
                        loadBalancerInstance.setEtag(etagInstance6);
                    }
                    if ((idValue18 = responseDoc.get("id")) != null && !(idValue18 instanceof NullNode)) {
                        String idInstance18 = idValue18.getTextValue();
                        loadBalancerInstance.setId(idInstance18);
                    }
                    if ((nameValue6 = responseDoc.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                        String nameInstance6 = nameValue6.getTextValue();
                        loadBalancerInstance.setName(nameInstance6);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        loadBalancerInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        loadBalancerInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            loadBalancerInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            LoadBalancerGetResponse loadBalancerGetResponse = result;
            return loadBalancerGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<LoadBalancerListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<LoadBalancerListResponse>(){

            @Override
            public LoadBalancerListResponse call() throws Exception {
                return LoadBalancerOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoadBalancerListResponse list(String resourceGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            LoadBalancerListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new LoadBalancerListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue6;
                            JsonNode idValue18;
                            JsonNode etagValue6;
                            LoadBalancer loadBalancerJsonFormatInstance = new LoadBalancer();
                            result.getLoadBalancers().add(loadBalancerJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue6;
                                JsonNode inboundNatRulesArray2;
                                JsonNode probesArray;
                                Object idValue12;
                                JsonNode loadBalancingRulesArray3;
                                JsonNode backendAddressPoolsArray;
                                Object idValue5;
                                JsonNode frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations");
                                if (frontendIPConfigurationsArray != null && !(frontendIPConfigurationsArray instanceof NullNode)) {
                                    for (Iterator frontendIPConfigurationsValue : (ArrayNode)frontendIPConfigurationsArray) {
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        FrontendIpConfiguration frontendIpConfigurationJsonFormatInstance = new FrontendIpConfiguration();
                                        loadBalancerJsonFormatInstance.getFrontendIpConfigurations().add(frontendIpConfigurationJsonFormatInstance);
                                        JsonNode propertiesValue2 = frontendIPConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode loadBalancingRulesArray;
                                            JsonNode inboundNatRulesArray;
                                            JsonNode publicIPAddressValue;
                                            JsonNode subnetValue;
                                            JsonNode privateIPAllocationMethodValue;
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                                String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            if ((privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                                String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            if ((subnetValue = propertiesValue2.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                                ResourceId subnetInstance = new ResourceId();
                                                frontendIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            if ((publicIPAddressValue = propertiesValue2.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                frontendIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                Iterator idValue2 = publicIPAddressValue.get("id");
                                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                                    String idInstance2 = idValue2.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance2);
                                                }
                                            }
                                            if ((inboundNatRulesArray = propertiesValue2.get("inboundNatRules")) != null && !(inboundNatRulesArray instanceof NullNode)) {
                                                for (Iterator inboundNatRulesValue : (ArrayNode)inboundNatRulesArray) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    frontendIpConfigurationJsonFormatInstance.getInboundNatRules().add(resourceIdInstance);
                                                    JsonNode idValue3 = inboundNatRulesValue.get("id");
                                                    if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                                    String idInstance3 = idValue3.getTextValue();
                                                    resourceIdInstance.setId(idInstance3);
                                                }
                                            }
                                            if ((loadBalancingRulesArray = propertiesValue2.get("loadBalancingRules")) != null && !(loadBalancingRulesArray instanceof NullNode)) {
                                                Iterator inboundNatRulesValue;
                                                inboundNatRulesValue = ((ArrayNode)loadBalancingRulesArray).iterator();
                                                while (inboundNatRulesValue.hasNext()) {
                                                    JsonNode loadBalancingRulesValue = (JsonNode)inboundNatRulesValue.next();
                                                    ResourceId resourceIdInstance2 = new ResourceId();
                                                    frontendIpConfigurationJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance2);
                                                    JsonNode idValue4 = loadBalancingRulesValue.get("id");
                                                    if (idValue4 == null || idValue4 instanceof NullNode) continue;
                                                    String idInstance4 = idValue4.getTextValue();
                                                    resourceIdInstance2.setId(idInstance4);
                                                }
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = frontendIPConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = frontendIPConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue5 = frontendIPConfigurationsValue.get("id")) == null || idValue5 instanceof NullNode) continue;
                                        String idInstance5 = idValue5.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setId(idInstance5);
                                    }
                                }
                                if ((backendAddressPoolsArray = propertiesValue.get("backendAddressPools")) != null && !(backendAddressPoolsArray instanceof NullNode)) {
                                    Iterator frontendIPConfigurationsValue;
                                    frontendIPConfigurationsValue = ((ArrayNode)backendAddressPoolsArray).iterator();
                                    while (frontendIPConfigurationsValue.hasNext()) {
                                        JsonNode idValue8;
                                        JsonNode etagValue2;
                                        JsonNode nameValue2;
                                        Iterator backendAddressPoolsValue = (JsonNode)frontendIPConfigurationsValue.next();
                                        BackendAddressPool backendAddressPoolJsonFormatInstance = new BackendAddressPool();
                                        loadBalancerJsonFormatInstance.getBackendAddressPools().add(backendAddressPoolJsonFormatInstance);
                                        JsonNode propertiesValue3 = backendAddressPoolsValue.get("properties");
                                        if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                            JsonNode provisioningStateValue2;
                                            JsonNode loadBalancingRulesArray2;
                                            JsonNode backendIPConfigurationsArray = propertiesValue3.get("backendIPConfigurations");
                                            if (backendIPConfigurationsArray != null && !(backendIPConfigurationsArray instanceof NullNode)) {
                                                idValue5 = ((ArrayNode)backendIPConfigurationsArray).iterator();
                                                while (idValue5.hasNext()) {
                                                    Iterator backendIPConfigurationsValue = (JsonNode)idValue5.next();
                                                    ResourceId resourceIdInstance3 = new ResourceId();
                                                    backendAddressPoolJsonFormatInstance.getBackendIpConfigurations().add(resourceIdInstance3);
                                                    JsonNode idValue6 = backendIPConfigurationsValue.get("id");
                                                    if (idValue6 == null || idValue6 instanceof NullNode) continue;
                                                    String idInstance6 = idValue6.getTextValue();
                                                    resourceIdInstance3.setId(idInstance6);
                                                }
                                            }
                                            if ((loadBalancingRulesArray2 = propertiesValue3.get("loadBalancingRules")) != null && !(loadBalancingRulesArray2 instanceof NullNode)) {
                                                for (JsonNode loadBalancingRulesValue2 : (ArrayNode)loadBalancingRulesArray2) {
                                                    ResourceId resourceIdInstance4 = new ResourceId();
                                                    backendAddressPoolJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance4);
                                                    JsonNode idValue7 = loadBalancingRulesValue2.get("id");
                                                    if (idValue7 == null || idValue7 instanceof NullNode) continue;
                                                    String idInstance7 = idValue7.getTextValue();
                                                    resourceIdInstance4.setId(idInstance7);
                                                }
                                            }
                                            if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                backendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        if ((nameValue2 = backendAddressPoolsValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                            String nameInstance2 = nameValue2.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setName(nameInstance2);
                                        }
                                        if ((etagValue2 = backendAddressPoolsValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                            String etagInstance2 = etagValue2.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setEtag(etagInstance2);
                                        }
                                        if ((idValue8 = backendAddressPoolsValue.get("id")) == null || idValue8 instanceof NullNode) continue;
                                        String idInstance8 = idValue8.getTextValue();
                                        backendAddressPoolJsonFormatInstance.setId(idInstance8);
                                    }
                                }
                                if ((loadBalancingRulesArray3 = propertiesValue.get("loadBalancingRules")) != null && !(loadBalancingRulesArray3 instanceof NullNode)) {
                                    for (Iterator loadBalancingRulesValue3 : (ArrayNode)loadBalancingRulesArray3) {
                                        JsonNode etagValue3;
                                        JsonNode nameValue3;
                                        LoadBalancingRule loadBalancingRuleJsonFormatInstance = new LoadBalancingRule();
                                        loadBalancerJsonFormatInstance.getLoadBalancingRules().add(loadBalancingRuleJsonFormatInstance);
                                        JsonNode propertiesValue4 = loadBalancingRulesValue3.get("properties");
                                        if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                            JsonNode provisioningStateValue3;
                                            JsonNode enableFloatingIPValue;
                                            JsonNode idleTimeoutInMinutesValue;
                                            JsonNode backendPortValue;
                                            JsonNode frontendPortValue;
                                            JsonNode loadDistributionValue;
                                            JsonNode protocolValue;
                                            JsonNode probeValue;
                                            JsonNode backendAddressPoolValue;
                                            JsonNode frontendIPConfigurationValue = propertiesValue4.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue != null && !(frontendIPConfigurationValue instanceof NullNode)) {
                                                ResourceId frontendIPConfigurationInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                                JsonNode idValue9 = frontendIPConfigurationValue.get("id");
                                                if (idValue9 != null && !(idValue9 instanceof NullNode)) {
                                                    String idInstance9 = idValue9.getTextValue();
                                                    frontendIPConfigurationInstance.setId(idInstance9);
                                                }
                                            }
                                            if ((backendAddressPoolValue = propertiesValue4.get("backendAddressPool")) != null && !(backendAddressPoolValue instanceof NullNode)) {
                                                ResourceId backendAddressPoolInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                                JsonNode idValue10 = backendAddressPoolValue.get("id");
                                                if (idValue10 != null && !(idValue10 instanceof NullNode)) {
                                                    String idInstance10 = idValue10.getTextValue();
                                                    backendAddressPoolInstance.setId(idInstance10);
                                                }
                                            }
                                            if ((probeValue = propertiesValue4.get("probe")) != null && !(probeValue instanceof NullNode)) {
                                                ResourceId probeInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setProbe(probeInstance);
                                                JsonNode idValue11 = probeValue.get("id");
                                                if (idValue11 != null && !(idValue11 instanceof NullNode)) {
                                                    String idInstance11 = idValue11.getTextValue();
                                                    probeInstance.setId(idInstance11);
                                                }
                                            }
                                            if ((protocolValue = propertiesValue4.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                                String protocolInstance = protocolValue.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            if ((loadDistributionValue = propertiesValue4.get("loadDistribution")) != null && !(loadDistributionValue instanceof NullNode)) {
                                                String loadDistributionInstance = loadDistributionValue.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setLoadDistribution(loadDistributionInstance);
                                            }
                                            if ((frontendPortValue = propertiesValue4.get("frontendPort")) != null && !(frontendPortValue instanceof NullNode)) {
                                                int frontendPortInstance = frontendPortValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                            }
                                            if ((backendPortValue = propertiesValue4.get("backendPort")) != null && !(backendPortValue instanceof NullNode)) {
                                                int backendPortInstance = backendPortValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setBackendPort(backendPortInstance);
                                            }
                                            if ((idleTimeoutInMinutesValue = propertiesValue4.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue instanceof NullNode)) {
                                                int idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                            }
                                            if ((enableFloatingIPValue = propertiesValue4.get("enableFloatingIP")) != null && !(enableFloatingIPValue instanceof NullNode)) {
                                                boolean enableFloatingIPInstance = enableFloatingIPValue.getBooleanValue();
                                                loadBalancingRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance);
                                            }
                                            if ((provisioningStateValue3 = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                                String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                            }
                                        }
                                        if ((nameValue3 = loadBalancingRulesValue3.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                            String nameInstance3 = nameValue3.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setName(nameInstance3);
                                        }
                                        if ((etagValue3 = loadBalancingRulesValue3.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                            String etagInstance3 = etagValue3.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setEtag(etagInstance3);
                                        }
                                        if ((idValue12 = loadBalancingRulesValue3.get("id")) == null || idValue12 instanceof NullNode) continue;
                                        String idInstance12 = idValue12.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setId(idInstance12);
                                    }
                                }
                                if ((probesArray = propertiesValue.get("probes")) != null && !(probesArray instanceof NullNode)) {
                                    Iterator loadBalancingRulesValue3;
                                    loadBalancingRulesValue3 = ((ArrayNode)probesArray).iterator();
                                    while (loadBalancingRulesValue3.hasNext()) {
                                        JsonNode idValue14;
                                        JsonNode etagValue4;
                                        JsonNode nameValue4;
                                        Iterator probesValue = (JsonNode)loadBalancingRulesValue3.next();
                                        Probe probeJsonFormatInstance = new Probe();
                                        loadBalancerJsonFormatInstance.getProbes().add(probeJsonFormatInstance);
                                        JsonNode propertiesValue5 = probesValue.get("properties");
                                        if (propertiesValue5 != null && !(propertiesValue5 instanceof NullNode)) {
                                            JsonNode provisioningStateValue4;
                                            JsonNode requestPathValue;
                                            JsonNode numberOfProbesValue;
                                            JsonNode intervalInSecondsValue;
                                            JsonNode portValue;
                                            JsonNode protocolValue2;
                                            JsonNode loadBalancingRulesArray4 = propertiesValue5.get("loadBalancingRules");
                                            if (loadBalancingRulesArray4 != null && !(loadBalancingRulesArray4 instanceof NullNode)) {
                                                idValue12 = ((ArrayNode)loadBalancingRulesArray4).iterator();
                                                while (idValue12.hasNext()) {
                                                    JsonNode loadBalancingRulesValue4 = (JsonNode)idValue12.next();
                                                    ResourceId resourceIdInstance5 = new ResourceId();
                                                    probeJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance5);
                                                    JsonNode idValue13 = loadBalancingRulesValue4.get("id");
                                                    if (idValue13 == null || idValue13 instanceof NullNode) continue;
                                                    String idInstance13 = idValue13.getTextValue();
                                                    resourceIdInstance5.setId(idInstance13);
                                                }
                                            }
                                            if ((protocolValue2 = propertiesValue5.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                                String protocolInstance2 = protocolValue2.getTextValue();
                                                probeJsonFormatInstance.setProtocol(protocolInstance2);
                                            }
                                            if ((portValue = propertiesValue5.get("port")) != null && !(portValue instanceof NullNode)) {
                                                int portInstance = portValue.getIntValue();
                                                probeJsonFormatInstance.setPort(portInstance);
                                            }
                                            if ((intervalInSecondsValue = propertiesValue5.get("intervalInSeconds")) != null && !(intervalInSecondsValue instanceof NullNode)) {
                                                int intervalInSecondsInstance = intervalInSecondsValue.getIntValue();
                                                probeJsonFormatInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                            }
                                            if ((numberOfProbesValue = propertiesValue5.get("numberOfProbes")) != null && !(numberOfProbesValue instanceof NullNode)) {
                                                int numberOfProbesInstance = numberOfProbesValue.getIntValue();
                                                probeJsonFormatInstance.setNumberOfProbes(numberOfProbesInstance);
                                            }
                                            if ((requestPathValue = propertiesValue5.get("requestPath")) != null && !(requestPathValue instanceof NullNode)) {
                                                String requestPathInstance = requestPathValue.getTextValue();
                                                probeJsonFormatInstance.setRequestPath(requestPathInstance);
                                            }
                                            if ((provisioningStateValue4 = propertiesValue5.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                                String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                                probeJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                            }
                                        }
                                        if ((nameValue4 = probesValue.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                            String nameInstance4 = nameValue4.getTextValue();
                                            probeJsonFormatInstance.setName(nameInstance4);
                                        }
                                        if ((etagValue4 = probesValue.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                            String etagInstance4 = etagValue4.getTextValue();
                                            probeJsonFormatInstance.setEtag(etagInstance4);
                                        }
                                        if ((idValue14 = probesValue.get("id")) == null || idValue14 instanceof NullNode) continue;
                                        String idInstance14 = idValue14.getTextValue();
                                        probeJsonFormatInstance.setId(idInstance14);
                                    }
                                }
                                if ((inboundNatRulesArray2 = propertiesValue.get("inboundNatRules")) != null && !(inboundNatRulesArray2 instanceof NullNode)) {
                                    for (JsonNode inboundNatRulesValue2 : (ArrayNode)inboundNatRulesArray2) {
                                        JsonNode idValue17;
                                        JsonNode etagValue5;
                                        JsonNode nameValue5;
                                        InboundNatRule inboundNatRuleJsonFormatInstance = new InboundNatRule();
                                        loadBalancerJsonFormatInstance.getInboundNatRules().add(inboundNatRuleJsonFormatInstance);
                                        JsonNode propertiesValue6 = inboundNatRulesValue2.get("properties");
                                        if (propertiesValue6 != null && !(propertiesValue6 instanceof NullNode)) {
                                            JsonNode provisioningStateValue5;
                                            JsonNode enableFloatingIPValue2;
                                            JsonNode idleTimeoutInMinutesValue2;
                                            JsonNode backendPortValue2;
                                            JsonNode frontendPortValue2;
                                            JsonNode protocolValue3;
                                            JsonNode backendIPConfigurationValue;
                                            JsonNode frontendIPConfigurationValue2 = propertiesValue6.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue2 != null && !(frontendIPConfigurationValue2 instanceof NullNode)) {
                                                ResourceId frontendIPConfigurationInstance2 = new ResourceId();
                                                inboundNatRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance2);
                                                JsonNode idValue15 = frontendIPConfigurationValue2.get("id");
                                                if (idValue15 != null && !(idValue15 instanceof NullNode)) {
                                                    String idInstance15 = idValue15.getTextValue();
                                                    frontendIPConfigurationInstance2.setId(idInstance15);
                                                }
                                            }
                                            if ((backendIPConfigurationValue = propertiesValue6.get("backendIPConfiguration")) != null && !(backendIPConfigurationValue instanceof NullNode)) {
                                                ResourceId backendIPConfigurationInstance = new ResourceId();
                                                inboundNatRuleJsonFormatInstance.setBackendIPConfiguration(backendIPConfigurationInstance);
                                                JsonNode idValue16 = backendIPConfigurationValue.get("id");
                                                if (idValue16 != null && !(idValue16 instanceof NullNode)) {
                                                    String idInstance16 = idValue16.getTextValue();
                                                    backendIPConfigurationInstance.setId(idInstance16);
                                                }
                                            }
                                            if ((protocolValue3 = propertiesValue6.get("protocol")) != null && !(protocolValue3 instanceof NullNode)) {
                                                String protocolInstance3 = protocolValue3.getTextValue();
                                                inboundNatRuleJsonFormatInstance.setProtocol(protocolInstance3);
                                            }
                                            if ((frontendPortValue2 = propertiesValue6.get("frontendPort")) != null && !(frontendPortValue2 instanceof NullNode)) {
                                                int frontendPortInstance2 = frontendPortValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setFrontendPort(frontendPortInstance2);
                                            }
                                            if ((backendPortValue2 = propertiesValue6.get("backendPort")) != null && !(backendPortValue2 instanceof NullNode)) {
                                                int backendPortInstance2 = backendPortValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setBackendPort(backendPortInstance2);
                                            }
                                            if ((idleTimeoutInMinutesValue2 = propertiesValue6.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue2 instanceof NullNode)) {
                                                int idleTimeoutInMinutesInstance2 = idleTimeoutInMinutesValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                            }
                                            if ((enableFloatingIPValue2 = propertiesValue6.get("enableFloatingIP")) != null && !(enableFloatingIPValue2 instanceof NullNode)) {
                                                boolean enableFloatingIPInstance2 = enableFloatingIPValue2.getBooleanValue();
                                                inboundNatRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance2);
                                            }
                                            if ((provisioningStateValue5 = propertiesValue6.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                                String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                                inboundNatRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                            }
                                        }
                                        if ((nameValue5 = inboundNatRulesValue2.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                            String nameInstance5 = nameValue5.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setName(nameInstance5);
                                        }
                                        if ((etagValue5 = inboundNatRulesValue2.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                            String etagInstance5 = etagValue5.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setEtag(etagInstance5);
                                        }
                                        if ((idValue17 = inboundNatRulesValue2.get("id")) == null || idValue17 instanceof NullNode) continue;
                                        String idInstance17 = idValue17.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setId(idInstance17);
                                    }
                                }
                                if ((provisioningStateValue6 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                                    String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                    loadBalancerJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                }
                            }
                            if ((etagValue6 = valueValue.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                                String etagInstance6 = etagValue6.getTextValue();
                                loadBalancerJsonFormatInstance.setEtag(etagInstance6);
                            }
                            if ((idValue18 = valueValue.get("id")) != null && !(idValue18 instanceof NullNode)) {
                                String idInstance18 = idValue18.getTextValue();
                                loadBalancerJsonFormatInstance.setId(idInstance18);
                            }
                            if ((nameValue6 = valueValue.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                                String nameInstance6 = nameValue6.getTextValue();
                                loadBalancerJsonFormatInstance.setName(nameInstance6);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                loadBalancerJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                loadBalancerJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                loadBalancerJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            LoadBalancerListResponse loadBalancerListResponse = result;
            return loadBalancerListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<LoadBalancerListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<LoadBalancerListResponse>(){

            @Override
            public LoadBalancerListResponse call() throws Exception {
                return LoadBalancerOperationsImpl.this.listAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoadBalancerListResponse listAll() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/loadBalancers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            LoadBalancerListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new LoadBalancerListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue6;
                            JsonNode idValue18;
                            JsonNode etagValue6;
                            LoadBalancer loadBalancerJsonFormatInstance = new LoadBalancer();
                            result.getLoadBalancers().add(loadBalancerJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue6;
                                JsonNode inboundNatRulesArray2;
                                JsonNode probesArray;
                                Object idValue12;
                                JsonNode loadBalancingRulesArray3;
                                JsonNode backendAddressPoolsArray;
                                Object idValue5;
                                JsonNode frontendIPConfigurationsArray = propertiesValue.get("frontendIPConfigurations");
                                if (frontendIPConfigurationsArray != null && !(frontendIPConfigurationsArray instanceof NullNode)) {
                                    for (Iterator frontendIPConfigurationsValue : (ArrayNode)frontendIPConfigurationsArray) {
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        FrontendIpConfiguration frontendIpConfigurationJsonFormatInstance = new FrontendIpConfiguration();
                                        loadBalancerJsonFormatInstance.getFrontendIpConfigurations().add(frontendIpConfigurationJsonFormatInstance);
                                        JsonNode propertiesValue2 = frontendIPConfigurationsValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode loadBalancingRulesArray;
                                            JsonNode inboundNatRulesArray;
                                            JsonNode publicIPAddressValue;
                                            JsonNode subnetValue;
                                            JsonNode privateIPAllocationMethodValue;
                                            JsonNode privateIPAddressValue = propertiesValue2.get("privateIPAddress");
                                            if (privateIPAddressValue != null && !(privateIPAddressValue instanceof NullNode)) {
                                                String privateIPAddressInstance = privateIPAddressValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setPrivateIpAddress(privateIPAddressInstance);
                                            }
                                            if ((privateIPAllocationMethodValue = propertiesValue2.get("privateIPAllocationMethod")) != null && !(privateIPAllocationMethodValue instanceof NullNode)) {
                                                String privateIPAllocationMethodInstance = privateIPAllocationMethodValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setPrivateIpAllocationMethod(privateIPAllocationMethodInstance);
                                            }
                                            if ((subnetValue = propertiesValue2.get("subnet")) != null && !(subnetValue instanceof NullNode)) {
                                                ResourceId subnetInstance = new ResourceId();
                                                frontendIpConfigurationJsonFormatInstance.setSubnet(subnetInstance);
                                                JsonNode idValue = subnetValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    subnetInstance.setId(idInstance);
                                                }
                                            }
                                            if ((publicIPAddressValue = propertiesValue2.get("publicIPAddress")) != null && !(publicIPAddressValue instanceof NullNode)) {
                                                ResourceId publicIPAddressInstance = new ResourceId();
                                                frontendIpConfigurationJsonFormatInstance.setPublicIpAddress(publicIPAddressInstance);
                                                Iterator idValue2 = publicIPAddressValue.get("id");
                                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                                    String idInstance2 = idValue2.getTextValue();
                                                    publicIPAddressInstance.setId(idInstance2);
                                                }
                                            }
                                            if ((inboundNatRulesArray = propertiesValue2.get("inboundNatRules")) != null && !(inboundNatRulesArray instanceof NullNode)) {
                                                for (Iterator inboundNatRulesValue : (ArrayNode)inboundNatRulesArray) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    frontendIpConfigurationJsonFormatInstance.getInboundNatRules().add(resourceIdInstance);
                                                    JsonNode idValue3 = inboundNatRulesValue.get("id");
                                                    if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                                    String idInstance3 = idValue3.getTextValue();
                                                    resourceIdInstance.setId(idInstance3);
                                                }
                                            }
                                            if ((loadBalancingRulesArray = propertiesValue2.get("loadBalancingRules")) != null && !(loadBalancingRulesArray instanceof NullNode)) {
                                                Iterator inboundNatRulesValue;
                                                inboundNatRulesValue = ((ArrayNode)loadBalancingRulesArray).iterator();
                                                while (inboundNatRulesValue.hasNext()) {
                                                    JsonNode loadBalancingRulesValue = (JsonNode)inboundNatRulesValue.next();
                                                    ResourceId resourceIdInstance2 = new ResourceId();
                                                    frontendIpConfigurationJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance2);
                                                    JsonNode idValue4 = loadBalancingRulesValue.get("id");
                                                    if (idValue4 == null || idValue4 instanceof NullNode) continue;
                                                    String idInstance4 = idValue4.getTextValue();
                                                    resourceIdInstance2.setId(idInstance4);
                                                }
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                frontendIpConfigurationJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = frontendIPConfigurationsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = frontendIPConfigurationsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            frontendIpConfigurationJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue5 = frontendIPConfigurationsValue.get("id")) == null || idValue5 instanceof NullNode) continue;
                                        String idInstance5 = idValue5.getTextValue();
                                        frontendIpConfigurationJsonFormatInstance.setId(idInstance5);
                                    }
                                }
                                if ((backendAddressPoolsArray = propertiesValue.get("backendAddressPools")) != null && !(backendAddressPoolsArray instanceof NullNode)) {
                                    Iterator frontendIPConfigurationsValue;
                                    frontendIPConfigurationsValue = ((ArrayNode)backendAddressPoolsArray).iterator();
                                    while (frontendIPConfigurationsValue.hasNext()) {
                                        JsonNode idValue8;
                                        JsonNode etagValue2;
                                        JsonNode nameValue2;
                                        Iterator backendAddressPoolsValue = (JsonNode)frontendIPConfigurationsValue.next();
                                        BackendAddressPool backendAddressPoolJsonFormatInstance = new BackendAddressPool();
                                        loadBalancerJsonFormatInstance.getBackendAddressPools().add(backendAddressPoolJsonFormatInstance);
                                        JsonNode propertiesValue3 = backendAddressPoolsValue.get("properties");
                                        if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                            JsonNode provisioningStateValue2;
                                            JsonNode loadBalancingRulesArray2;
                                            JsonNode backendIPConfigurationsArray = propertiesValue3.get("backendIPConfigurations");
                                            if (backendIPConfigurationsArray != null && !(backendIPConfigurationsArray instanceof NullNode)) {
                                                idValue5 = ((ArrayNode)backendIPConfigurationsArray).iterator();
                                                while (idValue5.hasNext()) {
                                                    Iterator backendIPConfigurationsValue = (JsonNode)idValue5.next();
                                                    ResourceId resourceIdInstance3 = new ResourceId();
                                                    backendAddressPoolJsonFormatInstance.getBackendIpConfigurations().add(resourceIdInstance3);
                                                    JsonNode idValue6 = backendIPConfigurationsValue.get("id");
                                                    if (idValue6 == null || idValue6 instanceof NullNode) continue;
                                                    String idInstance6 = idValue6.getTextValue();
                                                    resourceIdInstance3.setId(idInstance6);
                                                }
                                            }
                                            if ((loadBalancingRulesArray2 = propertiesValue3.get("loadBalancingRules")) != null && !(loadBalancingRulesArray2 instanceof NullNode)) {
                                                for (JsonNode loadBalancingRulesValue2 : (ArrayNode)loadBalancingRulesArray2) {
                                                    ResourceId resourceIdInstance4 = new ResourceId();
                                                    backendAddressPoolJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance4);
                                                    JsonNode idValue7 = loadBalancingRulesValue2.get("id");
                                                    if (idValue7 == null || idValue7 instanceof NullNode) continue;
                                                    String idInstance7 = idValue7.getTextValue();
                                                    resourceIdInstance4.setId(idInstance7);
                                                }
                                            }
                                            if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                                backendAddressPoolJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                            }
                                        }
                                        if ((nameValue2 = backendAddressPoolsValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                            String nameInstance2 = nameValue2.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setName(nameInstance2);
                                        }
                                        if ((etagValue2 = backendAddressPoolsValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                            String etagInstance2 = etagValue2.getTextValue();
                                            backendAddressPoolJsonFormatInstance.setEtag(etagInstance2);
                                        }
                                        if ((idValue8 = backendAddressPoolsValue.get("id")) == null || idValue8 instanceof NullNode) continue;
                                        String idInstance8 = idValue8.getTextValue();
                                        backendAddressPoolJsonFormatInstance.setId(idInstance8);
                                    }
                                }
                                if ((loadBalancingRulesArray3 = propertiesValue.get("loadBalancingRules")) != null && !(loadBalancingRulesArray3 instanceof NullNode)) {
                                    for (Iterator loadBalancingRulesValue3 : (ArrayNode)loadBalancingRulesArray3) {
                                        JsonNode etagValue3;
                                        JsonNode nameValue3;
                                        LoadBalancingRule loadBalancingRuleJsonFormatInstance = new LoadBalancingRule();
                                        loadBalancerJsonFormatInstance.getLoadBalancingRules().add(loadBalancingRuleJsonFormatInstance);
                                        JsonNode propertiesValue4 = loadBalancingRulesValue3.get("properties");
                                        if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                            JsonNode provisioningStateValue3;
                                            JsonNode enableFloatingIPValue;
                                            JsonNode idleTimeoutInMinutesValue;
                                            JsonNode backendPortValue;
                                            JsonNode frontendPortValue;
                                            JsonNode loadDistributionValue;
                                            JsonNode protocolValue;
                                            JsonNode probeValue;
                                            JsonNode backendAddressPoolValue;
                                            JsonNode frontendIPConfigurationValue = propertiesValue4.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue != null && !(frontendIPConfigurationValue instanceof NullNode)) {
                                                ResourceId frontendIPConfigurationInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance);
                                                JsonNode idValue9 = frontendIPConfigurationValue.get("id");
                                                if (idValue9 != null && !(idValue9 instanceof NullNode)) {
                                                    String idInstance9 = idValue9.getTextValue();
                                                    frontendIPConfigurationInstance.setId(idInstance9);
                                                }
                                            }
                                            if ((backendAddressPoolValue = propertiesValue4.get("backendAddressPool")) != null && !(backendAddressPoolValue instanceof NullNode)) {
                                                ResourceId backendAddressPoolInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setBackendAddressPool(backendAddressPoolInstance);
                                                JsonNode idValue10 = backendAddressPoolValue.get("id");
                                                if (idValue10 != null && !(idValue10 instanceof NullNode)) {
                                                    String idInstance10 = idValue10.getTextValue();
                                                    backendAddressPoolInstance.setId(idInstance10);
                                                }
                                            }
                                            if ((probeValue = propertiesValue4.get("probe")) != null && !(probeValue instanceof NullNode)) {
                                                ResourceId probeInstance = new ResourceId();
                                                loadBalancingRuleJsonFormatInstance.setProbe(probeInstance);
                                                JsonNode idValue11 = probeValue.get("id");
                                                if (idValue11 != null && !(idValue11 instanceof NullNode)) {
                                                    String idInstance11 = idValue11.getTextValue();
                                                    probeInstance.setId(idInstance11);
                                                }
                                            }
                                            if ((protocolValue = propertiesValue4.get("protocol")) != null && !(protocolValue instanceof NullNode)) {
                                                String protocolInstance = protocolValue.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setProtocol(protocolInstance);
                                            }
                                            if ((loadDistributionValue = propertiesValue4.get("loadDistribution")) != null && !(loadDistributionValue instanceof NullNode)) {
                                                String loadDistributionInstance = loadDistributionValue.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setLoadDistribution(loadDistributionInstance);
                                            }
                                            if ((frontendPortValue = propertiesValue4.get("frontendPort")) != null && !(frontendPortValue instanceof NullNode)) {
                                                int frontendPortInstance = frontendPortValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setFrontendPort(frontendPortInstance);
                                            }
                                            if ((backendPortValue = propertiesValue4.get("backendPort")) != null && !(backendPortValue instanceof NullNode)) {
                                                int backendPortInstance = backendPortValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setBackendPort(backendPortInstance);
                                            }
                                            if ((idleTimeoutInMinutesValue = propertiesValue4.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue instanceof NullNode)) {
                                                int idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                                loadBalancingRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                            }
                                            if ((enableFloatingIPValue = propertiesValue4.get("enableFloatingIP")) != null && !(enableFloatingIPValue instanceof NullNode)) {
                                                boolean enableFloatingIPInstance = enableFloatingIPValue.getBooleanValue();
                                                loadBalancingRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance);
                                            }
                                            if ((provisioningStateValue3 = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue3 instanceof NullNode)) {
                                                String provisioningStateInstance3 = provisioningStateValue3.getTextValue();
                                                loadBalancingRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance3);
                                            }
                                        }
                                        if ((nameValue3 = loadBalancingRulesValue3.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                            String nameInstance3 = nameValue3.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setName(nameInstance3);
                                        }
                                        if ((etagValue3 = loadBalancingRulesValue3.get("etag")) != null && !(etagValue3 instanceof NullNode)) {
                                            String etagInstance3 = etagValue3.getTextValue();
                                            loadBalancingRuleJsonFormatInstance.setEtag(etagInstance3);
                                        }
                                        if ((idValue12 = loadBalancingRulesValue3.get("id")) == null || idValue12 instanceof NullNode) continue;
                                        String idInstance12 = idValue12.getTextValue();
                                        loadBalancingRuleJsonFormatInstance.setId(idInstance12);
                                    }
                                }
                                if ((probesArray = propertiesValue.get("probes")) != null && !(probesArray instanceof NullNode)) {
                                    Iterator loadBalancingRulesValue3;
                                    loadBalancingRulesValue3 = ((ArrayNode)probesArray).iterator();
                                    while (loadBalancingRulesValue3.hasNext()) {
                                        JsonNode idValue14;
                                        JsonNode etagValue4;
                                        JsonNode nameValue4;
                                        Iterator probesValue = (JsonNode)loadBalancingRulesValue3.next();
                                        Probe probeJsonFormatInstance = new Probe();
                                        loadBalancerJsonFormatInstance.getProbes().add(probeJsonFormatInstance);
                                        JsonNode propertiesValue5 = probesValue.get("properties");
                                        if (propertiesValue5 != null && !(propertiesValue5 instanceof NullNode)) {
                                            JsonNode provisioningStateValue4;
                                            JsonNode requestPathValue;
                                            JsonNode numberOfProbesValue;
                                            JsonNode intervalInSecondsValue;
                                            JsonNode portValue;
                                            JsonNode protocolValue2;
                                            JsonNode loadBalancingRulesArray4 = propertiesValue5.get("loadBalancingRules");
                                            if (loadBalancingRulesArray4 != null && !(loadBalancingRulesArray4 instanceof NullNode)) {
                                                idValue12 = ((ArrayNode)loadBalancingRulesArray4).iterator();
                                                while (idValue12.hasNext()) {
                                                    JsonNode loadBalancingRulesValue4 = (JsonNode)idValue12.next();
                                                    ResourceId resourceIdInstance5 = new ResourceId();
                                                    probeJsonFormatInstance.getLoadBalancingRules().add(resourceIdInstance5);
                                                    JsonNode idValue13 = loadBalancingRulesValue4.get("id");
                                                    if (idValue13 == null || idValue13 instanceof NullNode) continue;
                                                    String idInstance13 = idValue13.getTextValue();
                                                    resourceIdInstance5.setId(idInstance13);
                                                }
                                            }
                                            if ((protocolValue2 = propertiesValue5.get("protocol")) != null && !(protocolValue2 instanceof NullNode)) {
                                                String protocolInstance2 = protocolValue2.getTextValue();
                                                probeJsonFormatInstance.setProtocol(protocolInstance2);
                                            }
                                            if ((portValue = propertiesValue5.get("port")) != null && !(portValue instanceof NullNode)) {
                                                int portInstance = portValue.getIntValue();
                                                probeJsonFormatInstance.setPort(portInstance);
                                            }
                                            if ((intervalInSecondsValue = propertiesValue5.get("intervalInSeconds")) != null && !(intervalInSecondsValue instanceof NullNode)) {
                                                int intervalInSecondsInstance = intervalInSecondsValue.getIntValue();
                                                probeJsonFormatInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                            }
                                            if ((numberOfProbesValue = propertiesValue5.get("numberOfProbes")) != null && !(numberOfProbesValue instanceof NullNode)) {
                                                int numberOfProbesInstance = numberOfProbesValue.getIntValue();
                                                probeJsonFormatInstance.setNumberOfProbes(numberOfProbesInstance);
                                            }
                                            if ((requestPathValue = propertiesValue5.get("requestPath")) != null && !(requestPathValue instanceof NullNode)) {
                                                String requestPathInstance = requestPathValue.getTextValue();
                                                probeJsonFormatInstance.setRequestPath(requestPathInstance);
                                            }
                                            if ((provisioningStateValue4 = propertiesValue5.get("provisioningState")) != null && !(provisioningStateValue4 instanceof NullNode)) {
                                                String provisioningStateInstance4 = provisioningStateValue4.getTextValue();
                                                probeJsonFormatInstance.setProvisioningState(provisioningStateInstance4);
                                            }
                                        }
                                        if ((nameValue4 = probesValue.get("name")) != null && !(nameValue4 instanceof NullNode)) {
                                            String nameInstance4 = nameValue4.getTextValue();
                                            probeJsonFormatInstance.setName(nameInstance4);
                                        }
                                        if ((etagValue4 = probesValue.get("etag")) != null && !(etagValue4 instanceof NullNode)) {
                                            String etagInstance4 = etagValue4.getTextValue();
                                            probeJsonFormatInstance.setEtag(etagInstance4);
                                        }
                                        if ((idValue14 = probesValue.get("id")) == null || idValue14 instanceof NullNode) continue;
                                        String idInstance14 = idValue14.getTextValue();
                                        probeJsonFormatInstance.setId(idInstance14);
                                    }
                                }
                                if ((inboundNatRulesArray2 = propertiesValue.get("inboundNatRules")) != null && !(inboundNatRulesArray2 instanceof NullNode)) {
                                    for (JsonNode inboundNatRulesValue2 : (ArrayNode)inboundNatRulesArray2) {
                                        JsonNode idValue17;
                                        JsonNode etagValue5;
                                        JsonNode nameValue5;
                                        InboundNatRule inboundNatRuleJsonFormatInstance = new InboundNatRule();
                                        loadBalancerJsonFormatInstance.getInboundNatRules().add(inboundNatRuleJsonFormatInstance);
                                        JsonNode propertiesValue6 = inboundNatRulesValue2.get("properties");
                                        if (propertiesValue6 != null && !(propertiesValue6 instanceof NullNode)) {
                                            JsonNode provisioningStateValue5;
                                            JsonNode enableFloatingIPValue2;
                                            JsonNode idleTimeoutInMinutesValue2;
                                            JsonNode backendPortValue2;
                                            JsonNode frontendPortValue2;
                                            JsonNode protocolValue3;
                                            JsonNode backendIPConfigurationValue;
                                            JsonNode frontendIPConfigurationValue2 = propertiesValue6.get("frontendIPConfiguration");
                                            if (frontendIPConfigurationValue2 != null && !(frontendIPConfigurationValue2 instanceof NullNode)) {
                                                ResourceId frontendIPConfigurationInstance2 = new ResourceId();
                                                inboundNatRuleJsonFormatInstance.setFrontendIPConfiguration(frontendIPConfigurationInstance2);
                                                JsonNode idValue15 = frontendIPConfigurationValue2.get("id");
                                                if (idValue15 != null && !(idValue15 instanceof NullNode)) {
                                                    String idInstance15 = idValue15.getTextValue();
                                                    frontendIPConfigurationInstance2.setId(idInstance15);
                                                }
                                            }
                                            if ((backendIPConfigurationValue = propertiesValue6.get("backendIPConfiguration")) != null && !(backendIPConfigurationValue instanceof NullNode)) {
                                                ResourceId backendIPConfigurationInstance = new ResourceId();
                                                inboundNatRuleJsonFormatInstance.setBackendIPConfiguration(backendIPConfigurationInstance);
                                                JsonNode idValue16 = backendIPConfigurationValue.get("id");
                                                if (idValue16 != null && !(idValue16 instanceof NullNode)) {
                                                    String idInstance16 = idValue16.getTextValue();
                                                    backendIPConfigurationInstance.setId(idInstance16);
                                                }
                                            }
                                            if ((protocolValue3 = propertiesValue6.get("protocol")) != null && !(protocolValue3 instanceof NullNode)) {
                                                String protocolInstance3 = protocolValue3.getTextValue();
                                                inboundNatRuleJsonFormatInstance.setProtocol(protocolInstance3);
                                            }
                                            if ((frontendPortValue2 = propertiesValue6.get("frontendPort")) != null && !(frontendPortValue2 instanceof NullNode)) {
                                                int frontendPortInstance2 = frontendPortValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setFrontendPort(frontendPortInstance2);
                                            }
                                            if ((backendPortValue2 = propertiesValue6.get("backendPort")) != null && !(backendPortValue2 instanceof NullNode)) {
                                                int backendPortInstance2 = backendPortValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setBackendPort(backendPortInstance2);
                                            }
                                            if ((idleTimeoutInMinutesValue2 = propertiesValue6.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue2 instanceof NullNode)) {
                                                int idleTimeoutInMinutesInstance2 = idleTimeoutInMinutesValue2.getIntValue();
                                                inboundNatRuleJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                            }
                                            if ((enableFloatingIPValue2 = propertiesValue6.get("enableFloatingIP")) != null && !(enableFloatingIPValue2 instanceof NullNode)) {
                                                boolean enableFloatingIPInstance2 = enableFloatingIPValue2.getBooleanValue();
                                                inboundNatRuleJsonFormatInstance.setEnableFloatingIP(enableFloatingIPInstance2);
                                            }
                                            if ((provisioningStateValue5 = propertiesValue6.get("provisioningState")) != null && !(provisioningStateValue5 instanceof NullNode)) {
                                                String provisioningStateInstance5 = provisioningStateValue5.getTextValue();
                                                inboundNatRuleJsonFormatInstance.setProvisioningState(provisioningStateInstance5);
                                            }
                                        }
                                        if ((nameValue5 = inboundNatRulesValue2.get("name")) != null && !(nameValue5 instanceof NullNode)) {
                                            String nameInstance5 = nameValue5.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setName(nameInstance5);
                                        }
                                        if ((etagValue5 = inboundNatRulesValue2.get("etag")) != null && !(etagValue5 instanceof NullNode)) {
                                            String etagInstance5 = etagValue5.getTextValue();
                                            inboundNatRuleJsonFormatInstance.setEtag(etagInstance5);
                                        }
                                        if ((idValue17 = inboundNatRulesValue2.get("id")) == null || idValue17 instanceof NullNode) continue;
                                        String idInstance17 = idValue17.getTextValue();
                                        inboundNatRuleJsonFormatInstance.setId(idInstance17);
                                    }
                                }
                                if ((provisioningStateValue6 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue6 instanceof NullNode)) {
                                    String provisioningStateInstance6 = provisioningStateValue6.getTextValue();
                                    loadBalancerJsonFormatInstance.setProvisioningState(provisioningStateInstance6);
                                }
                            }
                            if ((etagValue6 = valueValue.get("etag")) != null && !(etagValue6 instanceof NullNode)) {
                                String etagInstance6 = etagValue6.getTextValue();
                                loadBalancerJsonFormatInstance.setEtag(etagInstance6);
                            }
                            if ((idValue18 = valueValue.get("id")) != null && !(idValue18 instanceof NullNode)) {
                                String idInstance18 = idValue18.getTextValue();
                                loadBalancerJsonFormatInstance.setId(idInstance18);
                            }
                            if ((nameValue6 = valueValue.get("name")) != null && !(nameValue6 instanceof NullNode)) {
                                String nameInstance6 = nameValue6.getTextValue();
                                loadBalancerJsonFormatInstance.setName(nameInstance6);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                loadBalancerJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                loadBalancerJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                loadBalancerJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            LoadBalancerListResponse loadBalancerListResponse = result;
            return loadBalancerListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

