/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.PublicIpAddressOperations;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.PublicIpAddress;
import com.microsoft.azure.management.network.models.PublicIpAddressDnsSettings;
import com.microsoft.azure.management.network.models.PublicIpAddressGetResponse;
import com.microsoft.azure.management.network.models.PublicIpAddressListResponse;
import com.microsoft.azure.management.network.models.PublicIpAddressPutResponse;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class PublicIpAddressOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
PublicIpAddressOperations {
    private NetworkResourceProviderClientImpl client;

    PublicIpAddressOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<PublicIpAddressPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String publicIpAddressName, final PublicIpAddress parameters) {
        return this.getClient().getExecutorService().submit(new Callable<PublicIpAddressPutResponse>(){

            @Override
            public PublicIpAddressPutResponse call() throws Exception {
                return PublicIpAddressOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, publicIpAddressName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicIpAddressPutResponse beginCreateOrUpdating(String resourceGroupName, String publicIpAddressName, PublicIpAddress parameters) throws IOException, ServiceException {
        ObjectNode publicIpAddressJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (publicIpAddressName == null) {
            throw new NullPointerException("publicIpAddressName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getPublicIpAllocationMethod() == null) {
            throw new NullPointerException("parameters.PublicIpAllocationMethod");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses/";
        url = url + URLEncoder.encode(publicIpAddressName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = publicIpAddressJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        publicIpAddressJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        propertiesValue.put("publicIPAllocationMethod", parameters.getPublicIpAllocationMethod());
        if (parameters.getIpConfiguration() != null) {
            ObjectNode ipConfigurationValue = objectMapper.createObjectNode();
            propertiesValue.put("ipConfiguration", (JsonNode)ipConfigurationValue);
            if (parameters.getIpConfiguration().getId() != null) {
                ipConfigurationValue.put("id", parameters.getIpConfiguration().getId());
            }
        }
        if (parameters.getDnsSettings() != null) {
            ObjectNode dnsSettingsValue = objectMapper.createObjectNode();
            propertiesValue.put("dnsSettings", (JsonNode)dnsSettingsValue);
            if (parameters.getDnsSettings().getDomainNameLabel() != null) {
                dnsSettingsValue.put("domainNameLabel", parameters.getDnsSettings().getDomainNameLabel());
            }
            if (parameters.getDnsSettings().getFqdn() != null) {
                dnsSettingsValue.put("fqdn", parameters.getDnsSettings().getFqdn());
            }
            if (parameters.getDnsSettings().getReverseFqdn() != null) {
                dnsSettingsValue.put("reverseFqdn", parameters.getDnsSettings().getReverseFqdn());
            }
        }
        if (parameters.getIpAddress() != null) {
            propertiesValue.put("ipAddress", parameters.getIpAddress());
        }
        if (parameters.getIdleTimeoutInMinutes() != null) {
            propertiesValue.put("idleTimeoutInMinutes", parameters.getIdleTimeoutInMinutes());
        }
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            publicIpAddressJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            publicIpAddressJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            publicIpAddressJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            publicIpAddressJsonFormatValue.put("type", parameters.getType());
        }
        publicIpAddressJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            publicIpAddressJsonFormatValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            PublicIpAddressPutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new PublicIpAddressPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue;
                    JsonNode idValue2;
                    JsonNode etagValue;
                    PublicIpAddress publicIpAddressInstance = new PublicIpAddress();
                    result.setPublicIpAddress(publicIpAddressInstance);
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode provisioningStateValue;
                        JsonNode idleTimeoutInMinutesValue;
                        JsonNode ipAddressValue;
                        JsonNode dnsSettingsValue2;
                        JsonNode ipConfigurationValue2;
                        JsonNode publicIPAllocationMethodValue = propertiesValue2.get("publicIPAllocationMethod");
                        if (publicIPAllocationMethodValue != null && !(publicIPAllocationMethodValue instanceof NullNode)) {
                            String publicIPAllocationMethodInstance = publicIPAllocationMethodValue.getTextValue();
                            publicIpAddressInstance.setPublicIpAllocationMethod(publicIPAllocationMethodInstance);
                        }
                        if ((ipConfigurationValue2 = propertiesValue2.get("ipConfiguration")) != null && !(ipConfigurationValue2 instanceof NullNode)) {
                            ResourceId ipConfigurationInstance = new ResourceId();
                            publicIpAddressInstance.setIpConfiguration(ipConfigurationInstance);
                            JsonNode idValue = ipConfigurationValue2.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                ipConfigurationInstance.setId(idInstance);
                            }
                        }
                        if ((dnsSettingsValue2 = propertiesValue2.get("dnsSettings")) != null && !(dnsSettingsValue2 instanceof NullNode)) {
                            JsonNode reverseFqdnValue;
                            JsonNode fqdnValue;
                            PublicIpAddressDnsSettings dnsSettingsInstance = new PublicIpAddressDnsSettings();
                            publicIpAddressInstance.setDnsSettings(dnsSettingsInstance);
                            JsonNode domainNameLabelValue = dnsSettingsValue2.get("domainNameLabel");
                            if (domainNameLabelValue != null && !(domainNameLabelValue instanceof NullNode)) {
                                String domainNameLabelInstance = domainNameLabelValue.getTextValue();
                                dnsSettingsInstance.setDomainNameLabel(domainNameLabelInstance);
                            }
                            if ((fqdnValue = dnsSettingsValue2.get("fqdn")) != null && !(fqdnValue instanceof NullNode)) {
                                String fqdnInstance = fqdnValue.getTextValue();
                                dnsSettingsInstance.setFqdn(fqdnInstance);
                            }
                            if ((reverseFqdnValue = dnsSettingsValue2.get("reverseFqdn")) != null && !(reverseFqdnValue instanceof NullNode)) {
                                String reverseFqdnInstance = reverseFqdnValue.getTextValue();
                                dnsSettingsInstance.setReverseFqdn(reverseFqdnInstance);
                            }
                        }
                        if ((ipAddressValue = propertiesValue2.get("ipAddress")) != null && !(ipAddressValue instanceof NullNode)) {
                            String ipAddressInstance = ipAddressValue.getTextValue();
                            publicIpAddressInstance.setIpAddress(ipAddressInstance);
                        }
                        if ((idleTimeoutInMinutesValue = propertiesValue2.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue instanceof NullNode)) {
                            int idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                            publicIpAddressInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                        }
                        if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            publicIpAddressInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    if ((etagValue = responseDoc.get("etag")) != null && !(etagValue instanceof NullNode)) {
                        String etagInstance = etagValue.getTextValue();
                        publicIpAddressInstance.setEtag(etagInstance);
                    }
                    if ((idValue2 = responseDoc.get("id")) != null && !(idValue2 instanceof NullNode)) {
                        String idInstance2 = idValue2.getTextValue();
                        publicIpAddressInstance.setId(idInstance2);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        publicIpAddressInstance.setName(nameInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        publicIpAddressInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        publicIpAddressInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            publicIpAddressInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            PublicIpAddressPutResponse publicIpAddressPutResponse = result;
            return publicIpAddressPutResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String publicIpAddressName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return PublicIpAddressOperationsImpl.this.beginDeleting(resourceGroupName, publicIpAddressName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String publicIpAddressName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (publicIpAddressName == null) {
            throw new NullPointerException("publicIpAddressName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses/";
        url = url + URLEncoder.encode(publicIpAddressName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String publicIpAddressName, final PublicIpAddress parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return PublicIpAddressOperationsImpl.this.createOrUpdate(resourceGroupName, publicIpAddressName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String publicIpAddressName, PublicIpAddress parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            PublicIpAddressPutResponse response = client2.getPublicIpAddressesOperations().beginCreateOrUpdatingAsync(resourceGroupName, publicIpAddressName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String publicIpAddressName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return PublicIpAddressOperationsImpl.this.delete(resourceGroupName, publicIpAddressName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String publicIpAddressName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getPublicIpAddressesOperations().beginDeletingAsync(resourceGroupName, publicIpAddressName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<PublicIpAddressGetResponse> getAsync(final String resourceGroupName, final String publicIpAddressName) {
        return this.getClient().getExecutorService().submit(new Callable<PublicIpAddressGetResponse>(){

            @Override
            public PublicIpAddressGetResponse call() throws Exception {
                return PublicIpAddressOperationsImpl.this.get(resourceGroupName, publicIpAddressName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicIpAddressGetResponse get(String resourceGroupName, String publicIpAddressName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (publicIpAddressName == null) {
            throw new NullPointerException("publicIpAddressName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("publicIpAddressName", publicIpAddressName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses/";
        url = url + URLEncoder.encode(publicIpAddressName, "UTF-8");
        url = url + "/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            PublicIpAddressGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new PublicIpAddressGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue;
                    JsonNode idValue2;
                    JsonNode etagValue;
                    PublicIpAddress publicIpAddressInstance = new PublicIpAddress();
                    result.setPublicIpAddress(publicIpAddressInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue;
                        JsonNode idleTimeoutInMinutesValue;
                        JsonNode ipAddressValue;
                        JsonNode dnsSettingsValue;
                        JsonNode ipConfigurationValue;
                        JsonNode publicIPAllocationMethodValue = propertiesValue.get("publicIPAllocationMethod");
                        if (publicIPAllocationMethodValue != null && !(publicIPAllocationMethodValue instanceof NullNode)) {
                            String publicIPAllocationMethodInstance = publicIPAllocationMethodValue.getTextValue();
                            publicIpAddressInstance.setPublicIpAllocationMethod(publicIPAllocationMethodInstance);
                        }
                        if ((ipConfigurationValue = propertiesValue.get("ipConfiguration")) != null && !(ipConfigurationValue instanceof NullNode)) {
                            ResourceId ipConfigurationInstance = new ResourceId();
                            publicIpAddressInstance.setIpConfiguration(ipConfigurationInstance);
                            JsonNode idValue = ipConfigurationValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                ipConfigurationInstance.setId(idInstance);
                            }
                        }
                        if ((dnsSettingsValue = propertiesValue.get("dnsSettings")) != null && !(dnsSettingsValue instanceof NullNode)) {
                            JsonNode reverseFqdnValue;
                            JsonNode fqdnValue;
                            PublicIpAddressDnsSettings dnsSettingsInstance = new PublicIpAddressDnsSettings();
                            publicIpAddressInstance.setDnsSettings(dnsSettingsInstance);
                            JsonNode domainNameLabelValue = dnsSettingsValue.get("domainNameLabel");
                            if (domainNameLabelValue != null && !(domainNameLabelValue instanceof NullNode)) {
                                String domainNameLabelInstance = domainNameLabelValue.getTextValue();
                                dnsSettingsInstance.setDomainNameLabel(domainNameLabelInstance);
                            }
                            if ((fqdnValue = dnsSettingsValue.get("fqdn")) != null && !(fqdnValue instanceof NullNode)) {
                                String fqdnInstance = fqdnValue.getTextValue();
                                dnsSettingsInstance.setFqdn(fqdnInstance);
                            }
                            if ((reverseFqdnValue = dnsSettingsValue.get("reverseFqdn")) != null && !(reverseFqdnValue instanceof NullNode)) {
                                String reverseFqdnInstance = reverseFqdnValue.getTextValue();
                                dnsSettingsInstance.setReverseFqdn(reverseFqdnInstance);
                            }
                        }
                        if ((ipAddressValue = propertiesValue.get("ipAddress")) != null && !(ipAddressValue instanceof NullNode)) {
                            String ipAddressInstance = ipAddressValue.getTextValue();
                            publicIpAddressInstance.setIpAddress(ipAddressInstance);
                        }
                        if ((idleTimeoutInMinutesValue = propertiesValue.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue instanceof NullNode)) {
                            int idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                            publicIpAddressInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                        }
                        if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            publicIpAddressInstance.setProvisioningState(provisioningStateInstance);
                        }
                    }
                    if ((etagValue = responseDoc.get("etag")) != null && !(etagValue instanceof NullNode)) {
                        String etagInstance = etagValue.getTextValue();
                        publicIpAddressInstance.setEtag(etagInstance);
                    }
                    if ((idValue2 = responseDoc.get("id")) != null && !(idValue2 instanceof NullNode)) {
                        String idInstance2 = idValue2.getTextValue();
                        publicIpAddressInstance.setId(idInstance2);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        publicIpAddressInstance.setName(nameInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        publicIpAddressInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        publicIpAddressInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            publicIpAddressInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            PublicIpAddressGetResponse publicIpAddressGetResponse = result;
            return publicIpAddressGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<PublicIpAddressListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<PublicIpAddressListResponse>(){

            @Override
            public PublicIpAddressListResponse call() throws Exception {
                return PublicIpAddressOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicIpAddressListResponse list(String resourceGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            PublicIpAddressListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new PublicIpAddressListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue;
                            JsonNode idValue2;
                            JsonNode etagValue;
                            PublicIpAddress publicIpAddressJsonFormatInstance = new PublicIpAddress();
                            result.getPublicIpAddresses().add(publicIpAddressJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue;
                                JsonNode idleTimeoutInMinutesValue;
                                JsonNode ipAddressValue;
                                JsonNode dnsSettingsValue;
                                JsonNode ipConfigurationValue;
                                JsonNode publicIPAllocationMethodValue = propertiesValue.get("publicIPAllocationMethod");
                                if (publicIPAllocationMethodValue != null && !(publicIPAllocationMethodValue instanceof NullNode)) {
                                    String publicIPAllocationMethodInstance = publicIPAllocationMethodValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setPublicIpAllocationMethod(publicIPAllocationMethodInstance);
                                }
                                if ((ipConfigurationValue = propertiesValue.get("ipConfiguration")) != null && !(ipConfigurationValue instanceof NullNode)) {
                                    ResourceId ipConfigurationInstance = new ResourceId();
                                    publicIpAddressJsonFormatInstance.setIpConfiguration(ipConfigurationInstance);
                                    JsonNode idValue = ipConfigurationValue.get("id");
                                    if (idValue != null && !(idValue instanceof NullNode)) {
                                        String idInstance = idValue.getTextValue();
                                        ipConfigurationInstance.setId(idInstance);
                                    }
                                }
                                if ((dnsSettingsValue = propertiesValue.get("dnsSettings")) != null && !(dnsSettingsValue instanceof NullNode)) {
                                    JsonNode reverseFqdnValue;
                                    JsonNode fqdnValue;
                                    PublicIpAddressDnsSettings dnsSettingsInstance = new PublicIpAddressDnsSettings();
                                    publicIpAddressJsonFormatInstance.setDnsSettings(dnsSettingsInstance);
                                    JsonNode domainNameLabelValue = dnsSettingsValue.get("domainNameLabel");
                                    if (domainNameLabelValue != null && !(domainNameLabelValue instanceof NullNode)) {
                                        String domainNameLabelInstance = domainNameLabelValue.getTextValue();
                                        dnsSettingsInstance.setDomainNameLabel(domainNameLabelInstance);
                                    }
                                    if ((fqdnValue = dnsSettingsValue.get("fqdn")) != null && !(fqdnValue instanceof NullNode)) {
                                        String fqdnInstance = fqdnValue.getTextValue();
                                        dnsSettingsInstance.setFqdn(fqdnInstance);
                                    }
                                    if ((reverseFqdnValue = dnsSettingsValue.get("reverseFqdn")) != null && !(reverseFqdnValue instanceof NullNode)) {
                                        String reverseFqdnInstance = reverseFqdnValue.getTextValue();
                                        dnsSettingsInstance.setReverseFqdn(reverseFqdnInstance);
                                    }
                                }
                                if ((ipAddressValue = propertiesValue.get("ipAddress")) != null && !(ipAddressValue instanceof NullNode)) {
                                    String ipAddressInstance = ipAddressValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setIpAddress(ipAddressInstance);
                                }
                                if ((idleTimeoutInMinutesValue = propertiesValue.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue instanceof NullNode)) {
                                    int idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                    publicIpAddressJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                }
                                if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                    String provisioningStateInstance = provisioningStateValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            if ((etagValue = valueValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                String etagInstance = etagValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setEtag(etagInstance);
                            }
                            if ((idValue2 = valueValue.get("id")) != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                publicIpAddressJsonFormatInstance.setId(idInstance2);
                            }
                            if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setName(nameInstance);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                publicIpAddressJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            PublicIpAddressListResponse publicIpAddressListResponse = result;
            return publicIpAddressListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<PublicIpAddressListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<PublicIpAddressListResponse>(){

            @Override
            public PublicIpAddressListResponse call() throws Exception {
                return PublicIpAddressOperationsImpl.this.listAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicIpAddressListResponse listAll() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/publicIPAddresses";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            PublicIpAddressListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new PublicIpAddressListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue;
                            JsonNode idValue2;
                            JsonNode etagValue;
                            PublicIpAddress publicIpAddressJsonFormatInstance = new PublicIpAddress();
                            result.getPublicIpAddresses().add(publicIpAddressJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue;
                                JsonNode idleTimeoutInMinutesValue;
                                JsonNode ipAddressValue;
                                JsonNode dnsSettingsValue;
                                JsonNode ipConfigurationValue;
                                JsonNode publicIPAllocationMethodValue = propertiesValue.get("publicIPAllocationMethod");
                                if (publicIPAllocationMethodValue != null && !(publicIPAllocationMethodValue instanceof NullNode)) {
                                    String publicIPAllocationMethodInstance = publicIPAllocationMethodValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setPublicIpAllocationMethod(publicIPAllocationMethodInstance);
                                }
                                if ((ipConfigurationValue = propertiesValue.get("ipConfiguration")) != null && !(ipConfigurationValue instanceof NullNode)) {
                                    ResourceId ipConfigurationInstance = new ResourceId();
                                    publicIpAddressJsonFormatInstance.setIpConfiguration(ipConfigurationInstance);
                                    JsonNode idValue = ipConfigurationValue.get("id");
                                    if (idValue != null && !(idValue instanceof NullNode)) {
                                        String idInstance = idValue.getTextValue();
                                        ipConfigurationInstance.setId(idInstance);
                                    }
                                }
                                if ((dnsSettingsValue = propertiesValue.get("dnsSettings")) != null && !(dnsSettingsValue instanceof NullNode)) {
                                    JsonNode reverseFqdnValue;
                                    JsonNode fqdnValue;
                                    PublicIpAddressDnsSettings dnsSettingsInstance = new PublicIpAddressDnsSettings();
                                    publicIpAddressJsonFormatInstance.setDnsSettings(dnsSettingsInstance);
                                    JsonNode domainNameLabelValue = dnsSettingsValue.get("domainNameLabel");
                                    if (domainNameLabelValue != null && !(domainNameLabelValue instanceof NullNode)) {
                                        String domainNameLabelInstance = domainNameLabelValue.getTextValue();
                                        dnsSettingsInstance.setDomainNameLabel(domainNameLabelInstance);
                                    }
                                    if ((fqdnValue = dnsSettingsValue.get("fqdn")) != null && !(fqdnValue instanceof NullNode)) {
                                        String fqdnInstance = fqdnValue.getTextValue();
                                        dnsSettingsInstance.setFqdn(fqdnInstance);
                                    }
                                    if ((reverseFqdnValue = dnsSettingsValue.get("reverseFqdn")) != null && !(reverseFqdnValue instanceof NullNode)) {
                                        String reverseFqdnInstance = reverseFqdnValue.getTextValue();
                                        dnsSettingsInstance.setReverseFqdn(reverseFqdnInstance);
                                    }
                                }
                                if ((ipAddressValue = propertiesValue.get("ipAddress")) != null && !(ipAddressValue instanceof NullNode)) {
                                    String ipAddressInstance = ipAddressValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setIpAddress(ipAddressInstance);
                                }
                                if ((idleTimeoutInMinutesValue = propertiesValue.get("idleTimeoutInMinutes")) != null && !(idleTimeoutInMinutesValue instanceof NullNode)) {
                                    int idleTimeoutInMinutesInstance = idleTimeoutInMinutesValue.getIntValue();
                                    publicIpAddressJsonFormatInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                }
                                if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                    String provisioningStateInstance = provisioningStateValue.getTextValue();
                                    publicIpAddressJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                }
                            }
                            if ((etagValue = valueValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                String etagInstance = etagValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setEtag(etagInstance);
                            }
                            if ((idValue2 = valueValue.get("id")) != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                publicIpAddressJsonFormatInstance.setId(idInstance2);
                            }
                            if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setName(nameInstance);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                publicIpAddressJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                publicIpAddressJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            PublicIpAddressListResponse publicIpAddressListResponse = result;
            return publicIpAddressListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

