/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.NetworkResourceProviderClientImpl;
import com.microsoft.azure.management.network.VirtualNetworkOperations;
import com.microsoft.azure.management.network.models.AddressSpace;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.DhcpOptions;
import com.microsoft.azure.management.network.models.Error;
import com.microsoft.azure.management.network.models.ErrorDetails;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.Subnet;
import com.microsoft.azure.management.network.models.UpdateOperationResponse;
import com.microsoft.azure.management.network.models.VirtualNetwork;
import com.microsoft.azure.management.network.models.VirtualNetworkGetResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkListResponse;
import com.microsoft.azure.management.network.models.VirtualNetworkPutResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class VirtualNetworkOperationsImpl
implements ServiceOperations<NetworkResourceProviderClientImpl>,
VirtualNetworkOperations {
    private NetworkResourceProviderClientImpl client;

    VirtualNetworkOperationsImpl(NetworkResourceProviderClientImpl client) {
        this.client = client;
    }

    public NetworkResourceProviderClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<VirtualNetworkPutResponse> beginCreateOrUpdatingAsync(final String resourceGroupName, final String virtualNetworkName, final VirtualNetwork parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkPutResponse>(){

            @Override
            public VirtualNetworkPutResponse call() throws Exception {
                return VirtualNetworkOperationsImpl.this.beginCreateOrUpdating(resourceGroupName, virtualNetworkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkPutResponse beginCreateOrUpdating(String resourceGroupName, String virtualNetworkName, VirtualNetwork parameters) throws IOException, ServiceException {
        VirtualNetworkPutResponse virtualNetworkPutResponse;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode virtualNetworkJsonFormatValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getSubnets() != null) {
            for (Subnet subnetsParameterItem : parameters.getSubnets()) {
                if (subnetsParameterItem.getAddressPrefix() != null) continue;
                throw new NullPointerException("parameters.Subnets.AddressPrefix");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = virtualNetworkJsonFormatValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        virtualNetworkJsonFormatValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getAddressSpace() != null) {
            ObjectNode addressSpaceValue = objectMapper.createObjectNode();
            propertiesValue.put("addressSpace", (JsonNode)addressSpaceValue);
            if (parameters.getAddressSpace().getAddressPrefixes() != null && (!(parameters.getAddressSpace().getAddressPrefixes() instanceof LazyCollection) || ((LazyCollection)parameters.getAddressSpace().getAddressPrefixes()).isInitialized())) {
                ArrayNode addressPrefixesArray = objectMapper.createArrayNode();
                for (String addressPrefixesItem : parameters.getAddressSpace().getAddressPrefixes()) {
                    addressPrefixesArray.add(addressPrefixesItem);
                }
                addressSpaceValue.put("addressPrefixes", (JsonNode)addressPrefixesArray);
            }
        }
        if (parameters.getDhcpOptions() != null) {
            ObjectNode dhcpOptionsValue = objectMapper.createObjectNode();
            propertiesValue.put("dhcpOptions", (JsonNode)dhcpOptionsValue);
            if (parameters.getDhcpOptions().getDnsServers() != null && (!(parameters.getDhcpOptions().getDnsServers() instanceof LazyCollection) || ((LazyCollection)parameters.getDhcpOptions().getDnsServers()).isInitialized())) {
                ArrayNode dnsServersArray = objectMapper.createArrayNode();
                for (String dnsServersItem : parameters.getDhcpOptions().getDnsServers()) {
                    dnsServersArray.add(dnsServersItem);
                }
                dhcpOptionsValue.put("dnsServers", (JsonNode)dnsServersArray);
            }
        }
        if (parameters.getSubnets() != null && (!(parameters.getSubnets() instanceof LazyCollection) || ((LazyCollection)parameters.getSubnets()).isInitialized())) {
            ArrayNode subnetsArray = objectMapper.createArrayNode();
            for (Subnet subnet : parameters.getSubnets()) {
                ObjectNode subnetJsonFormatValue = objectMapper.createObjectNode();
                subnetsArray.add((JsonNode)subnetJsonFormatValue);
                ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                subnetJsonFormatValue.put("properties", (JsonNode)propertiesValue2);
                propertiesValue2.put("addressPrefix", subnet.getAddressPrefix());
                if (subnet.getNetworkSecurityGroup() != null) {
                    ObjectNode networkSecurityGroupValue = objectMapper.createObjectNode();
                    propertiesValue2.put("networkSecurityGroup", (JsonNode)networkSecurityGroupValue);
                    if (subnet.getNetworkSecurityGroup().getId() != null) {
                        networkSecurityGroupValue.put("id", subnet.getNetworkSecurityGroup().getId());
                    }
                }
                if (subnet.getRouteTable() != null) {
                    ObjectNode routeTableValue = objectMapper.createObjectNode();
                    propertiesValue2.put("routeTable", (JsonNode)routeTableValue);
                    if (subnet.getRouteTable().getId() != null) {
                        routeTableValue.put("id", subnet.getRouteTable().getId());
                    }
                }
                if (subnet.getIpConfigurations() != null && (!(subnet.getIpConfigurations() instanceof LazyCollection) || ((LazyCollection)subnet.getIpConfigurations()).isInitialized())) {
                    ArrayNode ipConfigurationsArray = objectMapper.createArrayNode();
                    for (ResourceId ipConfigurationsItem : subnet.getIpConfigurations()) {
                        ObjectNode resourceIdValue = objectMapper.createObjectNode();
                        ipConfigurationsArray.add((JsonNode)resourceIdValue);
                        if (ipConfigurationsItem.getId() == null) continue;
                        resourceIdValue.put("id", ipConfigurationsItem.getId());
                    }
                    propertiesValue2.put("ipConfigurations", (JsonNode)ipConfigurationsArray);
                }
                if (subnet.getProvisioningState() != null) {
                    propertiesValue2.put("provisioningState", subnet.getProvisioningState());
                }
                if (subnet.getName() != null) {
                    subnetJsonFormatValue.put("name", subnet.getName());
                }
                if (subnet.getEtag() != null) {
                    subnetJsonFormatValue.put("etag", subnet.getEtag());
                }
                if (subnet.getId() == null) continue;
                subnetJsonFormatValue.put("id", subnet.getId());
            }
            propertiesValue.put("subnets", (JsonNode)subnetsArray);
        }
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getEtag() != null) {
            virtualNetworkJsonFormatValue.put("etag", parameters.getEtag());
        }
        if (parameters.getId() != null) {
            virtualNetworkJsonFormatValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            virtualNetworkJsonFormatValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            virtualNetworkJsonFormatValue.put("type", parameters.getType());
        }
        virtualNetworkJsonFormatValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            virtualNetworkJsonFormatValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var17_25 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkPutResponse result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                result = new VirtualNetworkPutResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode errorValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue5;
                    JsonNode etagValue2;
                    VirtualNetwork virtualNetworkInstance = new VirtualNetwork();
                    result.setVirtualNetwork(virtualNetworkInstance);
                    JsonNode propertiesValue3 = responseDoc.get("properties");
                    if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                        JsonNode provisioningStateValue2;
                        JsonNode subnetsArray2;
                        JsonNode dhcpOptionsValue2;
                        JsonNode addressSpaceValue2 = propertiesValue3.get("addressSpace");
                        if (addressSpaceValue2 != null && !(addressSpaceValue2 instanceof NullNode)) {
                            AddressSpace addressSpaceInstance = new AddressSpace();
                            virtualNetworkInstance.setAddressSpace(addressSpaceInstance);
                            JsonNode addressPrefixesArray2 = addressSpaceValue2.get("addressPrefixes");
                            if (addressPrefixesArray2 != null && !(addressPrefixesArray2 instanceof NullNode)) {
                                for (Iterator addressPrefixesValue : (ArrayNode)addressPrefixesArray2) {
                                    addressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                }
                            }
                        }
                        if ((dhcpOptionsValue2 = propertiesValue3.get("dhcpOptions")) != null && !(dhcpOptionsValue2 instanceof NullNode)) {
                            DhcpOptions dhcpOptionsInstance = new DhcpOptions();
                            virtualNetworkInstance.setDhcpOptions(dhcpOptionsInstance);
                            Iterator dnsServersArray2 = dhcpOptionsValue2.get("dnsServers");
                            if (dnsServersArray2 != null && !(dnsServersArray2 instanceof NullNode)) {
                                for (JsonNode dnsServersValue : (ArrayNode)dnsServersArray2) {
                                    dhcpOptionsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                }
                            }
                        }
                        if ((subnetsArray2 = propertiesValue3.get("subnets")) != null && !(subnetsArray2 instanceof NullNode)) {
                            for (JsonNode subnetsValue : (ArrayNode)subnetsArray2) {
                                JsonNode idValue4;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                Subnet subnetJsonFormatInstance = new Subnet();
                                virtualNetworkInstance.getSubnets().add(subnetJsonFormatInstance);
                                JsonNode propertiesValue4 = subnetsValue.get("properties");
                                if (propertiesValue4 != null && !(propertiesValue4 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode ipConfigurationsArray2;
                                    JsonNode routeTableValue2;
                                    JsonNode networkSecurityGroupValue2;
                                    JsonNode addressPrefixValue = propertiesValue4.get("addressPrefix");
                                    if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                        String addressPrefixInstance = addressPrefixValue.getTextValue();
                                        subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                    }
                                    if ((networkSecurityGroupValue2 = propertiesValue4.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue2 instanceof NullNode)) {
                                        ResourceId networkSecurityGroupInstance = new ResourceId();
                                        subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                        JsonNode idValue = networkSecurityGroupValue2.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            networkSecurityGroupInstance.setId(idInstance);
                                        }
                                    }
                                    if ((routeTableValue2 = propertiesValue4.get("routeTable")) != null && !(routeTableValue2 instanceof NullNode)) {
                                        ResourceId routeTableInstance = new ResourceId();
                                        subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                        Iterator idValue2 = routeTableValue2.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            routeTableInstance.setId(idInstance2);
                                        }
                                    }
                                    if ((ipConfigurationsArray2 = propertiesValue4.get("ipConfigurations")) != null && !(ipConfigurationsArray2 instanceof NullNode)) {
                                        for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray2) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                            JsonNode idValue3 = ipConfigurationsValue.get("id");
                                            if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                            String idInstance3 = idValue3.getTextValue();
                                            resourceIdInstance.setId(idInstance3);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = subnetsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    subnetJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = subnetsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    subnetJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue4 = subnetsValue.get("id")) == null || idValue4 instanceof NullNode) continue;
                                String idInstance4 = idValue4.getTextValue();
                                subnetJsonFormatInstance.setId(idInstance4);
                            }
                        }
                        if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    if ((etagValue2 = responseDoc.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                        String etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkInstance.setEtag(etagInstance2);
                    }
                    if ((idValue5 = responseDoc.get("id")) != null && !(idValue5 instanceof NullNode)) {
                        String idInstance5 = idValue5.getTextValue();
                        virtualNetworkInstance.setId(idInstance5);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        virtualNetworkInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualNetworkInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            virtualNetworkInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((errorValue = responseDoc.get("error")) != null && !(errorValue instanceof NullNode)) {
                        JsonNode innerErrorValue;
                        JsonNode detailsArray;
                        JsonNode targetValue;
                        JsonNode messageValue;
                        Error errorInstance = new Error();
                        result.setError(errorInstance);
                        JsonNode codeValue = errorValue.get("code");
                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                            String codeInstance = codeValue.getTextValue();
                            errorInstance.setCode(codeInstance);
                        }
                        if ((messageValue = errorValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                            String messageInstance = messageValue.getTextValue();
                            errorInstance.setMessage(messageInstance);
                        }
                        if ((targetValue = errorValue.get("target")) != null && !(targetValue instanceof NullNode)) {
                            String targetInstance = targetValue.getTextValue();
                            errorInstance.setTarget(targetInstance);
                        }
                        if ((detailsArray = errorValue.get("details")) != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                JsonNode messageValue2;
                                JsonNode targetValue2;
                                ErrorDetails errorDetailsInstance = new ErrorDetails();
                                errorInstance.getDetails().add(errorDetailsInstance);
                                JsonNode codeValue2 = detailsValue.get("code");
                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                    String codeInstance2 = codeValue2.getTextValue();
                                    errorDetailsInstance.setCode(codeInstance2);
                                }
                                if ((targetValue2 = detailsValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                                    String targetInstance2 = targetValue2.getTextValue();
                                    errorDetailsInstance.setTarget(targetInstance2);
                                }
                                if ((messageValue2 = detailsValue.get("message")) == null || messageValue2 instanceof NullNode) continue;
                                String messageInstance2 = messageValue2.getTextValue();
                                errorDetailsInstance.setMessage(messageInstance2);
                            }
                        }
                        if ((innerErrorValue = errorValue.get("innerError")) != null && !(innerErrorValue instanceof NullNode)) {
                            String innerErrorInstance = innerErrorValue.getTextValue();
                            errorInstance.setInnerError(innerErrorInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(closeableHttpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (closeableHttpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)closeableHttpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (closeableHttpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(closeableHttpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            virtualNetworkPutResponse = result;
        }
        catch (Throwable throwable) {
            if (var17_25 != null && var17_25.getEntity() != null) {
                var17_25.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return virtualNetworkPutResponse;
    }

    @Override
    public Future<UpdateOperationResponse> beginDeletingAsync(final String resourceGroupName, final String virtualNetworkName) {
        return this.getClient().getExecutorService().submit(new Callable<UpdateOperationResponse>(){

            @Override
            public UpdateOperationResponse call() throws Exception {
                return VirtualNetworkOperationsImpl.this.beginDeleting(resourceGroupName, virtualNetworkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOperationResponse beginDeleting(String resourceGroupName, String virtualNetworkName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            UpdateOperationResponse result = null;
            result = new UpdateOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("Retry-After").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("Retry-After").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            UpdateOperationResponse updateOperationResponse = result;
            return updateOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AzureAsyncOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String virtualNetworkName, final VirtualNetwork parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AzureAsyncOperationResponse>(){

            @Override
            public AzureAsyncOperationResponse call() throws Exception {
                return VirtualNetworkOperationsImpl.this.createOrUpdate(resourceGroupName, virtualNetworkName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AzureAsyncOperationResponse createOrUpdate(String resourceGroupName, String virtualNetworkName, VirtualNetwork parameters) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            VirtualNetworkPutResponse response = client2.getVirtualNetworksOperations().beginCreateOrUpdatingAsync(resourceGroupName, virtualNetworkName, parameters).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String virtualNetworkName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualNetworkOperationsImpl.this.delete(resourceGroupName, virtualNetworkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String virtualNetworkName) throws InterruptedException, ExecutionException, IOException {
        NetworkResourceProviderClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (NetworkResourceProviderClient)((NetworkResourceProviderClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            UpdateOperationResponse response = client2.getVirtualNetworksOperations().beginDeletingAsync(resourceGroupName, virtualNetworkName).get();
            AzureAsyncOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 30;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != "InProgress")) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 15;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AzureAsyncOperationResponse azureAsyncOperationResponse = result;
            return azureAsyncOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkGetResponse> getAsync(final String resourceGroupName, final String virtualNetworkName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkGetResponse>(){

            @Override
            public VirtualNetworkGetResponse call() throws Exception {
                return VirtualNetworkOperationsImpl.this.get(resourceGroupName, virtualNetworkName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkGetResponse get(String resourceGroupName, String virtualNetworkName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (virtualNetworkName == null) {
            throw new NullPointerException("virtualNetworkName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("virtualNetworkName", virtualNetworkName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks/";
        url = url + URLEncoder.encode(virtualNetworkName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue5;
                    JsonNode etagValue2;
                    VirtualNetwork virtualNetworkInstance = new VirtualNetwork();
                    result.setVirtualNetwork(virtualNetworkInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode provisioningStateValue2;
                        JsonNode subnetsArray;
                        JsonNode dhcpOptionsValue;
                        JsonNode addressSpaceValue = propertiesValue.get("addressSpace");
                        if (addressSpaceValue != null && !(addressSpaceValue instanceof NullNode)) {
                            AddressSpace addressSpaceInstance = new AddressSpace();
                            virtualNetworkInstance.setAddressSpace(addressSpaceInstance);
                            JsonNode addressPrefixesArray = addressSpaceValue.get("addressPrefixes");
                            if (addressPrefixesArray != null && !(addressPrefixesArray instanceof NullNode)) {
                                for (Iterator addressPrefixesValue : (ArrayNode)addressPrefixesArray) {
                                    addressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                }
                            }
                        }
                        if ((dhcpOptionsValue = propertiesValue.get("dhcpOptions")) != null && !(dhcpOptionsValue instanceof NullNode)) {
                            DhcpOptions dhcpOptionsInstance = new DhcpOptions();
                            virtualNetworkInstance.setDhcpOptions(dhcpOptionsInstance);
                            Iterator dnsServersArray = dhcpOptionsValue.get("dnsServers");
                            if (dnsServersArray != null && !(dnsServersArray instanceof NullNode)) {
                                for (JsonNode dnsServersValue : (ArrayNode)dnsServersArray) {
                                    dhcpOptionsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                }
                            }
                        }
                        if ((subnetsArray = propertiesValue.get("subnets")) != null && !(subnetsArray instanceof NullNode)) {
                            for (JsonNode subnetsValue : (ArrayNode)subnetsArray) {
                                JsonNode idValue4;
                                JsonNode etagValue;
                                JsonNode nameValue;
                                Subnet subnetJsonFormatInstance = new Subnet();
                                virtualNetworkInstance.getSubnets().add(subnetJsonFormatInstance);
                                JsonNode propertiesValue2 = subnetsValue.get("properties");
                                if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                    JsonNode provisioningStateValue;
                                    JsonNode ipConfigurationsArray;
                                    JsonNode routeTableValue;
                                    JsonNode networkSecurityGroupValue;
                                    JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                                    if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                        String addressPrefixInstance = addressPrefixValue.getTextValue();
                                        subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                    }
                                    if ((networkSecurityGroupValue = propertiesValue2.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue instanceof NullNode)) {
                                        ResourceId networkSecurityGroupInstance = new ResourceId();
                                        subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                        JsonNode idValue = networkSecurityGroupValue.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            networkSecurityGroupInstance.setId(idInstance);
                                        }
                                    }
                                    if ((routeTableValue = propertiesValue2.get("routeTable")) != null && !(routeTableValue instanceof NullNode)) {
                                        ResourceId routeTableInstance = new ResourceId();
                                        subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                        Iterator idValue2 = routeTableValue.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            routeTableInstance.setId(idInstance2);
                                        }
                                    }
                                    if ((ipConfigurationsArray = propertiesValue2.get("ipConfigurations")) != null && !(ipConfigurationsArray instanceof NullNode)) {
                                        for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                            ResourceId resourceIdInstance = new ResourceId();
                                            subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                            JsonNode idValue3 = ipConfigurationsValue.get("id");
                                            if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                            String idInstance3 = idValue3.getTextValue();
                                            resourceIdInstance.setId(idInstance3);
                                        }
                                    }
                                    if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                                        subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                    }
                                }
                                if ((nameValue = subnetsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    subnetJsonFormatInstance.setName(nameInstance);
                                }
                                if ((etagValue = subnetsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                    String etagInstance = etagValue.getTextValue();
                                    subnetJsonFormatInstance.setEtag(etagInstance);
                                }
                                if ((idValue4 = subnetsValue.get("id")) == null || idValue4 instanceof NullNode) continue;
                                String idInstance4 = idValue4.getTextValue();
                                subnetJsonFormatInstance.setId(idInstance4);
                            }
                        }
                        if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                            virtualNetworkInstance.setProvisioningState(provisioningStateInstance2);
                        }
                    }
                    if ((etagValue2 = responseDoc.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                        String etagInstance2 = etagValue2.getTextValue();
                        virtualNetworkInstance.setEtag(etagInstance2);
                    }
                    if ((idValue5 = responseDoc.get("id")) != null && !(idValue5 instanceof NullNode)) {
                        String idInstance5 = idValue5.getTextValue();
                        virtualNetworkInstance.setId(idInstance5);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        virtualNetworkInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        virtualNetworkInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualNetworkInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            virtualNetworkInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkGetResponse virtualNetworkGetResponse = result;
            return virtualNetworkGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkListResponse>(){

            @Override
            public VirtualNetworkListResponse call() throws Exception {
                return VirtualNetworkOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkListResponse list(String resourceGroupName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue5;
                            JsonNode etagValue2;
                            VirtualNetwork virtualNetworkJsonFormatInstance = new VirtualNetwork();
                            result.getVirtualNetworks().add(virtualNetworkJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue2;
                                JsonNode subnetsArray;
                                JsonNode dhcpOptionsValue;
                                JsonNode addressSpaceValue = propertiesValue.get("addressSpace");
                                if (addressSpaceValue != null && !(addressSpaceValue instanceof NullNode)) {
                                    AddressSpace addressSpaceInstance = new AddressSpace();
                                    virtualNetworkJsonFormatInstance.setAddressSpace(addressSpaceInstance);
                                    JsonNode addressPrefixesArray = addressSpaceValue.get("addressPrefixes");
                                    if (addressPrefixesArray != null && !(addressPrefixesArray instanceof NullNode)) {
                                        for (Iterator addressPrefixesValue : (ArrayNode)addressPrefixesArray) {
                                            addressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                        }
                                    }
                                }
                                if ((dhcpOptionsValue = propertiesValue.get("dhcpOptions")) != null && !(dhcpOptionsValue instanceof NullNode)) {
                                    DhcpOptions dhcpOptionsInstance = new DhcpOptions();
                                    virtualNetworkJsonFormatInstance.setDhcpOptions(dhcpOptionsInstance);
                                    Iterator dnsServersArray = dhcpOptionsValue.get("dnsServers");
                                    if (dnsServersArray != null && !(dnsServersArray instanceof NullNode)) {
                                        Iterator addressPrefixesValue;
                                        addressPrefixesValue = ((ArrayNode)dnsServersArray).iterator();
                                        while (addressPrefixesValue.hasNext()) {
                                            JsonNode dnsServersValue = (JsonNode)addressPrefixesValue.next();
                                            dhcpOptionsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                        }
                                    }
                                }
                                if ((subnetsArray = propertiesValue.get("subnets")) != null && !(subnetsArray instanceof NullNode)) {
                                    for (JsonNode subnetsValue : (ArrayNode)subnetsArray) {
                                        JsonNode idValue4;
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        Subnet subnetJsonFormatInstance = new Subnet();
                                        virtualNetworkJsonFormatInstance.getSubnets().add(subnetJsonFormatInstance);
                                        JsonNode propertiesValue2 = subnetsValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode ipConfigurationsArray;
                                            JsonNode routeTableValue;
                                            JsonNode networkSecurityGroupValue;
                                            JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                                            if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                                String addressPrefixInstance = addressPrefixValue.getTextValue();
                                                subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                            }
                                            if ((networkSecurityGroupValue = propertiesValue2.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue instanceof NullNode)) {
                                                ResourceId networkSecurityGroupInstance = new ResourceId();
                                                subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                                JsonNode idValue = networkSecurityGroupValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    networkSecurityGroupInstance.setId(idInstance);
                                                }
                                            }
                                            if ((routeTableValue = propertiesValue2.get("routeTable")) != null && !(routeTableValue instanceof NullNode)) {
                                                ResourceId routeTableInstance = new ResourceId();
                                                subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                                Iterator idValue2 = routeTableValue.get("id");
                                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                                    String idInstance2 = idValue2.getTextValue();
                                                    routeTableInstance.setId(idInstance2);
                                                }
                                            }
                                            if ((ipConfigurationsArray = propertiesValue2.get("ipConfigurations")) != null && !(ipConfigurationsArray instanceof NullNode)) {
                                                for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                                    JsonNode idValue3 = ipConfigurationsValue.get("id");
                                                    if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                                    String idInstance3 = idValue3.getTextValue();
                                                    resourceIdInstance.setId(idInstance3);
                                                }
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = subnetsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            subnetJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = subnetsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            subnetJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue4 = subnetsValue.get("id")) == null || idValue4 instanceof NullNode) continue;
                                        String idInstance4 = idValue4.getTextValue();
                                        subnetJsonFormatInstance.setId(idInstance4);
                                    }
                                }
                                if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualNetworkJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            if ((etagValue2 = valueValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                String etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkJsonFormatInstance.setEtag(etagInstance2);
                            }
                            if ((idValue5 = valueValue.get("id")) != null && !(idValue5 instanceof NullNode)) {
                                String idInstance5 = idValue5.getTextValue();
                                virtualNetworkJsonFormatInstance.setId(idInstance5);
                            }
                            if ((nameValue2 = valueValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkJsonFormatInstance.setName(nameInstance2);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                virtualNetworkJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                virtualNetworkJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                virtualNetworkJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkListResponse virtualNetworkListResponse = result;
            return virtualNetworkListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualNetworkListResponse> listAllAsync() {
        return this.getClient().getExecutorService().submit(new Callable<VirtualNetworkListResponse>(){

            @Override
            public VirtualNetworkListResponse call() throws Exception {
                return VirtualNetworkOperationsImpl.this.listAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualNetworkListResponse listAll() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/virtualnetworks";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualNetworkListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualNetworkListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue5;
                            JsonNode etagValue2;
                            VirtualNetwork virtualNetworkJsonFormatInstance = new VirtualNetwork();
                            result.getVirtualNetworks().add(virtualNetworkJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode provisioningStateValue2;
                                JsonNode subnetsArray;
                                JsonNode dhcpOptionsValue;
                                JsonNode addressSpaceValue = propertiesValue.get("addressSpace");
                                if (addressSpaceValue != null && !(addressSpaceValue instanceof NullNode)) {
                                    AddressSpace addressSpaceInstance = new AddressSpace();
                                    virtualNetworkJsonFormatInstance.setAddressSpace(addressSpaceInstance);
                                    JsonNode addressPrefixesArray = addressSpaceValue.get("addressPrefixes");
                                    if (addressPrefixesArray != null && !(addressPrefixesArray instanceof NullNode)) {
                                        for (Iterator addressPrefixesValue : (ArrayNode)addressPrefixesArray) {
                                            addressSpaceInstance.getAddressPrefixes().add(addressPrefixesValue.getTextValue());
                                        }
                                    }
                                }
                                if ((dhcpOptionsValue = propertiesValue.get("dhcpOptions")) != null && !(dhcpOptionsValue instanceof NullNode)) {
                                    DhcpOptions dhcpOptionsInstance = new DhcpOptions();
                                    virtualNetworkJsonFormatInstance.setDhcpOptions(dhcpOptionsInstance);
                                    Iterator dnsServersArray = dhcpOptionsValue.get("dnsServers");
                                    if (dnsServersArray != null && !(dnsServersArray instanceof NullNode)) {
                                        Iterator addressPrefixesValue;
                                        addressPrefixesValue = ((ArrayNode)dnsServersArray).iterator();
                                        while (addressPrefixesValue.hasNext()) {
                                            JsonNode dnsServersValue = (JsonNode)addressPrefixesValue.next();
                                            dhcpOptionsInstance.getDnsServers().add(dnsServersValue.getTextValue());
                                        }
                                    }
                                }
                                if ((subnetsArray = propertiesValue.get("subnets")) != null && !(subnetsArray instanceof NullNode)) {
                                    for (JsonNode subnetsValue : (ArrayNode)subnetsArray) {
                                        JsonNode idValue4;
                                        JsonNode etagValue;
                                        JsonNode nameValue;
                                        Subnet subnetJsonFormatInstance = new Subnet();
                                        virtualNetworkJsonFormatInstance.getSubnets().add(subnetJsonFormatInstance);
                                        JsonNode propertiesValue2 = subnetsValue.get("properties");
                                        if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                                            JsonNode provisioningStateValue;
                                            JsonNode ipConfigurationsArray;
                                            JsonNode routeTableValue;
                                            JsonNode networkSecurityGroupValue;
                                            JsonNode addressPrefixValue = propertiesValue2.get("addressPrefix");
                                            if (addressPrefixValue != null && !(addressPrefixValue instanceof NullNode)) {
                                                String addressPrefixInstance = addressPrefixValue.getTextValue();
                                                subnetJsonFormatInstance.setAddressPrefix(addressPrefixInstance);
                                            }
                                            if ((networkSecurityGroupValue = propertiesValue2.get("networkSecurityGroup")) != null && !(networkSecurityGroupValue instanceof NullNode)) {
                                                ResourceId networkSecurityGroupInstance = new ResourceId();
                                                subnetJsonFormatInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                                JsonNode idValue = networkSecurityGroupValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    networkSecurityGroupInstance.setId(idInstance);
                                                }
                                            }
                                            if ((routeTableValue = propertiesValue2.get("routeTable")) != null && !(routeTableValue instanceof NullNode)) {
                                                ResourceId routeTableInstance = new ResourceId();
                                                subnetJsonFormatInstance.setRouteTable(routeTableInstance);
                                                Iterator idValue2 = routeTableValue.get("id");
                                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                                    String idInstance2 = idValue2.getTextValue();
                                                    routeTableInstance.setId(idInstance2);
                                                }
                                            }
                                            if ((ipConfigurationsArray = propertiesValue2.get("ipConfigurations")) != null && !(ipConfigurationsArray instanceof NullNode)) {
                                                for (JsonNode ipConfigurationsValue : (ArrayNode)ipConfigurationsArray) {
                                                    ResourceId resourceIdInstance = new ResourceId();
                                                    subnetJsonFormatInstance.getIpConfigurations().add(resourceIdInstance);
                                                    JsonNode idValue3 = ipConfigurationsValue.get("id");
                                                    if (idValue3 == null || idValue3 instanceof NullNode) continue;
                                                    String idInstance3 = idValue3.getTextValue();
                                                    resourceIdInstance.setId(idInstance3);
                                                }
                                            }
                                            if ((provisioningStateValue = propertiesValue2.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                                subnetJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                                            }
                                        }
                                        if ((nameValue = subnetsValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                            String nameInstance = nameValue.getTextValue();
                                            subnetJsonFormatInstance.setName(nameInstance);
                                        }
                                        if ((etagValue = subnetsValue.get("etag")) != null && !(etagValue instanceof NullNode)) {
                                            String etagInstance = etagValue.getTextValue();
                                            subnetJsonFormatInstance.setEtag(etagInstance);
                                        }
                                        if ((idValue4 = subnetsValue.get("id")) == null || idValue4 instanceof NullNode) continue;
                                        String idInstance4 = idValue4.getTextValue();
                                        subnetJsonFormatInstance.setId(idInstance4);
                                    }
                                }
                                if ((provisioningStateValue2 = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualNetworkJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                                }
                            }
                            if ((etagValue2 = valueValue.get("etag")) != null && !(etagValue2 instanceof NullNode)) {
                                String etagInstance2 = etagValue2.getTextValue();
                                virtualNetworkJsonFormatInstance.setEtag(etagInstance2);
                            }
                            if ((idValue5 = valueValue.get("id")) != null && !(idValue5 instanceof NullNode)) {
                                String idInstance5 = idValue5.getTextValue();
                                virtualNetworkJsonFormatInstance.setId(idInstance5);
                            }
                            if ((nameValue2 = valueValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                virtualNetworkJsonFormatInstance.setName(nameInstance2);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                virtualNetworkJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                virtualNetworkJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                virtualNetworkJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualNetworkListResponse virtualNetworkListResponse = result;
            return virtualNetworkListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

