/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewaySkuName;
import com.microsoft.azure.management.network.ApplicationGateways;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewaysInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.fluentcore.utils.RXMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import rx.Observable;

@LangDefinition
class ApplicationGatewaysImpl
extends TopLevelModifiableResourcesImpl<ApplicationGateway, ApplicationGatewayImpl, ApplicationGatewayInner, ApplicationGatewaysInner, NetworkManager>
implements ApplicationGateways {
    ApplicationGatewaysImpl(NetworkManager networkManager) {
        super((InnerSupportsListing)((NetworkManagementClientImpl)((Object)networkManager.inner())).applicationGateways(), (ManagerBase)networkManager);
    }

    public ApplicationGatewayImpl define(String name) {
        return this.wrapModel(name).withSize(ApplicationGatewaySkuName.STANDARD_SMALL).withInstanceCount(1);
    }

    protected ApplicationGatewayImpl wrapModel(String name) {
        ApplicationGatewayInner inner = new ApplicationGatewayInner();
        return new ApplicationGatewayImpl(name, inner, (NetworkManager)this.manager());
    }

    protected ApplicationGatewayImpl wrapModel(ApplicationGatewayInner inner) {
        return inner == null ? null : new ApplicationGatewayImpl(inner.name(), inner, (NetworkManager)this.manager());
    }

    @Override
    public void start(String ... applicationGatewayResourceId) {
        if (applicationGatewayResourceId == null) {
            return;
        }
        this.startAsync(applicationGatewayResourceId).toBlocking().last();
    }

    @Override
    public Observable<String> startAsync(String ... applicationGatewayResourceId) {
        return this.startAsync(new ArrayList<String>(Arrays.asList(applicationGatewayResourceId)));
    }

    @Override
    public void stop(String ... applicationGatewayResourceIds) {
        if (applicationGatewayResourceIds == null) {
            return;
        }
        this.stopAsync(applicationGatewayResourceIds).toBlocking().last();
    }

    @Override
    public void start(Collection<String> applicationGatewayResourceIds) {
        this.startAsync(applicationGatewayResourceIds).toBlocking().last();
    }

    @Override
    public void stop(Collection<String> applicationGatewayResourceIds) {
        this.stopAsync(applicationGatewayResourceIds).toBlocking().last();
    }

    @Override
    public Observable<String> stopAsync(String ... applicationGatewayResourceIds) {
        return this.stopAsync(new ArrayList<String>(Arrays.asList(applicationGatewayResourceIds)));
    }

    @Override
    public Observable<String> startAsync(Collection<String> applicationGatewayResourceIds) {
        if (applicationGatewayResourceIds == null) {
            return Observable.empty();
        }
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (String id : applicationGatewayResourceIds) {
            String resourceGroupName = ResourceUtils.groupFromResourceId((String)id);
            String name = ResourceUtils.nameFromResourceId((String)id);
            Observable o = RXMapper.map(((ApplicationGatewaysInner)this.inner()).startAsync(resourceGroupName, name), (Object)id);
            observables.add(o);
        }
        return Observable.mergeDelayError(observables);
    }

    @Override
    public Observable<String> stopAsync(Collection<String> applicationGatewayResourceIds) {
        if (applicationGatewayResourceIds == null) {
            Observable.empty();
        }
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (String id : applicationGatewayResourceIds) {
            String resourceGroupName = ResourceUtils.groupFromResourceId((String)id);
            String name = ResourceUtils.nameFromResourceId((String)id);
            Observable o = RXMapper.map(((ApplicationGatewaysInner)this.inner()).stopAsync(resourceGroupName, name), (Object)id);
            observables.add(o);
        }
        return Observable.mergeDelayError(observables);
    }
}

