/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.DeploymentOperationOperations;
import com.microsoft.azure.management.resources.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.models.DeploymentOperation;
import com.microsoft.azure.management.resources.models.DeploymentOperationProperties;
import com.microsoft.azure.management.resources.models.DeploymentOperationsGetResult;
import com.microsoft.azure.management.resources.models.DeploymentOperationsListParameters;
import com.microsoft.azure.management.resources.models.DeploymentOperationsListResult;
import com.microsoft.azure.management.resources.models.TargetResource;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class DeploymentOperationOperationsImpl
implements ServiceOperations<ResourceManagementClientImpl>,
DeploymentOperationOperations {
    private ResourceManagementClientImpl client;

    DeploymentOperationOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }

    public ResourceManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<DeploymentOperationsGetResult> getAsync(final String resourceGroupName, final String deploymentName, final String operationId) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentOperationsGetResult>(){

            @Override
            public DeploymentOperationsGetResult call() throws Exception {
                return DeploymentOperationOperationsImpl.this.get(resourceGroupName, deploymentName, operationId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentOperationsGetResult get(String resourceGroupName, String deploymentName, String operationId) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (operationId == null) {
            throw new NullPointerException("operationId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("operationId", operationId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/operations/";
        url = url + URLEncoder.encode(operationId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentOperationsGetResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentOperationsGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode propertiesValue;
                    JsonNode operationIdValue;
                    DeploymentOperation operationInstance = new DeploymentOperation();
                    result.setOperation(operationInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        operationInstance.setId(idInstance);
                    }
                    if ((operationIdValue = responseDoc.get("operationId")) != null && !(operationIdValue instanceof NullNode)) {
                        String operationIdInstance = operationIdValue.getTextValue();
                        operationInstance.setOperationId(operationIdInstance);
                    }
                    if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode targetResourceValue;
                        JsonNode statusMessageValue;
                        JsonNode statusCodeValue;
                        JsonNode timestampValue;
                        DeploymentOperationProperties propertiesInstance = new DeploymentOperationProperties();
                        operationInstance.setProperties(propertiesInstance);
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((timestampValue = propertiesValue.get("timestamp")) != null && !(timestampValue instanceof NullNode)) {
                            Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampValue.getTextValue());
                            propertiesInstance.setTimestamp(timestampInstance);
                        }
                        if ((statusCodeValue = propertiesValue.get("statusCode")) != null && !(statusCodeValue instanceof NullNode)) {
                            String statusCodeInstance = statusCodeValue.getTextValue();
                            propertiesInstance.setStatusCode(statusCodeInstance);
                        }
                        if ((statusMessageValue = propertiesValue.get("statusMessage")) != null && !(statusMessageValue instanceof NullNode)) {
                            String statusMessageInstance = statusMessageValue.getTextValue();
                            propertiesInstance.setStatusMessage(statusMessageInstance);
                        }
                        if ((targetResourceValue = propertiesValue.get("targetResource")) != null && !(targetResourceValue instanceof NullNode)) {
                            JsonNode resourceTypeValue;
                            JsonNode resourceNameValue;
                            TargetResource targetResourceInstance = new TargetResource();
                            propertiesInstance.setTargetResource(targetResourceInstance);
                            JsonNode idValue2 = targetResourceValue.get("id");
                            if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                targetResourceInstance.setId(idInstance2);
                            }
                            if ((resourceNameValue = targetResourceValue.get("resourceName")) != null && !(resourceNameValue instanceof NullNode)) {
                                String resourceNameInstance = resourceNameValue.getTextValue();
                                targetResourceInstance.setResourceName(resourceNameInstance);
                            }
                            if ((resourceTypeValue = targetResourceValue.get("resourceType")) != null && !(resourceTypeValue instanceof NullNode)) {
                                String resourceTypeInstance = resourceTypeValue.getTextValue();
                                targetResourceInstance.setResourceType(resourceTypeInstance);
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentOperationsGetResult deploymentOperationsGetResult = result;
            return deploymentOperationsGetResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeploymentOperationsListResult> listAsync(final String resourceGroupName, final String deploymentName, final DeploymentOperationsListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentOperationsListResult>(){

            @Override
            public DeploymentOperationsListResult call() throws Exception {
                return DeploymentOperationOperationsImpl.this.list(resourceGroupName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentOperationsListResult list(String resourceGroupName, String deploymentName, DeploymentOperationsListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/operations";
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentOperationsListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentOperationsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode resourceTypeValue;
                            JsonNode resourceNameValue;
                            JsonNode targetResourceValue;
                            JsonNode statusMessageValue;
                            JsonNode statusCodeValue;
                            JsonNode timestampValue;
                            JsonNode propertiesValue;
                            JsonNode operationIdValue;
                            DeploymentOperation deploymentOperationInstance = new DeploymentOperation();
                            result.getOperations().add(deploymentOperationInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                deploymentOperationInstance.setId(idInstance);
                            }
                            if ((operationIdValue = valueValue.get("operationId")) != null && !(operationIdValue instanceof NullNode)) {
                                String operationIdInstance = operationIdValue.getTextValue();
                                deploymentOperationInstance.setOperationId(operationIdInstance);
                            }
                            if ((propertiesValue = valueValue.get("properties")) == null || propertiesValue instanceof NullNode) continue;
                            DeploymentOperationProperties propertiesInstance = new DeploymentOperationProperties();
                            deploymentOperationInstance.setProperties(propertiesInstance);
                            JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                            if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                propertiesInstance.setProvisioningState(provisioningStateInstance);
                            }
                            if ((timestampValue = propertiesValue.get("timestamp")) != null && !(timestampValue instanceof NullNode)) {
                                Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampValue.getTextValue());
                                propertiesInstance.setTimestamp(timestampInstance);
                            }
                            if ((statusCodeValue = propertiesValue.get("statusCode")) != null && !(statusCodeValue instanceof NullNode)) {
                                String statusCodeInstance = statusCodeValue.getTextValue();
                                propertiesInstance.setStatusCode(statusCodeInstance);
                            }
                            if ((statusMessageValue = propertiesValue.get("statusMessage")) != null && !(statusMessageValue instanceof NullNode)) {
                                String statusMessageInstance = statusMessageValue.getTextValue();
                                propertiesInstance.setStatusMessage(statusMessageInstance);
                            }
                            if ((targetResourceValue = propertiesValue.get("targetResource")) == null || targetResourceValue instanceof NullNode) continue;
                            TargetResource targetResourceInstance = new TargetResource();
                            propertiesInstance.setTargetResource(targetResourceInstance);
                            JsonNode idValue2 = targetResourceValue.get("id");
                            if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                targetResourceInstance.setId(idInstance2);
                            }
                            if ((resourceNameValue = targetResourceValue.get("resourceName")) != null && !(resourceNameValue instanceof NullNode)) {
                                String resourceNameInstance = resourceNameValue.getTextValue();
                                targetResourceInstance.setResourceName(resourceNameInstance);
                            }
                            if ((resourceTypeValue = targetResourceValue.get("resourceType")) == null || resourceTypeValue instanceof NullNode) continue;
                            String resourceTypeInstance = resourceTypeValue.getTextValue();
                            targetResourceInstance.setResourceType(resourceTypeInstance);
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentOperationsListResult deploymentOperationsListResult = result;
            return deploymentOperationsListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeploymentOperationsListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentOperationsListResult>(){

            @Override
            public DeploymentOperationsListResult call() throws Exception {
                return DeploymentOperationOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentOperationsListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentOperationsListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentOperationsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode resourceTypeValue;
                            JsonNode resourceNameValue;
                            JsonNode targetResourceValue;
                            JsonNode statusMessageValue;
                            JsonNode statusCodeValue;
                            JsonNode timestampValue;
                            JsonNode propertiesValue;
                            JsonNode operationIdValue;
                            DeploymentOperation deploymentOperationInstance = new DeploymentOperation();
                            result.getOperations().add(deploymentOperationInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                deploymentOperationInstance.setId(idInstance);
                            }
                            if ((operationIdValue = valueValue.get("operationId")) != null && !(operationIdValue instanceof NullNode)) {
                                String operationIdInstance = operationIdValue.getTextValue();
                                deploymentOperationInstance.setOperationId(operationIdInstance);
                            }
                            if ((propertiesValue = valueValue.get("properties")) == null || propertiesValue instanceof NullNode) continue;
                            DeploymentOperationProperties propertiesInstance = new DeploymentOperationProperties();
                            deploymentOperationInstance.setProperties(propertiesInstance);
                            JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                            if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                propertiesInstance.setProvisioningState(provisioningStateInstance);
                            }
                            if ((timestampValue = propertiesValue.get("timestamp")) != null && !(timestampValue instanceof NullNode)) {
                                Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampValue.getTextValue());
                                propertiesInstance.setTimestamp(timestampInstance);
                            }
                            if ((statusCodeValue = propertiesValue.get("statusCode")) != null && !(statusCodeValue instanceof NullNode)) {
                                String statusCodeInstance = statusCodeValue.getTextValue();
                                propertiesInstance.setStatusCode(statusCodeInstance);
                            }
                            if ((statusMessageValue = propertiesValue.get("statusMessage")) != null && !(statusMessageValue instanceof NullNode)) {
                                String statusMessageInstance = statusMessageValue.getTextValue();
                                propertiesInstance.setStatusMessage(statusMessageInstance);
                            }
                            if ((targetResourceValue = propertiesValue.get("targetResource")) == null || targetResourceValue instanceof NullNode) continue;
                            TargetResource targetResourceInstance = new TargetResource();
                            propertiesInstance.setTargetResource(targetResourceInstance);
                            JsonNode idValue2 = targetResourceValue.get("id");
                            if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                targetResourceInstance.setId(idInstance2);
                            }
                            if ((resourceNameValue = targetResourceValue.get("resourceName")) != null && !(resourceNameValue instanceof NullNode)) {
                                String resourceNameInstance = resourceNameValue.getTextValue();
                                targetResourceInstance.setResourceName(resourceNameInstance);
                            }
                            if ((resourceTypeValue = targetResourceValue.get("resourceType")) == null || resourceTypeValue instanceof NullNode) continue;
                            String resourceTypeInstance = resourceTypeValue.getTextValue();
                            targetResourceInstance.setResourceType(resourceTypeInstance);
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentOperationsListResult deploymentOperationsListResult = result;
            return deploymentOperationsListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

