/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.DeploymentOperations;
import com.microsoft.azure.management.resources.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.models.BasicDependency;
import com.microsoft.azure.management.resources.models.Dependency;
import com.microsoft.azure.management.resources.models.Deployment;
import com.microsoft.azure.management.resources.models.DeploymentExtended;
import com.microsoft.azure.management.resources.models.DeploymentGetResult;
import com.microsoft.azure.management.resources.models.DeploymentListParameters;
import com.microsoft.azure.management.resources.models.DeploymentListResult;
import com.microsoft.azure.management.resources.models.DeploymentMode;
import com.microsoft.azure.management.resources.models.DeploymentOperationsCreateResult;
import com.microsoft.azure.management.resources.models.DeploymentPropertiesExtended;
import com.microsoft.azure.management.resources.models.DeploymentValidateResponse;
import com.microsoft.azure.management.resources.models.ParametersLink;
import com.microsoft.azure.management.resources.models.Provider;
import com.microsoft.azure.management.resources.models.ProviderResourceType;
import com.microsoft.azure.management.resources.models.ResourceManagementError;
import com.microsoft.azure.management.resources.models.ResourceManagementErrorWithDetails;
import com.microsoft.azure.management.resources.models.TemplateLink;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class DeploymentOperationsImpl
implements ServiceOperations<ResourceManagementClientImpl>,
DeploymentOperations {
    private ResourceManagementClientImpl client;

    DeploymentOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }

    public ResourceManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> cancelAsync(final String resourceGroupName, final String deploymentName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DeploymentOperationsImpl.this.cancel(resourceGroupName, deploymentName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse cancel(String resourceGroupName, String deploymentName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"cancelAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/cancel";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeploymentOperationsCreateResult> createOrUpdateAsync(final String resourceGroupName, final String deploymentName, final Deployment parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentOperationsCreateResult>(){

            @Override
            public DeploymentOperationsCreateResult call() throws Exception {
                return DeploymentOperationsImpl.this.createOrUpdate(resourceGroupName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentOperationsCreateResult createOrUpdate(String resourceGroupName, String deploymentName, Deployment parameters) throws IOException, ServiceException, URISyntaxException {
        ObjectNode deploymentValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() != null) {
            if (parameters.getProperties().getParametersLink() != null && parameters.getProperties().getParametersLink().getUri() == null) {
                throw new NullPointerException("parameters.Properties.ParametersLink.Uri");
            }
            if (parameters.getProperties().getTemplateLink() != null && parameters.getProperties().getTemplateLink().getUri() == null) {
                throw new NullPointerException("parameters.Properties.TemplateLink.Uri");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = deploymentValue = objectMapper.createObjectNode();
        if (parameters.getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            deploymentValue.put("properties", (JsonNode)propertiesValue);
            if (parameters.getProperties().getTemplate() != null) {
                propertiesValue.put("template", objectMapper.readTree(parameters.getProperties().getTemplate()));
            }
            if (parameters.getProperties().getTemplateLink() != null) {
                ObjectNode templateLinkValue = objectMapper.createObjectNode();
                propertiesValue.put("templateLink", (JsonNode)templateLinkValue);
                templateLinkValue.put("uri", parameters.getProperties().getTemplateLink().getUri().toString());
                if (parameters.getProperties().getTemplateLink().getContentVersion() != null) {
                    templateLinkValue.put("contentVersion", parameters.getProperties().getTemplateLink().getContentVersion());
                }
            }
            if (parameters.getProperties().getParameters() != null) {
                propertiesValue.put("parameters", objectMapper.readTree(parameters.getProperties().getParameters()));
            }
            if (parameters.getProperties().getParametersLink() != null) {
                ObjectNode parametersLinkValue = objectMapper.createObjectNode();
                propertiesValue.put("parametersLink", (JsonNode)parametersLinkValue);
                parametersLinkValue.put("uri", parameters.getProperties().getParametersLink().getUri().toString());
                if (parameters.getProperties().getParametersLink().getContentVersion() != null) {
                    parametersLinkValue.put("contentVersion", parameters.getProperties().getParametersLink().getContentVersion());
                }
            }
            if (parameters.getProperties().getMode() != null) {
                propertiesValue.put("mode", parameters.getProperties().getMode().toString());
            }
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentOperationsCreateResult result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentOperationsCreateResult();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode propertiesValue2;
                    JsonNode nameValue;
                    DeploymentExtended deploymentInstance = new DeploymentExtended();
                    result.setDeployment(deploymentInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        deploymentInstance.setId(idInstance);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        deploymentInstance.setName(nameInstance);
                    }
                    if ((propertiesValue2 = responseDoc.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode modeValue;
                        JsonNode parametersLinkValue2;
                        JsonNode parametersValue;
                        JsonNode templateLinkValue2;
                        JsonNode templateValue;
                        JsonNode dependenciesArray;
                        JsonNode providersArray;
                        JsonNode outputsValue;
                        JsonNode timestampValue;
                        JsonNode correlationIdValue;
                        DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                        deploymentInstance.setProperties(propertiesInstance);
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((correlationIdValue = propertiesValue2.get("correlationId")) != null && !(correlationIdValue instanceof NullNode)) {
                            String correlationIdInstance = correlationIdValue.getTextValue();
                            propertiesInstance.setCorrelationId(correlationIdInstance);
                        }
                        if ((timestampValue = propertiesValue2.get("timestamp")) != null && !(timestampValue instanceof NullNode)) {
                            Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampValue.getTextValue());
                            propertiesInstance.setTimestamp(timestampInstance);
                        }
                        if ((outputsValue = propertiesValue2.get("outputs")) != null && !(outputsValue instanceof NullNode)) {
                            String outputsInstance = outputsValue.getTextValue();
                            propertiesInstance.setOutputs(outputsInstance);
                        }
                        if ((providersArray = propertiesValue2.get("providers")) != null && !(providersArray instanceof NullNode)) {
                            for (Iterator providersValue : (ArrayNode)providersArray) {
                                JsonNode resourceTypesArray;
                                Object registrationStateValue;
                                JsonNode namespaceValue;
                                Provider providerInstance = new Provider();
                                propertiesInstance.getProviders().add(providerInstance);
                                JsonNode idValue2 = providersValue.get("id");
                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                    String idInstance2 = idValue2.getTextValue();
                                    providerInstance.setId(idInstance2);
                                }
                                if ((namespaceValue = providersValue.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                                    String namespaceInstance = namespaceValue.getTextValue();
                                    providerInstance.setNamespace(namespaceInstance);
                                }
                                if ((registrationStateValue = providersValue.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                                    String registrationStateInstance = registrationStateValue.getTextValue();
                                    providerInstance.setRegistrationState(registrationStateInstance);
                                }
                                if ((resourceTypesArray = providersValue.get("resourceTypes")) == null || resourceTypesArray instanceof NullNode) continue;
                                for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                                    JsonNode propertiesSequenceElement;
                                    JsonNode apiVersionsArray;
                                    JsonNode locationsArray;
                                    ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                    providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                    JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                    if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                        String resourceTypeInstance = resourceTypeValue.getTextValue();
                                        providerResourceTypeInstance.setName(resourceTypeInstance);
                                    }
                                    if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                        for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                            providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                        }
                                    }
                                    if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                        Iterator locationsValue;
                                        locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                        while (locationsValue.hasNext()) {
                                            JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                            providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                        }
                                    }
                                    if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                                    Iterator itr = propertiesSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry property = (Map.Entry)itr.next();
                                        String propertiesKey = (String)property.getKey();
                                        String propertiesValue3 = ((JsonNode)property.getValue()).getTextValue();
                                        providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue3);
                                    }
                                }
                            }
                        }
                        if ((dependenciesArray = propertiesValue2.get("dependencies")) != null && !(dependenciesArray instanceof NullNode)) {
                            for (JsonNode dependenciesValue : (ArrayNode)dependenciesArray) {
                                JsonNode resourceNameValue2;
                                JsonNode resourceTypeValue3;
                                JsonNode idValue4;
                                Dependency dependencyInstance = new Dependency();
                                propertiesInstance.getDependencies().add(dependencyInstance);
                                JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                if (dependsOnArray != null && !(dependsOnArray instanceof NullNode)) {
                                    for (JsonNode dependsOnValue : (ArrayNode)dependsOnArray) {
                                        JsonNode resourceNameValue;
                                        JsonNode resourceTypeValue2;
                                        BasicDependency basicDependencyInstance = new BasicDependency();
                                        dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                        JsonNode idValue3 = dependsOnValue.get("id");
                                        if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                            String idInstance3 = idValue3.getTextValue();
                                            basicDependencyInstance.setId(idInstance3);
                                        }
                                        if ((resourceTypeValue2 = dependsOnValue.get("resourceType")) != null && !(resourceTypeValue2 instanceof NullNode)) {
                                            String resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                            basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                        }
                                        if ((resourceNameValue = dependsOnValue.get("resourceName")) == null || resourceNameValue instanceof NullNode) continue;
                                        String resourceNameInstance = resourceNameValue.getTextValue();
                                        basicDependencyInstance.setResourceName(resourceNameInstance);
                                    }
                                }
                                if ((idValue4 = dependenciesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                    String idInstance4 = idValue4.getTextValue();
                                    dependencyInstance.setId(idInstance4);
                                }
                                if ((resourceTypeValue3 = dependenciesValue.get("resourceType")) != null && !(resourceTypeValue3 instanceof NullNode)) {
                                    String resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                    dependencyInstance.setResourceType(resourceTypeInstance3);
                                }
                                if ((resourceNameValue2 = dependenciesValue.get("resourceName")) == null || resourceNameValue2 instanceof NullNode) continue;
                                String resourceNameInstance2 = resourceNameValue2.getTextValue();
                                dependencyInstance.setResourceName(resourceNameInstance2);
                            }
                        }
                        if ((templateValue = propertiesValue2.get("template")) != null && !(templateValue instanceof NullNode)) {
                            String templateInstance = templateValue.getTextValue();
                            propertiesInstance.setTemplate(templateInstance);
                        }
                        if ((templateLinkValue2 = propertiesValue2.get("templateLink")) != null && !(templateLinkValue2 instanceof NullNode)) {
                            JsonNode contentVersionValue;
                            TemplateLink templateLinkInstance = new TemplateLink();
                            propertiesInstance.setTemplateLink(templateLinkInstance);
                            JsonNode uriValue = templateLinkValue2.get("uri");
                            if (uriValue != null && !(uriValue instanceof NullNode)) {
                                URI uriInstance = new URI(uriValue.getTextValue());
                                templateLinkInstance.setUri(uriInstance);
                            }
                            if ((contentVersionValue = templateLinkValue2.get("contentVersion")) != null && !(contentVersionValue instanceof NullNode)) {
                                String contentVersionInstance = contentVersionValue.getTextValue();
                                templateLinkInstance.setContentVersion(contentVersionInstance);
                            }
                        }
                        if ((parametersValue = propertiesValue2.get("parameters")) != null && !(parametersValue instanceof NullNode)) {
                            String parametersInstance = parametersValue.getTextValue();
                            propertiesInstance.setParameters(parametersInstance);
                        }
                        if ((parametersLinkValue2 = propertiesValue2.get("parametersLink")) != null && !(parametersLinkValue2 instanceof NullNode)) {
                            JsonNode contentVersionValue2;
                            ParametersLink parametersLinkInstance = new ParametersLink();
                            propertiesInstance.setParametersLink(parametersLinkInstance);
                            JsonNode uriValue2 = parametersLinkValue2.get("uri");
                            if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                URI uriInstance2 = new URI(uriValue2.getTextValue());
                                parametersLinkInstance.setUri(uriInstance2);
                            }
                            if ((contentVersionValue2 = parametersLinkValue2.get("contentVersion")) != null && !(contentVersionValue2 instanceof NullNode)) {
                                String contentVersionInstance2 = contentVersionValue2.getTextValue();
                                parametersLinkInstance.setContentVersion(contentVersionInstance2);
                            }
                        }
                        if ((modeValue = propertiesValue2.get("mode")) != null && !(modeValue instanceof NullNode)) {
                            DeploymentMode modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue().toUpperCase());
                            propertiesInstance.setMode(modeInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentOperationsCreateResult deploymentOperationsCreateResult = result;
            return deploymentOperationsCreateResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeploymentGetResult> getAsync(final String resourceGroupName, final String deploymentName) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentGetResult>(){

            @Override
            public DeploymentGetResult call() throws Exception {
                return DeploymentOperationsImpl.this.get(resourceGroupName, deploymentName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentGetResult get(String resourceGroupName, String deploymentName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentGetResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode propertiesValue;
                    JsonNode nameValue;
                    DeploymentExtended deploymentInstance = new DeploymentExtended();
                    result.setDeployment(deploymentInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        deploymentInstance.setId(idInstance);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        deploymentInstance.setName(nameInstance);
                    }
                    if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode modeValue;
                        JsonNode parametersLinkValue;
                        JsonNode parametersValue;
                        JsonNode templateLinkValue;
                        JsonNode templateValue;
                        JsonNode dependenciesArray;
                        JsonNode providersArray;
                        JsonNode outputsValue;
                        JsonNode timestampValue;
                        JsonNode correlationIdValue;
                        DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                        deploymentInstance.setProperties(propertiesInstance);
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((correlationIdValue = propertiesValue.get("correlationId")) != null && !(correlationIdValue instanceof NullNode)) {
                            String correlationIdInstance = correlationIdValue.getTextValue();
                            propertiesInstance.setCorrelationId(correlationIdInstance);
                        }
                        if ((timestampValue = propertiesValue.get("timestamp")) != null && !(timestampValue instanceof NullNode)) {
                            Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampValue.getTextValue());
                            propertiesInstance.setTimestamp(timestampInstance);
                        }
                        if ((outputsValue = propertiesValue.get("outputs")) != null && !(outputsValue instanceof NullNode)) {
                            String outputsInstance = outputsValue.getTextValue();
                            propertiesInstance.setOutputs(outputsInstance);
                        }
                        if ((providersArray = propertiesValue.get("providers")) != null && !(providersArray instanceof NullNode)) {
                            for (Iterator providersValue : (ArrayNode)providersArray) {
                                JsonNode resourceTypesArray;
                                Object registrationStateValue;
                                JsonNode namespaceValue;
                                Provider providerInstance = new Provider();
                                propertiesInstance.getProviders().add(providerInstance);
                                JsonNode idValue2 = providersValue.get("id");
                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                    String idInstance2 = idValue2.getTextValue();
                                    providerInstance.setId(idInstance2);
                                }
                                if ((namespaceValue = providersValue.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                                    String namespaceInstance = namespaceValue.getTextValue();
                                    providerInstance.setNamespace(namespaceInstance);
                                }
                                if ((registrationStateValue = providersValue.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                                    String registrationStateInstance = registrationStateValue.getTextValue();
                                    providerInstance.setRegistrationState(registrationStateInstance);
                                }
                                if ((resourceTypesArray = providersValue.get("resourceTypes")) == null || resourceTypesArray instanceof NullNode) continue;
                                for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                                    JsonNode propertiesSequenceElement;
                                    JsonNode apiVersionsArray;
                                    JsonNode locationsArray;
                                    ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                    providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                    JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                    if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                        String resourceTypeInstance = resourceTypeValue.getTextValue();
                                        providerResourceTypeInstance.setName(resourceTypeInstance);
                                    }
                                    if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                        for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                            providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                        }
                                    }
                                    if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                        Iterator locationsValue;
                                        locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                        while (locationsValue.hasNext()) {
                                            JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                            providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                        }
                                    }
                                    if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                                    Iterator itr = propertiesSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry property = (Map.Entry)itr.next();
                                        String propertiesKey = (String)property.getKey();
                                        String propertiesValue2 = ((JsonNode)property.getValue()).getTextValue();
                                        providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue2);
                                    }
                                }
                            }
                        }
                        if ((dependenciesArray = propertiesValue.get("dependencies")) != null && !(dependenciesArray instanceof NullNode)) {
                            for (JsonNode dependenciesValue : (ArrayNode)dependenciesArray) {
                                JsonNode resourceNameValue2;
                                JsonNode resourceTypeValue3;
                                JsonNode idValue4;
                                Dependency dependencyInstance = new Dependency();
                                propertiesInstance.getDependencies().add(dependencyInstance);
                                JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                if (dependsOnArray != null && !(dependsOnArray instanceof NullNode)) {
                                    for (JsonNode dependsOnValue : (ArrayNode)dependsOnArray) {
                                        JsonNode resourceNameValue;
                                        JsonNode resourceTypeValue2;
                                        BasicDependency basicDependencyInstance = new BasicDependency();
                                        dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                        JsonNode idValue3 = dependsOnValue.get("id");
                                        if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                            String idInstance3 = idValue3.getTextValue();
                                            basicDependencyInstance.setId(idInstance3);
                                        }
                                        if ((resourceTypeValue2 = dependsOnValue.get("resourceType")) != null && !(resourceTypeValue2 instanceof NullNode)) {
                                            String resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                            basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                        }
                                        if ((resourceNameValue = dependsOnValue.get("resourceName")) == null || resourceNameValue instanceof NullNode) continue;
                                        String resourceNameInstance = resourceNameValue.getTextValue();
                                        basicDependencyInstance.setResourceName(resourceNameInstance);
                                    }
                                }
                                if ((idValue4 = dependenciesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                    String idInstance4 = idValue4.getTextValue();
                                    dependencyInstance.setId(idInstance4);
                                }
                                if ((resourceTypeValue3 = dependenciesValue.get("resourceType")) != null && !(resourceTypeValue3 instanceof NullNode)) {
                                    String resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                    dependencyInstance.setResourceType(resourceTypeInstance3);
                                }
                                if ((resourceNameValue2 = dependenciesValue.get("resourceName")) == null || resourceNameValue2 instanceof NullNode) continue;
                                String resourceNameInstance2 = resourceNameValue2.getTextValue();
                                dependencyInstance.setResourceName(resourceNameInstance2);
                            }
                        }
                        if ((templateValue = propertiesValue.get("template")) != null && !(templateValue instanceof NullNode)) {
                            String templateInstance = templateValue.getTextValue();
                            propertiesInstance.setTemplate(templateInstance);
                        }
                        if ((templateLinkValue = propertiesValue.get("templateLink")) != null && !(templateLinkValue instanceof NullNode)) {
                            JsonNode contentVersionValue;
                            TemplateLink templateLinkInstance = new TemplateLink();
                            propertiesInstance.setTemplateLink(templateLinkInstance);
                            JsonNode uriValue = templateLinkValue.get("uri");
                            if (uriValue != null && !(uriValue instanceof NullNode)) {
                                URI uriInstance = new URI(uriValue.getTextValue());
                                templateLinkInstance.setUri(uriInstance);
                            }
                            if ((contentVersionValue = templateLinkValue.get("contentVersion")) != null && !(contentVersionValue instanceof NullNode)) {
                                String contentVersionInstance = contentVersionValue.getTextValue();
                                templateLinkInstance.setContentVersion(contentVersionInstance);
                            }
                        }
                        if ((parametersValue = propertiesValue.get("parameters")) != null && !(parametersValue instanceof NullNode)) {
                            String parametersInstance = parametersValue.getTextValue();
                            propertiesInstance.setParameters(parametersInstance);
                        }
                        if ((parametersLinkValue = propertiesValue.get("parametersLink")) != null && !(parametersLinkValue instanceof NullNode)) {
                            JsonNode contentVersionValue2;
                            ParametersLink parametersLinkInstance = new ParametersLink();
                            propertiesInstance.setParametersLink(parametersLinkInstance);
                            JsonNode uriValue2 = parametersLinkValue.get("uri");
                            if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                URI uriInstance2 = new URI(uriValue2.getTextValue());
                                parametersLinkInstance.setUri(uriInstance2);
                            }
                            if ((contentVersionValue2 = parametersLinkValue.get("contentVersion")) != null && !(contentVersionValue2 instanceof NullNode)) {
                                String contentVersionInstance2 = contentVersionValue2.getTextValue();
                                parametersLinkInstance.setContentVersion(contentVersionInstance2);
                            }
                        }
                        if ((modeValue = propertiesValue.get("mode")) != null && !(modeValue instanceof NullNode)) {
                            DeploymentMode modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue().toUpperCase());
                            propertiesInstance.setMode(modeInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentGetResult deploymentGetResult = result;
            return deploymentGetResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeploymentListResult> listAsync(final String resourceGroupName, final DeploymentListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentListResult>(){

            @Override
            public DeploymentListResult call() throws Exception {
                return DeploymentOperationsImpl.this.list(resourceGroupName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentListResult list(String resourceGroupName, DeploymentListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/";
        url = url + "resourcegroups/" + URLEncoder.encode(resourceGroupName, "UTF-8") + "/";
        url = url + "deployments/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getProvisioningState() != null) {
            odataFilter.add("provisioningState eq '" + URLEncoder.encode(parameters.getProvisioningState(), "UTF-8") + "'");
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode modeValue;
                            JsonNode parametersLinkValue;
                            JsonNode parametersValue;
                            JsonNode templateLinkValue;
                            JsonNode templateValue;
                            JsonNode dependenciesArray;
                            Object registrationStateValue;
                            JsonNode providersArray;
                            JsonNode outputsValue;
                            JsonNode timestampValue;
                            JsonNode correlationIdValue;
                            JsonNode propertiesValue;
                            JsonNode nameValue;
                            DeploymentExtended deploymentExtendedInstance = new DeploymentExtended();
                            result.getDeployments().add(deploymentExtendedInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                deploymentExtendedInstance.setId(idInstance);
                            }
                            if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                deploymentExtendedInstance.setName(nameInstance);
                            }
                            if ((propertiesValue = valueValue.get("properties")) == null || propertiesValue instanceof NullNode) continue;
                            DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                            deploymentExtendedInstance.setProperties(propertiesInstance);
                            JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                            if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                propertiesInstance.setProvisioningState(provisioningStateInstance);
                            }
                            if ((correlationIdValue = propertiesValue.get("correlationId")) != null && !(correlationIdValue instanceof NullNode)) {
                                String correlationIdInstance = correlationIdValue.getTextValue();
                                propertiesInstance.setCorrelationId(correlationIdInstance);
                            }
                            if ((timestampValue = propertiesValue.get("timestamp")) != null && !(timestampValue instanceof NullNode)) {
                                Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampValue.getTextValue());
                                propertiesInstance.setTimestamp(timestampInstance);
                            }
                            if ((outputsValue = propertiesValue.get("outputs")) != null && !(outputsValue instanceof NullNode)) {
                                String outputsInstance = outputsValue.getTextValue();
                                propertiesInstance.setOutputs(outputsInstance);
                            }
                            if ((providersArray = propertiesValue.get("providers")) != null && !(providersArray instanceof NullNode)) {
                                for (Iterator providersValue : (ArrayNode)providersArray) {
                                    JsonNode resourceTypesArray;
                                    JsonNode namespaceValue;
                                    Provider providerInstance = new Provider();
                                    propertiesInstance.getProviders().add(providerInstance);
                                    JsonNode idValue2 = providersValue.get("id");
                                    if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                        String idInstance2 = idValue2.getTextValue();
                                        providerInstance.setId(idInstance2);
                                    }
                                    if ((namespaceValue = providersValue.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                                        String namespaceInstance = namespaceValue.getTextValue();
                                        providerInstance.setNamespace(namespaceInstance);
                                    }
                                    if ((registrationStateValue = providersValue.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                                        String registrationStateInstance = registrationStateValue.getTextValue();
                                        providerInstance.setRegistrationState(registrationStateInstance);
                                    }
                                    if ((resourceTypesArray = providersValue.get("resourceTypes")) == null || resourceTypesArray instanceof NullNode) continue;
                                    for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                                        JsonNode propertiesSequenceElement;
                                        JsonNode apiVersionsArray;
                                        JsonNode locationsArray;
                                        ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                        providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                        JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                        if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                            String resourceTypeInstance = resourceTypeValue.getTextValue();
                                            providerResourceTypeInstance.setName(resourceTypeInstance);
                                        }
                                        if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                            for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                                providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                            }
                                        }
                                        if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                            Iterator locationsValue;
                                            locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                            while (locationsValue.hasNext()) {
                                                JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                                providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                            }
                                        }
                                        if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                                        Iterator itr = propertiesSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry property = (Map.Entry)itr.next();
                                            String propertiesKey = (String)property.getKey();
                                            String propertiesValue2 = ((JsonNode)property.getValue()).getTextValue();
                                            providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue2);
                                        }
                                    }
                                }
                            }
                            if ((dependenciesArray = propertiesValue.get("dependencies")) != null && !(dependenciesArray instanceof NullNode)) {
                                Iterator providersValue;
                                providersValue = ((ArrayNode)dependenciesArray).iterator();
                                while (providersValue.hasNext()) {
                                    JsonNode resourceNameValue2;
                                    JsonNode resourceTypeValue3;
                                    JsonNode idValue4;
                                    JsonNode dependenciesValue = (JsonNode)providersValue.next();
                                    Dependency dependencyInstance = new Dependency();
                                    propertiesInstance.getDependencies().add(dependencyInstance);
                                    JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                    if (dependsOnArray != null && !(dependsOnArray instanceof NullNode)) {
                                        registrationStateValue = ((ArrayNode)dependsOnArray).iterator();
                                        while (registrationStateValue.hasNext()) {
                                            JsonNode resourceNameValue;
                                            JsonNode resourceTypeValue2;
                                            JsonNode dependsOnValue = (JsonNode)registrationStateValue.next();
                                            BasicDependency basicDependencyInstance = new BasicDependency();
                                            dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                            JsonNode idValue3 = dependsOnValue.get("id");
                                            if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                                String idInstance3 = idValue3.getTextValue();
                                                basicDependencyInstance.setId(idInstance3);
                                            }
                                            if ((resourceTypeValue2 = dependsOnValue.get("resourceType")) != null && !(resourceTypeValue2 instanceof NullNode)) {
                                                String resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                                basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                            }
                                            if ((resourceNameValue = dependsOnValue.get("resourceName")) == null || resourceNameValue instanceof NullNode) continue;
                                            String resourceNameInstance = resourceNameValue.getTextValue();
                                            basicDependencyInstance.setResourceName(resourceNameInstance);
                                        }
                                    }
                                    if ((idValue4 = dependenciesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                        String idInstance4 = idValue4.getTextValue();
                                        dependencyInstance.setId(idInstance4);
                                    }
                                    if ((resourceTypeValue3 = dependenciesValue.get("resourceType")) != null && !(resourceTypeValue3 instanceof NullNode)) {
                                        String resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                        dependencyInstance.setResourceType(resourceTypeInstance3);
                                    }
                                    if ((resourceNameValue2 = dependenciesValue.get("resourceName")) == null || resourceNameValue2 instanceof NullNode) continue;
                                    String resourceNameInstance2 = resourceNameValue2.getTextValue();
                                    dependencyInstance.setResourceName(resourceNameInstance2);
                                }
                            }
                            if ((templateValue = propertiesValue.get("template")) != null && !(templateValue instanceof NullNode)) {
                                String templateInstance = templateValue.getTextValue();
                                propertiesInstance.setTemplate(templateInstance);
                            }
                            if ((templateLinkValue = propertiesValue.get("templateLink")) != null && !(templateLinkValue instanceof NullNode)) {
                                JsonNode contentVersionValue;
                                TemplateLink templateLinkInstance = new TemplateLink();
                                propertiesInstance.setTemplateLink(templateLinkInstance);
                                JsonNode uriValue = templateLinkValue.get("uri");
                                if (uriValue != null && !(uriValue instanceof NullNode)) {
                                    URI uriInstance = new URI(uriValue.getTextValue());
                                    templateLinkInstance.setUri(uriInstance);
                                }
                                if ((contentVersionValue = templateLinkValue.get("contentVersion")) != null && !(contentVersionValue instanceof NullNode)) {
                                    String contentVersionInstance = contentVersionValue.getTextValue();
                                    templateLinkInstance.setContentVersion(contentVersionInstance);
                                }
                            }
                            if ((parametersValue = propertiesValue.get("parameters")) != null && !(parametersValue instanceof NullNode)) {
                                String parametersInstance = parametersValue.getTextValue();
                                propertiesInstance.setParameters(parametersInstance);
                            }
                            if ((parametersLinkValue = propertiesValue.get("parametersLink")) != null && !(parametersLinkValue instanceof NullNode)) {
                                JsonNode contentVersionValue2;
                                ParametersLink parametersLinkInstance = new ParametersLink();
                                propertiesInstance.setParametersLink(parametersLinkInstance);
                                JsonNode uriValue2 = parametersLinkValue.get("uri");
                                if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                    URI uriInstance2 = new URI(uriValue2.getTextValue());
                                    parametersLinkInstance.setUri(uriInstance2);
                                }
                                if ((contentVersionValue2 = parametersLinkValue.get("contentVersion")) != null && !(contentVersionValue2 instanceof NullNode)) {
                                    String contentVersionInstance2 = contentVersionValue2.getTextValue();
                                    parametersLinkInstance.setContentVersion(contentVersionInstance2);
                                }
                            }
                            if ((modeValue = propertiesValue.get("mode")) == null || modeValue instanceof NullNode) continue;
                            DeploymentMode modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue().toUpperCase());
                            propertiesInstance.setMode(modeInstance);
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentListResult deploymentListResult = result;
            return deploymentListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeploymentListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentListResult>(){

            @Override
            public DeploymentListResult call() throws Exception {
                return DeploymentOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode modeValue;
                            JsonNode parametersLinkValue;
                            JsonNode parametersValue;
                            JsonNode templateLinkValue;
                            JsonNode templateValue;
                            JsonNode dependenciesArray;
                            Object registrationStateValue;
                            JsonNode providersArray;
                            JsonNode outputsValue;
                            JsonNode timestampValue;
                            JsonNode correlationIdValue;
                            JsonNode propertiesValue;
                            JsonNode nameValue;
                            DeploymentExtended deploymentExtendedInstance = new DeploymentExtended();
                            result.getDeployments().add(deploymentExtendedInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                deploymentExtendedInstance.setId(idInstance);
                            }
                            if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                deploymentExtendedInstance.setName(nameInstance);
                            }
                            if ((propertiesValue = valueValue.get("properties")) == null || propertiesValue instanceof NullNode) continue;
                            DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                            deploymentExtendedInstance.setProperties(propertiesInstance);
                            JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                            if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                propertiesInstance.setProvisioningState(provisioningStateInstance);
                            }
                            if ((correlationIdValue = propertiesValue.get("correlationId")) != null && !(correlationIdValue instanceof NullNode)) {
                                String correlationIdInstance = correlationIdValue.getTextValue();
                                propertiesInstance.setCorrelationId(correlationIdInstance);
                            }
                            if ((timestampValue = propertiesValue.get("timestamp")) != null && !(timestampValue instanceof NullNode)) {
                                Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampValue.getTextValue());
                                propertiesInstance.setTimestamp(timestampInstance);
                            }
                            if ((outputsValue = propertiesValue.get("outputs")) != null && !(outputsValue instanceof NullNode)) {
                                String outputsInstance = outputsValue.getTextValue();
                                propertiesInstance.setOutputs(outputsInstance);
                            }
                            if ((providersArray = propertiesValue.get("providers")) != null && !(providersArray instanceof NullNode)) {
                                for (Iterator providersValue : (ArrayNode)providersArray) {
                                    JsonNode resourceTypesArray;
                                    JsonNode namespaceValue;
                                    Provider providerInstance = new Provider();
                                    propertiesInstance.getProviders().add(providerInstance);
                                    JsonNode idValue2 = providersValue.get("id");
                                    if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                        String idInstance2 = idValue2.getTextValue();
                                        providerInstance.setId(idInstance2);
                                    }
                                    if ((namespaceValue = providersValue.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                                        String namespaceInstance = namespaceValue.getTextValue();
                                        providerInstance.setNamespace(namespaceInstance);
                                    }
                                    if ((registrationStateValue = providersValue.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                                        String registrationStateInstance = registrationStateValue.getTextValue();
                                        providerInstance.setRegistrationState(registrationStateInstance);
                                    }
                                    if ((resourceTypesArray = providersValue.get("resourceTypes")) == null || resourceTypesArray instanceof NullNode) continue;
                                    for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                                        JsonNode propertiesSequenceElement;
                                        JsonNode apiVersionsArray;
                                        JsonNode locationsArray;
                                        ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                        providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                        JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                        if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                            String resourceTypeInstance = resourceTypeValue.getTextValue();
                                            providerResourceTypeInstance.setName(resourceTypeInstance);
                                        }
                                        if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                            for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                                providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                            }
                                        }
                                        if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                            Iterator locationsValue;
                                            locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                            while (locationsValue.hasNext()) {
                                                JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                                providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                            }
                                        }
                                        if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                                        Iterator itr = propertiesSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry property = (Map.Entry)itr.next();
                                            String propertiesKey = (String)property.getKey();
                                            String propertiesValue2 = ((JsonNode)property.getValue()).getTextValue();
                                            providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue2);
                                        }
                                    }
                                }
                            }
                            if ((dependenciesArray = propertiesValue.get("dependencies")) != null && !(dependenciesArray instanceof NullNode)) {
                                Iterator providersValue;
                                providersValue = ((ArrayNode)dependenciesArray).iterator();
                                while (providersValue.hasNext()) {
                                    JsonNode resourceNameValue2;
                                    JsonNode resourceTypeValue3;
                                    JsonNode idValue4;
                                    JsonNode dependenciesValue = (JsonNode)providersValue.next();
                                    Dependency dependencyInstance = new Dependency();
                                    propertiesInstance.getDependencies().add(dependencyInstance);
                                    JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                    if (dependsOnArray != null && !(dependsOnArray instanceof NullNode)) {
                                        registrationStateValue = ((ArrayNode)dependsOnArray).iterator();
                                        while (registrationStateValue.hasNext()) {
                                            JsonNode resourceNameValue;
                                            JsonNode resourceTypeValue2;
                                            JsonNode dependsOnValue = (JsonNode)registrationStateValue.next();
                                            BasicDependency basicDependencyInstance = new BasicDependency();
                                            dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                            JsonNode idValue3 = dependsOnValue.get("id");
                                            if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                                String idInstance3 = idValue3.getTextValue();
                                                basicDependencyInstance.setId(idInstance3);
                                            }
                                            if ((resourceTypeValue2 = dependsOnValue.get("resourceType")) != null && !(resourceTypeValue2 instanceof NullNode)) {
                                                String resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                                basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                            }
                                            if ((resourceNameValue = dependsOnValue.get("resourceName")) == null || resourceNameValue instanceof NullNode) continue;
                                            String resourceNameInstance = resourceNameValue.getTextValue();
                                            basicDependencyInstance.setResourceName(resourceNameInstance);
                                        }
                                    }
                                    if ((idValue4 = dependenciesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                        String idInstance4 = idValue4.getTextValue();
                                        dependencyInstance.setId(idInstance4);
                                    }
                                    if ((resourceTypeValue3 = dependenciesValue.get("resourceType")) != null && !(resourceTypeValue3 instanceof NullNode)) {
                                        String resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                        dependencyInstance.setResourceType(resourceTypeInstance3);
                                    }
                                    if ((resourceNameValue2 = dependenciesValue.get("resourceName")) == null || resourceNameValue2 instanceof NullNode) continue;
                                    String resourceNameInstance2 = resourceNameValue2.getTextValue();
                                    dependencyInstance.setResourceName(resourceNameInstance2);
                                }
                            }
                            if ((templateValue = propertiesValue.get("template")) != null && !(templateValue instanceof NullNode)) {
                                String templateInstance = templateValue.getTextValue();
                                propertiesInstance.setTemplate(templateInstance);
                            }
                            if ((templateLinkValue = propertiesValue.get("templateLink")) != null && !(templateLinkValue instanceof NullNode)) {
                                JsonNode contentVersionValue;
                                TemplateLink templateLinkInstance = new TemplateLink();
                                propertiesInstance.setTemplateLink(templateLinkInstance);
                                JsonNode uriValue = templateLinkValue.get("uri");
                                if (uriValue != null && !(uriValue instanceof NullNode)) {
                                    URI uriInstance = new URI(uriValue.getTextValue());
                                    templateLinkInstance.setUri(uriInstance);
                                }
                                if ((contentVersionValue = templateLinkValue.get("contentVersion")) != null && !(contentVersionValue instanceof NullNode)) {
                                    String contentVersionInstance = contentVersionValue.getTextValue();
                                    templateLinkInstance.setContentVersion(contentVersionInstance);
                                }
                            }
                            if ((parametersValue = propertiesValue.get("parameters")) != null && !(parametersValue instanceof NullNode)) {
                                String parametersInstance = parametersValue.getTextValue();
                                propertiesInstance.setParameters(parametersInstance);
                            }
                            if ((parametersLinkValue = propertiesValue.get("parametersLink")) != null && !(parametersLinkValue instanceof NullNode)) {
                                JsonNode contentVersionValue2;
                                ParametersLink parametersLinkInstance = new ParametersLink();
                                propertiesInstance.setParametersLink(parametersLinkInstance);
                                JsonNode uriValue2 = parametersLinkValue.get("uri");
                                if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                    URI uriInstance2 = new URI(uriValue2.getTextValue());
                                    parametersLinkInstance.setUri(uriInstance2);
                                }
                                if ((contentVersionValue2 = parametersLinkValue.get("contentVersion")) != null && !(contentVersionValue2 instanceof NullNode)) {
                                    String contentVersionInstance2 = contentVersionValue2.getTextValue();
                                    parametersLinkInstance.setContentVersion(contentVersionInstance2);
                                }
                            }
                            if ((modeValue = propertiesValue.get("mode")) == null || modeValue instanceof NullNode) continue;
                            DeploymentMode modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue().toUpperCase());
                            propertiesInstance.setMode(modeInstance);
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentListResult deploymentListResult = result;
            return deploymentListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeploymentValidateResponse> validateAsync(final String resourceGroupName, final String deploymentName, final Deployment parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentValidateResponse>(){

            @Override
            public DeploymentValidateResponse call() throws Exception {
                return DeploymentOperationsImpl.this.validate(resourceGroupName, deploymentName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentValidateResponse validate(String resourceGroupName, String deploymentName, Deployment parameters) throws IOException, ServiceException, URISyntaxException {
        ObjectNode deploymentValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getProperties() != null) {
            if (parameters.getProperties().getParametersLink() != null && parameters.getProperties().getParametersLink().getUri() == null) {
                throw new NullPointerException("parameters.Properties.ParametersLink.Uri");
            }
            if (parameters.getProperties().getTemplateLink() != null && parameters.getProperties().getTemplateLink().getUri() == null) {
                throw new NullPointerException("parameters.Properties.TemplateLink.Uri");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"validateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/microsoft.resources/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/validate";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = deploymentValue = objectMapper.createObjectNode();
        if (parameters.getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            deploymentValue.put("properties", (JsonNode)propertiesValue);
            if (parameters.getProperties().getTemplate() != null) {
                propertiesValue.put("template", objectMapper.readTree(parameters.getProperties().getTemplate()));
            }
            if (parameters.getProperties().getTemplateLink() != null) {
                ObjectNode templateLinkValue = objectMapper.createObjectNode();
                propertiesValue.put("templateLink", (JsonNode)templateLinkValue);
                templateLinkValue.put("uri", parameters.getProperties().getTemplateLink().getUri().toString());
                if (parameters.getProperties().getTemplateLink().getContentVersion() != null) {
                    templateLinkValue.put("contentVersion", parameters.getProperties().getTemplateLink().getContentVersion());
                }
            }
            if (parameters.getProperties().getParameters() != null) {
                propertiesValue.put("parameters", objectMapper.readTree(parameters.getProperties().getParameters()));
            }
            if (parameters.getProperties().getParametersLink() != null) {
                ObjectNode parametersLinkValue = objectMapper.createObjectNode();
                propertiesValue.put("parametersLink", (JsonNode)parametersLinkValue);
                parametersLinkValue.put("uri", parameters.getProperties().getParametersLink().getUri().toString());
                if (parameters.getProperties().getParametersLink().getContentVersion() != null) {
                    parametersLinkValue.put("contentVersion", parameters.getProperties().getParametersLink().getContentVersion());
                }
            }
            if (parameters.getProperties().getMode() != null) {
                propertiesValue.put("mode", parameters.getProperties().getMode().toString());
            }
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 400) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeploymentValidateResponse result = null;
            if (statusCode == 200 || statusCode == 400) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeploymentValidateResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode propertiesValue2;
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && !(errorValue instanceof NullNode)) {
                        JsonNode targetValue2;
                        JsonNode messageValue2;
                        JsonNode codeValue2;
                        ResourceManagementErrorWithDetails errorInstance = new ResourceManagementErrorWithDetails();
                        result.setError(errorInstance);
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && !(detailsArray instanceof NullNode)) {
                            for (JsonNode detailsValue : (ArrayNode)detailsArray) {
                                Iterator targetValue;
                                JsonNode messageValue;
                                ResourceManagementError resourceManagementErrorInstance = new ResourceManagementError();
                                errorInstance.getDetails().add(resourceManagementErrorInstance);
                                JsonNode codeValue = detailsValue.get("code");
                                if (codeValue != null && !(codeValue instanceof NullNode)) {
                                    String codeInstance = codeValue.getTextValue();
                                    resourceManagementErrorInstance.setCode(codeInstance);
                                }
                                if ((messageValue = detailsValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                    String messageInstance = messageValue.getTextValue();
                                    resourceManagementErrorInstance.setMessage(messageInstance);
                                }
                                if ((targetValue = detailsValue.get("target")) == null || targetValue instanceof NullNode) continue;
                                String targetInstance = targetValue.getTextValue();
                                resourceManagementErrorInstance.setTarget(targetInstance);
                            }
                        }
                        if ((codeValue2 = errorValue.get("code")) != null && !(codeValue2 instanceof NullNode)) {
                            String codeInstance2 = codeValue2.getTextValue();
                            errorInstance.setCode(codeInstance2);
                        }
                        if ((messageValue2 = errorValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                            String messageInstance2 = messageValue2.getTextValue();
                            errorInstance.setMessage(messageInstance2);
                        }
                        if ((targetValue2 = errorValue.get("target")) != null && !(targetValue2 instanceof NullNode)) {
                            String targetInstance2 = targetValue2.getTextValue();
                            errorInstance.setTarget(targetInstance2);
                        }
                    }
                    if ((propertiesValue2 = responseDoc.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode modeValue;
                        JsonNode parametersLinkValue2;
                        JsonNode parametersValue;
                        JsonNode templateLinkValue2;
                        JsonNode templateValue;
                        JsonNode dependenciesArray;
                        JsonNode providersArray;
                        JsonNode outputsValue;
                        JsonNode timestampValue;
                        JsonNode correlationIdValue;
                        DeploymentPropertiesExtended propertiesInstance = new DeploymentPropertiesExtended();
                        result.setProperties(propertiesInstance);
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            propertiesInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((correlationIdValue = propertiesValue2.get("correlationId")) != null && !(correlationIdValue instanceof NullNode)) {
                            String correlationIdInstance = correlationIdValue.getTextValue();
                            propertiesInstance.setCorrelationId(correlationIdInstance);
                        }
                        if ((timestampValue = propertiesValue2.get("timestamp")) != null && !(timestampValue instanceof NullNode)) {
                            Calendar timestampInstance = DatatypeConverter.parseDateTime((String)timestampValue.getTextValue());
                            propertiesInstance.setTimestamp(timestampInstance);
                        }
                        if ((outputsValue = propertiesValue2.get("outputs")) != null && !(outputsValue instanceof NullNode)) {
                            String outputsInstance = outputsValue.getTextValue();
                            propertiesInstance.setOutputs(outputsInstance);
                        }
                        if ((providersArray = propertiesValue2.get("providers")) != null && !(providersArray instanceof NullNode)) {
                            for (Iterator providersValue : (ArrayNode)providersArray) {
                                JsonNode resourceTypesArray;
                                Object registrationStateValue;
                                JsonNode namespaceValue;
                                Provider providerInstance = new Provider();
                                propertiesInstance.getProviders().add(providerInstance);
                                JsonNode idValue = providersValue.get("id");
                                if (idValue != null && !(idValue instanceof NullNode)) {
                                    String idInstance = idValue.getTextValue();
                                    providerInstance.setId(idInstance);
                                }
                                if ((namespaceValue = providersValue.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                                    String namespaceInstance = namespaceValue.getTextValue();
                                    providerInstance.setNamespace(namespaceInstance);
                                }
                                if ((registrationStateValue = providersValue.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                                    String registrationStateInstance = registrationStateValue.getTextValue();
                                    providerInstance.setRegistrationState(registrationStateInstance);
                                }
                                if ((resourceTypesArray = providersValue.get("resourceTypes")) == null || resourceTypesArray instanceof NullNode) continue;
                                for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                                    JsonNode propertiesSequenceElement;
                                    JsonNode apiVersionsArray;
                                    JsonNode locationsArray;
                                    ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                    providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                    JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                    if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                        String resourceTypeInstance = resourceTypeValue.getTextValue();
                                        providerResourceTypeInstance.setName(resourceTypeInstance);
                                    }
                                    if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                        for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                            providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                        }
                                    }
                                    if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                        Iterator locationsValue;
                                        locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                        while (locationsValue.hasNext()) {
                                            JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                            providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                        }
                                    }
                                    if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                                    Iterator itr = propertiesSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry property = (Map.Entry)itr.next();
                                        String propertiesKey = (String)property.getKey();
                                        String propertiesValue3 = ((JsonNode)property.getValue()).getTextValue();
                                        providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue3);
                                    }
                                }
                            }
                        }
                        if ((dependenciesArray = propertiesValue2.get("dependencies")) != null && !(dependenciesArray instanceof NullNode)) {
                            for (JsonNode dependenciesValue : (ArrayNode)dependenciesArray) {
                                JsonNode resourceNameValue2;
                                JsonNode resourceTypeValue3;
                                JsonNode idValue3;
                                Dependency dependencyInstance = new Dependency();
                                propertiesInstance.getDependencies().add(dependencyInstance);
                                JsonNode dependsOnArray = dependenciesValue.get("dependsOn");
                                if (dependsOnArray != null && !(dependsOnArray instanceof NullNode)) {
                                    for (JsonNode dependsOnValue : (ArrayNode)dependsOnArray) {
                                        JsonNode resourceNameValue;
                                        JsonNode resourceTypeValue2;
                                        BasicDependency basicDependencyInstance = new BasicDependency();
                                        dependencyInstance.getDependsOn().add(basicDependencyInstance);
                                        JsonNode idValue2 = dependsOnValue.get("id");
                                        if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                            String idInstance2 = idValue2.getTextValue();
                                            basicDependencyInstance.setId(idInstance2);
                                        }
                                        if ((resourceTypeValue2 = dependsOnValue.get("resourceType")) != null && !(resourceTypeValue2 instanceof NullNode)) {
                                            String resourceTypeInstance2 = resourceTypeValue2.getTextValue();
                                            basicDependencyInstance.setResourceType(resourceTypeInstance2);
                                        }
                                        if ((resourceNameValue = dependsOnValue.get("resourceName")) == null || resourceNameValue instanceof NullNode) continue;
                                        String resourceNameInstance = resourceNameValue.getTextValue();
                                        basicDependencyInstance.setResourceName(resourceNameInstance);
                                    }
                                }
                                if ((idValue3 = dependenciesValue.get("id")) != null && !(idValue3 instanceof NullNode)) {
                                    String idInstance3 = idValue3.getTextValue();
                                    dependencyInstance.setId(idInstance3);
                                }
                                if ((resourceTypeValue3 = dependenciesValue.get("resourceType")) != null && !(resourceTypeValue3 instanceof NullNode)) {
                                    String resourceTypeInstance3 = resourceTypeValue3.getTextValue();
                                    dependencyInstance.setResourceType(resourceTypeInstance3);
                                }
                                if ((resourceNameValue2 = dependenciesValue.get("resourceName")) == null || resourceNameValue2 instanceof NullNode) continue;
                                String resourceNameInstance2 = resourceNameValue2.getTextValue();
                                dependencyInstance.setResourceName(resourceNameInstance2);
                            }
                        }
                        if ((templateValue = propertiesValue2.get("template")) != null && !(templateValue instanceof NullNode)) {
                            String templateInstance = templateValue.getTextValue();
                            propertiesInstance.setTemplate(templateInstance);
                        }
                        if ((templateLinkValue2 = propertiesValue2.get("templateLink")) != null && !(templateLinkValue2 instanceof NullNode)) {
                            JsonNode contentVersionValue;
                            TemplateLink templateLinkInstance = new TemplateLink();
                            propertiesInstance.setTemplateLink(templateLinkInstance);
                            JsonNode uriValue = templateLinkValue2.get("uri");
                            if (uriValue != null && !(uriValue instanceof NullNode)) {
                                URI uriInstance = new URI(uriValue.getTextValue());
                                templateLinkInstance.setUri(uriInstance);
                            }
                            if ((contentVersionValue = templateLinkValue2.get("contentVersion")) != null && !(contentVersionValue instanceof NullNode)) {
                                String contentVersionInstance = contentVersionValue.getTextValue();
                                templateLinkInstance.setContentVersion(contentVersionInstance);
                            }
                        }
                        if ((parametersValue = propertiesValue2.get("parameters")) != null && !(parametersValue instanceof NullNode)) {
                            String parametersInstance = parametersValue.getTextValue();
                            propertiesInstance.setParameters(parametersInstance);
                        }
                        if ((parametersLinkValue2 = propertiesValue2.get("parametersLink")) != null && !(parametersLinkValue2 instanceof NullNode)) {
                            JsonNode contentVersionValue2;
                            ParametersLink parametersLinkInstance = new ParametersLink();
                            propertiesInstance.setParametersLink(parametersLinkInstance);
                            JsonNode uriValue2 = parametersLinkValue2.get("uri");
                            if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                URI uriInstance2 = new URI(uriValue2.getTextValue());
                                parametersLinkInstance.setUri(uriInstance2);
                            }
                            if ((contentVersionValue2 = parametersLinkValue2.get("contentVersion")) != null && !(contentVersionValue2 instanceof NullNode)) {
                                String contentVersionInstance2 = contentVersionValue2.getTextValue();
                                parametersLinkInstance.setContentVersion(contentVersionInstance2);
                            }
                        }
                        if ((modeValue = propertiesValue2.get("mode")) != null && !(modeValue instanceof NullNode)) {
                            DeploymentMode modeInstance = Enum.valueOf(DeploymentMode.class, modeValue.getTextValue().toUpperCase());
                            propertiesInstance.setMode(modeInstance);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == 200) {
                result.setIsValid(true);
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeploymentValidateResponse deploymentValidateResponse = result;
            return deploymentValidateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

