/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.ProviderOperations;
import com.microsoft.azure.management.resources.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.models.Provider;
import com.microsoft.azure.management.resources.models.ProviderGetResult;
import com.microsoft.azure.management.resources.models.ProviderListParameters;
import com.microsoft.azure.management.resources.models.ProviderListResult;
import com.microsoft.azure.management.resources.models.ProviderRegistionResult;
import com.microsoft.azure.management.resources.models.ProviderResourceType;
import com.microsoft.azure.management.resources.models.ProviderUnregistionResult;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class ProviderOperationsImpl
implements ServiceOperations<ResourceManagementClientImpl>,
ProviderOperations {
    private ResourceManagementClientImpl client;

    ProviderOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }

    public ResourceManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<ProviderGetResult> getAsync(final String resourceProviderNamespace) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderGetResult>(){

            @Override
            public ProviderGetResult call() throws Exception {
                return ProviderOperationsImpl.this.get(resourceProviderNamespace);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderGetResult get(String resourceProviderNamespace) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ProviderGetResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode resourceTypesArray;
                    JsonNode registrationStateValue;
                    JsonNode namespaceValue;
                    Provider providerInstance = new Provider();
                    result.setProvider(providerInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        providerInstance.setId(idInstance);
                    }
                    if ((namespaceValue = responseDoc.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                        String namespaceInstance = namespaceValue.getTextValue();
                        providerInstance.setNamespace(namespaceInstance);
                    }
                    if ((registrationStateValue = responseDoc.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                        String registrationStateInstance = registrationStateValue.getTextValue();
                        providerInstance.setRegistrationState(registrationStateInstance);
                    }
                    if ((resourceTypesArray = responseDoc.get("resourceTypes")) != null && !(resourceTypesArray instanceof NullNode)) {
                        for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                            JsonNode propertiesSequenceElement;
                            JsonNode apiVersionsArray;
                            JsonNode locationsArray;
                            ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                            providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                            JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                            if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                String resourceTypeInstance = resourceTypeValue.getTextValue();
                                providerResourceTypeInstance.setName(resourceTypeInstance);
                            }
                            if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                    providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                }
                            }
                            if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                Iterator locationsValue;
                                locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                while (locationsValue.hasNext()) {
                                    JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                    providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                }
                            }
                            if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                            Iterator itr = propertiesSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String propertiesKey = (String)property.getKey();
                                String propertiesValue = ((JsonNode)property.getValue()).getTextValue();
                                providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ProviderGetResult providerGetResult = result;
            return providerGetResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ProviderListResult> listAsync(final ProviderListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderListResult>(){

            @Override
            public ProviderListResult call() throws Exception {
                return ProviderOperationsImpl.this.list(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderListResult list(ProviderListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, ProviderListParameters> tracingParameters = new HashMap<String, ProviderListParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ProviderListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode resourceTypesArray;
                            JsonNode registrationStateValue;
                            JsonNode namespaceValue;
                            Provider providerInstance = new Provider();
                            result.getProviders().add(providerInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                providerInstance.setId(idInstance);
                            }
                            if ((namespaceValue = valueValue.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                                String namespaceInstance = namespaceValue.getTextValue();
                                providerInstance.setNamespace(namespaceInstance);
                            }
                            if ((registrationStateValue = valueValue.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                                String registrationStateInstance = registrationStateValue.getTextValue();
                                providerInstance.setRegistrationState(registrationStateInstance);
                            }
                            if ((resourceTypesArray = valueValue.get("resourceTypes")) == null || resourceTypesArray instanceof NullNode) continue;
                            for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                                JsonNode propertiesSequenceElement;
                                JsonNode apiVersionsArray;
                                JsonNode locationsArray;
                                ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                    String resourceTypeInstance = resourceTypeValue.getTextValue();
                                    providerResourceTypeInstance.setName(resourceTypeInstance);
                                }
                                if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                    for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                        providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                    }
                                }
                                if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                    Iterator locationsValue;
                                    locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                    while (locationsValue.hasNext()) {
                                        JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                        providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                    }
                                }
                                if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                                Iterator itr = propertiesSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry property = (Map.Entry)itr.next();
                                    String propertiesKey = (String)property.getKey();
                                    String propertiesValue = ((JsonNode)property.getValue()).getTextValue();
                                    providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                                }
                            }
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ProviderListResult providerListResult = result;
            return providerListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ProviderListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderListResult>(){

            @Override
            public ProviderListResult call() throws Exception {
                return ProviderOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ProviderListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode resourceTypesArray;
                            JsonNode registrationStateValue;
                            JsonNode namespaceValue;
                            Provider providerInstance = new Provider();
                            result.getProviders().add(providerInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                providerInstance.setId(idInstance);
                            }
                            if ((namespaceValue = valueValue.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                                String namespaceInstance = namespaceValue.getTextValue();
                                providerInstance.setNamespace(namespaceInstance);
                            }
                            if ((registrationStateValue = valueValue.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                                String registrationStateInstance = registrationStateValue.getTextValue();
                                providerInstance.setRegistrationState(registrationStateInstance);
                            }
                            if ((resourceTypesArray = valueValue.get("resourceTypes")) == null || resourceTypesArray instanceof NullNode) continue;
                            for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                                JsonNode propertiesSequenceElement;
                                JsonNode apiVersionsArray;
                                JsonNode locationsArray;
                                ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                                providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                                JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                                if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                    String resourceTypeInstance = resourceTypeValue.getTextValue();
                                    providerResourceTypeInstance.setName(resourceTypeInstance);
                                }
                                if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                    for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                        providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                    }
                                }
                                if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                    Iterator locationsValue;
                                    locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                    while (locationsValue.hasNext()) {
                                        JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                        providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                    }
                                }
                                if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                                Iterator itr = propertiesSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry property = (Map.Entry)itr.next();
                                    String propertiesKey = (String)property.getKey();
                                    String propertiesValue = ((JsonNode)property.getValue()).getTextValue();
                                    providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                                }
                            }
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ProviderListResult providerListResult = result;
            return providerListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ProviderRegistionResult> registerAsync(final String resourceProviderNamespace) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderRegistionResult>(){

            @Override
            public ProviderRegistionResult call() throws Exception {
                return ProviderOperationsImpl.this.register(resourceProviderNamespace);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderRegistionResult register(String resourceProviderNamespace) throws IOException, ServiceException {
        String baseUrl;
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"registerAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        url = url + "/register";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ProviderRegistionResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderRegistionResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode resourceTypesArray;
                    JsonNode registrationStateValue;
                    JsonNode namespaceValue;
                    Provider providerInstance = new Provider();
                    result.setProvider(providerInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        providerInstance.setId(idInstance);
                    }
                    if ((namespaceValue = responseDoc.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                        String namespaceInstance = namespaceValue.getTextValue();
                        providerInstance.setNamespace(namespaceInstance);
                    }
                    if ((registrationStateValue = responseDoc.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                        String registrationStateInstance = registrationStateValue.getTextValue();
                        providerInstance.setRegistrationState(registrationStateInstance);
                    }
                    if ((resourceTypesArray = responseDoc.get("resourceTypes")) != null && !(resourceTypesArray instanceof NullNode)) {
                        for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                            JsonNode propertiesSequenceElement;
                            JsonNode apiVersionsArray;
                            JsonNode locationsArray;
                            ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                            providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                            JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                            if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                String resourceTypeInstance = resourceTypeValue.getTextValue();
                                providerResourceTypeInstance.setName(resourceTypeInstance);
                            }
                            if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                    providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                }
                            }
                            if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                Iterator locationsValue;
                                locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                while (locationsValue.hasNext()) {
                                    JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                    providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                }
                            }
                            if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                            Iterator itr = propertiesSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String propertiesKey = (String)property.getKey();
                                String propertiesValue = ((JsonNode)property.getValue()).getTextValue();
                                providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ProviderRegistionResult providerRegistionResult = result;
            return providerRegistionResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ProviderUnregistionResult> unregisterAsync(final String resourceProviderNamespace) {
        return this.getClient().getExecutorService().submit(new Callable<ProviderUnregistionResult>(){

            @Override
            public ProviderUnregistionResult call() throws Exception {
                return ProviderOperationsImpl.this.unregister(resourceProviderNamespace);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderUnregistionResult unregister(String resourceProviderNamespace) throws IOException, ServiceException {
        String baseUrl;
        if (resourceProviderNamespace == null) {
            throw new NullPointerException("resourceProviderNamespace");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceProviderNamespace", resourceProviderNamespace);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"unregisterAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + URLEncoder.encode(resourceProviderNamespace, "UTF-8");
        url = url + "/unregister";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ProviderUnregistionResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ProviderUnregistionResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode resourceTypesArray;
                    JsonNode registrationStateValue;
                    JsonNode namespaceValue;
                    Provider providerInstance = new Provider();
                    result.setProvider(providerInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        providerInstance.setId(idInstance);
                    }
                    if ((namespaceValue = responseDoc.get("namespace")) != null && !(namespaceValue instanceof NullNode)) {
                        String namespaceInstance = namespaceValue.getTextValue();
                        providerInstance.setNamespace(namespaceInstance);
                    }
                    if ((registrationStateValue = responseDoc.get("registrationState")) != null && !(registrationStateValue instanceof NullNode)) {
                        String registrationStateInstance = registrationStateValue.getTextValue();
                        providerInstance.setRegistrationState(registrationStateInstance);
                    }
                    if ((resourceTypesArray = responseDoc.get("resourceTypes")) != null && !(resourceTypesArray instanceof NullNode)) {
                        for (JsonNode resourceTypesValue : (ArrayNode)resourceTypesArray) {
                            JsonNode propertiesSequenceElement;
                            JsonNode apiVersionsArray;
                            JsonNode locationsArray;
                            ProviderResourceType providerResourceTypeInstance = new ProviderResourceType();
                            providerInstance.getResourceTypes().add(providerResourceTypeInstance);
                            JsonNode resourceTypeValue = resourceTypesValue.get("resourceType");
                            if (resourceTypeValue != null && !(resourceTypeValue instanceof NullNode)) {
                                String resourceTypeInstance = resourceTypeValue.getTextValue();
                                providerResourceTypeInstance.setName(resourceTypeInstance);
                            }
                            if ((locationsArray = resourceTypesValue.get("locations")) != null && !(locationsArray instanceof NullNode)) {
                                for (Iterator locationsValue : (ArrayNode)locationsArray) {
                                    providerResourceTypeInstance.getLocations().add(locationsValue.getTextValue());
                                }
                            }
                            if ((apiVersionsArray = resourceTypesValue.get("apiVersions")) != null && !(apiVersionsArray instanceof NullNode)) {
                                Iterator locationsValue;
                                locationsValue = ((ArrayNode)apiVersionsArray).iterator();
                                while (locationsValue.hasNext()) {
                                    JsonNode apiVersionsValue = (JsonNode)locationsValue.next();
                                    providerResourceTypeInstance.getApiVersions().add(apiVersionsValue.getTextValue());
                                }
                            }
                            if ((propertiesSequenceElement = resourceTypesValue.get("properties")) == null || propertiesSequenceElement instanceof NullNode) continue;
                            Iterator itr = propertiesSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String propertiesKey = (String)property.getKey();
                                String propertiesValue = ((JsonNode)property.getValue()).getTextValue();
                                providerResourceTypeInstance.getProperties().put(propertiesKey, propertiesValue);
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ProviderUnregistionResult providerUnregistionResult = result;
            return providerUnregistionResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

