/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.ResourceOperations;
import com.microsoft.azure.management.resources.models.GenericResource;
import com.microsoft.azure.management.resources.models.GenericResourceExtended;
import com.microsoft.azure.management.resources.models.Plan;
import com.microsoft.azure.management.resources.models.ResourceCreateOrUpdateResult;
import com.microsoft.azure.management.resources.models.ResourceExistsResult;
import com.microsoft.azure.management.resources.models.ResourceGetResult;
import com.microsoft.azure.management.resources.models.ResourceListParameters;
import com.microsoft.azure.management.resources.models.ResourceListResult;
import com.microsoft.azure.management.resources.models.ResourcesMoveInfo;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ResourceIdentity;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class ResourceOperationsImpl
implements ServiceOperations<ResourceManagementClientImpl>,
ResourceOperations {
    private ResourceManagementClientImpl client;

    ResourceOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }

    public ResourceManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<ResourceExistsResult> checkExistenceAsync(final String resourceGroupName, final ResourceIdentity identity) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceExistsResult>(){

            @Override
            public ResourceExistsResult call() throws Exception {
                return ResourceOperationsImpl.this.checkExistence(resourceGroupName, identity);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceExistsResult checkExistence(String resourceGroupName, ResourceIdentity identity) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", (String)identity);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"checkExistenceAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 404) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ResourceExistsResult result = null;
            result = new ResourceExistsResult();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == 200) {
                result.setExists(true);
            } else {
                result.setExists(false);
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ResourceExistsResult resourceExistsResult = result;
            return resourceExistsResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ResourceCreateOrUpdateResult> createOrUpdateAsync(final String resourceGroupName, final ResourceIdentity identity, final GenericResource parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceCreateOrUpdateResult>(){

            @Override
            public ResourceCreateOrUpdateResult call() throws Exception {
                return ResourceOperationsImpl.this.createOrUpdate(resourceGroupName, identity, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceCreateOrUpdateResult createOrUpdate(String resourceGroupName, ResourceIdentity identity, GenericResource parameters) throws IOException, ServiceException, URISyntaxException {
        ObjectNode genericResourceValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", identity);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = genericResourceValue = objectMapper.createObjectNode();
        if (parameters.getProperties() != null) {
            genericResourceValue.put("properties", objectMapper.readTree(parameters.getProperties()));
        }
        if (parameters.getProvisioningState() != null) {
            genericResourceValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getPlan() != null) {
            ObjectNode planValue = objectMapper.createObjectNode();
            genericResourceValue.put("plan", (JsonNode)planValue);
            if (parameters.getPlan().getName() != null) {
                planValue.put("name", parameters.getPlan().getName());
            }
            if (parameters.getPlan().getPublisher() != null) {
                planValue.put("publisher", parameters.getPlan().getPublisher());
            }
            if (parameters.getPlan().getProduct() != null) {
                planValue.put("product", parameters.getPlan().getProduct());
            }
            if (parameters.getPlan().getPromotionCode() != null) {
                planValue.put("promotionCode", parameters.getPlan().getPromotionCode());
            }
        }
        genericResourceValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            genericResourceValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ResourceCreateOrUpdateResult result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceCreateOrUpdateResult();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue;
                    JsonNode planValue2;
                    JsonNode provisioningStateValue2;
                    JsonNode propertiesValue2;
                    JsonNode provisioningStateValue;
                    GenericResourceExtended resourceInstance = new GenericResourceExtended();
                    result.setResource(resourceInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode) && (provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                        resourceInstance.setProvisioningState(provisioningStateInstance);
                    }
                    if ((propertiesValue2 = responseDoc.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                        String propertiesInstance = propertiesValue2.getTextValue();
                        resourceInstance.setProperties(propertiesInstance);
                    }
                    if ((provisioningStateValue2 = responseDoc.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                        String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                        resourceInstance.setProvisioningState(provisioningStateInstance2);
                    }
                    if ((planValue2 = responseDoc.get("plan")) != null && !(planValue2 instanceof NullNode)) {
                        JsonNode promotionCodeValue;
                        JsonNode productValue;
                        JsonNode publisherValue;
                        Plan planInstance = new Plan();
                        resourceInstance.setPlan(planInstance);
                        JsonNode nameValue = planValue2.get("name");
                        if (nameValue != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        if ((publisherValue = planValue2.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                            String publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        if ((productValue = planValue2.get("product")) != null && !(productValue instanceof NullNode)) {
                            String productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        if ((promotionCodeValue = planValue2.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                            String promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            resourceInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ResourceCreateOrUpdateResult resourceCreateOrUpdateResult = result;
            return resourceCreateOrUpdateResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final ResourceIdentity identity) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ResourceOperationsImpl.this.delete(resourceGroupName, identity);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, ResourceIdentity identity) throws InterruptedException, ExecutionException, IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", (String)identity);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ResourceGetResult> getAsync(final String resourceGroupName, final ResourceIdentity identity) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceGetResult>(){

            @Override
            public ResourceGetResult call() throws Exception {
                return ResourceOperationsImpl.this.get(resourceGroupName, identity);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceGetResult get(String resourceGroupName, ResourceIdentity identity) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (resourceGroupName != null && resourceGroupName.length() > 1000) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", resourceGroupName)) {
            throw new IllegalArgumentException("resourceGroupName");
        }
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("identity", (String)identity);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourcegroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/";
        if (identity.getParentResourcePath() != null) {
            url = url + identity.getParentResourcePath();
        }
        url = url + "/";
        url = url + identity.getResourceType();
        url = url + "/";
        url = url + URLEncoder.encode(identity.getResourceName(), "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ResourceGetResult result = null;
            if (statusCode == 200 || statusCode == 204) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceGetResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue2;
                    JsonNode idValue;
                    JsonNode planValue;
                    JsonNode provisioningStateValue2;
                    JsonNode propertiesValue2;
                    JsonNode provisioningStateValue;
                    GenericResourceExtended resourceInstance = new GenericResourceExtended();
                    result.setResource(resourceInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode) && (provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                        String provisioningStateInstance = provisioningStateValue.getTextValue();
                        resourceInstance.setProvisioningState(provisioningStateInstance);
                    }
                    if ((propertiesValue2 = responseDoc.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                        String propertiesInstance = propertiesValue2.getTextValue();
                        resourceInstance.setProperties(propertiesInstance);
                    }
                    if ((provisioningStateValue2 = responseDoc.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                        String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                        resourceInstance.setProvisioningState(provisioningStateInstance2);
                    }
                    if ((planValue = responseDoc.get("plan")) != null && !(planValue instanceof NullNode)) {
                        JsonNode promotionCodeValue;
                        JsonNode productValue;
                        JsonNode publisherValue;
                        Plan planInstance = new Plan();
                        resourceInstance.setPlan(planInstance);
                        JsonNode nameValue = planValue.get("name");
                        if (nameValue != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        if ((publisherValue = planValue.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                            String publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        if ((productValue = planValue.get("product")) != null && !(productValue instanceof NullNode)) {
                            String productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        if ((promotionCodeValue = planValue.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                            String promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        resourceInstance.setId(idInstance);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        resourceInstance.setName(nameInstance2);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        resourceInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        resourceInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            resourceInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ResourceGetResult resourceGetResult = result;
            return resourceGetResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ResourceListResult> listAsync(final ResourceListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceListResult>(){

            @Override
            public ResourceListResult call() throws Exception {
                return ResourceOperationsImpl.this.list(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceListResult list(ResourceListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, ResourceListParameters> tracingParameters = new HashMap<String, ResourceListParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/";
        if (parameters != null && parameters.getResourceGroupName() != null) {
            url = url + "resourceGroups/" + URLEncoder.encode(parameters.getResourceGroupName(), "UTF-8") + "/";
        }
        url = url + "resources";
        ArrayList<String> queryParameters = new ArrayList<String>();
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getResourceType() != null) {
            odataFilter.add("resourceType eq '" + URLEncoder.encode(parameters.getResourceType(), "UTF-8") + "'");
        }
        if (parameters != null && parameters.getTagName() != null) {
            odataFilter.add("tagname eq '" + URLEncoder.encode(parameters.getTagName(), "UTF-8") + "'");
        }
        if (parameters != null && parameters.getTagValue() != null) {
            odataFilter.add("tagvalue eq '" + URLEncoder.encode(parameters.getTagValue(), "UTF-8") + "'");
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, (String)" and "));
        }
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ResourceListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue;
                            JsonNode planValue;
                            JsonNode provisioningStateValue2;
                            JsonNode propertiesValue2;
                            JsonNode provisioningStateValue;
                            GenericResourceExtended resourceJsonFormatInstance = new GenericResourceExtended();
                            result.getResources().add(resourceJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode) && (provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                resourceJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                            }
                            if ((propertiesValue2 = valueValue.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                                String propertiesInstance = propertiesValue2.getTextValue();
                                resourceJsonFormatInstance.setProperties(propertiesInstance);
                            }
                            if ((provisioningStateValue2 = valueValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                resourceJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                            }
                            if ((planValue = valueValue.get("plan")) != null && !(planValue instanceof NullNode)) {
                                JsonNode promotionCodeValue;
                                JsonNode productValue;
                                JsonNode publisherValue;
                                Plan planInstance = new Plan();
                                resourceJsonFormatInstance.setPlan(planInstance);
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                if ((publisherValue = planValue.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                                    String publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                if ((productValue = planValue.get("product")) != null && !(productValue instanceof NullNode)) {
                                    String productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                if ((promotionCodeValue = planValue.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                                    String promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                resourceJsonFormatInstance.setId(idInstance);
                            }
                            if ((nameValue2 = valueValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                resourceJsonFormatInstance.setName(nameInstance2);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                resourceJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                resourceJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                resourceJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ResourceListResult resourceListResult = result;
            return resourceListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ResourceListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceListResult>(){

            @Override
            public ResourceListResult call() throws Exception {
                return ResourceOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ResourceListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue2;
                            JsonNode idValue;
                            JsonNode planValue;
                            JsonNode provisioningStateValue2;
                            JsonNode propertiesValue2;
                            JsonNode provisioningStateValue;
                            GenericResourceExtended resourceJsonFormatInstance = new GenericResourceExtended();
                            result.getResources().add(resourceJsonFormatInstance);
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && !(propertiesValue instanceof NullNode) && (provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                String provisioningStateInstance = provisioningStateValue.getTextValue();
                                resourceJsonFormatInstance.setProvisioningState(provisioningStateInstance);
                            }
                            if ((propertiesValue2 = valueValue.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                                String propertiesInstance = propertiesValue2.getTextValue();
                                resourceJsonFormatInstance.setProperties(propertiesInstance);
                            }
                            if ((provisioningStateValue2 = valueValue.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                resourceJsonFormatInstance.setProvisioningState(provisioningStateInstance2);
                            }
                            if ((planValue = valueValue.get("plan")) != null && !(planValue instanceof NullNode)) {
                                JsonNode promotionCodeValue;
                                JsonNode productValue;
                                JsonNode publisherValue;
                                Plan planInstance = new Plan();
                                resourceJsonFormatInstance.setPlan(planInstance);
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                if ((publisherValue = planValue.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                                    String publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                if ((productValue = planValue.get("product")) != null && !(productValue instanceof NullNode)) {
                                    String productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                if ((promotionCodeValue = planValue.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                                    String promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            if ((idValue = valueValue.get("id")) != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                resourceJsonFormatInstance.setId(idInstance);
                            }
                            if ((nameValue2 = valueValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                resourceJsonFormatInstance.setName(nameInstance2);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                resourceJsonFormatInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                resourceJsonFormatInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                resourceJsonFormatInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ResourceListResult resourceListResult = result;
            return resourceListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> moveResourcesAsync(final String sourceResourceGroupName, final ResourcesMoveInfo parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ResourceOperationsImpl.this.moveResources(sourceResourceGroupName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse moveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) throws IOException, ServiceException {
        ObjectNode resourcesMoveInfoValue;
        String baseUrl;
        if (sourceResourceGroupName == null) {
            throw new NullPointerException("sourceResourceGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("sourceResourceGroupName", sourceResourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"moveResourcesAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(sourceResourceGroupName, "UTF-8");
        url = url + "/moveResources";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = resourcesMoveInfoValue = objectMapper.createObjectNode();
        if (parameters.getResources() != null && (!(parameters.getResources() instanceof LazyCollection) || ((LazyCollection)parameters.getResources()).isInitialized())) {
            ArrayNode resourcesArray = objectMapper.createArrayNode();
            for (String resourcesItem : parameters.getResources()) {
                resourcesArray.add(resourcesItem);
            }
            resourcesMoveInfoValue.put("resources", (JsonNode)resourcesArray);
        }
        if (parameters.getTargetResourceGroup() != null) {
            resourcesMoveInfoValue.put("targetResourceGroup", parameters.getTargetResourceGroup());
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

