/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.ResourceProviderOperationDetailsOperations;
import com.microsoft.azure.management.resources.models.ResourceProviderOperationDefinition;
import com.microsoft.azure.management.resources.models.ResourceProviderOperationDetailListResult;
import com.microsoft.azure.management.resources.models.ResourceProviderOperationDisplayProperties;
import com.microsoft.windowsazure.core.ResourceIdentity;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class ResourceProviderOperationDetailsOperationsImpl
implements ServiceOperations<ResourceManagementClientImpl>,
ResourceProviderOperationDetailsOperations {
    private ResourceManagementClientImpl client;

    ResourceProviderOperationDetailsOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }

    public ResourceManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<ResourceProviderOperationDetailListResult> listAsync(final ResourceIdentity identity) {
        return this.getClient().getExecutorService().submit(new Callable<ResourceProviderOperationDetailListResult>(){

            @Override
            public ResourceProviderOperationDetailListResult call() throws Exception {
                return ResourceProviderOperationDetailsOperationsImpl.this.list(identity);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceProviderOperationDetailListResult list(ResourceIdentity identity) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (identity == null) {
            throw new NullPointerException("identity");
        }
        if (identity.getResourceName() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderApiVersion() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceProviderNamespace() == null) {
            throw new NullPointerException("identity.");
        }
        if (identity.getResourceType() == null) {
            throw new NullPointerException("identity.");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, ResourceIdentity> tracingParameters = new HashMap<String, ResourceIdentity>();
            tracingParameters.put("identity", identity);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/providers/";
        url = url + URLEncoder.encode(identity.getResourceProviderNamespace(), "UTF-8");
        url = url + "/operations";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + URLEncoder.encode(identity.getResourceProviderApiVersion(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ResourceProviderOperationDetailListResult result = null;
            if (statusCode == 200 || statusCode == 204) {
                JsonNode valueArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ResourceProviderOperationDetailListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueArray = responseDoc.get("value")) != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode descriptionValue;
                        JsonNode operationValue;
                        JsonNode resourceValue;
                        JsonNode providerValue;
                        JsonNode displayValue;
                        ResourceProviderOperationDefinition resourceProviderOperationDefinitionInstance = new ResourceProviderOperationDefinition();
                        result.getResourceProviderOperationDetails().add(resourceProviderOperationDefinitionInstance);
                        JsonNode nameValue = valueValue.get("name");
                        if (nameValue != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            resourceProviderOperationDefinitionInstance.setName(nameInstance);
                        }
                        if ((displayValue = valueValue.get("display")) == null || displayValue instanceof NullNode) continue;
                        ResourceProviderOperationDisplayProperties displayInstance = new ResourceProviderOperationDisplayProperties();
                        resourceProviderOperationDefinitionInstance.setResourceProviderOperationDisplayProperties(displayInstance);
                        JsonNode publisherValue = displayValue.get("publisher");
                        if (publisherValue != null && !(publisherValue instanceof NullNode)) {
                            String publisherInstance = publisherValue.getTextValue();
                            displayInstance.setPublisher(publisherInstance);
                        }
                        if ((providerValue = displayValue.get("provider")) != null && !(providerValue instanceof NullNode)) {
                            String providerInstance = providerValue.getTextValue();
                            displayInstance.setProvider(providerInstance);
                        }
                        if ((resourceValue = displayValue.get("resource")) != null && !(resourceValue instanceof NullNode)) {
                            String resourceInstance = resourceValue.getTextValue();
                            displayInstance.setResource(resourceInstance);
                        }
                        if ((operationValue = displayValue.get("operation")) != null && !(operationValue instanceof NullNode)) {
                            String operationInstance = operationValue.getTextValue();
                            displayInstance.setOperation(operationInstance);
                        }
                        if ((descriptionValue = displayValue.get("description")) == null || descriptionValue instanceof NullNode) continue;
                        String descriptionInstance = descriptionValue.getTextValue();
                        displayInstance.setDescription(descriptionInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ResourceProviderOperationDetailListResult resourceProviderOperationDetailListResult = result;
            return resourceProviderOperationDetailListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

