/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources;

import com.microsoft.azure.management.resources.ResourceManagementClientImpl;
import com.microsoft.azure.management.resources.TagOperations;
import com.microsoft.azure.management.resources.models.TagCount;
import com.microsoft.azure.management.resources.models.TagCreateResult;
import com.microsoft.azure.management.resources.models.TagCreateValueResult;
import com.microsoft.azure.management.resources.models.TagDetails;
import com.microsoft.azure.management.resources.models.TagValue;
import com.microsoft.azure.management.resources.models.TagsListResult;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class TagOperationsImpl
implements ServiceOperations<ResourceManagementClientImpl>,
TagOperations {
    private ResourceManagementClientImpl client;

    TagOperationsImpl(ResourceManagementClientImpl client) {
        this.client = client;
    }

    public ResourceManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<TagCreateResult> createOrUpdateAsync(final String tagName) {
        return this.getClient().getExecutorService().submit(new Callable<TagCreateResult>(){

            @Override
            public TagCreateResult call() throws Exception {
                return TagOperationsImpl.this.createOrUpdate(tagName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagCreateResult createOrUpdate(String tagName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (tagName == null) {
            throw new NullPointerException("tagName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("tagName", tagName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames/";
        url = url + URLEncoder.encode(tagName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            TagCreateResult result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new TagCreateResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode valuesArray;
                    JsonNode countValue;
                    JsonNode tagNameValue;
                    TagDetails tagInstance = new TagDetails();
                    result.setTag(tagInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        tagInstance.setId(idInstance);
                    }
                    if ((tagNameValue = responseDoc.get("tagName")) != null && !(tagNameValue instanceof NullNode)) {
                        String tagNameInstance = tagNameValue.getTextValue();
                        tagInstance.setName(tagNameInstance);
                    }
                    if ((countValue = responseDoc.get("count")) != null && !(countValue instanceof NullNode)) {
                        JsonNode valueValue;
                        TagCount countInstance = new TagCount();
                        tagInstance.setCount(countInstance);
                        JsonNode typeValue = countValue.get("type");
                        if (typeValue != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            countInstance.setType(typeInstance);
                        }
                        if ((valueValue = countValue.get("value")) != null && !(valueValue instanceof NullNode)) {
                            String valueInstance = valueValue.getTextValue();
                            countInstance.setValue(valueInstance);
                        }
                    }
                    if ((valuesArray = responseDoc.get("values")) != null && !(valuesArray instanceof NullNode)) {
                        for (JsonNode valuesValue : (ArrayNode)valuesArray) {
                            JsonNode valueValue2;
                            JsonNode countValue2;
                            JsonNode tagValueValue;
                            TagValue tagValueInstance = new TagValue();
                            tagInstance.getValues().add(tagValueInstance);
                            JsonNode idValue2 = valuesValue.get("id");
                            if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                String idInstance2 = idValue2.getTextValue();
                                tagValueInstance.setId(idInstance2);
                            }
                            if ((tagValueValue = valuesValue.get("tagValue")) != null && !(tagValueValue instanceof NullNode)) {
                                String tagValueInstance2 = tagValueValue.getTextValue();
                                tagValueInstance.setValue(tagValueInstance2);
                            }
                            if ((countValue2 = valuesValue.get("count")) == null || countValue2 instanceof NullNode) continue;
                            TagCount countInstance2 = new TagCount();
                            tagValueInstance.setCount(countInstance2);
                            JsonNode typeValue2 = countValue2.get("type");
                            if (typeValue2 != null && !(typeValue2 instanceof NullNode)) {
                                String typeInstance2 = typeValue2.getTextValue();
                                countInstance2.setType(typeInstance2);
                            }
                            if ((valueValue2 = countValue2.get("value")) == null || valueValue2 instanceof NullNode) continue;
                            String valueInstance2 = valueValue2.getTextValue();
                            countInstance2.setValue(valueInstance2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            TagCreateResult tagCreateResult = result;
            return tagCreateResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<TagCreateValueResult> createOrUpdateValueAsync(final String tagName, final String tagValue) {
        return this.getClient().getExecutorService().submit(new Callable<TagCreateValueResult>(){

            @Override
            public TagCreateValueResult call() throws Exception {
                return TagOperationsImpl.this.createOrUpdateValue(tagName, tagValue);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagCreateValueResult createOrUpdateValue(String tagName, String tagValue) throws IOException, ServiceException {
        String baseUrl;
        if (tagName == null) {
            throw new NullPointerException("tagName");
        }
        if (tagValue == null) {
            throw new NullPointerException("tagValue");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("tagName", tagName);
            tracingParameters.put("tagValue", tagValue);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateValueAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames/";
        url = url + URLEncoder.encode(tagName, "UTF-8");
        url = url + "/tagValues/";
        url = url + URLEncoder.encode(tagValue, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            TagCreateValueResult result = null;
            if (statusCode == 200 || statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new TagCreateValueResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode countValue;
                    JsonNode tagValueValue;
                    TagValue valueInstance = new TagValue();
                    result.setValue(valueInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        valueInstance.setId(idInstance);
                    }
                    if ((tagValueValue = responseDoc.get("tagValue")) != null && !(tagValueValue instanceof NullNode)) {
                        String tagValueInstance = tagValueValue.getTextValue();
                        valueInstance.setValue(tagValueInstance);
                    }
                    if ((countValue = responseDoc.get("count")) != null && !(countValue instanceof NullNode)) {
                        JsonNode valueValue;
                        TagCount countInstance = new TagCount();
                        valueInstance.setCount(countInstance);
                        JsonNode typeValue = countValue.get("type");
                        if (typeValue != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            countInstance.setType(typeInstance);
                        }
                        if ((valueValue = countValue.get("value")) != null && !(valueValue instanceof NullNode)) {
                            String valueInstance2 = valueValue.getTextValue();
                            countInstance.setValue(valueInstance2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            TagCreateValueResult tagCreateValueResult = result;
            return tagCreateValueResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String tagName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return TagOperationsImpl.this.delete(tagName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String tagName) throws InterruptedException, ExecutionException, IOException, ServiceException {
        String baseUrl;
        if (tagName == null) {
            throw new NullPointerException("tagName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("tagName", tagName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames/";
        url = url + URLEncoder.encode(tagName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteValueAsync(final String tagName, final String tagValue) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return TagOperationsImpl.this.deleteValue(tagName, tagValue);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse deleteValue(String tagName, String tagValue) throws IOException, ServiceException {
        String baseUrl;
        if (tagName == null) {
            throw new NullPointerException("tagName");
        }
        if (tagValue == null) {
            throw new NullPointerException("tagValue");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("tagName", tagName);
            tracingParameters.put("tagValue", tagValue);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteValueAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames/";
        url = url + URLEncoder.encode(tagName, "UTF-8");
        url = url + "/tagValues/";
        url = url + URLEncoder.encode(tagValue, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<TagsListResult> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<TagsListResult>(){

            @Override
            public TagsListResult call() throws Exception {
                return TagOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagsListResult list() throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/tagNames";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            TagsListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new TagsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode valuesArray;
                            JsonNode countValue;
                            JsonNode tagNameValue;
                            TagDetails tagDetailsInstance = new TagDetails();
                            result.getTags().add(tagDetailsInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                tagDetailsInstance.setId(idInstance);
                            }
                            if ((tagNameValue = valueValue.get("tagName")) != null && !(tagNameValue instanceof NullNode)) {
                                String tagNameInstance = tagNameValue.getTextValue();
                                tagDetailsInstance.setName(tagNameInstance);
                            }
                            if ((countValue = valueValue.get("count")) != null && !(countValue instanceof NullNode)) {
                                JsonNode valueValue2;
                                TagCount countInstance = new TagCount();
                                tagDetailsInstance.setCount(countInstance);
                                JsonNode typeValue = countValue.get("type");
                                if (typeValue != null && !(typeValue instanceof NullNode)) {
                                    String typeInstance = typeValue.getTextValue();
                                    countInstance.setType(typeInstance);
                                }
                                if ((valueValue2 = countValue.get("value")) != null && !(valueValue2 instanceof NullNode)) {
                                    String valueInstance = valueValue2.getTextValue();
                                    countInstance.setValue(valueInstance);
                                }
                            }
                            if ((valuesArray = valueValue.get("values")) == null || valuesArray instanceof NullNode) continue;
                            for (JsonNode valuesValue : (ArrayNode)valuesArray) {
                                JsonNode valueValue3;
                                JsonNode countValue2;
                                JsonNode tagValueValue;
                                TagValue tagValueInstance = new TagValue();
                                tagDetailsInstance.getValues().add(tagValueInstance);
                                JsonNode idValue2 = valuesValue.get("id");
                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                    String idInstance2 = idValue2.getTextValue();
                                    tagValueInstance.setId(idInstance2);
                                }
                                if ((tagValueValue = valuesValue.get("tagValue")) != null && !(tagValueValue instanceof NullNode)) {
                                    String tagValueInstance2 = tagValueValue.getTextValue();
                                    tagValueInstance.setValue(tagValueInstance2);
                                }
                                if ((countValue2 = valuesValue.get("count")) == null || countValue2 instanceof NullNode) continue;
                                TagCount countInstance2 = new TagCount();
                                tagValueInstance.setCount(countInstance2);
                                JsonNode typeValue2 = countValue2.get("type");
                                if (typeValue2 != null && !(typeValue2 instanceof NullNode)) {
                                    String typeInstance2 = typeValue2.getTextValue();
                                    countInstance2.setType(typeInstance2);
                                }
                                if ((valueValue3 = countValue2.get("value")) == null || valueValue3 instanceof NullNode) continue;
                                String valueInstance2 = valueValue3.getTextValue();
                                countInstance2.setValue(valueInstance2);
                            }
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            TagsListResult tagsListResult = result;
            return tagsListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<TagsListResult> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<TagsListResult>(){

            @Override
            public TagsListResult call() throws Exception {
                return TagOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagsListResult listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            TagsListResult result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new TagsListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode odatanextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode valuesArray;
                            JsonNode countValue;
                            JsonNode tagNameValue;
                            TagDetails tagDetailsInstance = new TagDetails();
                            result.getTags().add(tagDetailsInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                tagDetailsInstance.setId(idInstance);
                            }
                            if ((tagNameValue = valueValue.get("tagName")) != null && !(tagNameValue instanceof NullNode)) {
                                String tagNameInstance = tagNameValue.getTextValue();
                                tagDetailsInstance.setName(tagNameInstance);
                            }
                            if ((countValue = valueValue.get("count")) != null && !(countValue instanceof NullNode)) {
                                JsonNode valueValue2;
                                TagCount countInstance = new TagCount();
                                tagDetailsInstance.setCount(countInstance);
                                JsonNode typeValue = countValue.get("type");
                                if (typeValue != null && !(typeValue instanceof NullNode)) {
                                    String typeInstance = typeValue.getTextValue();
                                    countInstance.setType(typeInstance);
                                }
                                if ((valueValue2 = countValue.get("value")) != null && !(valueValue2 instanceof NullNode)) {
                                    String valueInstance = valueValue2.getTextValue();
                                    countInstance.setValue(valueInstance);
                                }
                            }
                            if ((valuesArray = valueValue.get("values")) == null || valuesArray instanceof NullNode) continue;
                            for (JsonNode valuesValue : (ArrayNode)valuesArray) {
                                JsonNode valueValue3;
                                JsonNode countValue2;
                                JsonNode tagValueValue;
                                TagValue tagValueInstance = new TagValue();
                                tagDetailsInstance.getValues().add(tagValueInstance);
                                JsonNode idValue2 = valuesValue.get("id");
                                if (idValue2 != null && !(idValue2 instanceof NullNode)) {
                                    String idInstance2 = idValue2.getTextValue();
                                    tagValueInstance.setId(idInstance2);
                                }
                                if ((tagValueValue = valuesValue.get("tagValue")) != null && !(tagValueValue instanceof NullNode)) {
                                    String tagValueInstance2 = tagValueValue.getTextValue();
                                    tagValueInstance.setValue(tagValueInstance2);
                                }
                                if ((countValue2 = valuesValue.get("count")) == null || countValue2 instanceof NullNode) continue;
                                TagCount countInstance2 = new TagCount();
                                tagValueInstance.setCount(countInstance2);
                                JsonNode typeValue2 = countValue2.get("type");
                                if (typeValue2 != null && !(typeValue2 instanceof NullNode)) {
                                    String typeInstance2 = typeValue2.getTextValue();
                                    countInstance2.setType(typeInstance2);
                                }
                                if ((valueValue3 = countValue2.get("value")) == null || valueValue3 instanceof NullNode) continue;
                                String valueInstance2 = valueValue3.getTextValue();
                                countInstance2.setValue(valueInstance2);
                            }
                        }
                    }
                    if ((odatanextLinkValue = responseDoc.get("@odata.nextLink")) != null && !(odatanextLinkValue instanceof NullNode)) {
                        String odatanextLinkInstance = odatanextLinkValue.getTextValue();
                        result.setNextLink(odatanextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            TagsListResult tagsListResult = result;
            return tagsListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

