/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.subscriptions;

import com.microsoft.azure.subscriptions.SubscriptionClientImpl;
import com.microsoft.azure.subscriptions.TenantOperations;
import com.microsoft.azure.subscriptions.models.TenantIdDescription;
import com.microsoft.azure.subscriptions.models.TenantListResult;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class TenantOperationsImpl
implements ServiceOperations<SubscriptionClientImpl>,
TenantOperations {
    private SubscriptionClientImpl client;

    TenantOperationsImpl(SubscriptionClientImpl client) {
        this.client = client;
    }

    public SubscriptionClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<TenantListResult> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<TenantListResult>(){

            @Override
            public TenantListResult call() throws Exception {
                return TenantOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TenantListResult list() throws IOException, ServiceException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/tenants";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2014-04-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            TenantListResult result = null;
            if (statusCode == 200) {
                JsonNode valueArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new TenantListResult();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueArray = responseDoc.get("value")) != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode tenantIdValue;
                        TenantIdDescription tenantIdDescriptionInstance = new TenantIdDescription();
                        result.getTenantIds().add(tenantIdDescriptionInstance);
                        JsonNode idValue = valueValue.get("id");
                        if (idValue != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            tenantIdDescriptionInstance.setId(idInstance);
                        }
                        if ((tenantIdValue = valueValue.get("tenantId")) == null || tenantIdValue instanceof NullNode) continue;
                        String tenantIdInstance = tenantIdValue.getTextValue();
                        tenantIdDescriptionInstance.setTenantId(tenantIdInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            TenantListResult tenantListResult = result;
            return tenantListResult;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

