/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.dag;

import com.microsoft.azure.management.resources.fluentcore.dag.DAGraph;
import com.microsoft.azure.management.resources.fluentcore.dag.ErroredDependencyTaskException;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskCancelledException;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroupEntry;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroupTerminateOnErrorStrategy;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskItem;
import java.util.ArrayList;
import java.util.HashSet;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

public class TaskGroup<ResultT, TaskT extends TaskItem<ResultT>>
extends DAGraph<TaskT, TaskGroupEntry<ResultT, TaskT>> {
    private final TaskGroupTerminateOnErrorStrategy taskGroupTerminateOnErrorStrategy;
    private boolean isGroupCancelled;
    private final TaskCancelledException taskCancelledException = new TaskCancelledException();

    private TaskGroup(TaskGroupEntry<ResultT, TaskT> rootTaskEntry, TaskGroupTerminateOnErrorStrategy taskGroupTerminateOnErrorStrategy) {
        super(rootTaskEntry);
        this.taskGroupTerminateOnErrorStrategy = taskGroupTerminateOnErrorStrategy;
    }

    public TaskGroup(String rootTaskItemId, TaskT rootTaskItem, TaskGroupTerminateOnErrorStrategy taskGroupTerminateOnErrorStrategy) {
        this(new TaskGroupEntry(rootTaskItemId, rootTaskItem), taskGroupTerminateOnErrorStrategy);
    }

    public ResultT taskResult(String taskId) {
        TaskGroupEntry taskGroupEntry = (TaskGroupEntry)super.getNode(taskId);
        if (taskGroupEntry == null) {
            throw new IllegalArgumentException("A task with id '" + taskId + "' is not found");
        }
        return taskGroupEntry.taskResult();
    }

    @Override
    public void merge(TaskGroup<ResultT, TaskT> parentTaskGroup) {
        super.merge(parentTaskGroup);
    }

    public Observable<ResultT> executeAsync() {
        if (!this.isPreparer()) {
            return Observable.error((Throwable)new IllegalStateException("executeAsync can be called only from root TaskGroup"));
        }
        this.isGroupCancelled = false;
        this.prepareTasks();
        return this.executeReadyTasksAsync();
    }

    private void prepareTasks() {
        boolean isPreparePending;
        HashSet<String> preparedTasksKeys = new HashSet<String>();
        do {
            isPreparePending = false;
            super.prepare();
            TaskGroupEntry entry = (TaskGroupEntry)super.getNext();
            while (entry != null) {
                if (!preparedTasksKeys.contains(entry.key())) {
                    int dependencyCountBefore = entry.dependencyKeys().size();
                    ((TaskItem)entry.data()).prepare();
                    int dependencyCountAfter = entry.dependencyKeys().size();
                    if (dependencyCountAfter - dependencyCountBefore > 0) {
                        isPreparePending = true;
                    }
                    preparedTasksKeys.add(entry.key());
                }
                for (String parentKey : entry.dependentKeys()) {
                    super.mergeChildToParent(parentKey, entry);
                }
                super.reportCompletion(entry);
                entry = (TaskGroupEntry)super.getNext();
            }
        } while (isPreparePending);
        super.prepare();
    }

    private Observable<ResultT> executeReadyTasksAsync() {
        TaskGroupEntry entry = (TaskGroupEntry)super.getNext();
        ArrayList<Observable> observables = new ArrayList<Observable>();
        while (entry != null) {
            final TaskGroupEntry currentEntry = entry;
            Observable<ResultT> currentTaskObservable = this.executeTaskAsync(currentEntry);
            Func1 onNext = new Func1<ResultT, Observable<ResultT>>(){

                public Observable<ResultT> call(ResultT taskResult) {
                    return Observable.just(taskResult);
                }
            };
            Func1 onError = new Func1<Throwable, Observable<ResultT>>(){

                public Observable<ResultT> call(Throwable throwable) {
                    return TaskGroup.this.processFaultedTaskAsync(currentEntry, throwable);
                }
            };
            Func0 onComplete = new Func0<Observable<ResultT>>(){

                public Observable<ResultT> call() {
                    return TaskGroup.this.processCompletedTaskAsync(currentEntry);
                }
            };
            observables.add(currentTaskObservable.flatMap(onNext, onError, onComplete));
            entry = (TaskGroupEntry)super.getNext();
        }
        return Observable.mergeDelayError(observables);
    }

    private Observable<ResultT> executeTaskAsync(TaskGroupEntry<ResultT, TaskT> entry) {
        if (this.isGroupCancelled) {
            return this.toErrorObservable(this.taskCancelledException);
        }
        return entry.executeTaskAsync(this.isRootEntry(entry));
    }

    private Observable<ResultT> processCompletedTaskAsync(TaskGroupEntry<ResultT, TaskT> completedEntry) {
        this.reportCompletion(completedEntry);
        if (this.isRootEntry(completedEntry)) {
            return Observable.empty();
        }
        return this.executeReadyTasksAsync();
    }

    private Observable<ResultT> processFaultedTaskAsync(TaskGroupEntry<ResultT, TaskT> faultedEntry, Throwable throwable) {
        this.isGroupCancelled = this.taskGroupTerminateOnErrorStrategy == TaskGroupTerminateOnErrorStrategy.TERMINATE_ON_INPROGRESS_TASKS_COMPLETION;
        this.reportError(faultedEntry, throwable);
        if (this.isRootEntry(faultedEntry)) {
            if (this.shouldPropagateException(throwable)) {
                return this.toErrorObservable(throwable);
            }
            return Observable.empty();
        }
        if (this.shouldPropagateException(throwable)) {
            return Observable.concatDelayError(this.executeReadyTasksAsync(), this.toErrorObservable(throwable));
        }
        return this.executeReadyTasksAsync();
    }

    private boolean isRootEntry(TaskGroupEntry<ResultT, TaskT> taskGroupEntry) {
        return this.isRootNode(taskGroupEntry);
    }

    private boolean shouldPropagateException(Throwable throwable) {
        return !(throwable instanceof ErroredDependencyTaskException) && !(throwable instanceof TaskCancelledException);
    }

    private Observable<ResultT> toErrorObservable(Throwable throwable) {
        return Observable.error((Throwable)throwable);
    }

    public static interface HasTaskGroup<T, U extends TaskItem<T>> {
        public TaskGroup<T, U> taskGroup();
    }
}

