/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.Subscription;
import com.microsoft.azure.management.resources.Subscriptions;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.SupportsGettingByIdImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.implementation.SubscriptionImpl;
import com.microsoft.azure.management.resources.implementation.SubscriptionInner;
import com.microsoft.azure.management.resources.implementation.SubscriptionsInner;
import rx.Observable;
import rx.functions.Func1;

final class SubscriptionsImpl
extends SupportsGettingByIdImpl<Subscription>
implements Subscriptions {
    private final SubscriptionsInner client;

    SubscriptionsImpl(SubscriptionsInner client) {
        this.client = client;
    }

    @Override
    public PagedList<Subscription> list() {
        PagedListConverter<SubscriptionInner, Subscription> converter = new PagedListConverter<SubscriptionInner, Subscription>(){

            @Override
            public Subscription typeConvert(SubscriptionInner subscriptionInner) {
                return SubscriptionsImpl.this.wrapModel(subscriptionInner);
            }
        };
        return converter.convert(this.client.list());
    }

    @Override
    public Observable<Subscription> getByIdAsync(String id) {
        return this.client.getAsync(id).map((Func1)new Func1<SubscriptionInner, Subscription>(){

            public Subscription call(SubscriptionInner subscriptionInner) {
                return SubscriptionsImpl.this.wrapModel(subscriptionInner);
            }
        });
    }

    @Override
    public Observable<Subscription> listAsync() {
        return ReadableWrappersImpl.convertPageToInnerAsync(this.client.listAsync()).map((Func1)new Func1<SubscriptionInner, Subscription>(){

            public Subscription call(SubscriptionInner subscriptionInner) {
                return SubscriptionsImpl.this.wrapModel(subscriptionInner);
            }
        });
    }

    private SubscriptionImpl wrapModel(SubscriptionInner subscriptionInner) {
        if (subscriptionInner == null) {
            return null;
        }
        return new SubscriptionImpl(subscriptionInner, this.client);
    }
}

