/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.servicebus.NamespaceAuthorizationRule;
import com.microsoft.azure.management.servicebus.NamespaceAuthorizationRules;
import com.microsoft.azure.management.servicebus.ServiceBusNamespace;
import com.microsoft.azure.management.servicebus.implementation.NamespaceAuthorizationRuleImpl;
import com.microsoft.azure.management.servicebus.implementation.NamespacesInner;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.SharedAccessAuthorizationRuleInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import rx.Completable;
import rx.Observable;

@LangDefinition
class NamespaceAuthorizationRulesImpl
extends ServiceBusChildResourcesImpl<NamespaceAuthorizationRule, NamespaceAuthorizationRuleImpl, SharedAccessAuthorizationRuleInner, NamespacesInner, ServiceBusManager, ServiceBusNamespace>
implements NamespaceAuthorizationRules {
    private final String resourceGroupName;
    private final String namespaceName;
    private final Region region;

    NamespaceAuthorizationRulesImpl(String resourceGroupName, String namespaceName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClientImpl)((Object)manager.inner())).namespaces(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.region = region;
    }

    public NamespaceAuthorizationRuleImpl define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByNameAsync(String name) {
        return ((NamespacesInner)this.inner()).deleteAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, name).toCompletable();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ((NamespacesInner)this.inner()).deleteAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, name, callback);
    }

    @Override
    protected Observable<SharedAccessAuthorizationRuleInner> getInnerByNameAsync(String name) {
        return ((NamespacesInner)this.inner()).getAuthorizationRuleAsync(this.resourceGroupName, this.namespaceName, name);
    }

    @Override
    protected Observable<ServiceResponse<Page<SharedAccessAuthorizationRuleInner>>> listInnerAsync() {
        return ((NamespacesInner)this.inner()).listAuthorizationRulesWithServiceResponseAsync(this.resourceGroupName, this.namespaceName);
    }

    @Override
    protected PagedList<SharedAccessAuthorizationRuleInner> listInner() {
        return ((NamespacesInner)this.inner()).listAuthorizationRules(this.resourceGroupName, this.namespaceName);
    }

    protected NamespaceAuthorizationRuleImpl wrapModel(String name) {
        return new NamespaceAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, name, this.region, new SharedAccessAuthorizationRuleInner(), (ServiceBusManager)this.manager());
    }

    protected NamespaceAuthorizationRuleImpl wrapModel(SharedAccessAuthorizationRuleInner inner) {
        return new NamespaceAuthorizationRuleImpl(this.resourceGroupName, this.namespaceName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedList<NamespaceAuthorizationRule> listByParent(String resourceGroupName, String parentName) {
        throw new UnsupportedOperationException();
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        throw new UnsupportedOperationException();
    }

    public Observable<NamespaceAuthorizationRule> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw new UnsupportedOperationException();
    }
}

