/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.servicebus.EntityStatus;
import com.microsoft.azure.management.servicebus.ServiceBusSubscription;
import com.microsoft.azure.management.servicebus.Topic;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.SubscriptionInner;
import com.microsoft.azure.management.servicebus.implementation.TimeSpan;
import org.joda.time.DateTime;
import org.joda.time.Period;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ServiceBusSubscriptionImpl
extends IndependentChildResourceImpl<ServiceBusSubscription, Topic, SubscriptionInner, ServiceBusSubscriptionImpl, ServiceBusManager>
implements ServiceBusSubscription,
ServiceBusSubscription.Definition,
ServiceBusSubscription.Update {
    private final String namespaceName;
    private final Region region;

    ServiceBusSubscriptionImpl(String resourceGroupName, String namespaceName, String topicName, String name, Region region, SubscriptionInner inner, ServiceBusManager manager) {
        super(name, (Resource)inner, (Object)manager);
        this.namespaceName = namespaceName;
        this.region = region;
        this.withExistingParentResource(resourceGroupName, topicName);
        if (inner.location() == null) {
            inner.withLocation(this.region.toString());
        }
    }

    @Override
    public DateTime createdAt() {
        return ((SubscriptionInner)((Object)this.inner())).createdAt();
    }

    @Override
    public DateTime accessedAt() {
        return ((SubscriptionInner)((Object)this.inner())).accessedAt();
    }

    @Override
    public DateTime updatedAt() {
        return ((SubscriptionInner)((Object)this.inner())).updatedAt();
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((SubscriptionInner)((Object)this.inner())).enableBatchedOperations());
    }

    @Override
    public boolean isDeadLetteringEnabledForExpiredMessages() {
        return Utils.toPrimitiveBoolean((Boolean)((SubscriptionInner)((Object)this.inner())).deadLetteringOnMessageExpiration());
    }

    @Override
    public boolean isSessionEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((SubscriptionInner)((Object)this.inner())).requiresSession());
    }

    @Override
    public long lockDurationInSeconds() {
        if (((SubscriptionInner)((Object)this.inner())).lockDuration() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((SubscriptionInner)((Object)this.inner())).lockDuration());
        return (long)timeSpan.totalSeconds();
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((SubscriptionInner)((Object)this.inner())).autoDeleteOnIdle() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((SubscriptionInner)((Object)this.inner())).autoDeleteOnIdle());
        return (long)timeSpan.totalMinutes();
    }

    @Override
    public Period defaultMessageTtlDuration() {
        if (((SubscriptionInner)((Object)this.inner())).defaultMessageTimeToLive() == null) {
            return null;
        }
        TimeSpan timeSpan = TimeSpan.parse(((SubscriptionInner)((Object)this.inner())).defaultMessageTimeToLive());
        return new Period().withDays(timeSpan.days()).withHours(timeSpan.hours()).withMinutes(timeSpan.minutes()).withSeconds(timeSpan.seconds()).withMillis(timeSpan.milliseconds());
    }

    @Override
    public int maxDeliveryCountBeforeDeadLetteringMessage() {
        return Utils.toPrimitiveInt((Integer)((SubscriptionInner)((Object)this.inner())).maxDeliveryCount());
    }

    @Override
    public long messageCount() {
        return Utils.toPrimitiveLong((Long)((SubscriptionInner)((Object)this.inner())).messageCount());
    }

    @Override
    public long activeMessageCount() {
        if (((SubscriptionInner)((Object)this.inner())).countDetails() == null || ((SubscriptionInner)((Object)this.inner())).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((SubscriptionInner)((Object)this.inner())).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((SubscriptionInner)((Object)this.inner())).countDetails() == null || ((SubscriptionInner)((Object)this.inner())).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((SubscriptionInner)((Object)this.inner())).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((SubscriptionInner)((Object)this.inner())).countDetails() == null || ((SubscriptionInner)((Object)this.inner())).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((SubscriptionInner)((Object)this.inner())).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((SubscriptionInner)((Object)this.inner())).countDetails() == null || ((SubscriptionInner)((Object)this.inner())).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((SubscriptionInner)((Object)this.inner())).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((SubscriptionInner)((Object)this.inner())).countDetails() == null || ((SubscriptionInner)((Object)this.inner())).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((SubscriptionInner)((Object)this.inner())).countDetails().transferMessageCount());
    }

    @Override
    public EntityStatus status() {
        return ((SubscriptionInner)((Object)this.inner())).status();
    }

    @Override
    public boolean isDeadLetteringEnabledForFilterEvaluationFailedMessages() {
        return Utils.toPrimitiveBoolean((Boolean)((SubscriptionInner)((Object)this.inner())).deadLetteringOnFilterEvaluationExceptions());
    }

    @Override
    public ServiceBusSubscriptionImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        TimeSpan timeSpan = new TimeSpan().withMinutes(durationInMinutes);
        ((SubscriptionInner)((Object)this.inner())).withAutoDeleteOnIdle(timeSpan.toString());
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageLockDurationInSeconds(int durationInSeconds) {
        TimeSpan timeSpan = new TimeSpan().withSeconds(durationInSeconds);
        ((SubscriptionInner)((Object)this.inner())).withLockDuration(timeSpan.toString());
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withDefaultMessageTTL(Period ttl) {
        ((SubscriptionInner)((Object)this.inner())).withDefaultMessageTimeToLive(TimeSpan.fromPeriod(ttl).toString());
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withSession() {
        ((SubscriptionInner)((Object)this.inner())).withRequiresSession(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutSession() {
        ((SubscriptionInner)((Object)this.inner())).withRequiresSession(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageBatching() {
        ((SubscriptionInner)((Object)this.inner())).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutMessageBatching() {
        ((SubscriptionInner)((Object)this.inner())).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterSubscriptionOnMaxDeliveryCount(int deliveryCount) {
        ((SubscriptionInner)((Object)this.inner())).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterSubscriptionOnFilterEvaluationException() {
        ((SubscriptionInner)((Object)this.inner())).withDeadLetteringOnFilterEvaluationExceptions(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutMessageMovedToDeadLetterSubscriptionOnFilterEvaluationException() {
        ((SubscriptionInner)((Object)this.inner())).withDeadLetteringOnFilterEvaluationExceptions(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withExpiredMessageMovedToDeadLetterSubscription() {
        ((SubscriptionInner)((Object)this.inner())).withDeadLetteringOnMessageExpiration(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutExpiredMessageMovedToDeadLetterSubscription() {
        ((SubscriptionInner)((Object)this.inner())).withDeadLetteringOnMessageExpiration(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int deliveryCount) {
        ((SubscriptionInner)((Object)this.inner())).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    protected Observable<SubscriptionInner> getInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).subscriptions().getAsync(this.resourceGroupName(), this.namespaceName, this.parentName, this.name());
    }

    protected Observable<ServiceBusSubscription> createChildResourceAsync() {
        final ServiceBusSubscriptionImpl self = this;
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).subscriptions().createOrUpdateAsync(this.resourceGroupName(), this.namespaceName, this.parentName, this.name(), (SubscriptionInner)((Object)this.inner())).map((Func1)new Func1<SubscriptionInner, ServiceBusSubscription>(){

            public ServiceBusSubscription call(SubscriptionInner inner) {
                ServiceBusSubscriptionImpl.this.setInner((Object)inner);
                return self;
            }
        });
    }
}

