/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingByParent;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsListingByParent;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.IndependentChildResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlElasticPools;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.DatabasesImpl;
import com.microsoft.azure.management.sql.implementation.ElasticPoolInner;
import com.microsoft.azure.management.sql.implementation.ElasticPoolsInner;
import com.microsoft.azure.management.sql.implementation.SqlElasticPoolImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SqlElasticPoolsImpl
extends IndependentChildResourcesImpl<SqlElasticPool, SqlElasticPoolImpl, ElasticPoolInner, ElasticPoolsInner, SqlServerManager, SqlServer>
implements SqlElasticPools.SqlElasticPoolsCreatable,
SupportsGettingByParent<SqlElasticPool, SqlServer, SqlServerManager>,
SupportsListingByParent<SqlElasticPool, SqlServer, SqlServerManager> {
    private final DatabasesImpl databasesImpl;

    protected SqlElasticPoolsImpl(SqlServerManager manager, DatabasesImpl databasesImpl) {
        super((Object)((SqlManagementClientImpl)((Object)manager.inner())).elasticPools(), (ManagerBase)manager);
        this.databasesImpl = databasesImpl;
    }

    protected SqlElasticPoolImpl wrapModel(String name) {
        ElasticPoolInner inner = new ElasticPoolInner();
        return new SqlElasticPoolImpl(name, inner, this.databasesImpl, (SqlServerManager)this.manager());
    }

    public Observable<SqlElasticPool> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((ElasticPoolsInner)this.innerCollection).getAsync(resourceGroup, parentName, name).map((Func1)new Func1<ElasticPoolInner, SqlElasticPool>(){

            public SqlElasticPool call(ElasticPoolInner elasticPoolInner) {
                return SqlElasticPoolsImpl.this.wrapModel(elasticPoolInner);
            }
        });
    }

    public PagedList<SqlElasticPool> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((ElasticPoolsInner)this.innerCollection).listByServer(resourceGroupName, parentName));
    }

    protected SqlElasticPoolImpl wrapModel(ElasticPoolInner inner) {
        if (inner == null) {
            return null;
        }
        return new SqlElasticPoolImpl(inner.name(), inner, this.databasesImpl, (SqlServerManager)this.manager());
    }

    public SqlElasticPool.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        return ((ElasticPoolsInner)this.innerCollection).deleteAsync(groupName, parentName, name).toCompletable();
    }

    @Override
    public SqlElasticPool getBySqlServer(String resourceGroup, String sqlServerName, String name) {
        return (SqlElasticPool)this.getByParent(resourceGroup, sqlServerName, name);
    }

    @Override
    public SqlElasticPool getBySqlServer(SqlServer sqlServer, String name) {
        return (SqlElasticPool)this.getByParent((Resource)sqlServer, name);
    }

    @Override
    public List<SqlElasticPool> listBySqlServer(String resourceGroupName, String sqlServerName) {
        return this.listByParent(resourceGroupName, sqlServerName);
    }

    @Override
    public List<SqlElasticPool> listBySqlServer(SqlServer sqlServer) {
        return this.listByParent((Resource)sqlServer);
    }

    @Override
    public SqlElasticPool.DefinitionStages.Blank definedWithSqlServer(String resourceGroupName, String sqlServerName, String elasticPoolName, Region region) {
        ElasticPoolInner inner = new ElasticPoolInner();
        inner.withLocation(region.name());
        return (SqlElasticPool.DefinitionStages.Blank)new SqlElasticPoolImpl(elasticPoolName, inner, this.databasesImpl, (SqlServerManager)this.manager()).withExistingParentResource(resourceGroupName, sqlServerName);
    }
}

