/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.CreateDatabaseRestorePointDefinition;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.RestorePointInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class RestorePointsInner {
    private RestorePointsService service;
    private SqlManagementClientImpl client;

    public RestorePointsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (RestorePointsService)retrofit.create(RestorePointsService.class);
        this.client = client;
    }

    public List<RestorePointInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        return (List)((ServiceResponse)this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<RestorePointInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<List<RestorePointInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<List<RestorePointInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<List<RestorePointInner>>, List<RestorePointInner>>(){

            public List<RestorePointInner> call(ServiceResponse<List<RestorePointInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<RestorePointInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByDatabase(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<RestorePointInner>>>>(){

            public Observable<ServiceResponse<List<RestorePointInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RestorePointsInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RestorePointInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RestorePointInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RestorePointInner create(String resourceGroupName, String serverName, String databaseName, String restorePointLabel) {
        return (RestorePointInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointLabel).toBlocking().last()).body());
    }

    public ServiceFuture<RestorePointInner> createAsync(String resourceGroupName, String serverName, String databaseName, String restorePointLabel, ServiceCallback<RestorePointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointLabel), serviceCallback);
    }

    public Observable<RestorePointInner> createAsync(String resourceGroupName, String serverName, String databaseName, String restorePointLabel) {
        return this.createWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointLabel).map((Func1)new Func1<ServiceResponse<RestorePointInner>, RestorePointInner>(){

            public RestorePointInner call(ServiceResponse<RestorePointInner> response) {
                return (RestorePointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RestorePointInner>> createWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String restorePointLabel) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (restorePointLabel == null) {
            throw new IllegalArgumentException("Parameter restorePointLabel is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        CreateDatabaseRestorePointDefinition parameters = new CreateDatabaseRestorePointDefinition();
        parameters.withRestorePointLabel(restorePointLabel);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<RestorePointInner>(){}.getType());
    }

    public RestorePointInner beginCreate(String resourceGroupName, String serverName, String databaseName, String restorePointLabel) {
        return (RestorePointInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointLabel).toBlocking().single()).body());
    }

    public ServiceFuture<RestorePointInner> beginCreateAsync(String resourceGroupName, String serverName, String databaseName, String restorePointLabel, ServiceCallback<RestorePointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointLabel), serviceCallback);
    }

    public Observable<RestorePointInner> beginCreateAsync(String resourceGroupName, String serverName, String databaseName, String restorePointLabel) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointLabel).map((Func1)new Func1<ServiceResponse<RestorePointInner>, RestorePointInner>(){

            public RestorePointInner call(ServiceResponse<RestorePointInner> response) {
                return (RestorePointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RestorePointInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String restorePointLabel) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (restorePointLabel == null) {
            throw new IllegalArgumentException("Parameter restorePointLabel is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        CreateDatabaseRestorePointDefinition parameters = new CreateDatabaseRestorePointDefinition();
        parameters.withRestorePointLabel(restorePointLabel);
        return this.service.beginCreate(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RestorePointInner>>>(){

            public Observable<ServiceResponse<RestorePointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RestorePointsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RestorePointInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RestorePointInner>(){}.getType()).register(201, new TypeToken<RestorePointInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RestorePointInner get(String resourceGroupName, String serverName, String databaseName, String restorePointName) {
        return (RestorePointInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointName).toBlocking().single()).body());
    }

    public ServiceFuture<RestorePointInner> getAsync(String resourceGroupName, String serverName, String databaseName, String restorePointName, ServiceCallback<RestorePointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointName), serviceCallback);
    }

    public Observable<RestorePointInner> getAsync(String resourceGroupName, String serverName, String databaseName, String restorePointName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointName).map((Func1)new Func1<ServiceResponse<RestorePointInner>, RestorePointInner>(){

            public RestorePointInner call(ServiceResponse<RestorePointInner> response) {
                return (RestorePointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RestorePointInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String restorePointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (restorePointName == null) {
            throw new IllegalArgumentException("Parameter restorePointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, databaseName, restorePointName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RestorePointInner>>>(){

            public Observable<ServiceResponse<RestorePointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RestorePointsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RestorePointInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RestorePointInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String databaseName, String restorePointName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String restorePointName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String restorePointName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName, restorePointName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String restorePointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (restorePointName == null) {
            throw new IllegalArgumentException("Parameter restorePointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.delete(resourceGroupName, serverName, databaseName, restorePointName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RestorePointsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RestorePointsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorePoints listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorePoints create"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body CreateDatabaseRestorePointDefinition var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorePoints beginCreate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body CreateDatabaseRestorePointDefinition var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorePoints get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints/{restorePointName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="restorePointName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorePoints delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/restorePoints/{restorePointName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="restorePointName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

