/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage;

import com.microsoft.azure.management.storage.StorageAccountOperations;
import com.microsoft.azure.management.storage.StorageManagementClient;
import com.microsoft.azure.management.storage.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.models.AccountStatus;
import com.microsoft.azure.management.storage.models.AccountType;
import com.microsoft.azure.management.storage.models.CheckNameAvailabilityResponse;
import com.microsoft.azure.management.storage.models.CustomDomain;
import com.microsoft.azure.management.storage.models.Endpoints;
import com.microsoft.azure.management.storage.models.KeyName;
import com.microsoft.azure.management.storage.models.ProvisioningState;
import com.microsoft.azure.management.storage.models.Reason;
import com.microsoft.azure.management.storage.models.StorageAccount;
import com.microsoft.azure.management.storage.models.StorageAccountCreateParameters;
import com.microsoft.azure.management.storage.models.StorageAccountCreateResponse;
import com.microsoft.azure.management.storage.models.StorageAccountGetPropertiesResponse;
import com.microsoft.azure.management.storage.models.StorageAccountKeys;
import com.microsoft.azure.management.storage.models.StorageAccountListKeysResponse;
import com.microsoft.azure.management.storage.models.StorageAccountListResponse;
import com.microsoft.azure.management.storage.models.StorageAccountRegenerateKeyResponse;
import com.microsoft.azure.management.storage.models.StorageAccountUpdateParameters;
import com.microsoft.azure.management.storage.models.StorageAccountUpdateResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class StorageAccountOperationsImpl
implements ServiceOperations<StorageManagementClientImpl>,
StorageAccountOperations {
    private StorageManagementClientImpl client;

    StorageAccountOperationsImpl(StorageManagementClientImpl client) {
        this.client = client;
    }

    public StorageManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<StorageAccountCreateResponse> beginCreateAsync(final String resourceGroupName, final String accountName, final StorageAccountCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountCreateResponse>(){

            @Override
            public StorageAccountCreateResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.beginCreate(resourceGroupName, accountName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountCreateResponse beginCreate(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters) throws IOException, ServiceException, URISyntaxException {
        ObjectNode storageAccountCreateParametersJsonValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        if (accountName.length() < 3) {
            throw new IllegalArgumentException("accountName");
        }
        if (accountName.length() > 24) {
            throw new IllegalArgumentException("accountName");
        }
        for (char accountNameChar : accountName.toCharArray()) {
            if (Character.isLowerCase(accountNameChar) || Character.isDigit(accountNameChar)) continue;
            throw new IllegalArgumentException("accountName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getAccountType() == null) {
            throw new NullPointerException("parameters.AccountType");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("accountName", accountName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/Microsoft.Storage/storageAccounts/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = storageAccountCreateParametersJsonValue = objectMapper.createObjectNode();
        storageAccountCreateParametersJsonValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null && (!(parameters.getTags() instanceof LazyCollection) || ((LazyCollection)parameters.getTags()).isInitialized())) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            storageAccountCreateParametersJsonValue.put("tags", (JsonNode)tagsDictionary);
        }
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        storageAccountCreateParametersJsonValue.put("properties", (JsonNode)propertiesValue);
        propertiesValue.put("accountType", StorageManagementClientImpl.accountTypeToString(parameters.getAccountType()));
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountCreateResponse result = null;
            if (statusCode == 200 || statusCode == 202) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountCreateResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode propertiesValue2;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue;
                    StorageAccount storageAccountInstance = new StorageAccount();
                    result.setStorageAccount(storageAccountInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        storageAccountInstance.setId(idInstance);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        storageAccountInstance.setName(nameInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        storageAccountInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        storageAccountInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            storageAccountInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((propertiesValue2 = responseDoc.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode secondaryEndpointsValue;
                        JsonNode customDomainValue;
                        JsonNode creationTimeValue;
                        JsonNode statusOfSecondaryValue;
                        JsonNode secondaryLocationValue;
                        JsonNode lastGeoFailoverTimeValue;
                        JsonNode statusOfPrimaryValue;
                        JsonNode primaryLocationValue;
                        JsonNode primaryEndpointsValue;
                        JsonNode accountTypeValue;
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                            ProvisioningState provisioningStateInstance = Enum.valueOf(ProvisioningState.class, provisioningStateValue.getTextValue().toUpperCase());
                            storageAccountInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((accountTypeValue = propertiesValue2.get("accountType")) != null && !(accountTypeValue instanceof NullNode)) {
                            AccountType accountTypeInstance = StorageManagementClientImpl.parseAccountType(accountTypeValue.getTextValue());
                            storageAccountInstance.setAccountType(accountTypeInstance);
                        }
                        if ((primaryEndpointsValue = propertiesValue2.get("primaryEndpoints")) != null && !(primaryEndpointsValue instanceof NullNode)) {
                            JsonNode tableValue;
                            JsonNode queueValue;
                            Endpoints primaryEndpointsInstance = new Endpoints();
                            storageAccountInstance.setPrimaryEndpoints(primaryEndpointsInstance);
                            JsonNode blobValue = primaryEndpointsValue.get("blob");
                            if (blobValue != null && !(blobValue instanceof NullNode)) {
                                URI blobInstance = new URI(blobValue.getTextValue());
                                primaryEndpointsInstance.setBlob(blobInstance);
                            }
                            if ((queueValue = primaryEndpointsValue.get("queue")) != null && !(queueValue instanceof NullNode)) {
                                URI queueInstance = new URI(queueValue.getTextValue());
                                primaryEndpointsInstance.setQueue(queueInstance);
                            }
                            if ((tableValue = primaryEndpointsValue.get("table")) != null && !(tableValue instanceof NullNode)) {
                                URI tableInstance = new URI(tableValue.getTextValue());
                                primaryEndpointsInstance.setTable(tableInstance);
                            }
                        }
                        if ((primaryLocationValue = propertiesValue2.get("primaryLocation")) != null && !(primaryLocationValue instanceof NullNode)) {
                            String primaryLocationInstance = primaryLocationValue.getTextValue();
                            storageAccountInstance.setPrimaryLocation(primaryLocationInstance);
                        }
                        if ((statusOfPrimaryValue = propertiesValue2.get("statusOfPrimary")) != null && !(statusOfPrimaryValue instanceof NullNode)) {
                            AccountStatus statusOfPrimaryInstance = Enum.valueOf(AccountStatus.class, statusOfPrimaryValue.getTextValue().toUpperCase());
                            storageAccountInstance.setStatusOfPrimary(statusOfPrimaryInstance);
                        }
                        if ((lastGeoFailoverTimeValue = propertiesValue2.get("lastGeoFailoverTime")) != null && !(lastGeoFailoverTimeValue instanceof NullNode)) {
                            Calendar lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime((String)lastGeoFailoverTimeValue.getTextValue());
                            storageAccountInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                        }
                        if ((secondaryLocationValue = propertiesValue2.get("secondaryLocation")) != null && !(secondaryLocationValue instanceof NullNode)) {
                            String secondaryLocationInstance = secondaryLocationValue.getTextValue();
                            storageAccountInstance.setSecondaryLocation(secondaryLocationInstance);
                        }
                        if ((statusOfSecondaryValue = propertiesValue2.get("statusOfSecondary")) != null && !(statusOfSecondaryValue instanceof NullNode)) {
                            AccountStatus statusOfSecondaryInstance = Enum.valueOf(AccountStatus.class, statusOfSecondaryValue.getTextValue().toUpperCase());
                            storageAccountInstance.setStatusOfSecondary(statusOfSecondaryInstance);
                        }
                        if ((creationTimeValue = propertiesValue2.get("creationTime")) != null && !(creationTimeValue instanceof NullNode)) {
                            Calendar creationTimeInstance = DatatypeConverter.parseDateTime((String)creationTimeValue.getTextValue());
                            storageAccountInstance.setCreationTime(creationTimeInstance);
                        }
                        if ((customDomainValue = propertiesValue2.get("customDomain")) != null && !(customDomainValue instanceof NullNode)) {
                            JsonNode useSubDomainValue;
                            CustomDomain customDomainInstance = new CustomDomain();
                            storageAccountInstance.setCustomDomain(customDomainInstance);
                            JsonNode nameValue2 = customDomainValue.get("name");
                            if (nameValue2 != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                customDomainInstance.setName(nameInstance2);
                            }
                            if ((useSubDomainValue = customDomainValue.get("useSubDomain")) != null && !(useSubDomainValue instanceof NullNode)) {
                                boolean useSubDomainInstance = useSubDomainValue.getBooleanValue();
                                customDomainInstance.setUseSubDomain(useSubDomainInstance);
                            }
                        }
                        if ((secondaryEndpointsValue = propertiesValue2.get("secondaryEndpoints")) != null && !(secondaryEndpointsValue instanceof NullNode)) {
                            JsonNode tableValue2;
                            JsonNode queueValue2;
                            Endpoints secondaryEndpointsInstance = new Endpoints();
                            storageAccountInstance.setSecondaryEndpoints(secondaryEndpointsInstance);
                            JsonNode blobValue2 = secondaryEndpointsValue.get("blob");
                            if (blobValue2 != null && !(blobValue2 instanceof NullNode)) {
                                URI blobInstance2 = new URI(blobValue2.getTextValue());
                                secondaryEndpointsInstance.setBlob(blobInstance2);
                            }
                            if ((queueValue2 = secondaryEndpointsValue.get("queue")) != null && !(queueValue2 instanceof NullNode)) {
                                URI queueInstance2 = new URI(queueValue2.getTextValue());
                                secondaryEndpointsInstance.setQueue(queueInstance2);
                            }
                            if ((tableValue2 = secondaryEndpointsValue.get("table")) != null && !(tableValue2 instanceof NullNode)) {
                                URI tableInstance2 = new URI(tableValue2.getTextValue());
                                secondaryEndpointsInstance.setTable(tableInstance2);
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Location").length > 0) {
                result.setOperationStatusLink(httpResponse.getFirstHeader("Location").getValue());
            }
            if (httpResponse.getHeaders("RetryAfter").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("RetryAfter").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == 409 || statusCode == 400) {
                result.setStatus(OperationStatus.FAILED);
            }
            if (statusCode == 200) {
                result.setStatus(OperationStatus.SUCCEEDED);
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountCreateResponse storageAccountCreateResponse = result;
            return storageAccountCreateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<CheckNameAvailabilityResponse> checkNameAvailabilityAsync(final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<CheckNameAvailabilityResponse>(){

            @Override
            public CheckNameAvailabilityResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.checkNameAvailability(accountName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckNameAvailabilityResponse checkNameAvailability(String accountName) throws IOException, ServiceException {
        ObjectNode storageAccountCheckNameAvailabilityParametersValue;
        String baseUrl;
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"checkNameAvailabilityAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Storage/checkNameAvailability";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json");
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = storageAccountCheckNameAvailabilityParametersValue = objectMapper.createObjectNode();
        storageAccountCheckNameAvailabilityParametersValue.put("name", accountName);
        storageAccountCheckNameAvailabilityParametersValue.put("type", "Microsoft.Storage/storageAccounts");
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            CheckNameAvailabilityResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new CheckNameAvailabilityResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode messageValue;
                    JsonNode reasonValue;
                    JsonNode nameAvailableValue = responseDoc.get("nameAvailable");
                    if (nameAvailableValue != null && !(nameAvailableValue instanceof NullNode)) {
                        boolean nameAvailableInstance = nameAvailableValue.getBooleanValue();
                        result.setNameAvailable(nameAvailableInstance);
                    }
                    if ((reasonValue = responseDoc.get("reason")) != null && !(reasonValue instanceof NullNode)) {
                        Reason reasonInstance = Enum.valueOf(Reason.class, reasonValue.getTextValue().toUpperCase());
                        result.setReason(reasonInstance);
                    }
                    if ((messageValue = responseDoc.get("message")) != null && !(messageValue instanceof NullNode)) {
                        String messageInstance = messageValue.getTextValue();
                        result.setMessage(messageInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            CheckNameAvailabilityResponse checkNameAvailabilityResponse = result;
            return checkNameAvailabilityResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountCreateResponse> createAsync(final String resourceGroupName, final String accountName, final StorageAccountCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountCreateResponse>(){

            @Override
            public StorageAccountCreateResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.create(resourceGroupName, accountName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountCreateResponse create(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters) throws InterruptedException, ExecutionException, IOException {
        StorageManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("accountName", accountName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        try {
            StorageAccountCreateResponse response;
            if (shouldTrace) {
                client2 = (StorageManagementClient)((StorageManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            if ((response = client2.getStorageAccountsOperations().beginCreateAsync(resourceGroupName, accountName, parameters).get()).getStatus() == OperationStatus.SUCCEEDED) {
                StorageAccountCreateResponse storageAccountCreateResponse = response;
                return storageAccountCreateResponse;
            }
            StorageAccountCreateResponse result = client2.getCreateOperationStatusAsync(response.getOperationStatusLink()).get();
            int delayInSeconds = response.getRetryAfter();
            if (delayInSeconds == 0) {
                delayInSeconds = 25;
            }
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getCreateOperationStatusAsync(response.getOperationStatusLink()).get();
                delayInSeconds = result.getRetryAfter();
                if (delayInSeconds == 0) {
                    delayInSeconds = 25;
                }
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountCreateResponse storageAccountCreateResponse = result;
            return storageAccountCreateResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.delete(resourceGroupName, accountName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String accountName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        if (accountName.length() < 3) {
            throw new IllegalArgumentException("accountName");
        }
        if (accountName.length() > 24) {
            throw new IllegalArgumentException("accountName");
        }
        for (char accountNameChar : accountName.toCharArray()) {
            if (Character.isLowerCase(accountNameChar) || Character.isDigit(accountNameChar)) continue;
            throw new IllegalArgumentException("accountName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/Microsoft.Storage/storageAccounts/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountGetPropertiesResponse> getPropertiesAsync(final String resourceGroupName, final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountGetPropertiesResponse>(){

            @Override
            public StorageAccountGetPropertiesResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.getProperties(resourceGroupName, accountName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountGetPropertiesResponse getProperties(String resourceGroupName, String accountName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        if (accountName.length() < 3) {
            throw new IllegalArgumentException("accountName");
        }
        if (accountName.length() > 24) {
            throw new IllegalArgumentException("accountName");
        }
        for (char accountNameChar : accountName.toCharArray()) {
            if (Character.isLowerCase(accountNameChar) || Character.isDigit(accountNameChar)) continue;
            throw new IllegalArgumentException("accountName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getPropertiesAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/Microsoft.Storage/storageAccounts/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountGetPropertiesResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountGetPropertiesResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode propertiesValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue;
                    StorageAccount storageAccountInstance = new StorageAccount();
                    result.setStorageAccount(storageAccountInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        storageAccountInstance.setId(idInstance);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        storageAccountInstance.setName(nameInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        storageAccountInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        storageAccountInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            storageAccountInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode secondaryEndpointsValue;
                        JsonNode customDomainValue;
                        JsonNode creationTimeValue;
                        JsonNode statusOfSecondaryValue;
                        JsonNode secondaryLocationValue;
                        JsonNode lastGeoFailoverTimeValue;
                        JsonNode statusOfPrimaryValue;
                        JsonNode primaryLocationValue;
                        JsonNode primaryEndpointsValue;
                        JsonNode accountTypeValue;
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                            ProvisioningState provisioningStateInstance = Enum.valueOf(ProvisioningState.class, provisioningStateValue.getTextValue().toUpperCase());
                            storageAccountInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((accountTypeValue = propertiesValue.get("accountType")) != null && !(accountTypeValue instanceof NullNode)) {
                            AccountType accountTypeInstance = StorageManagementClientImpl.parseAccountType(accountTypeValue.getTextValue());
                            storageAccountInstance.setAccountType(accountTypeInstance);
                        }
                        if ((primaryEndpointsValue = propertiesValue.get("primaryEndpoints")) != null && !(primaryEndpointsValue instanceof NullNode)) {
                            JsonNode tableValue;
                            JsonNode queueValue;
                            Endpoints primaryEndpointsInstance = new Endpoints();
                            storageAccountInstance.setPrimaryEndpoints(primaryEndpointsInstance);
                            JsonNode blobValue = primaryEndpointsValue.get("blob");
                            if (blobValue != null && !(blobValue instanceof NullNode)) {
                                URI blobInstance = new URI(blobValue.getTextValue());
                                primaryEndpointsInstance.setBlob(blobInstance);
                            }
                            if ((queueValue = primaryEndpointsValue.get("queue")) != null && !(queueValue instanceof NullNode)) {
                                URI queueInstance = new URI(queueValue.getTextValue());
                                primaryEndpointsInstance.setQueue(queueInstance);
                            }
                            if ((tableValue = primaryEndpointsValue.get("table")) != null && !(tableValue instanceof NullNode)) {
                                URI tableInstance = new URI(tableValue.getTextValue());
                                primaryEndpointsInstance.setTable(tableInstance);
                            }
                        }
                        if ((primaryLocationValue = propertiesValue.get("primaryLocation")) != null && !(primaryLocationValue instanceof NullNode)) {
                            String primaryLocationInstance = primaryLocationValue.getTextValue();
                            storageAccountInstance.setPrimaryLocation(primaryLocationInstance);
                        }
                        if ((statusOfPrimaryValue = propertiesValue.get("statusOfPrimary")) != null && !(statusOfPrimaryValue instanceof NullNode)) {
                            AccountStatus statusOfPrimaryInstance = Enum.valueOf(AccountStatus.class, statusOfPrimaryValue.getTextValue().toUpperCase());
                            storageAccountInstance.setStatusOfPrimary(statusOfPrimaryInstance);
                        }
                        if ((lastGeoFailoverTimeValue = propertiesValue.get("lastGeoFailoverTime")) != null && !(lastGeoFailoverTimeValue instanceof NullNode)) {
                            Calendar lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime((String)lastGeoFailoverTimeValue.getTextValue());
                            storageAccountInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                        }
                        if ((secondaryLocationValue = propertiesValue.get("secondaryLocation")) != null && !(secondaryLocationValue instanceof NullNode)) {
                            String secondaryLocationInstance = secondaryLocationValue.getTextValue();
                            storageAccountInstance.setSecondaryLocation(secondaryLocationInstance);
                        }
                        if ((statusOfSecondaryValue = propertiesValue.get("statusOfSecondary")) != null && !(statusOfSecondaryValue instanceof NullNode)) {
                            AccountStatus statusOfSecondaryInstance = Enum.valueOf(AccountStatus.class, statusOfSecondaryValue.getTextValue().toUpperCase());
                            storageAccountInstance.setStatusOfSecondary(statusOfSecondaryInstance);
                        }
                        if ((creationTimeValue = propertiesValue.get("creationTime")) != null && !(creationTimeValue instanceof NullNode)) {
                            Calendar creationTimeInstance = DatatypeConverter.parseDateTime((String)creationTimeValue.getTextValue());
                            storageAccountInstance.setCreationTime(creationTimeInstance);
                        }
                        if ((customDomainValue = propertiesValue.get("customDomain")) != null && !(customDomainValue instanceof NullNode)) {
                            JsonNode useSubDomainValue;
                            CustomDomain customDomainInstance = new CustomDomain();
                            storageAccountInstance.setCustomDomain(customDomainInstance);
                            JsonNode nameValue2 = customDomainValue.get("name");
                            if (nameValue2 != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                customDomainInstance.setName(nameInstance2);
                            }
                            if ((useSubDomainValue = customDomainValue.get("useSubDomain")) != null && !(useSubDomainValue instanceof NullNode)) {
                                boolean useSubDomainInstance = useSubDomainValue.getBooleanValue();
                                customDomainInstance.setUseSubDomain(useSubDomainInstance);
                            }
                        }
                        if ((secondaryEndpointsValue = propertiesValue.get("secondaryEndpoints")) != null && !(secondaryEndpointsValue instanceof NullNode)) {
                            JsonNode tableValue2;
                            JsonNode queueValue2;
                            Endpoints secondaryEndpointsInstance = new Endpoints();
                            storageAccountInstance.setSecondaryEndpoints(secondaryEndpointsInstance);
                            JsonNode blobValue2 = secondaryEndpointsValue.get("blob");
                            if (blobValue2 != null && !(blobValue2 instanceof NullNode)) {
                                URI blobInstance2 = new URI(blobValue2.getTextValue());
                                secondaryEndpointsInstance.setBlob(blobInstance2);
                            }
                            if ((queueValue2 = secondaryEndpointsValue.get("queue")) != null && !(queueValue2 instanceof NullNode)) {
                                URI queueInstance2 = new URI(queueValue2.getTextValue());
                                secondaryEndpointsInstance.setQueue(queueInstance2);
                            }
                            if ((tableValue2 = secondaryEndpointsValue.get("table")) != null && !(tableValue2 instanceof NullNode)) {
                                URI tableInstance2 = new URI(tableValue2.getTextValue());
                                secondaryEndpointsInstance.setTable(tableInstance2);
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountGetPropertiesResponse storageAccountGetPropertiesResponse = result;
            return storageAccountGetPropertiesResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountListResponse>(){

            @Override
            public StorageAccountListResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountListResponse list() throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/Microsoft.Storage/storageAccounts";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tableValue2;
                            JsonNode queueValue2;
                            JsonNode secondaryEndpointsValue;
                            JsonNode customDomainValue;
                            JsonNode creationTimeValue;
                            JsonNode statusOfSecondaryValue;
                            JsonNode secondaryLocationValue;
                            JsonNode lastGeoFailoverTimeValue;
                            JsonNode statusOfPrimaryValue;
                            JsonNode primaryLocationValue;
                            JsonNode primaryEndpointsValue;
                            JsonNode accountTypeValue;
                            JsonNode propertiesValue;
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue;
                            StorageAccount storageAccountJsonInstance = new StorageAccount();
                            result.getStorageAccounts().add(storageAccountJsonInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                storageAccountJsonInstance.setId(idInstance);
                            }
                            if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                storageAccountJsonInstance.setName(nameInstance);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                storageAccountJsonInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                storageAccountJsonInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                                Iterator itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry property = (Map.Entry)itr.next();
                                    String tagsKey = (String)property.getKey();
                                    String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                    storageAccountJsonInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            if ((propertiesValue = valueValue.get("properties")) == null || propertiesValue instanceof NullNode) continue;
                            JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                            if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                                ProvisioningState provisioningStateInstance = Enum.valueOf(ProvisioningState.class, provisioningStateValue.getTextValue().toUpperCase());
                                storageAccountJsonInstance.setProvisioningState(provisioningStateInstance);
                            }
                            if ((accountTypeValue = propertiesValue.get("accountType")) != null && !(accountTypeValue instanceof NullNode)) {
                                AccountType accountTypeInstance = StorageManagementClientImpl.parseAccountType(accountTypeValue.getTextValue());
                                storageAccountJsonInstance.setAccountType(accountTypeInstance);
                            }
                            if ((primaryEndpointsValue = propertiesValue.get("primaryEndpoints")) != null && !(primaryEndpointsValue instanceof NullNode)) {
                                JsonNode tableValue;
                                JsonNode queueValue;
                                Endpoints primaryEndpointsInstance = new Endpoints();
                                storageAccountJsonInstance.setPrimaryEndpoints(primaryEndpointsInstance);
                                JsonNode blobValue = primaryEndpointsValue.get("blob");
                                if (blobValue != null && !(blobValue instanceof NullNode)) {
                                    URI blobInstance = new URI(blobValue.getTextValue());
                                    primaryEndpointsInstance.setBlob(blobInstance);
                                }
                                if ((queueValue = primaryEndpointsValue.get("queue")) != null && !(queueValue instanceof NullNode)) {
                                    URI queueInstance = new URI(queueValue.getTextValue());
                                    primaryEndpointsInstance.setQueue(queueInstance);
                                }
                                if ((tableValue = primaryEndpointsValue.get("table")) != null && !(tableValue instanceof NullNode)) {
                                    URI tableInstance = new URI(tableValue.getTextValue());
                                    primaryEndpointsInstance.setTable(tableInstance);
                                }
                            }
                            if ((primaryLocationValue = propertiesValue.get("primaryLocation")) != null && !(primaryLocationValue instanceof NullNode)) {
                                String primaryLocationInstance = primaryLocationValue.getTextValue();
                                storageAccountJsonInstance.setPrimaryLocation(primaryLocationInstance);
                            }
                            if ((statusOfPrimaryValue = propertiesValue.get("statusOfPrimary")) != null && !(statusOfPrimaryValue instanceof NullNode)) {
                                AccountStatus statusOfPrimaryInstance = Enum.valueOf(AccountStatus.class, statusOfPrimaryValue.getTextValue().toUpperCase());
                                storageAccountJsonInstance.setStatusOfPrimary(statusOfPrimaryInstance);
                            }
                            if ((lastGeoFailoverTimeValue = propertiesValue.get("lastGeoFailoverTime")) != null && !(lastGeoFailoverTimeValue instanceof NullNode)) {
                                Calendar lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime((String)lastGeoFailoverTimeValue.getTextValue());
                                storageAccountJsonInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                            }
                            if ((secondaryLocationValue = propertiesValue.get("secondaryLocation")) != null && !(secondaryLocationValue instanceof NullNode)) {
                                String secondaryLocationInstance = secondaryLocationValue.getTextValue();
                                storageAccountJsonInstance.setSecondaryLocation(secondaryLocationInstance);
                            }
                            if ((statusOfSecondaryValue = propertiesValue.get("statusOfSecondary")) != null && !(statusOfSecondaryValue instanceof NullNode)) {
                                AccountStatus statusOfSecondaryInstance = Enum.valueOf(AccountStatus.class, statusOfSecondaryValue.getTextValue().toUpperCase());
                                storageAccountJsonInstance.setStatusOfSecondary(statusOfSecondaryInstance);
                            }
                            if ((creationTimeValue = propertiesValue.get("creationTime")) != null && !(creationTimeValue instanceof NullNode)) {
                                Calendar creationTimeInstance = DatatypeConverter.parseDateTime((String)creationTimeValue.getTextValue());
                                storageAccountJsonInstance.setCreationTime(creationTimeInstance);
                            }
                            if ((customDomainValue = propertiesValue.get("customDomain")) != null && !(customDomainValue instanceof NullNode)) {
                                JsonNode useSubDomainValue;
                                CustomDomain customDomainInstance = new CustomDomain();
                                storageAccountJsonInstance.setCustomDomain(customDomainInstance);
                                JsonNode nameValue2 = customDomainValue.get("name");
                                if (nameValue2 != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    customDomainInstance.setName(nameInstance2);
                                }
                                if ((useSubDomainValue = customDomainValue.get("useSubDomain")) != null && !(useSubDomainValue instanceof NullNode)) {
                                    boolean useSubDomainInstance = useSubDomainValue.getBooleanValue();
                                    customDomainInstance.setUseSubDomain(useSubDomainInstance);
                                }
                            }
                            if ((secondaryEndpointsValue = propertiesValue.get("secondaryEndpoints")) == null || secondaryEndpointsValue instanceof NullNode) continue;
                            Endpoints secondaryEndpointsInstance = new Endpoints();
                            storageAccountJsonInstance.setSecondaryEndpoints(secondaryEndpointsInstance);
                            JsonNode blobValue2 = secondaryEndpointsValue.get("blob");
                            if (blobValue2 != null && !(blobValue2 instanceof NullNode)) {
                                URI blobInstance2 = new URI(blobValue2.getTextValue());
                                secondaryEndpointsInstance.setBlob(blobInstance2);
                            }
                            if ((queueValue2 = secondaryEndpointsValue.get("queue")) != null && !(queueValue2 instanceof NullNode)) {
                                URI queueInstance2 = new URI(queueValue2.getTextValue());
                                secondaryEndpointsInstance.setQueue(queueInstance2);
                            }
                            if ((tableValue2 = secondaryEndpointsValue.get("table")) == null || tableValue2 instanceof NullNode) continue;
                            URI tableInstance2 = new URI(tableValue2.getTextValue());
                            secondaryEndpointsInstance.setTable(tableInstance2);
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountListResponse storageAccountListResponse = result;
            return storageAccountListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountListResponse> listByResourceGroupAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountListResponse>(){

            @Override
            public StorageAccountListResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.listByResourceGroup(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountListResponse listByResourceGroup(String resourceGroupName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listByResourceGroupAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/Microsoft.Storage/storageAccounts";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tableValue2;
                            JsonNode queueValue2;
                            JsonNode secondaryEndpointsValue;
                            JsonNode customDomainValue;
                            JsonNode creationTimeValue;
                            JsonNode statusOfSecondaryValue;
                            JsonNode secondaryLocationValue;
                            JsonNode lastGeoFailoverTimeValue;
                            JsonNode statusOfPrimaryValue;
                            JsonNode primaryLocationValue;
                            JsonNode primaryEndpointsValue;
                            JsonNode accountTypeValue;
                            JsonNode propertiesValue;
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue;
                            JsonNode nameValue;
                            StorageAccount storageAccountJsonInstance = new StorageAccount();
                            result.getStorageAccounts().add(storageAccountJsonInstance);
                            JsonNode idValue = valueValue.get("id");
                            if (idValue != null && !(idValue instanceof NullNode)) {
                                String idInstance = idValue.getTextValue();
                                storageAccountJsonInstance.setId(idInstance);
                            }
                            if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                storageAccountJsonInstance.setName(nameInstance);
                            }
                            if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                                String typeInstance = typeValue.getTextValue();
                                storageAccountJsonInstance.setType(typeInstance);
                            }
                            if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                storageAccountJsonInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = valueValue.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                                Iterator itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry property = (Map.Entry)itr.next();
                                    String tagsKey = (String)property.getKey();
                                    String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                    storageAccountJsonInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                            if ((propertiesValue = valueValue.get("properties")) == null || propertiesValue instanceof NullNode) continue;
                            JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                            if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                                ProvisioningState provisioningStateInstance = Enum.valueOf(ProvisioningState.class, provisioningStateValue.getTextValue().toUpperCase());
                                storageAccountJsonInstance.setProvisioningState(provisioningStateInstance);
                            }
                            if ((accountTypeValue = propertiesValue.get("accountType")) != null && !(accountTypeValue instanceof NullNode)) {
                                AccountType accountTypeInstance = StorageManagementClientImpl.parseAccountType(accountTypeValue.getTextValue());
                                storageAccountJsonInstance.setAccountType(accountTypeInstance);
                            }
                            if ((primaryEndpointsValue = propertiesValue.get("primaryEndpoints")) != null && !(primaryEndpointsValue instanceof NullNode)) {
                                JsonNode tableValue;
                                JsonNode queueValue;
                                Endpoints primaryEndpointsInstance = new Endpoints();
                                storageAccountJsonInstance.setPrimaryEndpoints(primaryEndpointsInstance);
                                JsonNode blobValue = primaryEndpointsValue.get("blob");
                                if (blobValue != null && !(blobValue instanceof NullNode)) {
                                    URI blobInstance = new URI(blobValue.getTextValue());
                                    primaryEndpointsInstance.setBlob(blobInstance);
                                }
                                if ((queueValue = primaryEndpointsValue.get("queue")) != null && !(queueValue instanceof NullNode)) {
                                    URI queueInstance = new URI(queueValue.getTextValue());
                                    primaryEndpointsInstance.setQueue(queueInstance);
                                }
                                if ((tableValue = primaryEndpointsValue.get("table")) != null && !(tableValue instanceof NullNode)) {
                                    URI tableInstance = new URI(tableValue.getTextValue());
                                    primaryEndpointsInstance.setTable(tableInstance);
                                }
                            }
                            if ((primaryLocationValue = propertiesValue.get("primaryLocation")) != null && !(primaryLocationValue instanceof NullNode)) {
                                String primaryLocationInstance = primaryLocationValue.getTextValue();
                                storageAccountJsonInstance.setPrimaryLocation(primaryLocationInstance);
                            }
                            if ((statusOfPrimaryValue = propertiesValue.get("statusOfPrimary")) != null && !(statusOfPrimaryValue instanceof NullNode)) {
                                AccountStatus statusOfPrimaryInstance = Enum.valueOf(AccountStatus.class, statusOfPrimaryValue.getTextValue().toUpperCase());
                                storageAccountJsonInstance.setStatusOfPrimary(statusOfPrimaryInstance);
                            }
                            if ((lastGeoFailoverTimeValue = propertiesValue.get("lastGeoFailoverTime")) != null && !(lastGeoFailoverTimeValue instanceof NullNode)) {
                                Calendar lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime((String)lastGeoFailoverTimeValue.getTextValue());
                                storageAccountJsonInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                            }
                            if ((secondaryLocationValue = propertiesValue.get("secondaryLocation")) != null && !(secondaryLocationValue instanceof NullNode)) {
                                String secondaryLocationInstance = secondaryLocationValue.getTextValue();
                                storageAccountJsonInstance.setSecondaryLocation(secondaryLocationInstance);
                            }
                            if ((statusOfSecondaryValue = propertiesValue.get("statusOfSecondary")) != null && !(statusOfSecondaryValue instanceof NullNode)) {
                                AccountStatus statusOfSecondaryInstance = Enum.valueOf(AccountStatus.class, statusOfSecondaryValue.getTextValue().toUpperCase());
                                storageAccountJsonInstance.setStatusOfSecondary(statusOfSecondaryInstance);
                            }
                            if ((creationTimeValue = propertiesValue.get("creationTime")) != null && !(creationTimeValue instanceof NullNode)) {
                                Calendar creationTimeInstance = DatatypeConverter.parseDateTime((String)creationTimeValue.getTextValue());
                                storageAccountJsonInstance.setCreationTime(creationTimeInstance);
                            }
                            if ((customDomainValue = propertiesValue.get("customDomain")) != null && !(customDomainValue instanceof NullNode)) {
                                JsonNode useSubDomainValue;
                                CustomDomain customDomainInstance = new CustomDomain();
                                storageAccountJsonInstance.setCustomDomain(customDomainInstance);
                                JsonNode nameValue2 = customDomainValue.get("name");
                                if (nameValue2 != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    customDomainInstance.setName(nameInstance2);
                                }
                                if ((useSubDomainValue = customDomainValue.get("useSubDomain")) != null && !(useSubDomainValue instanceof NullNode)) {
                                    boolean useSubDomainInstance = useSubDomainValue.getBooleanValue();
                                    customDomainInstance.setUseSubDomain(useSubDomainInstance);
                                }
                            }
                            if ((secondaryEndpointsValue = propertiesValue.get("secondaryEndpoints")) == null || secondaryEndpointsValue instanceof NullNode) continue;
                            Endpoints secondaryEndpointsInstance = new Endpoints();
                            storageAccountJsonInstance.setSecondaryEndpoints(secondaryEndpointsInstance);
                            JsonNode blobValue2 = secondaryEndpointsValue.get("blob");
                            if (blobValue2 != null && !(blobValue2 instanceof NullNode)) {
                                URI blobInstance2 = new URI(blobValue2.getTextValue());
                                secondaryEndpointsInstance.setBlob(blobInstance2);
                            }
                            if ((queueValue2 = secondaryEndpointsValue.get("queue")) != null && !(queueValue2 instanceof NullNode)) {
                                URI queueInstance2 = new URI(queueValue2.getTextValue());
                                secondaryEndpointsInstance.setQueue(queueInstance2);
                            }
                            if ((tableValue2 = secondaryEndpointsValue.get("table")) == null || tableValue2 instanceof NullNode) continue;
                            URI tableInstance2 = new URI(tableValue2.getTextValue());
                            secondaryEndpointsInstance.setTable(tableInstance2);
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountListResponse storageAccountListResponse = result;
            return storageAccountListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountListKeysResponse> listKeysAsync(final String resourceGroupName, final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountListKeysResponse>(){

            @Override
            public StorageAccountListKeysResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.listKeys(resourceGroupName, accountName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountListKeysResponse listKeys(String resourceGroupName, String accountName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        if (accountName.length() < 3) {
            throw new IllegalArgumentException("accountName");
        }
        if (accountName.length() > 24) {
            throw new IllegalArgumentException("accountName");
        }
        for (char accountNameChar : accountName.toCharArray()) {
            if (Character.isLowerCase(accountNameChar) || Character.isDigit(accountNameChar)) continue;
            throw new IllegalArgumentException("accountName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listKeysAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/Microsoft.Storage/storageAccounts/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        url = url + "/listKeys";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountListKeysResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountListKeysResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode key2Value;
                    StorageAccountKeys storageAccountKeysInstance = new StorageAccountKeys();
                    result.setStorageAccountKeys(storageAccountKeysInstance);
                    JsonNode key1Value = responseDoc.get("key1");
                    if (key1Value != null && !(key1Value instanceof NullNode)) {
                        String key1Instance = key1Value.getTextValue();
                        storageAccountKeysInstance.setKey1(key1Instance);
                    }
                    if ((key2Value = responseDoc.get("key2")) != null && !(key2Value instanceof NullNode)) {
                        String key2Instance = key2Value.getTextValue();
                        storageAccountKeysInstance.setKey2(key2Instance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountListKeysResponse storageAccountListKeysResponse = result;
            return storageAccountListKeysResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountRegenerateKeyResponse> regenerateKeyAsync(final String resourceGroupName, final String accountName, final KeyName regenerateKey) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountRegenerateKeyResponse>(){

            @Override
            public StorageAccountRegenerateKeyResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.regenerateKey(resourceGroupName, accountName, regenerateKey);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountRegenerateKeyResponse regenerateKey(String resourceGroupName, String accountName, KeyName regenerateKey) throws IOException, ServiceException {
        ObjectNode storageAccountRegenerateKeyParametersValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        if (accountName.length() < 3) {
            throw new IllegalArgumentException("accountName");
        }
        if (accountName.length() > 24) {
            throw new IllegalArgumentException("accountName");
        }
        for (char accountNameChar : accountName.toCharArray()) {
            if (Character.isLowerCase(accountNameChar) || Character.isDigit(accountNameChar)) continue;
            throw new IllegalArgumentException("accountName");
        }
        if (regenerateKey == null) {
            throw new NullPointerException("regenerateKey");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("accountName", accountName);
            tracingParameters.put("regenerateKey", (Object)regenerateKey);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"regenerateKeyAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/Microsoft.Storage/storageAccounts/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        url = url + "/regenerateKey";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json");
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = storageAccountRegenerateKeyParametersValue = objectMapper.createObjectNode();
        storageAccountRegenerateKeyParametersValue.put("keyName", StorageManagementClientImpl.keyNameToString(regenerateKey));
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountRegenerateKeyResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountRegenerateKeyResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode key2Value;
                    StorageAccountKeys storageAccountKeysInstance = new StorageAccountKeys();
                    result.setStorageAccountKeys(storageAccountKeysInstance);
                    JsonNode key1Value = responseDoc.get("key1");
                    if (key1Value != null && !(key1Value instanceof NullNode)) {
                        String key1Instance = key1Value.getTextValue();
                        storageAccountKeysInstance.setKey1(key1Instance);
                    }
                    if ((key2Value = responseDoc.get("key2")) != null && !(key2Value instanceof NullNode)) {
                        String key2Instance = key2Value.getTextValue();
                        storageAccountKeysInstance.setKey2(key2Instance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountRegenerateKeyResponse storageAccountRegenerateKeyResponse = result;
            return storageAccountRegenerateKeyResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountUpdateResponse> updateAsync(final String resourceGroupName, final String accountName, final StorageAccountUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountUpdateResponse>(){

            @Override
            public StorageAccountUpdateResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.update(resourceGroupName, accountName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountUpdateResponse update(String resourceGroupName, String accountName, StorageAccountUpdateParameters parameters) throws IOException, ServiceException, URISyntaxException {
        ObjectNode storageAccountUpdateParametersJsonValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        if (accountName.length() < 3) {
            throw new IllegalArgumentException("accountName");
        }
        if (accountName.length() > 24) {
            throw new IllegalArgumentException("accountName");
        }
        for (char accountNameChar : accountName.toCharArray()) {
            if (Character.isLowerCase(accountNameChar) || Character.isDigit(accountNameChar)) continue;
            throw new IllegalArgumentException("accountName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getCustomDomain() != null && parameters.getCustomDomain().getName() == null) {
            throw new NullPointerException("parameters.CustomDomain.Name");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("accountName", accountName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/Microsoft.Storage/storageAccounts/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-05-01-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPatch httpRequest = new HttpPatch(url);
        httpRequest.setHeader("Content-Type", "application/json");
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = storageAccountUpdateParametersJsonValue = objectMapper.createObjectNode();
        if (parameters.getTags() != null && (!(parameters.getTags() instanceof LazyCollection) || ((LazyCollection)parameters.getTags()).isInitialized())) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            storageAccountUpdateParametersJsonValue.put("tags", (JsonNode)tagsDictionary);
        }
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        storageAccountUpdateParametersJsonValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getAccountType() != null) {
            propertiesValue.put("accountType", StorageManagementClientImpl.accountTypeToString(parameters.getAccountType()));
        }
        if (parameters.getCustomDomain() != null) {
            ObjectNode customDomainValue = objectMapper.createObjectNode();
            propertiesValue.put("customDomain", (JsonNode)customDomainValue);
            customDomainValue.put("name", parameters.getCustomDomain().getName());
            if (parameters.getCustomDomain().isUseSubDomain() != null) {
                customDomainValue.put("useSubDomain", parameters.getCustomDomain().isUseSubDomain());
            }
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountUpdateResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountUpdateResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode propertiesValue2;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue;
                    StorageAccount storageAccountInstance = new StorageAccount();
                    result.setStorageAccount(storageAccountInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        storageAccountInstance.setId(idInstance);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        storageAccountInstance.setName(nameInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        storageAccountInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        storageAccountInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            storageAccountInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                    if ((propertiesValue2 = responseDoc.get("properties")) != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode secondaryEndpointsValue;
                        JsonNode customDomainValue2;
                        JsonNode creationTimeValue;
                        JsonNode statusOfSecondaryValue;
                        JsonNode secondaryLocationValue;
                        JsonNode lastGeoFailoverTimeValue;
                        JsonNode statusOfPrimaryValue;
                        JsonNode primaryLocationValue;
                        JsonNode primaryEndpointsValue;
                        JsonNode accountTypeValue;
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                            ProvisioningState provisioningStateInstance = Enum.valueOf(ProvisioningState.class, provisioningStateValue.getTextValue().toUpperCase());
                            storageAccountInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((accountTypeValue = propertiesValue2.get("accountType")) != null && !(accountTypeValue instanceof NullNode)) {
                            AccountType accountTypeInstance = StorageManagementClientImpl.parseAccountType(accountTypeValue.getTextValue());
                            storageAccountInstance.setAccountType(accountTypeInstance);
                        }
                        if ((primaryEndpointsValue = propertiesValue2.get("primaryEndpoints")) != null && !(primaryEndpointsValue instanceof NullNode)) {
                            JsonNode tableValue;
                            JsonNode queueValue;
                            Endpoints primaryEndpointsInstance = new Endpoints();
                            storageAccountInstance.setPrimaryEndpoints(primaryEndpointsInstance);
                            JsonNode blobValue = primaryEndpointsValue.get("blob");
                            if (blobValue != null && !(blobValue instanceof NullNode)) {
                                URI blobInstance = new URI(blobValue.getTextValue());
                                primaryEndpointsInstance.setBlob(blobInstance);
                            }
                            if ((queueValue = primaryEndpointsValue.get("queue")) != null && !(queueValue instanceof NullNode)) {
                                URI queueInstance = new URI(queueValue.getTextValue());
                                primaryEndpointsInstance.setQueue(queueInstance);
                            }
                            if ((tableValue = primaryEndpointsValue.get("table")) != null && !(tableValue instanceof NullNode)) {
                                URI tableInstance = new URI(tableValue.getTextValue());
                                primaryEndpointsInstance.setTable(tableInstance);
                            }
                        }
                        if ((primaryLocationValue = propertiesValue2.get("primaryLocation")) != null && !(primaryLocationValue instanceof NullNode)) {
                            String primaryLocationInstance = primaryLocationValue.getTextValue();
                            storageAccountInstance.setPrimaryLocation(primaryLocationInstance);
                        }
                        if ((statusOfPrimaryValue = propertiesValue2.get("statusOfPrimary")) != null && !(statusOfPrimaryValue instanceof NullNode)) {
                            AccountStatus statusOfPrimaryInstance = Enum.valueOf(AccountStatus.class, statusOfPrimaryValue.getTextValue().toUpperCase());
                            storageAccountInstance.setStatusOfPrimary(statusOfPrimaryInstance);
                        }
                        if ((lastGeoFailoverTimeValue = propertiesValue2.get("lastGeoFailoverTime")) != null && !(lastGeoFailoverTimeValue instanceof NullNode)) {
                            Calendar lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime((String)lastGeoFailoverTimeValue.getTextValue());
                            storageAccountInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                        }
                        if ((secondaryLocationValue = propertiesValue2.get("secondaryLocation")) != null && !(secondaryLocationValue instanceof NullNode)) {
                            String secondaryLocationInstance = secondaryLocationValue.getTextValue();
                            storageAccountInstance.setSecondaryLocation(secondaryLocationInstance);
                        }
                        if ((statusOfSecondaryValue = propertiesValue2.get("statusOfSecondary")) != null && !(statusOfSecondaryValue instanceof NullNode)) {
                            AccountStatus statusOfSecondaryInstance = Enum.valueOf(AccountStatus.class, statusOfSecondaryValue.getTextValue().toUpperCase());
                            storageAccountInstance.setStatusOfSecondary(statusOfSecondaryInstance);
                        }
                        if ((creationTimeValue = propertiesValue2.get("creationTime")) != null && !(creationTimeValue instanceof NullNode)) {
                            Calendar creationTimeInstance = DatatypeConverter.parseDateTime((String)creationTimeValue.getTextValue());
                            storageAccountInstance.setCreationTime(creationTimeInstance);
                        }
                        if ((customDomainValue2 = propertiesValue2.get("customDomain")) != null && !(customDomainValue2 instanceof NullNode)) {
                            JsonNode useSubDomainValue;
                            CustomDomain customDomainInstance = new CustomDomain();
                            storageAccountInstance.setCustomDomain(customDomainInstance);
                            JsonNode nameValue2 = customDomainValue2.get("name");
                            if (nameValue2 != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                customDomainInstance.setName(nameInstance2);
                            }
                            if ((useSubDomainValue = customDomainValue2.get("useSubDomain")) != null && !(useSubDomainValue instanceof NullNode)) {
                                boolean useSubDomainInstance = useSubDomainValue.getBooleanValue();
                                customDomainInstance.setUseSubDomain(useSubDomainInstance);
                            }
                        }
                        if ((secondaryEndpointsValue = propertiesValue2.get("secondaryEndpoints")) != null && !(secondaryEndpointsValue instanceof NullNode)) {
                            JsonNode tableValue2;
                            JsonNode queueValue2;
                            Endpoints secondaryEndpointsInstance = new Endpoints();
                            storageAccountInstance.setSecondaryEndpoints(secondaryEndpointsInstance);
                            JsonNode blobValue2 = secondaryEndpointsValue.get("blob");
                            if (blobValue2 != null && !(blobValue2 instanceof NullNode)) {
                                URI blobInstance2 = new URI(blobValue2.getTextValue());
                                secondaryEndpointsInstance.setBlob(blobInstance2);
                            }
                            if ((queueValue2 = secondaryEndpointsValue.get("queue")) != null && !(queueValue2 instanceof NullNode)) {
                                URI queueInstance2 = new URI(queueValue2.getTextValue());
                                secondaryEndpointsInstance.setQueue(queueInstance2);
                            }
                            if ((tableValue2 = secondaryEndpointsValue.get("table")) != null && !(tableValue2 instanceof NullNode)) {
                                URI tableInstance2 = new URI(tableValue2.getTextValue());
                                secondaryEndpointsInstance.setTable(tableInstance2);
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountUpdateResponse storageAccountUpdateResponse = result;
            return storageAccountUpdateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

