/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage;

import com.microsoft.azure.management.storage.StorageAccountOperations;
import com.microsoft.azure.management.storage.StorageAccountOperationsImpl;
import com.microsoft.azure.management.storage.StorageManagementClient;
import com.microsoft.azure.management.storage.models.AccountStatus;
import com.microsoft.azure.management.storage.models.AccountType;
import com.microsoft.azure.management.storage.models.CustomDomain;
import com.microsoft.azure.management.storage.models.Endpoints;
import com.microsoft.azure.management.storage.models.KeyName;
import com.microsoft.azure.management.storage.models.ProvisioningState;
import com.microsoft.azure.management.storage.models.StorageAccount;
import com.microsoft.azure.management.storage.models.StorageAccountCreateResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.NullNode;

public class StorageManagementClientImpl
extends ServiceClient<StorageManagementClient>
implements StorageManagementClient {
    private String apiVersion = "2015-05-01-preview";
    private URI baseUri;
    private SubscriptionCloudCredentials credentials;
    private int longRunningOperationInitialTimeout = -1;
    private int longRunningOperationRetryTimeout = -1;
    private StorageAccountOperations storageAccounts = new StorageAccountOperationsImpl(this);

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public SubscriptionCloudCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }

    @Override
    public void setLongRunningOperationInitialTimeout(int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }

    @Override
    public StorageAccountOperations getStorageAccountsOperations() {
        return this.storageAccounts;
    }

    public StorageManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
    }

    @Inject
    public StorageManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(value="com.microsoft.windowsazure.Configuration.credentials") SubscriptionCloudCredentials credentials, @Named(value="management.uri") URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.azure.com/");
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.baseUri = baseUri;
        }
    }

    public StorageManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.azure.com/");
    }

    public StorageManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    protected StorageManagementClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new StorageManagementClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }

    static AccountType parseAccountType(String value) {
        if ("Standard_LRS".equalsIgnoreCase(value)) {
            return AccountType.STANDARDLRS;
        }
        if ("Standard_ZRS".equalsIgnoreCase(value)) {
            return AccountType.STANDARDZRS;
        }
        if ("Standard_GRS".equalsIgnoreCase(value)) {
            return AccountType.STANDARDGRS;
        }
        if ("Standard_RAGRS".equalsIgnoreCase(value)) {
            return AccountType.STANDARDRAGRS;
        }
        if ("Premium_LRS".equalsIgnoreCase(value)) {
            return AccountType.PREMIUMLRS;
        }
        throw new IllegalArgumentException("value");
    }

    static String accountTypeToString(AccountType value) {
        if (value == AccountType.STANDARDLRS) {
            return "Standard_LRS";
        }
        if (value == AccountType.STANDARDZRS) {
            return "Standard_ZRS";
        }
        if (value == AccountType.STANDARDGRS) {
            return "Standard_GRS";
        }
        if (value == AccountType.STANDARDRAGRS) {
            return "Standard_RAGRS";
        }
        if (value == AccountType.PREMIUMLRS) {
            return "Premium_LRS";
        }
        throw new IllegalArgumentException("value");
    }

    static KeyName parseKeyName(String value) {
        if ("key1".equalsIgnoreCase(value)) {
            return KeyName.KEY1;
        }
        if ("key2".equalsIgnoreCase(value)) {
            return KeyName.KEY2;
        }
        throw new IllegalArgumentException("value");
    }

    static String keyNameToString(KeyName value) {
        if (value == KeyName.KEY1) {
            return "key1";
        }
        if (value == KeyName.KEY2) {
            return "key2";
        }
        throw new IllegalArgumentException("value");
    }

    @Override
    public Future<StorageAccountCreateResponse> getCreateOperationStatusAsync(final String operationStatusLink) {
        return this.getExecutorService().submit(new Callable<StorageAccountCreateResponse>(){

            @Override
            public StorageAccountCreateResponse call() throws Exception {
                return StorageManagementClientImpl.this.getCreateOperationStatus(operationStatusLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountCreateResponse getCreateOperationStatus(String operationStatusLink) throws IOException, ServiceException, URISyntaxException {
        if (operationStatusLink == null) {
            throw new NullPointerException("operationStatusLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("operationStatusLink", operationStatusLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getCreateOperationStatusAsync", tracingParameters);
        }
        String url = "";
        url = url + operationStatusLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 500) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountCreateResponse result = null;
            if (statusCode == 200 || statusCode == 202 || statusCode == 500) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountCreateResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode propertiesValue;
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue;
                    StorageAccount storageAccountInstance = new StorageAccount();
                    result.setStorageAccount(storageAccountInstance);
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        storageAccountInstance.setId(idInstance);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        storageAccountInstance.setName(nameInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        storageAccountInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        storageAccountInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            storageAccountInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                    if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode secondaryEndpointsValue;
                        JsonNode customDomainValue;
                        JsonNode creationTimeValue;
                        JsonNode statusOfSecondaryValue;
                        JsonNode secondaryLocationValue;
                        JsonNode lastGeoFailoverTimeValue;
                        JsonNode statusOfPrimaryValue;
                        JsonNode primaryLocationValue;
                        JsonNode primaryEndpointsValue;
                        JsonNode accountTypeValue;
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && !(provisioningStateValue instanceof NullNode)) {
                            ProvisioningState provisioningStateInstance = Enum.valueOf(ProvisioningState.class, provisioningStateValue.getTextValue().toUpperCase());
                            storageAccountInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((accountTypeValue = propertiesValue.get("accountType")) != null && !(accountTypeValue instanceof NullNode)) {
                            AccountType accountTypeInstance = StorageManagementClientImpl.parseAccountType(accountTypeValue.getTextValue());
                            storageAccountInstance.setAccountType(accountTypeInstance);
                        }
                        if ((primaryEndpointsValue = propertiesValue.get("primaryEndpoints")) != null && !(primaryEndpointsValue instanceof NullNode)) {
                            JsonNode tableValue;
                            JsonNode queueValue;
                            Endpoints primaryEndpointsInstance = new Endpoints();
                            storageAccountInstance.setPrimaryEndpoints(primaryEndpointsInstance);
                            JsonNode blobValue = primaryEndpointsValue.get("blob");
                            if (blobValue != null && !(blobValue instanceof NullNode)) {
                                URI blobInstance = new URI(blobValue.getTextValue());
                                primaryEndpointsInstance.setBlob(blobInstance);
                            }
                            if ((queueValue = primaryEndpointsValue.get("queue")) != null && !(queueValue instanceof NullNode)) {
                                URI queueInstance = new URI(queueValue.getTextValue());
                                primaryEndpointsInstance.setQueue(queueInstance);
                            }
                            if ((tableValue = primaryEndpointsValue.get("table")) != null && !(tableValue instanceof NullNode)) {
                                URI tableInstance = new URI(tableValue.getTextValue());
                                primaryEndpointsInstance.setTable(tableInstance);
                            }
                        }
                        if ((primaryLocationValue = propertiesValue.get("primaryLocation")) != null && !(primaryLocationValue instanceof NullNode)) {
                            String primaryLocationInstance = primaryLocationValue.getTextValue();
                            storageAccountInstance.setPrimaryLocation(primaryLocationInstance);
                        }
                        if ((statusOfPrimaryValue = propertiesValue.get("statusOfPrimary")) != null && !(statusOfPrimaryValue instanceof NullNode)) {
                            AccountStatus statusOfPrimaryInstance = Enum.valueOf(AccountStatus.class, statusOfPrimaryValue.getTextValue().toUpperCase());
                            storageAccountInstance.setStatusOfPrimary(statusOfPrimaryInstance);
                        }
                        if ((lastGeoFailoverTimeValue = propertiesValue.get("lastGeoFailoverTime")) != null && !(lastGeoFailoverTimeValue instanceof NullNode)) {
                            Calendar lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime((String)lastGeoFailoverTimeValue.getTextValue());
                            storageAccountInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                        }
                        if ((secondaryLocationValue = propertiesValue.get("secondaryLocation")) != null && !(secondaryLocationValue instanceof NullNode)) {
                            String secondaryLocationInstance = secondaryLocationValue.getTextValue();
                            storageAccountInstance.setSecondaryLocation(secondaryLocationInstance);
                        }
                        if ((statusOfSecondaryValue = propertiesValue.get("statusOfSecondary")) != null && !(statusOfSecondaryValue instanceof NullNode)) {
                            AccountStatus statusOfSecondaryInstance = Enum.valueOf(AccountStatus.class, statusOfSecondaryValue.getTextValue().toUpperCase());
                            storageAccountInstance.setStatusOfSecondary(statusOfSecondaryInstance);
                        }
                        if ((creationTimeValue = propertiesValue.get("creationTime")) != null && !(creationTimeValue instanceof NullNode)) {
                            Calendar creationTimeInstance = DatatypeConverter.parseDateTime((String)creationTimeValue.getTextValue());
                            storageAccountInstance.setCreationTime(creationTimeInstance);
                        }
                        if ((customDomainValue = propertiesValue.get("customDomain")) != null && !(customDomainValue instanceof NullNode)) {
                            JsonNode useSubDomainValue;
                            CustomDomain customDomainInstance = new CustomDomain();
                            storageAccountInstance.setCustomDomain(customDomainInstance);
                            JsonNode nameValue2 = customDomainValue.get("name");
                            if (nameValue2 != null && !(nameValue2 instanceof NullNode)) {
                                String nameInstance2 = nameValue2.getTextValue();
                                customDomainInstance.setName(nameInstance2);
                            }
                            if ((useSubDomainValue = customDomainValue.get("useSubDomain")) != null && !(useSubDomainValue instanceof NullNode)) {
                                boolean useSubDomainInstance = useSubDomainValue.getBooleanValue();
                                customDomainInstance.setUseSubDomain(useSubDomainInstance);
                            }
                        }
                        if ((secondaryEndpointsValue = propertiesValue.get("secondaryEndpoints")) != null && !(secondaryEndpointsValue instanceof NullNode)) {
                            JsonNode tableValue2;
                            JsonNode queueValue2;
                            Endpoints secondaryEndpointsInstance = new Endpoints();
                            storageAccountInstance.setSecondaryEndpoints(secondaryEndpointsInstance);
                            JsonNode blobValue2 = secondaryEndpointsValue.get("blob");
                            if (blobValue2 != null && !(blobValue2 instanceof NullNode)) {
                                URI blobInstance2 = new URI(blobValue2.getTextValue());
                                secondaryEndpointsInstance.setBlob(blobInstance2);
                            }
                            if ((queueValue2 = secondaryEndpointsValue.get("queue")) != null && !(queueValue2 instanceof NullNode)) {
                                URI queueInstance2 = new URI(queueValue2.getTextValue());
                                secondaryEndpointsInstance.setQueue(queueInstance2);
                            }
                            if ((tableValue2 = secondaryEndpointsValue.get("table")) != null && !(tableValue2 instanceof NullNode)) {
                                URI tableInstance2 = new URI(tableValue2.getTextValue());
                                secondaryEndpointsInstance.setTable(tableInstance2);
                            }
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("RetryAfter").length > 0) {
                result.setRetryAfter(DatatypeConverter.parseInt((String)httpResponse.getFirstHeader("RetryAfter").getValue()));
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == 409) {
                result.setStatus(OperationStatus.FAILED);
            }
            if (statusCode == 500) {
                result.setStatus(OperationStatus.INPROGRESS);
            }
            if (statusCode == 202) {
                result.setStatus(OperationStatus.INPROGRESS);
            }
            if (statusCode == 200) {
                result.setStatus(OperationStatus.SUCCEEDED);
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountCreateResponse storageAccountCreateResponse = result;
            return storageAccountCreateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

