/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.storage.AccessTier;
import com.microsoft.azure.management.storage.CustomDomain;
import com.microsoft.azure.management.storage.Encryption;
import com.microsoft.azure.management.storage.Kind;
import com.microsoft.azure.management.storage.ProvisioningState;
import com.microsoft.azure.management.storage.PublicEndpoints;
import com.microsoft.azure.management.storage.Sku;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccountEncryptionKeySource;
import com.microsoft.azure.management.storage.StorageAccountEncryptionStatus;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.StorageAccountSkuType;
import com.microsoft.azure.management.storage.StorageService;
import com.microsoft.azure.management.storage.implementation.AccountStatuses;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Observable;

@Fluent
public interface StorageAccount
extends GroupableResource<StorageManager, StorageAccountInner>,
Refreshable<StorageAccount>,
Updatable<Update> {
    public AccountStatuses accountStatuses();

    @Deprecated
    public Sku sku();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public StorageAccountSkuType skuType();

    public Kind kind();

    public DateTime creationTime();

    public CustomDomain customDomain();

    public DateTime lastGeoFailoverTime();

    public ProvisioningState provisioningState();

    public PublicEndpoints endPoints();

    @Deprecated
    public Encryption encryption();

    public StorageAccountEncryptionKeySource encryptionKeySource();

    public Map<StorageService, StorageAccountEncryptionStatus> encryptionStatuses();

    public AccessTier accessTier();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public String systemAssignedManagedServiceIdentityTenantId();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public String systemAssignedManagedServiceIdentityPrincipalId();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public boolean isAccessAllowedFromAllNetworks();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public List<String> networkSubnetsWithAccess();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public List<String> ipAddressesWithAccess();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public List<String> ipAddressRangesWithAccess();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public boolean canReadLogEntriesFromAnyNetwork();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public boolean canReadMetricsFromAnyNetwork();

    @Beta(value=Beta.SinceVersion.V1_5_0)
    public boolean canAccessFromAzureServices();

    @Beta
    public boolean isAzureFilesAadIntegrationEnabled();

    @Beta
    public boolean isHnsEnabled();

    @Beta
    public boolean isLargeFileSharesEnabled();

    @Method
    public List<StorageAccountKey> getKeys();

    @Method
    public Observable<List<StorageAccountKey>> getKeysAsync();

    public ServiceFuture<List<StorageAccountKey>> getKeysAsync(ServiceCallback<List<StorageAccountKey>> var1);

    public List<StorageAccountKey> regenerateKey(String var1);

    public Observable<List<StorageAccountKey>> regenerateKeyAsync(String var1);

    public ServiceFuture<List<StorageAccountKey>> regenerateKeyAsync(String var1, ServiceCallback<List<StorageAccountKey>> var2);

    public static interface Update
    extends Appliable<StorageAccount>,
    UpdateStages.WithSku,
    UpdateStages.WithCustomDomain,
    UpdateStages.WithEncryption,
    UpdateStages.WithAccessTier,
    UpdateStages.WithManagedServiceIdentity,
    UpdateStages.WithAccessTraffic,
    UpdateStages.WithNetworkAccess,
    UpdateStages.WithUpgrade,
    Resource.UpdateWithTags<Update> {
    }

    public static interface UpdateStages {

        @Beta(value=Beta.SinceVersion.V1_5_1)
        public static interface WithUpgrade {
            @Beta(value=Beta.SinceVersion.V1_5_1)
            @Method
            public Update upgradeToGeneralPurposeAccountKindV2();
        }

        @Beta(value=Beta.SinceVersion.V1_5_0)
        public static interface WithNetworkAccess {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withAccessFromAllNetworks();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withAccessFromSelectedNetworks();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public Update withAccessFromNetworkSubnet(String var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public Update withAccessFromIpAddress(String var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public Update withAccessFromIpAddressRange(String var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withReadAccessToLogEntriesFromAnyNetwork();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withReadAccessToMetricsFromAnyNetwork();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withAccessFromAzureServices();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public Update withoutNetworkSubnetAccess(String var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public Update withoutIpAddressAccess(String var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public Update withoutIpAddressRangeAccess(String var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withoutReadAccessToLoggingFromAnyNetwork();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withoutReadAccessToMetricsFromAnyNetwork();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withoutAccessFromAzureServices();

            public Update withAzureFilesAadIntegrationEnabled(boolean var1);
        }

        @Beta(value=Beta.SinceVersion.V1_5_0)
        public static interface WithAccessTraffic {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withOnlyHttpsTraffic();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withHttpAndHttpsTraffic();
        }

        public static interface WithManagedServiceIdentity {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withSystemAssignedManagedServiceIdentity();
        }

        public static interface WithAccessTier {
            public Update withAccessTier(AccessTier var1);
        }

        public static interface WithEncryption {
            @Deprecated
            @Method
            public Update withEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withBlobEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withFileEncryption();

            @Deprecated
            @Method
            public Update withoutEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withoutBlobEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public Update withoutFileEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public Update withEncryptionKeyFromKeyVault(String var1, String var2, String var3);
        }

        public static interface WithCustomDomain {
            public Update withCustomDomain(CustomDomain var1);

            public Update withCustomDomain(String var1);

            public Update withCustomDomain(String var1, boolean var2);
        }

        public static interface WithSku {
            @Deprecated
            public Update withSku(SkuName var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public Update withSku(StorageAccountSkuType var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreateAndAccessTier
        extends WithCreate {
            public WithCreate withAccessTier(AccessTier var1);
        }

        public static interface WithCreate
        extends Creatable<StorageAccount>,
        WithSku,
        WithBlobStorageAccountKind,
        WithGeneralPurposeAccountKind,
        WithBlockBlobStorageAccountKind,
        WithFileStorageAccountKind,
        WithEncryption,
        WithCustomDomain,
        WithManagedServiceIdentity,
        WithAccessTraffic,
        WithNetworkAccess,
        WithAzureFilesAadIntegration,
        WithLargeFileShares,
        WithHns,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithHns {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withHnsEnabled(boolean var1);
        }

        public static interface WithLargeFileShares {
            @Beta(value=Beta.SinceVersion.V1_30_0)
            @Method
            public WithCreate withLargeFileShares(boolean var1);
        }

        public static interface WithAzureFilesAadIntegration {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withAzureFilesAadIntegrationEnabled(boolean var1);
        }

        @Beta(value=Beta.SinceVersion.V1_5_0)
        public static interface WithNetworkAccess {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withAccessFromAllNetworks();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withAccessFromSelectedNetworks();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithCreate withAccessFromNetworkSubnet(String var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithCreate withAccessFromIpAddress(String var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithCreate withAccessFromIpAddressRange(String var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withReadAccessToLogEntriesFromAnyNetwork();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withReadAccessToMetricsFromAnyNetwork();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withAccessFromAzureServices();
        }

        @Beta(value=Beta.SinceVersion.V1_5_0)
        public static interface WithAccessTraffic {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withOnlyHttpsTraffic();
        }

        public static interface WithManagedServiceIdentity {
            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withSystemAssignedManagedServiceIdentity();
        }

        public static interface WithCustomDomain {
            public WithCreate withCustomDomain(CustomDomain var1);

            public WithCreate withCustomDomain(String var1);

            public WithCreate withCustomDomain(String var1, boolean var2);
        }

        public static interface WithEncryption {
            @Deprecated
            @Method
            public WithCreate withEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withBlobEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withoutBlobEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withFileEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            @Method
            public WithCreate withoutFileEncryption();

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithCreate withEncryptionKeyFromKeyVault(String var1, String var2, String var3);
        }

        public static interface WithFileStorageAccountKind {
            public WithCreate withFileStorageAccountKind();
        }

        public static interface WithBlockBlobStorageAccountKind {
            public WithCreate withBlockBlobStorageAccountKind();
        }

        public static interface WithGeneralPurposeAccountKind {
            @Method
            public WithCreate withGeneralPurposeAccountKind();

            @Method
            public WithCreate withGeneralPurposeAccountKindV2();
        }

        public static interface WithBlobStorageAccountKind {
            @Method
            public WithCreateAndAccessTier withBlobStorageAccountKind();
        }

        public static interface WithSku {
            @Deprecated
            public WithCreate withSku(SkuName var1);

            @Beta(value=Beta.SinceVersion.V1_5_0)
            public WithCreate withSku(StorageAccountSkuType var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate,
    DefinitionStages.WithCreateAndAccessTier {
    }
}

