/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.trafficmanager.MonitorProtocol;
import com.microsoft.azure.management.trafficmanager.ProfileMonitorStatus;
import com.microsoft.azure.management.trafficmanager.ProfileStatus;
import com.microsoft.azure.management.trafficmanager.TrafficManagerAzureEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficManagerExternalEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficManagerNestedProfileEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficManagerProfile;
import com.microsoft.azure.management.trafficmanager.TrafficRoutingMethod;
import com.microsoft.azure.management.trafficmanager.implementation.ProfileInner;
import com.microsoft.azure.management.trafficmanager.implementation.ProfilesInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManager;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerEndpointImpl;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerEndpointsImpl;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerManagementClientImpl;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class TrafficManagerProfileImpl
extends GroupableResourceImpl<TrafficManagerProfile, ProfileInner, TrafficManagerProfileImpl, TrafficManager>
implements TrafficManagerProfile,
TrafficManagerProfile.Definition,
TrafficManagerProfile.Update {
    private TrafficManagerEndpointsImpl endpoints;

    TrafficManagerProfileImpl(String name, ProfileInner innerModel, TrafficManager trafficManager) {
        super(name, (Resource)innerModel, (ManagerBase)trafficManager);
        this.endpoints = new TrafficManagerEndpointsImpl(((TrafficManagerManagementClientImpl)((Object)trafficManager.inner())).endpoints(), this);
    }

    @Override
    public String dnsLabel() {
        return ((ProfileInner)((Object)this.inner())).dnsConfig().relativeName();
    }

    @Override
    public String fqdn() {
        return ((ProfileInner)((Object)this.inner())).dnsConfig().fqdn();
    }

    @Override
    public long timeToLive() {
        return Utils.toPrimitiveLong((Long)((ProfileInner)((Object)this.inner())).dnsConfig().ttl());
    }

    @Override
    public boolean isEnabled() {
        return ((ProfileInner)((Object)this.inner())).profileStatus().equals(ProfileStatus.ENABLED);
    }

    @Override
    public TrafficRoutingMethod trafficRoutingMethod() {
        return ((ProfileInner)((Object)this.inner())).trafficRoutingMethod();
    }

    @Override
    public ProfileMonitorStatus monitorStatus() {
        return ((ProfileInner)((Object)this.inner())).monitorConfig().profileMonitorStatus();
    }

    @Override
    public long monitoringPort() {
        return Utils.toPrimitiveLong((Long)((ProfileInner)((Object)this.inner())).monitorConfig().port());
    }

    @Override
    public String monitoringPath() {
        return ((ProfileInner)((Object)this.inner())).monitorConfig().path();
    }

    @Override
    public Map<String, TrafficManagerExternalEndpoint> externalEndpoints() {
        return this.endpoints.externalEndpointsAsMap();
    }

    @Override
    public Map<String, TrafficManagerAzureEndpoint> azureEndpoints() {
        return this.endpoints.azureEndpointsAsMap();
    }

    @Override
    public Map<String, TrafficManagerNestedProfileEndpoint> nestedProfileEndpoints() {
        return this.endpoints.nestedProfileEndpointsAsMap();
    }

    public Observable<TrafficManagerProfile> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<TrafficManagerProfile, TrafficManagerProfile>(){

            public TrafficManagerProfile call(TrafficManagerProfile trafficManagerProfile) {
                TrafficManagerProfileImpl impl = (TrafficManagerProfileImpl)trafficManagerProfile;
                impl.endpoints.refresh();
                return impl;
            }
        });
    }

    protected Observable<ProfileInner> getInnerAsync() {
        return ((TrafficManagerManagementClientImpl)((Object)((TrafficManager)this.manager()).inner())).profiles().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public TrafficManagerProfileImpl withLeafDomainLabel(String dnsLabel) {
        ((ProfileInner)((Object)this.inner())).dnsConfig().withRelativeName(dnsLabel);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withPriorityBasedRouting() {
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.PRIORITY);
    }

    @Override
    public TrafficManagerProfileImpl withWeightBasedRouting() {
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.WEIGHTED);
    }

    @Override
    public TrafficManagerProfileImpl withPerformanceBasedRouting() {
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.PERFORMANCE);
    }

    @Override
    public TrafficManagerProfileImpl withGeographicBasedRouting() {
        return this.withTrafficRoutingMethod(TrafficRoutingMethod.GEOGRAPHIC);
    }

    @Override
    public TrafficManagerProfileImpl withTrafficRoutingMethod(TrafficRoutingMethod routingMethod) {
        ((ProfileInner)((Object)this.inner())).withTrafficRoutingMethod(routingMethod);
        return this;
    }

    public TrafficManagerEndpointImpl defineAzureTargetEndpoint(String name) {
        return this.endpoints.defineAzureTargetEndpoint(name);
    }

    public TrafficManagerEndpointImpl defineExternalTargetEndpoint(String name) {
        return this.endpoints.defineExteralTargetEndpoint(name);
    }

    public TrafficManagerEndpointImpl defineNestedTargetEndpoint(String name) {
        return this.endpoints.defineNestedProfileTargetEndpoint(name);
    }

    @Override
    public TrafficManagerEndpointImpl updateAzureTargetEndpoint(String name) {
        return this.endpoints.updateAzureEndpoint(name);
    }

    @Override
    public TrafficManagerEndpointImpl updateExternalTargetEndpoint(String name) {
        return this.endpoints.updateExternalEndpoint(name);
    }

    @Override
    public TrafficManagerEndpointImpl updateNestedProfileTargetEndpoint(String name) {
        return this.endpoints.updateNestedProfileEndpoint(name);
    }

    @Override
    public TrafficManagerProfileImpl withoutEndpoint(String name) {
        this.endpoints.remove(name);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withHttpMonitoring() {
        return this.withHttpMonitoring(80, "/");
    }

    @Override
    public TrafficManagerProfileImpl withHttpsMonitoring() {
        return this.withHttpsMonitoring(443, "/");
    }

    @Override
    public TrafficManagerProfileImpl withHttpMonitoring(int port, String path) {
        ((ProfileInner)((Object)this.inner())).monitorConfig().withPort(new Long(port)).withPath(path).withProtocol(MonitorProtocol.HTTP);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withHttpsMonitoring(int port, String path) {
        ((ProfileInner)((Object)this.inner())).monitorConfig().withPort(new Long(port)).withPath(path).withProtocol(MonitorProtocol.HTTPS);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withProfileStatusDisabled() {
        ((ProfileInner)((Object)this.inner())).withProfileStatus(ProfileStatus.DISABLED);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withProfileStatusEnabled() {
        ((ProfileInner)((Object)this.inner())).withProfileStatus(ProfileStatus.ENABLED);
        return this;
    }

    @Override
    public TrafficManagerProfileImpl withTimeToLive(int ttlInSeconds) {
        ((ProfileInner)((Object)this.inner())).dnsConfig().withTtl(new Long(ttlInSeconds));
        return this;
    }

    public Observable<TrafficManagerProfile> createResourceAsync() {
        final TrafficManagerProfileImpl self = this;
        return ((TrafficManagerManagementClientImpl)((Object)((TrafficManager)this.manager()).inner())).profiles().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ProfileInner)((Object)this.inner())).map((Func1)new Func1<ProfileInner, TrafficManagerProfile>(){

            public TrafficManagerProfile call(ProfileInner profileInner) {
                self.setInner((Object)profileInner);
                return self;
            }
        }).flatMap((Func1)new Func1<TrafficManagerProfile, Observable<? extends TrafficManagerProfile>>(){

            public Observable<? extends TrafficManagerProfile> call(TrafficManagerProfile profile) {
                return self.endpoints.commitAndGetAllAsync().map((Func1)new Func1<List<TrafficManagerEndpointImpl>, TrafficManagerProfile>(){

                    public TrafficManagerProfile call(List<TrafficManagerEndpointImpl> endpoints) {
                        return self;
                    }
                });
            }
        });
    }

    public Observable<TrafficManagerProfile> updateResourceAsync() {
        final TrafficManagerProfileImpl self = this;
        final ProfilesInner innerCollection = ((TrafficManagerManagementClientImpl)((Object)((TrafficManager)this.manager()).inner())).profiles();
        return self.endpoints.commitAndGetAllAsync().flatMap((Func1)new Func1<List<TrafficManagerEndpointImpl>, Observable<? extends TrafficManagerProfile>>(){

            public Observable<? extends TrafficManagerProfile> call(List<TrafficManagerEndpointImpl> endpoints) {
                return innerCollection.createOrUpdateAsync(TrafficManagerProfileImpl.this.resourceGroupName(), TrafficManagerProfileImpl.this.name(), (ProfileInner)((Object)TrafficManagerProfileImpl.this.inner())).map((Func1)new Func1<ProfileInner, TrafficManagerProfile>(){

                    public TrafficManagerProfile call(ProfileInner profileInner) {
                        self.setInner((Object)profileInner);
                        return self;
                    }
                });
            }
        });
    }

    TrafficManagerProfileImpl withEndpoint(TrafficManagerEndpointImpl endpoint) {
        this.endpoints.addEndpoint(endpoint);
        return this;
    }
}

