/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.utility;

import com.microsoft.azure.management.compute.ComputeManagementClient;
import com.microsoft.azure.management.compute.models.AvailabilitySet;
import com.microsoft.azure.management.compute.models.AvailabilitySetReference;
import com.microsoft.azure.management.compute.models.HardwareProfile;
import com.microsoft.azure.management.compute.models.ImageReference;
import com.microsoft.azure.management.compute.models.NetworkInterfaceReference;
import com.microsoft.azure.management.compute.models.NetworkProfile;
import com.microsoft.azure.management.compute.models.OSDisk;
import com.microsoft.azure.management.compute.models.OSProfile;
import com.microsoft.azure.management.compute.models.StorageProfile;
import com.microsoft.azure.management.compute.models.VirtualHardDisk;
import com.microsoft.azure.management.compute.models.VirtualMachine;
import com.microsoft.azure.management.compute.models.VirtualMachineCreateOrUpdateResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineImage;
import com.microsoft.azure.management.compute.models.VirtualMachineImageGetParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageListParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageResource;
import com.microsoft.azure.management.compute.models.VirtualMachineImageResourceList;
import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.models.Subnet;
import com.microsoft.azure.management.resources.ResourceManagementClient;
import com.microsoft.azure.management.resources.models.ResourceGroup;
import com.microsoft.azure.management.storage.StorageManagementClient;
import com.microsoft.azure.utility.ConsumerWrapper;
import com.microsoft.azure.utility.NetworkHelper;
import com.microsoft.azure.utility.ResourceContext;
import com.microsoft.azure.utility.StorageHelper;
import com.microsoft.windowsazure.exception.ServiceException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class ComputeHelper {
    public static final String Subscriptions = "subscriptions";
    public static final String ResourceGroups = "resourceGroups";
    public static final String Providers = "providers";
    public static final String AvailabilitySets = "availabilitySets";
    public static final String ResourceProviderNamespace = "Microsoft.Compute";
    public static final String VirtualMachines = "virtualMachines";

    private static String getEntityReferenceId(String subId, String resourceGrpName, String controllerName, String entityName) {
        return String.format("/%s/%s/%s/%s/%s/%s/%s/%s", Subscriptions, subId, ResourceGroups, resourceGrpName, Providers, ResourceProviderNamespace, controllerName, entityName);
    }

    public static String getAvailabilitySetRef(String subId, String resourceGrpName, String availabilitySetName) {
        return ComputeHelper.getEntityReferenceId(subId, resourceGrpName, AvailabilitySets, availabilitySetName);
    }

    public static String getVMReferenceId(String subId, String rgName, String vmName) {
        return ComputeHelper.getEntityReferenceId(subId, rgName, VirtualMachines, vmName);
    }

    public static void createOrUpdateResourceGroup(ResourceManagementClient resourceManagementClient, ResourceContext context) throws ServiceException, IOException, URISyntaxException {
        resourceManagementClient.getResourceGroupsOperations().createOrUpdate(context.getResourceGroupName(), new ResourceGroup(context.getLocation()));
    }

    public static String createAvailabilitySet(ComputeManagementClient computeManagementClient, ResourceContext context) throws Exception {
        String asName = context.getAvailabilitySetName();
        AvailabilitySet as = new AvailabilitySet(context.getLocation());
        as.setName(asName);
        if (context.getTags() != null) {
            as.setTags(context.getTags());
        }
        return ComputeHelper.createAvailabilitySet(computeManagementClient, as, context);
    }

    public static String createAvailabilitySet(ComputeManagementClient computeManagementClient, AvailabilitySet avSet, ResourceContext context) throws Exception {
        computeManagementClient.getAvailabilitySetsOperations().createOrUpdate(context.getResourceGroupName(), avSet);
        String availabilitySetId = ComputeHelper.getAvailabilitySetRef(context.getSubscriptionId(), context.getResourceGroupName(), avSet.getName());
        context.setAvailabilitySetId(availabilitySetId);
        return availabilitySetId;
    }

    public static VirtualMachine createDefaultVMInput(ResourceContext context, String vmName, String adminName, String adminPassword) {
        String vhdContainer = ComputeHelper.getVhdContainerUrl(context);
        String osVhduri = vhdContainer + String.format("/os%s.vhd", "osvhd");
        VirtualMachine vm = new VirtualMachine(context.getLocation());
        vm.setName(vmName);
        if (context.getTags() != null) {
            vm.setTags(context.getTags());
        }
        vm.setType("Microsoft.Compute/virtualMachines");
        AvailabilitySetReference asRef = new AvailabilitySetReference();
        asRef.setReferenceUri(context.getAvailabilitySetId());
        vm.setAvailabilitySetReference(asRef);
        HardwareProfile hwProfile = new HardwareProfile();
        if (context.getVirtualMachineSizeType() != null && !context.getVirtualMachineSizeType().isEmpty()) {
            hwProfile.setVirtualMachineSize(context.getVirtualMachineSizeType());
        } else {
            hwProfile.setVirtualMachineSize("Standard_A0");
        }
        vm.setHardwareProfile(hwProfile);
        StorageProfile sto = new StorageProfile();
        if (context.getImageReference() != null) {
            sto.setImageReference(context.getImageReference());
        } else {
            ImageReference ir = new ImageReference();
            ir.setPublisher("MicrosoftWindowsServer");
            ir.setOffer("WindowsServer");
            ir.setSku("2008-R2-SP1");
            ir.setVersion("latest");
            sto.setImageReference(ir);
        }
        VirtualHardDisk vhardDisk = new VirtualHardDisk();
        vhardDisk.setUri(osVhduri);
        OSDisk osDisk = new OSDisk("osdisk", vhardDisk, "fromImage");
        osDisk.setCaching("None");
        sto.setOSDisk(osDisk);
        vm.setStorageProfile(sto);
        NetworkProfile networkProfile = new NetworkProfile();
        NetworkInterfaceReference nir = new NetworkInterfaceReference();
        nir.setReferenceUri(context.getNetworkInterface().getId());
        ArrayList<NetworkInterfaceReference> nirs = new ArrayList<NetworkInterfaceReference>(1);
        nirs.add(nir);
        networkProfile.setNetworkInterfaces(nirs);
        vm.setNetworkProfile(networkProfile);
        OSProfile osProfile = new OSProfile();
        osProfile.setAdminPassword(adminPassword);
        osProfile.setAdminUsername(adminName);
        osProfile.setComputerName(vmName);
        vm.setOSProfile(osProfile);
        context.setVMInput(vm);
        return vm;
    }

    public static VirtualMachineCreateOrUpdateResponse createVM(ResourceManagementClient resourceManagementClient, ComputeManagementClient computeManagementClient, NetworkResourceProviderClient networkResourceProviderClient, StorageManagementClient storageManagementClient, ResourceContext context, String vmName, String adminName, String adminPassword) throws Exception {
        return ComputeHelper.createVM(resourceManagementClient, computeManagementClient, networkResourceProviderClient, storageManagementClient, context, vmName, adminName, adminPassword, null);
    }

    public static VirtualMachineCreateOrUpdateResponse createVM(ResourceManagementClient resourceManagementClient, ComputeManagementClient computeManagementClient, NetworkResourceProviderClient networkResourceProviderClient, StorageManagementClient storageManagementClient, ResourceContext context, String vmName, String adminName, String adminPassword, ConsumerWrapper<VirtualMachine> vmInputModifier) throws Exception {
        VirtualMachineCreateOrUpdateResponse vmCreationResponse;
        ComputeHelper.createOrUpdateResourceGroup(resourceManagementClient, context);
        if (context.getStorageAccount() == null) {
            StorageHelper.createStorageAccount(storageManagementClient, context);
        }
        if (context.getNetworkInterface() == null) {
            if (context.isCreatePublicIpAddress() && context.getPublicIpAddress() == null) {
                NetworkHelper.createPublicIpAddress(networkResourceProviderClient, context);
            }
            if (context.getVirtualNetwork() == null) {
                NetworkHelper.createVirtualNetwork(networkResourceProviderClient, context);
            }
            NetworkHelper.createNIC(networkResourceProviderClient, context, (Subnet)context.getVirtualNetwork().getSubnets().get(0));
        }
        if (context.getAvailabilitySetId() == null || context.getAvailabilitySetId().isEmpty()) {
            ComputeHelper.createAvailabilitySet(computeManagementClient, context);
        }
        if (context.getVMInput() == null) {
            ComputeHelper.createDefaultVMInput(context, vmName, adminName, adminPassword);
        }
        if (vmInputModifier != null) {
            vmInputModifier.accept(context.getVMInput());
        }
        ComputeHelper.assertTrue(201 == (vmCreationResponse = computeManagementClient.getVirtualMachinesOperations().beginCreatingOrUpdating(context.getResourceGroupName(), context.getVMInput())).getStatusCode());
        return vmCreationResponse;
    }

    public static ArrayList<VirtualMachineImageResource> queryVMImage(ComputeManagementClient computeManagementClient, String location, String publisher, String offer, String sku, String filterExpression) throws ServiceException, IOException, URISyntaxException {
        VirtualMachineImageListParameters param = new VirtualMachineImageListParameters();
        param.setLocation(location);
        param.setPublisherName(publisher);
        param.setOffer(offer);
        param.setSkus(sku);
        param.setFilterExpression(filterExpression);
        VirtualMachineImageResourceList images = computeManagementClient.getVirtualMachineImagesOperations().list(param);
        return images.getResources();
    }

    public static ImageReference getDefaultVMImage(ComputeManagementClient computeManagementClient, String location, String publisher, String offer, String sku) throws IOException, ServiceException, URISyntaxException {
        ArrayList<VirtualMachineImageResource> queryResult = ComputeHelper.queryVMImage(computeManagementClient, location, publisher, offer, sku, "$top=1");
        if (queryResult.size() < 1) {
            throw new IllegalArgumentException(String.format("no image found for %s, %s, %s, %s", location, publisher, offer, sku));
        }
        VirtualMachineImageResource image = queryResult.get(0);
        ImageReference defaultImage = new ImageReference();
        defaultImage.setOffer(offer);
        defaultImage.setPublisher(publisher);
        defaultImage.setSku(sku);
        defaultImage.setVersion(image.getName());
        return defaultImage;
    }

    public static ImageReference getWindowsServerDefaultImage(ComputeManagementClient computeManagementClient, String location) throws ServiceException, IOException, URISyntaxException {
        return ComputeHelper.getDefaultVMImage(computeManagementClient, location, "MicrosoftWindowsServer", "WindowsServer", "2012-R2-Datacenter");
    }

    public static ImageReference getUbuntuServerDefaultImage(ComputeManagementClient computeManagementClient, String location) throws ServiceException, IOException, URISyntaxException {
        return ComputeHelper.getDefaultVMImage(computeManagementClient, location, "Canonical", "UbuntuServer", "15.04");
    }

    public static VirtualMachineImage getMarketplaceVMImage(ComputeManagementClient computeManagementClient, String location, String publisher, String offer, String sku) throws ServiceException, IOException, URISyntaxException {
        ImageReference imageRef = ComputeHelper.getDefaultVMImage(computeManagementClient, location, publisher, offer, sku);
        VirtualMachineImageGetParameters param = new VirtualMachineImageGetParameters();
        param.setLocation(location);
        param.setPublisherName(publisher);
        param.setOffer(offer);
        param.setSkus(sku);
        param.setVersion(imageRef.getVersion());
        return computeManagementClient.getVirtualMachineImagesOperations().get(param).getVirtualMachineImage();
    }

    public static String getVhdContainerUrl(ResourceContext context) {
        return String.format("https://%s.blob.core.windows.net/%s", context.getStorageAccount().getName(), context.getContainerName());
    }

    private static void assertTrue(boolean condition) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }
}

