/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.utility;

import com.microsoft.azure.management.compute.models.ImageReference;
import com.microsoft.azure.management.compute.models.VirtualMachine;
import com.microsoft.azure.management.network.models.NetworkInterface;
import com.microsoft.azure.management.network.models.PublicIpAddress;
import com.microsoft.azure.management.network.models.VirtualNetwork;
import com.microsoft.azure.management.storage.models.StorageAccount;
import java.util.HashMap;
import java.util.Random;

public class ResourceContext {
    private String Location;
    private String ResourceGroupName;
    private String SubscriptionId;
    private StorageAccount StorageAccount;
    private VirtualNetwork VirtualNetwork;
    private PublicIpAddress PublicIpAddress;
    private NetworkInterface NetworkInterface;
    private VirtualMachine VMInput;
    private String AvailabilitySetId;
    private String VirtualMachineSizeType;
    private ImageReference ImageReference;
    private HashMap<String, String> Tags;
    private boolean CreatePublicIpAddress;
    private String StorageAccountName;
    private String PublicIpName;
    private String SubnetName;
    private String NetworkInterfaceName;
    private String IpConfigName;
    private String ContainerName;
    private String VirtualNetworkName;
    private String AvailabilitySetName;

    public String getLocation() {
        return this.Location;
    }

    public String getResourceGroupName() {
        return this.ResourceGroupName;
    }

    public String getSubscriptionId() {
        return this.SubscriptionId;
    }

    public ResourceContext(String location, String resourceGroupName, String subscriptionId) {
        this.Location = location;
        this.ResourceGroupName = resourceGroupName;
        this.SubscriptionId = subscriptionId;
        this.CreatePublicIpAddress = true;
    }

    public ResourceContext(String location, String resourceGroupName, String subscriptionId, boolean createPublicIpAddress) {
        this.Location = location;
        this.ResourceGroupName = resourceGroupName;
        this.SubscriptionId = subscriptionId;
        this.CreatePublicIpAddress = createPublicIpAddress;
    }

    public StorageAccount getStorageAccount() {
        return this.StorageAccount;
    }

    public void setStorageAccount(StorageAccount storageAccount) {
        this.StorageAccount = storageAccount;
    }

    public PublicIpAddress getPublicIpAddress() {
        return this.PublicIpAddress;
    }

    public void setPublicIpAddress(PublicIpAddress publicIpAddress) {
        this.PublicIpAddress = publicIpAddress;
    }

    public boolean isCreatePublicIpAddress() {
        return this.CreatePublicIpAddress;
    }

    public void setCreatePublicIpAddress(boolean createPublicIpAddress) {
        this.CreatePublicIpAddress = createPublicIpAddress;
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.VirtualNetwork;
    }

    public void setVirtualNetwork(VirtualNetwork virtualNetwork) {
        this.VirtualNetwork = virtualNetwork;
    }

    public NetworkInterface getNetworkInterface() {
        return this.NetworkInterface;
    }

    public void setNetworkInterface(NetworkInterface networkInterface) {
        this.NetworkInterface = networkInterface;
    }

    public String getAvailabilitySetId() {
        return this.AvailabilitySetId;
    }

    public void setAvailabilitySetId(String availabilitySetId) {
        this.AvailabilitySetId = availabilitySetId;
    }

    public HashMap<String, String> getTags() {
        return this.Tags;
    }

    public void setTags(HashMap<String, String> tags) {
        this.Tags = tags;
    }

    public String getVirtualMachineSizeType() {
        return this.VirtualMachineSizeType;
    }

    public void setVirtualMachineSizeType(String virtualMachineSizeType) {
        this.VirtualMachineSizeType = virtualMachineSizeType;
    }

    public ImageReference getImageReference() {
        return this.ImageReference;
    }

    public void setImageReference(ImageReference imageReference) {
        this.ImageReference = imageReference;
    }

    public VirtualMachine getVMInput() {
        return this.VMInput;
    }

    public void setVMInput(VirtualMachine VMInput) {
        this.VMInput = VMInput;
    }

    public String getStorageAccountName() {
        if (this.StorageAccountName == null || this.StorageAccountName.isEmpty()) {
            this.StorageAccountName = ResourceContext.generateName("javasto").toLowerCase();
        }
        return this.StorageAccountName;
    }

    public void setStorageAccountName(String storageAccountName) {
        this.StorageAccountName = storageAccountName;
    }

    public static String randomString(int length) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            stringBuilder.append((char)(97 + random.nextInt(26)));
        }
        return stringBuilder.toString();
    }

    public static String generateName(String prefix) {
        String name = prefix + ResourceContext.randomString(5);
        return name;
    }

    public String getPublicIpName() {
        if (this.PublicIpName == null || this.PublicIpName.isEmpty()) {
            this.PublicIpName = ResourceContext.generateName(this.ResourceGroupName + "publicip");
        }
        return this.PublicIpName;
    }

    public void setPublicIpName(String publicIpName) {
        this.PublicIpName = publicIpName;
    }

    public String getSubnetName() {
        if (this.SubnetName == null || this.SubnetName.isEmpty()) {
            this.SubnetName = ResourceContext.generateName(this.ResourceGroupName + "subnet");
        }
        return this.SubnetName;
    }

    public void setSubnetName(String subnetName) {
        this.SubnetName = subnetName;
    }

    public String getNetworkInterfaceName() {
        if (this.NetworkInterfaceName == null || this.NetworkInterfaceName.isEmpty()) {
            this.NetworkInterfaceName = ResourceContext.generateName(this.ResourceGroupName + "nic");
        }
        return this.NetworkInterfaceName;
    }

    public void setNetworkInterfaceName(String networkInterfaceName) {
        this.NetworkInterfaceName = networkInterfaceName;
    }

    public String getIpConfigName() {
        if (this.IpConfigName == null || this.IpConfigName.isEmpty()) {
            this.IpConfigName = ResourceContext.generateName(this.ResourceGroupName + "ipconfig");
        }
        return this.IpConfigName;
    }

    public void setIpConfigName(String ipConfigName) {
        this.IpConfigName = ipConfigName;
    }

    public String getContainerName() {
        if (this.ContainerName == null || this.ContainerName.isEmpty()) {
            this.ContainerName = ResourceContext.generateName(this.ResourceGroupName.toLowerCase() + "container");
        }
        return this.ContainerName;
    }

    public void setContainerName(String containerName) {
        this.ContainerName = containerName;
    }

    public String getVirtualNetworkName() {
        if (this.VirtualNetworkName == null || this.VirtualNetworkName.isEmpty()) {
            this.VirtualNetworkName = ResourceContext.generateName(this.ResourceGroupName + "vnet");
        }
        return this.VirtualNetworkName;
    }

    public void setVirtualNetworkName(String virtualNetworkName) {
        this.VirtualNetworkName = virtualNetworkName;
    }

    public String getAvailabilitySetName() {
        if (this.AvailabilitySetName == null || this.AvailabilitySetName.isEmpty()) {
            this.AvailabilitySetName = ResourceContext.generateName(this.ResourceGroupName + "availabilityset");
        }
        return this.AvailabilitySetName;
    }

    public void setAvailabilitySetName(String availabilitySetName) {
        this.AvailabilitySetName = availabilitySetName;
    }
}

