/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.utility;

import com.microsoft.azure.management.storage.StorageManagementClient;
import com.microsoft.azure.management.storage.models.AccountType;
import com.microsoft.azure.management.storage.models.KeyName;
import com.microsoft.azure.management.storage.models.StorageAccount;
import com.microsoft.azure.management.storage.models.StorageAccountCreateParameters;
import com.microsoft.azure.management.storage.models.StorageAccountListResponse;
import com.microsoft.azure.management.storage.models.StorageAccountRegenerateKeyResponse;
import com.microsoft.azure.management.storage.models.StorageAccountUpdateParameters;
import com.microsoft.azure.management.storage.models.StorageAccountUpdateResponse;
import com.microsoft.azure.utility.ResourceContext;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class StorageHelper {
    public static StorageAccount createStorageAccount(StorageManagementClient storageManagementClient, ResourceContext context) throws Exception {
        StorageAccountCreateParameters stoInput = new StorageAccountCreateParameters(AccountType.STANDARDGRS, context.getLocation());
        return StorageHelper.createStorageAccount(storageManagementClient, context, stoInput);
    }

    public static StorageAccount createStorageAccount(StorageManagementClient storageManagementClient, ResourceContext context, StorageAccountCreateParameters stoInput) throws Exception {
        String storageAccountName = context.getStorageAccountName();
        StorageAccount storageAccount = storageManagementClient.getStorageAccountsOperations().create(context.getResourceGroupName(), storageAccountName, stoInput).getStorageAccount();
        boolean created = false;
        while (!created) {
            StorageHelper.waitSeconds(3.0);
            ArrayList storageAccountList = storageManagementClient.getStorageAccountsOperations().listByResourceGroup(context.getResourceGroupName()).getStorageAccounts();
            for (StorageAccount account : storageAccountList) {
                if (!account.getName().equalsIgnoreCase(storageAccountName)) continue;
                created = true;
                break;
            }
            storageAccount.setName(storageAccountName);
        }
        context.setStorageAccount(storageAccount);
        return storageAccount;
    }

    protected static void waitSeconds(double seconds) throws InterruptedException {
        if (!ManagementConfiguration.isPlayback()) {
            Thread.sleep((long)seconds * 100L);
        }
    }

    public static StorageAccount getStorageAccount(StorageManagementClient storageManagementClient, ResourceContext context) throws Exception {
        StorageAccount result = null;
        String storageAccountName = context.getStorageAccountName();
        ArrayList storageAccountList = storageManagementClient.getStorageAccountsOperations().listByResourceGroup(context.getResourceGroupName()).getStorageAccounts();
        for (StorageAccount account : storageAccountList) {
            if (!account.getName().equalsIgnoreCase(storageAccountName)) continue;
            result = account;
            break;
        }
        return result;
    }

    public static boolean deleteStorageAccount(StorageManagementClient storageManagementClient, ResourceContext context) throws Exception {
        String storageAccountName = context.getStorageAccountName();
        boolean result = false;
        ExecutorService service = null;
        try {
            Future future = null;
            service = Executors.newFixedThreadPool(1);
            future = storageManagementClient.getStorageAccountsOperations().deleteAsync(context.getResourceGroupName(), storageAccountName);
            OperationResponse response = (OperationResponse)future.get();
            if (response.getStatusCode() / 100 == 2) {
                result = true;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            service.shutdown();
        }
        return result;
    }

    public static List<StorageAccount> listStorageAccounts(StorageManagementClient storageManagementClient, String resourceGroup) throws Exception {
        ArrayList accounts = null;
        ExecutorService service = null;
        try {
            Future future = null;
            service = Executors.newFixedThreadPool(1);
            future = resourceGroup == null ? storageManagementClient.getStorageAccountsOperations().listAsync() : storageManagementClient.getStorageAccountsOperations().listByResourceGroupAsync(resourceGroup);
            StorageAccountListResponse response = (StorageAccountListResponse)future.get();
            if (response != null) {
                accounts = response.getStorageAccounts();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            service.shutdown();
        }
        return accounts;
    }

    public static StorageAccountRegenerateKeyResponse regenerateStorageAccountKey(StorageManagementClient storageManagementClient, ResourceContext context, KeyName keyName) throws Exception {
        String storageAccountName = context.getStorageAccountName();
        StorageAccountRegenerateKeyResponse response = null;
        ExecutorService service = null;
        try {
            Future future = null;
            service = Executors.newFixedThreadPool(1);
            future = storageManagementClient.getStorageAccountsOperations().regenerateKeyAsync(context.getResourceGroupName(), storageAccountName, keyName);
            response = (StorageAccountRegenerateKeyResponse)future.get();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            service.shutdown();
        }
        return response;
    }

    public static StorageAccountUpdateResponse updateAccountTags(StorageManagementClient storageManagementClient, ResourceContext context, HashMap<String, String> tags) throws Exception {
        String storageAccountName = context.getStorageAccountName();
        StorageAccountUpdateResponse response = null;
        StorageAccountUpdateParameters parameters = new StorageAccountUpdateParameters();
        if (tags != null) {
            parameters.setTags(tags);
        }
        ExecutorService service = null;
        try {
            Future future = null;
            service = Executors.newFixedThreadPool(1);
            future = storageManagementClient.getStorageAccountsOperations().updateAsync(context.getResourceGroupName(), storageAccountName, parameters);
            response = (StorageAccountUpdateResponse)future.get();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            service.shutdown();
        }
        return response;
    }
}

