/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.primitives.RetryPolicy;
import com.microsoft.azure.servicebus.primitives.TransportType;
import com.microsoft.azure.servicebus.security.TokenProvider;
import java.time.Duration;

public class ClientSettings {
    private TokenProvider tokenProvider;
    private RetryPolicy retryPolicy;
    private Duration operationTimeout;
    private TransportType transportType;

    public ClientSettings(TokenProvider tokenProvider) {
        this(tokenProvider, RetryPolicy.getDefault(), Duration.ofSeconds(30L), TransportType.AMQP);
    }

    public ClientSettings(TokenProvider tokenProvider, RetryPolicy retryPolicy, Duration operationTimeout) {
        this(tokenProvider, retryPolicy, operationTimeout, TransportType.AMQP);
    }

    public ClientSettings(TokenProvider tokenProvider, RetryPolicy retryPolicy, Duration operationTimeout, TransportType transportType) {
        this.tokenProvider = tokenProvider;
        this.retryPolicy = retryPolicy;
        this.operationTimeout = operationTimeout;
        this.transportType = transportType;
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }
}

