/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.ClientSettings;
import com.microsoft.azure.servicebus.management.EntityNameHelper;
import com.microsoft.azure.servicebus.management.ManagementClientConstants;
import com.microsoft.azure.servicebus.management.NamespaceInfo;
import com.microsoft.azure.servicebus.management.NamespaceInfoSerializer;
import com.microsoft.azure.servicebus.management.QueueDescription;
import com.microsoft.azure.servicebus.management.QueueDescriptionSerializer;
import com.microsoft.azure.servicebus.management.QueueRuntimeInfo;
import com.microsoft.azure.servicebus.management.QueueRuntimeInfoSerializer;
import com.microsoft.azure.servicebus.management.RuleDescriptionSerializer;
import com.microsoft.azure.servicebus.management.SerializerUtil;
import com.microsoft.azure.servicebus.management.SubscriptionDescription;
import com.microsoft.azure.servicebus.management.SubscriptionDescriptionSerializer;
import com.microsoft.azure.servicebus.management.SubscriptionRuntimeInfo;
import com.microsoft.azure.servicebus.management.SubscriptionRuntimeInfoSerializer;
import com.microsoft.azure.servicebus.management.TopicDescription;
import com.microsoft.azure.servicebus.management.TopicDescriptionSerializer;
import com.microsoft.azure.servicebus.management.TopicRuntimeInfo;
import com.microsoft.azure.servicebus.management.TopicRuntimeInfoSerializer;
import com.microsoft.azure.servicebus.primitives.AuthorizationFailedException;
import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.MessagingEntityAlreadyExistsException;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.QuotaExceededException;
import com.microsoft.azure.servicebus.primitives.ServerBusyException;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.servicebus.primitives.Util;
import com.microsoft.azure.servicebus.rules.RuleDescription;
import com.microsoft.azure.servicebus.security.SecurityToken;
import com.microsoft.azure.servicebus.security.TokenProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.util.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManagementClientAsync {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ManagementClientAsync.class);
    private static final int ONE_BOX_HTTPS_PORT = 4446;
    private static final String API_VERSION_QUERY = "api-version=2017-04";
    private static final String USER_AGENT_HEADER_NAME = "User-Agent";
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String CONTENT_TYPE = "application/atom+xml";
    private static final Duration CONNECTION_TIMEOUT = Duration.ofMinutes(1L);
    private static final String USER_AGENT = String.format("%s/%s(%s)", "MSJavaClient", ClientConstants.CURRENT_JAVACLIENT_VERSION, ClientConstants.PLATFORM_INFO);
    private ClientSettings clientSettings;
    private MessagingFactory factory;
    private URI namespaceEndpointURI;
    private AsyncHttpClient asyncHttpClient;
    private List<Proxy> proxies;

    public ManagementClientAsync(ConnectionStringBuilder connectionStringBuilder) {
        this(connectionStringBuilder.getEndpoint(), Util.getClientSettingsFromConnectionStringBuilder(connectionStringBuilder));
    }

    public ManagementClientAsync(URI namespaceEndpointURI, ClientSettings clientSettings) {
        this.namespaceEndpointURI = namespaceEndpointURI;
        this.clientSettings = clientSettings;
        DefaultAsyncHttpClientConfig.Builder clientBuilder = Dsl.config().setConnectTimeout((int)CONNECTION_TIMEOUT.toMillis()).setUseProxySelector(true).setUseProxyProperties(true).setRequestTimeout((int)this.clientSettings.getOperationTimeout().toMillis());
        this.asyncHttpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)clientBuilder);
    }

    public CompletableFuture<NamespaceInfo> getNamespaceInfoAsync() {
        CompletableFuture<String> contentFuture = this.getEntityAsync("$namespaceinfo", null, false);
        CompletableFuture<NamespaceInfo> nsInfoFuture = new CompletableFuture<NamespaceInfo>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                nsInfoFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    nsInfoFuture.complete(NamespaceInfoSerializer.parseFromContent(content));
                }
                catch (Exception e) {
                    nsInfoFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return nsInfoFuture;
    }

    public CompletableFuture<QueueDescription> getQueueAsync(String path) {
        EntityNameHelper.checkValidQueueName(path);
        CompletableFuture<String> contentFuture = this.getEntityAsync(path, null, false);
        CompletableFuture<QueueDescription> qdFuture = new CompletableFuture<QueueDescription>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                qdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    qdFuture.complete(QueueDescriptionSerializer.parseFromContent(content));
                }
                catch (Exception e) {
                    qdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return qdFuture;
    }

    public CompletableFuture<QueueRuntimeInfo> getQueueRuntimeInfoAsync(String path) {
        EntityNameHelper.checkValidQueueName(path);
        CompletableFuture<String> contentFuture = this.getEntityAsync(path, null, true);
        CompletableFuture<QueueRuntimeInfo> qdFuture = new CompletableFuture<QueueRuntimeInfo>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                qdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    qdFuture.complete(QueueRuntimeInfoSerializer.parseFromContent(content));
                }
                catch (Exception e) {
                    qdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return qdFuture;
    }

    public CompletableFuture<TopicDescription> getTopicAsync(String path) {
        EntityNameHelper.checkValidTopicName(path);
        CompletableFuture<String> contentFuture = this.getEntityAsync(path, null, false);
        CompletableFuture<TopicDescription> tdFuture = new CompletableFuture<TopicDescription>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                tdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    tdFuture.complete(TopicDescriptionSerializer.parseFromContent(content));
                }
                catch (Exception e) {
                    tdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return tdFuture;
    }

    public CompletableFuture<TopicRuntimeInfo> getTopicRuntimeInfoAsync(String path) {
        EntityNameHelper.checkValidTopicName(path);
        CompletableFuture<String> contentFuture = this.getEntityAsync(path, null, true);
        CompletableFuture<TopicRuntimeInfo> tdFuture = new CompletableFuture<TopicRuntimeInfo>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                tdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    tdFuture.complete(TopicRuntimeInfoSerializer.parseFromContent(content));
                }
                catch (Exception e) {
                    tdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return tdFuture;
    }

    public CompletableFuture<SubscriptionDescription> getSubscriptionAsync(String topicPath, String subscriptionName) {
        EntityNameHelper.checkValidTopicName(topicPath);
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        String path = EntityNameHelper.formatSubscriptionPath(topicPath, subscriptionName);
        CompletableFuture<String> contentFuture = this.getEntityAsync(path, null, false);
        CompletableFuture<SubscriptionDescription> sdFuture = new CompletableFuture<SubscriptionDescription>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                sdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    sdFuture.complete(SubscriptionDescriptionSerializer.parseFromContent(topicPath, content));
                }
                catch (Exception e) {
                    sdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return sdFuture;
    }

    public CompletableFuture<SubscriptionRuntimeInfo> getSubscriptionRuntimeInfoAsync(String topicPath, String subscriptionName) {
        EntityNameHelper.checkValidTopicName(topicPath);
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        String path = EntityNameHelper.formatSubscriptionPath(topicPath, subscriptionName);
        CompletableFuture<String> contentFuture = this.getEntityAsync(path, null, true);
        CompletableFuture<SubscriptionRuntimeInfo> sdFuture = new CompletableFuture<SubscriptionRuntimeInfo>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                sdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    sdFuture.complete(SubscriptionRuntimeInfoSerializer.parseFromContent(topicPath, content));
                }
                catch (Exception e) {
                    sdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return sdFuture;
    }

    public CompletableFuture<RuleDescription> getRuleAsync(String topicPath, String subscriptionName, String ruleName) {
        EntityNameHelper.checkValidTopicName(topicPath);
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        EntityNameHelper.checkValidRuleName(ruleName);
        String path = EntityNameHelper.formatRulePath(topicPath, subscriptionName, ruleName);
        CompletableFuture<String> contentFuture = this.getEntityAsync(path, null, false);
        CompletableFuture<RuleDescription> rdFuture = new CompletableFuture<RuleDescription>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                rdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    rdFuture.complete(RuleDescriptionSerializer.parseFromContent(content));
                }
                catch (Exception e) {
                    rdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return rdFuture;
    }

    public CompletableFuture<List<QueueDescription>> getQueuesAsync() {
        return this.getQueuesAsync(100, 0);
    }

    public CompletableFuture<List<QueueDescription>> getQueuesAsync(int count, int skip) {
        if (count > 100 || count < 1) {
            throw new IllegalArgumentException("Count should be between 1 and 100");
        }
        if (skip < 0) {
            throw new IllegalArgumentException("Skip cannot be negative");
        }
        CompletableFuture<String> contentFuture = this.getEntityAsync("$Resources/queues", String.format("$skip=%d&$top=%d", skip, count), false);
        CompletableFuture<List<QueueDescription>> qdFuture = new CompletableFuture<List<QueueDescription>>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                qdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    qdFuture.complete(QueueDescriptionSerializer.parseCollectionFromContent(content));
                }
                catch (Exception e) {
                    qdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return qdFuture;
    }

    public CompletableFuture<List<TopicDescription>> getTopicsAsync() {
        return this.getTopicsAsync(100, 0);
    }

    public CompletableFuture<List<TopicDescription>> getTopicsAsync(int count, int skip) {
        if (count > 100 || count < 1) {
            throw new IllegalArgumentException("Count should be between 1 and 100");
        }
        if (skip < 0) {
            throw new IllegalArgumentException("Skip cannot be negative");
        }
        CompletableFuture<String> contentFuture = this.getEntityAsync("$Resources/topics", String.format("$skip=%d&$top=%d", skip, count), false);
        CompletableFuture<List<TopicDescription>> tdFuture = new CompletableFuture<List<TopicDescription>>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                tdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    tdFuture.complete(TopicDescriptionSerializer.parseCollectionFromContent(content));
                }
                catch (Exception e) {
                    tdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return tdFuture;
    }

    public CompletableFuture<List<SubscriptionDescription>> getSubscriptionsAsync(String topicName) {
        return this.getSubscriptionsAsync(topicName, 100, 0);
    }

    public CompletableFuture<List<SubscriptionDescription>> getSubscriptionsAsync(String topicName, int count, int skip) {
        if (count > 100 || count < 1) {
            throw new IllegalArgumentException("Count should be between 1 and 100");
        }
        if (skip < 0) {
            throw new IllegalArgumentException("Skip cannot be negative");
        }
        EntityNameHelper.checkValidTopicName(topicName);
        CompletableFuture<String> contentFuture = this.getEntityAsync(String.format("%s/Subscriptions", topicName), String.format("$skip=%d&$top=%d", skip, count), false);
        CompletableFuture<List<SubscriptionDescription>> sdFuture = new CompletableFuture<List<SubscriptionDescription>>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                sdFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    sdFuture.complete(SubscriptionDescriptionSerializer.parseCollectionFromContent(topicName, content));
                }
                catch (Exception e) {
                    sdFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return sdFuture;
    }

    public CompletableFuture<List<RuleDescription>> getRulesAsync(String topicName, String subscriptionName) {
        return this.getRulesAsync(topicName, subscriptionName, 100, 0);
    }

    public CompletableFuture<List<RuleDescription>> getRulesAsync(String topicName, String subscriptionName, int count, int skip) {
        if (count > 100 || count < 1) {
            throw new IllegalArgumentException("Count should be between 1 and 100");
        }
        if (skip < 0) {
            throw new IllegalArgumentException("Skip cannot be negative");
        }
        EntityNameHelper.checkValidTopicName(topicName);
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        CompletableFuture<String> contentFuture = this.getEntityAsync(String.format("%s/Subscriptions/%s/rules", topicName, subscriptionName), String.format("$skip=%d&$top=%d", skip, count), false);
        CompletableFuture<List<RuleDescription>> rulesFuture = new CompletableFuture<List<RuleDescription>>();
        contentFuture.handleAsync((content, ex) -> {
            if (ex != null) {
                rulesFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    rulesFuture.complete(RuleDescriptionSerializer.parseCollectionFromContent(content));
                }
                catch (Exception e) {
                    rulesFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return rulesFuture;
    }

    private CompletableFuture<String> getEntityAsync(String path, String query, boolean enrich) {
        String queryString = "api-version=2017-04&enrich=" + enrich;
        if (query != null) {
            queryString = queryString + "&" + query;
        }
        URL entityURL = null;
        try {
            entityURL = ManagementClientAsync.getManagementURL(this.namespaceEndpointURI, path, queryString);
        }
        catch (ServiceBusException e) {
            CompletableFuture<String> exceptionFuture = new CompletableFuture<String>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
        return this.sendManagementHttpRequestAsync(HttpConstants.Methods.GET, entityURL, null, null);
    }

    public CompletableFuture<QueueDescription> createQueueAsync(String queuePath) {
        return this.createQueueAsync(new QueueDescription(queuePath));
    }

    public CompletableFuture<QueueDescription> createQueueAsync(QueueDescription queueDescription) {
        return this.putQueueAsync(queueDescription, false);
    }

    public CompletableFuture<QueueDescription> updateQueueAsync(QueueDescription queueDescription) {
        return this.putQueueAsync(queueDescription, true);
    }

    private CompletableFuture<QueueDescription> putQueueAsync(QueueDescription queueDescription, boolean isUpdate) {
        if (queueDescription == null) {
            throw new IllegalArgumentException("queueDescription passed cannot be null");
        }
        QueueDescriptionSerializer.normalizeDescription(queueDescription, this.namespaceEndpointURI);
        String atomRequest = null;
        try {
            atomRequest = QueueDescriptionSerializer.serialize(queueDescription);
        }
        catch (ServiceBusException e) {
            CompletableFuture<QueueDescription> exceptionFuture = new CompletableFuture<QueueDescription>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
        CompletableFuture<QueueDescription> responseFuture = new CompletableFuture<QueueDescription>();
        this.putEntityAsync(queueDescription.path, atomRequest, isUpdate, queueDescription.getForwardTo(), queueDescription.getForwardDeadLetteredMessagesTo()).handleAsync((content, ex) -> {
            if (ex != null) {
                responseFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    responseFuture.complete(QueueDescriptionSerializer.parseFromContent(content));
                }
                catch (Exception e) {
                    responseFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return responseFuture;
    }

    public CompletableFuture<TopicDescription> createTopicAsync(String topicPath) {
        return this.createTopicAsync(new TopicDescription(topicPath));
    }

    public CompletableFuture<TopicDescription> createTopicAsync(TopicDescription topicDescription) {
        return this.putTopicAsync(topicDescription, false);
    }

    public CompletableFuture<TopicDescription> updateTopicAsync(TopicDescription topicDescription) {
        return this.putTopicAsync(topicDescription, true);
    }

    private CompletableFuture<TopicDescription> putTopicAsync(TopicDescription topicDescription, boolean isUpdate) {
        if (topicDescription == null) {
            throw new IllegalArgumentException("topicDescription passed cannot be null");
        }
        String atomRequest = null;
        try {
            atomRequest = TopicDescriptionSerializer.serialize(topicDescription);
        }
        catch (ServiceBusException e) {
            CompletableFuture<TopicDescription> exceptionFuture = new CompletableFuture<TopicDescription>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
        CompletableFuture<TopicDescription> responseFuture = new CompletableFuture<TopicDescription>();
        this.putEntityAsync(topicDescription.path, atomRequest, isUpdate, null, null).handleAsync((content, ex) -> {
            if (ex != null) {
                responseFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    responseFuture.complete(TopicDescriptionSerializer.parseFromContent(content));
                }
                catch (Exception e) {
                    responseFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return responseFuture;
    }

    public CompletableFuture<SubscriptionDescription> createSubscriptionAsync(String topicPath, String subscriptionName) {
        return this.createSubscriptionAsync(new SubscriptionDescription(topicPath, subscriptionName));
    }

    public CompletableFuture<SubscriptionDescription> createSubscriptionAsync(SubscriptionDescription subscriptionDescription) {
        return this.createSubscriptionAsync(subscriptionDescription, null);
    }

    public CompletableFuture<SubscriptionDescription> createSubscriptionAsync(SubscriptionDescription subscriptionDescription, RuleDescription defaultRule) {
        subscriptionDescription.defaultRule = defaultRule;
        return this.putSubscriptionAsync(subscriptionDescription, false);
    }

    public CompletableFuture<SubscriptionDescription> updateSubscriptionAsync(SubscriptionDescription subscriptionDescription) {
        return this.putSubscriptionAsync(subscriptionDescription, true);
    }

    private CompletableFuture<SubscriptionDescription> putSubscriptionAsync(SubscriptionDescription subscriptionDescription, boolean isUpdate) {
        if (subscriptionDescription == null) {
            throw new IllegalArgumentException("queueDescription passed cannot be null");
        }
        SubscriptionDescriptionSerializer.normalizeDescription(subscriptionDescription, this.namespaceEndpointURI);
        String atomRequest = null;
        try {
            atomRequest = SubscriptionDescriptionSerializer.serialize(subscriptionDescription);
        }
        catch (ServiceBusException e) {
            CompletableFuture<SubscriptionDescription> exceptionFuture = new CompletableFuture<SubscriptionDescription>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
        CompletableFuture<SubscriptionDescription> responseFuture = new CompletableFuture<SubscriptionDescription>();
        String path = EntityNameHelper.formatSubscriptionPath(subscriptionDescription.getTopicPath(), subscriptionDescription.getSubscriptionName());
        this.putEntityAsync(path, atomRequest, isUpdate, subscriptionDescription.getForwardTo(), subscriptionDescription.getForwardDeadLetteredMessagesTo()).handleAsync((content, ex) -> {
            if (ex != null) {
                responseFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    responseFuture.complete(SubscriptionDescriptionSerializer.parseFromContent(subscriptionDescription.getTopicPath(), content));
                }
                catch (Exception e) {
                    responseFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return responseFuture;
    }

    public CompletableFuture<RuleDescription> createRuleAsync(String topicName, String subscriptionName, RuleDescription ruleDescription) {
        return this.putRuleAsync(topicName, subscriptionName, ruleDescription, false);
    }

    public CompletableFuture<RuleDescription> updateRuleAsync(String topicName, String subscriptionName, RuleDescription ruleDescription) {
        return this.putRuleAsync(topicName, subscriptionName, ruleDescription, true);
    }

    private CompletableFuture<RuleDescription> putRuleAsync(String topicName, String subscriptionName, RuleDescription ruleDescription, boolean isUpdate) {
        EntityNameHelper.checkValidTopicName(topicName);
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        if (ruleDescription == null) {
            throw new IllegalArgumentException("queueDescription passed cannot be null");
        }
        String atomRequest = null;
        try {
            atomRequest = RuleDescriptionSerializer.serialize(ruleDescription);
        }
        catch (ServiceBusException e) {
            CompletableFuture<RuleDescription> exceptionFuture = new CompletableFuture<RuleDescription>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
        CompletableFuture<RuleDescription> responseFuture = new CompletableFuture<RuleDescription>();
        String path = EntityNameHelper.formatRulePath(topicName, subscriptionName, ruleDescription.getName());
        this.putEntityAsync(path, atomRequest, isUpdate, null, null).handleAsync((content, ex) -> {
            if (ex != null) {
                responseFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    responseFuture.complete(RuleDescriptionSerializer.parseFromContent(content));
                }
                catch (Exception e) {
                    responseFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return responseFuture;
    }

    private CompletableFuture<String> putEntityAsync(String path, String requestBody, boolean isUpdate, String forwardTo, String fwdDeadLetterTo) {
        String securityToken;
        URL entityURL = null;
        try {
            entityURL = ManagementClientAsync.getManagementURL(this.namespaceEndpointURI, path, API_VERSION_QUERY);
        }
        catch (ServiceBusException e) {
            CompletableFuture<String> exceptionFuture = new CompletableFuture<String>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        if (isUpdate) {
            additionalHeaders.put("If-Match", "*");
        }
        if (forwardTo != null && !forwardTo.isEmpty()) {
            try {
                securityToken = ManagementClientAsync.getSecurityToken(this.clientSettings.getTokenProvider(), forwardTo);
                additionalHeaders.put("ServiceBusSupplementaryAuthorization", securityToken);
            }
            catch (InterruptedException | ExecutionException e) {
                CompletableFuture<String> exceptionFuture = new CompletableFuture<String>();
                exceptionFuture.completeExceptionally(e);
                return exceptionFuture;
            }
        }
        if (fwdDeadLetterTo != null && !fwdDeadLetterTo.isEmpty()) {
            try {
                securityToken = ManagementClientAsync.getSecurityToken(this.clientSettings.getTokenProvider(), fwdDeadLetterTo);
                additionalHeaders.put("ServiceBusDlqSupplementaryAuthorization", securityToken);
            }
            catch (InterruptedException | ExecutionException e) {
                CompletableFuture<String> exceptionFuture = new CompletableFuture<String>();
                exceptionFuture.completeExceptionally(e);
                return exceptionFuture;
            }
        }
        return this.sendManagementHttpRequestAsync(HttpConstants.Methods.PUT, entityURL, requestBody, additionalHeaders);
    }

    public CompletableFuture<Boolean> queueExistsAsync(String path) {
        EntityNameHelper.checkValidQueueName(path);
        CompletableFuture<Boolean> existsFuture = new CompletableFuture<Boolean>();
        this.getQueueAsync(path).handleAsync((qd, ex) -> {
            if (ex != null) {
                if (ex instanceof MessagingEntityNotFoundException) {
                    existsFuture.complete(Boolean.FALSE);
                    return false;
                }
                existsFuture.completeExceptionally((Throwable)ex);
                return false;
            }
            existsFuture.complete(Boolean.TRUE);
            return true;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return existsFuture;
    }

    public CompletableFuture<Boolean> topicExistsAsync(String path) {
        EntityNameHelper.checkValidTopicName(path);
        CompletableFuture<Boolean> existsFuture = new CompletableFuture<Boolean>();
        this.getTopicAsync(path).handleAsync((qd, ex) -> {
            if (ex != null) {
                if (ex instanceof MessagingEntityNotFoundException) {
                    existsFuture.complete(Boolean.FALSE);
                    return false;
                }
                existsFuture.completeExceptionally((Throwable)ex);
                return false;
            }
            existsFuture.complete(Boolean.TRUE);
            return true;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return existsFuture;
    }

    public CompletableFuture<Boolean> subscriptionExistsAsync(String topicPath, String subscriptionName) {
        EntityNameHelper.checkValidTopicName(topicPath);
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        CompletableFuture<Boolean> existsFuture = new CompletableFuture<Boolean>();
        this.getSubscriptionAsync(topicPath, subscriptionName).handleAsync((qd, ex) -> {
            if (ex != null) {
                if (ex instanceof MessagingEntityNotFoundException) {
                    existsFuture.complete(Boolean.FALSE);
                    return false;
                }
                existsFuture.completeExceptionally((Throwable)ex);
                return false;
            }
            existsFuture.complete(Boolean.TRUE);
            return true;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return existsFuture;
    }

    public CompletableFuture<Boolean> ruleExistsAsync(String topicPath, String subscriptionName, String ruleName) {
        EntityNameHelper.checkValidTopicName(topicPath);
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        EntityNameHelper.checkValidRuleName(ruleName);
        CompletableFuture<Boolean> existsFuture = new CompletableFuture<Boolean>();
        this.getRuleAsync(topicPath, subscriptionName, ruleName).handleAsync((qd, ex) -> {
            if (ex != null) {
                if (ex instanceof MessagingEntityNotFoundException) {
                    existsFuture.complete(Boolean.FALSE);
                    return false;
                }
                existsFuture.completeExceptionally((Throwable)ex);
                return false;
            }
            existsFuture.complete(Boolean.TRUE);
            return true;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return existsFuture;
    }

    public CompletableFuture<Void> deleteQueueAsync(String path) {
        EntityNameHelper.checkValidQueueName(path);
        return this.deleteEntityAsync(path);
    }

    public CompletableFuture<Void> deleteTopicAsync(String path) {
        EntityNameHelper.checkValidTopicName(path);
        return this.deleteEntityAsync(path);
    }

    public CompletableFuture<Void> deleteSubscriptionAsync(String topicPath, String subscriptionName) {
        EntityNameHelper.checkValidTopicName(topicPath);
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        String path = EntityNameHelper.formatSubscriptionPath(topicPath, subscriptionName);
        return this.deleteEntityAsync(path);
    }

    public CompletableFuture<Void> deleteRuleAsync(String topicPath, String subscriptionName, String ruleName) {
        EntityNameHelper.checkValidTopicName(topicPath);
        EntityNameHelper.checkValidSubscriptionName(subscriptionName);
        EntityNameHelper.checkValidRuleName(ruleName);
        String path = EntityNameHelper.formatRulePath(topicPath, subscriptionName, ruleName);
        return this.deleteEntityAsync(path);
    }

    private CompletableFuture<Void> deleteEntityAsync(String path) {
        URL entityURL = null;
        try {
            entityURL = ManagementClientAsync.getManagementURL(this.namespaceEndpointURI, path, API_VERSION_QUERY);
        }
        catch (ServiceBusException e) {
            CompletableFuture<Void> exceptionFuture = new CompletableFuture<Void>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
        return this.sendManagementHttpRequestAsync(HttpConstants.Methods.DELETE, entityURL, null, null).thenAccept(c -> {});
    }

    public void close() throws IOException {
        this.asyncHttpClient.close();
    }

    private static URL getManagementURL(URI namespaceEndpontURI, String entityPath, String query) throws ServiceBusException {
        try {
            URI httpURI = new URI("https", null, namespaceEndpontURI.getHost(), ManagementClientAsync.getPortNumberFromHost(namespaceEndpontURI.getHost()), "/" + entityPath, query, null);
            return httpURI.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new ServiceBusException(false, (Throwable)e);
        }
    }

    private CompletableFuture<String> sendManagementHttpRequestAsync(String httpMethod, URL url, String atomEntryString, HashMap<String, String> additionalHeaders) {
        String securityToken = null;
        try {
            securityToken = ManagementClientAsync.getSecurityToken(this.clientSettings.getTokenProvider(), url.toString());
        }
        catch (InterruptedException | ExecutionException e) {
            CompletableFuture<String> exceptionFuture = new CompletableFuture<String>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
        RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(httpMethod).setUrl(url.toString())).setBody(atomEntryString)).addHeader((CharSequence)USER_AGENT_HEADER_NAME, USER_AGENT)).addHeader((CharSequence)AUTHORIZATION_HEADER_NAME, securityToken)).addHeader((CharSequence)CONTENT_TYPE_HEADER_NAME, CONTENT_TYPE);
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                requestBuilder.addHeader((CharSequence)entry.getKey(), entry.getValue());
            }
        }
        Request unboundRequest = requestBuilder.build();
        ListenableFuture listenableFuture = this.asyncHttpClient.executeRequest(unboundRequest);
        CompletableFuture<String> outputFuture = new CompletableFuture<String>();
        listenableFuture.toCompletableFuture().handleAsync((response, ex) -> {
            if (ex != null) {
                outputFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    ManagementClientAsync.validateHttpResponse(unboundRequest, response);
                    outputFuture.complete(response.getResponseBody());
                }
                catch (ServiceBusException e) {
                    outputFuture.completeExceptionally(e);
                }
            }
            return null;
        }, (Executor)MessagingFactory.INTERNAL_THREAD_POOL);
        return outputFuture;
    }

    private static void validateHttpResponse(Request request, Response response) throws ServiceBusException, UnsupportedOperationException {
        if (response.hasResponseStatus() && response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
            return;
        }
        String exceptionMessage = response.getResponseBody();
        if ((exceptionMessage = ManagementClientAsync.parseDetailIfAvailable(exceptionMessage)) == null) {
            exceptionMessage = response.getStatusText();
        }
        ServiceBusException exception = null;
        switch (response.getStatusCode()) {
            case 401: {
                exception = new AuthorizationFailedException(exceptionMessage);
                break;
            }
            case 204: 
            case 404: {
                exception = new MessagingEntityNotFoundException(exceptionMessage);
                break;
            }
            case 409: {
                if (HttpConstants.Methods.DELETE.equals(request.getMethod())) {
                    exception = new ServiceBusException(true, exceptionMessage);
                    break;
                }
                if (HttpConstants.Methods.PUT.equals(request.getMethod()) && request.getHeaders().contains("IfMatch")) {
                    exception = new ServiceBusException(true, exceptionMessage);
                    break;
                }
                if (exceptionMessage.contains(ManagementClientConstants.CONFLICT_OPERATION_IN_PROGRESS_SUB_CODE)) {
                    exception = new ServiceBusException(true, exceptionMessage);
                    break;
                }
                exception = new MessagingEntityAlreadyExistsException(exceptionMessage);
                break;
            }
            case 403: {
                if (exceptionMessage.contains(ManagementClientConstants.FORBIDDEN_INVALID_OPERATION_SUB_CODE)) {
                    throw new UnsupportedOperationException(exceptionMessage);
                }
                exception = new QuotaExceededException(exceptionMessage);
                break;
            }
            case 400: {
                exception = new ServiceBusException(false, (Throwable)new IllegalArgumentException(exceptionMessage));
                break;
            }
            case 503: {
                exception = new ServerBusyException(exceptionMessage);
                break;
            }
            default: {
                exception = new ServiceBusException(true, exceptionMessage + "; Status code: " + response.getStatusCode());
            }
        }
        throw exception;
    }

    private static String parseDetailIfAvailable(String content) {
        block5: {
            if (content == null || content.isEmpty()) {
                return null;
            }
            try {
                DocumentBuilderFactory dbf = SerializerUtil.getDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(content.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                NodeList entries = doc.getChildNodes();
                for (int i = 0; i < entries.getLength(); ++i) {
                    Node node = entries.item(i);
                    if (!node.getNodeName().equals("Detail")) continue;
                    return node.getFirstChild().getTextContent();
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.info("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block5;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)content);
            }
        }
        return null;
    }

    private static String getSecurityToken(TokenProvider tokenProvider, String url) throws InterruptedException, ExecutionException {
        SecurityToken token = tokenProvider.getSecurityTokenAsync(url).get();
        return token.getTokenValue();
    }

    private static int getPortNumberFromHost(String host) {
        if (host.endsWith("onebox.windows-int.net")) {
            return 4446;
        }
        return -1;
    }
}

