/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.management;

import com.microsoft.azure.servicebus.management.MessageCountDetails;
import com.microsoft.azure.servicebus.management.SerializerUtil;
import com.microsoft.azure.servicebus.management.SubscriptionRuntimeInfo;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Instant;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SubscriptionRuntimeInfoSerializer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(SubscriptionRuntimeInfoSerializer.class);

    static SubscriptionRuntimeInfo parseFromContent(String topicPath, String xml) throws MessagingEntityNotFoundException {
        block4: {
            try {
                DocumentBuilderFactory dbf = SerializerUtil.getDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new ByteArrayInputStream(xml.getBytes("utf-8")));
                Element doc = dom.getDocumentElement();
                doc.normalize();
                if ("entry".equals(doc.getTagName())) {
                    return SubscriptionRuntimeInfoSerializer.parseFromEntry(topicPath, doc);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                if (TRACE_LOGGER.isErrorEnabled()) {
                    TRACE_LOGGER.info("Exception while parsing response.", (Throwable)e);
                }
                if (!TRACE_LOGGER.isDebugEnabled()) break block4;
                TRACE_LOGGER.debug("XML which failed to parse: \n %s", (Object)xml);
            }
        }
        throw new MessagingEntityNotFoundException("Subscription was not found");
    }

    private static SubscriptionRuntimeInfo parseFromEntry(String topicPath, Node xEntry) {
        SubscriptionRuntimeInfo runtimeInfo = null;
        NodeList nList = xEntry.getChildNodes();
        block36: for (int i = 0; i < nList.getLength(); ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "title": {
                    runtimeInfo = new SubscriptionRuntimeInfo(topicPath, element.getFirstChild().getNodeValue());
                    continue block36;
                }
                case "content": {
                    NodeList qdNodes = element.getFirstChild().getChildNodes();
                    block37: for (int j = 0; j < qdNodes.getLength(); ++j) {
                        node = qdNodes.item(j);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        switch (element.getTagName()) {
                            case "AccessedAt": {
                                runtimeInfo.setAccessedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block37;
                            }
                            case "CreatedAt": {
                                runtimeInfo.setCreatedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block37;
                            }
                            case "UpdatedAt": {
                                runtimeInfo.setUpdatedAt(Instant.parse(element.getFirstChild().getNodeValue()));
                                continue block37;
                            }
                            case "MessageCount": {
                                runtimeInfo.setMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                continue block37;
                            }
                            case "CountDetails": {
                                runtimeInfo.setMessageCountDetails(new MessageCountDetails());
                                NodeList mcDetails = element.getChildNodes();
                                block38: for (int k = 0; k < mcDetails.getLength(); ++k) {
                                    String localName;
                                    Node node2 = mcDetails.item(k);
                                    if (node2.getNodeType() != 1) continue;
                                    element = (Element)node2;
                                    switch (localName = element.getTagName().substring(element.getTagName().indexOf(58) + 1)) {
                                        case "ActiveMessageCount": {
                                            runtimeInfo.getMessageCountDetails().setActiveMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block38;
                                        }
                                        case "DeadLetterMessageCount": {
                                            runtimeInfo.getMessageCountDetails().setDeadLetterMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block38;
                                        }
                                        case "ScheduledMessageCount": {
                                            runtimeInfo.getMessageCountDetails().setScheduledMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block38;
                                        }
                                        case "TransferMessageCount": {
                                            runtimeInfo.getMessageCountDetails().setTransferMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block38;
                                        }
                                        case "TransferDeadLetterMessageCount": {
                                            runtimeInfo.getMessageCountDetails().setTransferDeadLetterMessageCount(Long.parseLong(element.getFirstChild().getNodeValue()));
                                            continue block38;
                                        }
                                    }
                                }
                                continue block37;
                            }
                        }
                    }
                    continue block36;
                }
            }
        }
        return runtimeInfo;
    }
}

