/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.sqlserver;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class AlwaysEncryptedEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlwaysEncryptedEnvironmentPostProcessor.class);
    private static final String PROPERTY_SOURCE_NAME = "aeProperties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!((Boolean)environment.getProperty("spring.datasource.always-encrypted.enabled", Boolean.class, (Object)false)).booleanValue()) {
            return;
        }
        LOGGER.info("Setting AlwaysEncrypted properties");
        MapPropertySource target = new MapPropertySource(PROPERTY_SOURCE_NAME, AlwaysEncryptedEnvironmentPostProcessor.getSettingsMap(environment));
        environment.getPropertySources().addFirst((PropertySource)target);
    }

    public static Map<String, Object> getSettingsMap(ConfigurableEnvironment environment) {
        String connectionProps;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!environment.containsProperty("spring.datasource.data-source-properties.ColumnEncryptionSetting")) {
            map.put("spring.datasource.data-source-properties.ColumnEncryptionSetting", "Enabled");
        }
        if ((connectionProps = environment.getProperty("spring.datasource.connection-properties")) == null) {
            map.put("spring.datasource.connection-properties", "ColumnEncryptionSetting=Enabled");
        } else {
            map.put("spring.datasource.connection-properties", connectionProps + ", " + "ColumnEncryptionSetting=Enabled");
        }
        return map;
    }
}

