/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.sqlserver;

import com.microsoft.azure.spring.autoconfigure.sqlserver.KeyVaultProperties;
import com.microsoft.azure.telemetry.TelemetryData;
import com.microsoft.azure.telemetry.TelemetrySender;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionAzureKeyVaultProvider;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.ClassUtils;

public class KeyVaultProviderInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(KeyVaultProviderInitializer.class);
    private KeyVaultProperties properties;

    public KeyVaultProviderInitializer(KeyVaultProperties properties) {
        this.properties = properties;
        this.init();
    }

    public void init() {
        LOG.info("initializing DataSource AlwaysEncryption Vault provider");
        try {
            SQLServerColumnEncryptionAzureKeyVaultProvider akvProvider = new SQLServerColumnEncryptionAzureKeyVaultProvider(this.properties.getClientId(), this.properties.getClientSecret());
            HashMap<String, SQLServerColumnEncryptionAzureKeyVaultProvider> keyStoreMap = new HashMap<String, SQLServerColumnEncryptionAzureKeyVaultProvider>();
            keyStoreMap.put(akvProvider.getName(), akvProvider);
            SQLServerConnection.registerColumnEncryptionKeyStoreProviders(keyStoreMap);
        }
        catch (SQLException ex) {
            LOG.error(ex.getMessage());
            throw new FatalBeanException(ex.getMessage());
        }
    }

    @PostConstruct
    private void sendTelemetry() {
        if (this.properties.isAllowTelemetry()) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(KeyVaultProviderInitializer.class));
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }
}

