/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.servicebus;

import com.microsoft.azure.servicebus.QueueClient;
import com.microsoft.azure.servicebus.SubscriptionClient;
import com.microsoft.azure.servicebus.TopicClient;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.spring.autoconfigure.servicebus.ServiceBusProperties;
import com.microsoft.azure.telemetry.TelemetryData;
import com.microsoft.azure.telemetry.TelemetrySender;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.ClassUtils;

@Lazy
@Configuration
@EnableConfigurationProperties(value={ServiceBusProperties.class})
@ConditionalOnProperty(prefix="azure.servicebus", value={"connection-string"})
public class ServiceBusAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ServiceBusAutoConfiguration.class);
    private final ServiceBusProperties properties;

    public ServiceBusAutoConfiguration(ServiceBusProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="azure.servicebus", value={"queue-name", "queue-receive-mode"})
    public QueueClient queueClient() throws InterruptedException, ServiceBusException {
        return new QueueClient(new ConnectionStringBuilder(this.properties.getConnectionString(), this.properties.getQueueName()), this.properties.getQueueReceiveMode());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="azure.servicebus", value={"topic-name"})
    public TopicClient topicClient() throws InterruptedException, ServiceBusException {
        return new TopicClient(new ConnectionStringBuilder(this.properties.getConnectionString(), this.properties.getTopicName()));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="azure.servicebus", value={"topic-name", "subscription-name", "subscription-receive-mode"})
    public SubscriptionClient subscriptionClient() throws ServiceBusException, InterruptedException {
        return new SubscriptionClient(new ConnectionStringBuilder(this.properties.getConnectionString(), this.properties.getTopicName() + "/subscriptions/" + this.properties.getSubscriptionName()), this.properties.getSubscriptionReceiveMode());
    }

    private String getHashNamespace() {
        String namespace = this.properties.getConnectionString().replaceFirst("^.*//", "").replaceAll("\\..*$", "");
        if (!namespace.matches("[a-zA-Z][a-zA-Z-0-9]{4,48}[a-zA-Z0-9]")) {
            log.warn("Unexpected name {}, please check if it's valid name or portal name rule changes.", (Object)namespace);
        }
        return DigestUtils.sha256Hex((String)namespace);
    }

    @PostConstruct
    private void sendTelemetry() {
        if (this.properties.isAllowTelemetry()) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(ServiceBusAutoConfiguration.class));
            events.put("hashedNamespace", this.getHashNamespace());
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }
}

