/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import com.microsoft.azure.spring.autoconfigure.aad.UserPrincipal;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPrincipalManager {
    private static final Logger log = LoggerFactory.getLogger(UserPrincipalManager.class);
    private static final String LOGIN_MICROSOFT_ONLINE_ISSUER = "https://login.microsoftonline.com/";
    private static final String STS_WINDOWS_ISSUER = "https://sts.windows.net/";
    private static final String STS_CHINA_CLOUD_API_ISSUER = "https://sts.chinacloudapi.cn/";
    private final JWKSource<SecurityContext> keySource;
    private final AADAuthenticationProperties aadAuthProps;
    private final Boolean explicitAudienceCheck;
    private final Set<String> validAudiences = new HashSet<String>();

    public UserPrincipalManager(JWKSource<SecurityContext> keySource) {
        this.keySource = keySource;
        this.explicitAudienceCheck = false;
        this.aadAuthProps = null;
    }

    public UserPrincipalManager(ServiceEndpointsProperties serviceEndpointsProps, AADAuthenticationProperties aadAuthProps, ResourceRetriever resourceRetriever, boolean explicitAudienceCheck) {
        this.aadAuthProps = aadAuthProps;
        this.explicitAudienceCheck = explicitAudienceCheck;
        if (explicitAudienceCheck) {
            this.validAudiences.add(this.aadAuthProps.getClientId());
            this.validAudiences.add(this.aadAuthProps.getAppIdUri());
        }
        try {
            this.keySource = new RemoteJWKSet(new URL(serviceEndpointsProps.getServiceEndpoints(aadAuthProps.getEnvironment()).getAadKeyDiscoveryUri()), resourceRetriever);
        }
        catch (MalformedURLException e) {
            log.error("Failed to parse active directory key discovery uri.", (Throwable)e);
            throw new IllegalStateException("Failed to parse active directory key discovery uri.", e);
        }
    }

    public UserPrincipalManager(ServiceEndpointsProperties serviceEndpointsProps, AADAuthenticationProperties aadAuthProps, ResourceRetriever resourceRetriever, boolean explicitAudienceCheck, JWKSetCache jwkSetCache) {
        this.aadAuthProps = aadAuthProps;
        this.explicitAudienceCheck = explicitAudienceCheck;
        if (explicitAudienceCheck) {
            this.validAudiences.add(this.aadAuthProps.getClientId());
            this.validAudiences.add(this.aadAuthProps.getAppIdUri());
        }
        try {
            this.keySource = new RemoteJWKSet(new URL(serviceEndpointsProps.getServiceEndpoints(aadAuthProps.getEnvironment()).getAadKeyDiscoveryUri()), resourceRetriever, jwkSetCache);
        }
        catch (MalformedURLException e) {
            log.error("Failed to parse active directory key discovery uri.", (Throwable)e);
            throw new IllegalStateException("Failed to parse active directory key discovery uri.", e);
        }
    }

    public UserPrincipal buildUserPrincipal(String idToken) throws ParseException, JOSEException, BadJOSEException {
        JWSObject jwsObject = JWSObject.parse((String)idToken);
        ConfigurableJWTProcessor<SecurityContext> validator = this.getAadJwtTokenValidator(jwsObject.getHeader().getAlgorithm());
        JWTClaimsSet jwtClaimsSet = validator.process(idToken, null);
        JWTClaimsSetVerifier verifier = validator.getJWTClaimsSetVerifier();
        verifier.verify(jwtClaimsSet, null);
        return new UserPrincipal(jwsObject, jwtClaimsSet);
    }

    private ConfigurableJWTProcessor<SecurityContext> getAadJwtTokenValidator(JWSAlgorithm jwsAlgorithm) {
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(jwsAlgorithm, this.keySource);
        jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier<SecurityContext>(){

            public void verify(JWTClaimsSet claimsSet, SecurityContext ctx) throws BadJWTException {
                super.verify(claimsSet, ctx);
                String issuer = claimsSet.getIssuer();
                if (issuer == null || !issuer.startsWith(UserPrincipalManager.LOGIN_MICROSOFT_ONLINE_ISSUER) && !issuer.startsWith(UserPrincipalManager.STS_WINDOWS_ISSUER) && !issuer.startsWith(UserPrincipalManager.STS_CHINA_CLOUD_API_ISSUER)) {
                    throw new BadJWTException("Invalid token issuer");
                }
                if (UserPrincipalManager.this.explicitAudienceCheck.booleanValue()) {
                    Optional<String> matchedAudience = claimsSet.getAudience().stream().filter(UserPrincipalManager.this.validAudiences::contains).findFirst();
                    if (matchedAudience.isPresent()) {
                        log.debug("Matched audience [{}]", (Object)matchedAudience.get());
                    } else {
                        throw new BadJWTException("Invalid token audience. Provided value " + claimsSet.getAudience() + "does not match neither client-id nor AppIdUri.");
                    }
                }
            }
        });
        return jwtProcessor;
    }
}

