/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.b2c;

import com.microsoft.azure.spring.autoconfigure.b2c.AADB2CProperties;
import com.microsoft.azure.spring.autoconfigure.b2c.AADB2CURL;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class AADB2CLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final AADB2CProperties properties;

    public AADB2CLogoutSuccessHandler(@NonNull AADB2CProperties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = properties;
        super.setDefaultTargetUrl(this.getAADB2CEndSessionUrl());
    }

    private String getAADB2CEndSessionUrl() {
        String userFlow = this.properties.getUserFlows().getSignUpOrSignIn();
        String logoutSuccessUrl = this.properties.getLogoutSuccessUrl();
        return AADB2CURL.getEndSessionUrl(this.properties.getTenant(), logoutSuccessUrl, userFlow);
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        super.onLogoutSuccess(request, response, authentication);
    }
}

